/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl5;

import java.util.Set;
import polyglot.frontend.ExtensionInfo;
import polyglot.main.OptFlag;
import polyglot.main.Options;
import polyglot.main.UsageError;

public class JL5Options
extends Options {
    public boolean translateEnums;
    public String enumImplClass;
    public String enumSetImplClass;
    public boolean removeJava5isms;
    public boolean morePermissiveInference;
    public boolean morePermissiveCasts;
    public boolean skip524checks;
    public boolean leaveCovariantReturns;

    public JL5Options(ExtensionInfo extension) {
        super(extension);
    }

    @Override
    protected void populateFlags(Set<OptFlag<?>> flags) {
        super.populateFlags(flags);
        flags.add(new OptFlag<String>(new String[]{"-enumImplClass", "--enumImplClass"}, "<classname>", "Runtime class to implement Enums", "java.lang.Enum"){

            @Override
            public OptFlag.Arg<String> handle(String[] args, int index) throws UsageError {
                return this.createArg(index + 1, args[index]);
            }

            @Override
            public OptFlag.Arg<String> defaultArg() {
                return this.createDefault(this.defaultValue);
            }
        });
        flags.add(new OptFlag<String>(new String[]{"-enumSetImplClass", "--enumSetImplClass"}, "<classname>", "Runtime class to implement EnumSet", "java.util.EnumSet"){

            @Override
            public OptFlag.Arg<String> handle(String[] args, int index) throws UsageError {
                return this.createArg(index + 1, args[index]);
            }

            @Override
            public OptFlag.Arg<String> defaultArg() {
                return this.createDefault(this.defaultValue);
            }
        });
        flags.add(new OptFlag.Switch(new String[]{"-removeJava5isms", "--removeJava5isms"}, "Translate Java 5 language features to Java 1.4 features"));
        flags.add(new OptFlag.Switch(OptFlag.Kind.SECRET, new String[]{"-skip524checks", "--skip524checks"}, "Don't type check the result of removeJava5isms"));
        flags.add(new OptFlag.Switch(OptFlag.Kind.SECRET, new String[]{"-leaveCovariantReturns", "--leaveCovariantReturns"}, "With removeJava5isms, does not translate away covariant returns"));
        flags.add(new OptFlag.Switch(new String[]{"-morepermissiveinference", "--morepermissiveinference"}, "Use a more permissive algorithm for type inference. (Experimental)"));
        flags.add(new OptFlag.Switch(new String[]{"-morepermissivecasts", "--morepermissivecasts"}, "Allow allow more permissive casts to and from numeric wrapper types. (Experimental)"));
    }

    @Override
    protected void handleArg(OptFlag.Arg<?> arg) throws UsageError {
        if (arg.flag().ids().contains("-enumImplClass")) {
            this.enumImplClass = (String)arg.value();
            this.translateEnums = this.enumImplClass.equals("java.lang.Enum");
        } else if (arg.flag().ids().contains("-enumSetImplClass")) {
            this.enumSetImplClass = (String)arg.value();
        } else if (arg.flag().ids().contains("-removeJava5isms")) {
            this.removeJava5isms = (Boolean)arg.value();
        } else if (arg.flag().ids().contains("-morepermissiveinference")) {
            this.morePermissiveInference = (Boolean)arg.value();
        } else if (arg.flag().ids().contains("-morepermissivecasts")) {
            this.morePermissiveCasts = (Boolean)arg.value();
        } else if (arg.flag().ids().contains("-skip524checks")) {
            this.skip524checks = (Boolean)arg.value();
        } else if (arg.flag().ids().contains("-leaveCovariantReturns")) {
            this.leaveCovariantReturns = (Boolean)arg.value();
        } else {
            super.handleArg(arg);
        }
    }
}

