/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import java.util.List;
import polyglot.ast.Expr;
import polyglot.ast.Ext;
import polyglot.ast.Loop_c;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Stmt;
import polyglot.ast.Term;
import polyglot.ast.While;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.CodeWriter;
import polyglot.util.Position;
import polyglot.util.SerialVersionUID;
import polyglot.visit.AscriptionVisitor;
import polyglot.visit.CFGBuilder;
import polyglot.visit.FlowGraph;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeChecker;

public class While_c
extends Loop_c
implements While {
    private static final long serialVersionUID = SerialVersionUID.generate();

    public While_c(Position pos, Expr cond, Stmt body) {
        this(pos, cond, body, null);
    }

    public While_c(Position pos, Expr cond, Stmt body, Ext ext) {
        super(pos, cond, body, ext);
        assert (cond != null);
    }

    @Override
    public While cond(Expr cond) {
        return this.cond(this, cond);
    }

    @Override
    public While body(Stmt body) {
        return this.body(this, body);
    }

    @Override
    public Node visitChildren(NodeVisitor v) {
        Expr cond = this.visitChild(this.cond, v);
        Stmt body = this.visitChild(this.body, v);
        return this.reconstruct(this, cond, body);
    }

    @Override
    public Node typeCheck(TypeChecker tc) throws SemanticException {
        TypeSystem ts = tc.typeSystem();
        if (!ts.isImplicitCastValid(this.cond.type(), ts.Boolean())) {
            throw new SemanticException("Condition of while statement must have boolean type.", this.cond.position());
        }
        return this;
    }

    @Override
    public Type childExpectedType(Expr child, AscriptionVisitor av) {
        TypeSystem ts = av.typeSystem();
        if (child == this.cond) {
            return ts.Boolean();
        }
        return child.type();
    }

    @Override
    public String toString() {
        return "while (" + this.cond + ") ...";
    }

    @Override
    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        w.write("while (");
        this.printBlock(this.cond, w, tr);
        w.write(")");
        this.printSubStmt(this.body, w, tr);
    }

    @Override
    public Term firstChild() {
        return this.cond;
    }

    @Override
    public <T> List<T> acceptCFG(CFGBuilder<?> v, List<T> succs) {
        if (v.lang().condIsConstantTrue(this, v.lang())) {
            v.visitCFG(this.cond, this.body, 1);
        } else {
            if (v.lang().condIsConstantFalse(this, v.lang()) && v.skipDeadLoopBodies()) {
                v.visitCFG((Term)this.cond, FlowGraph.EDGE_KEY_FALSE, this, 0);
                return succs;
            }
            v.visitCFG(this.cond, FlowGraph.EDGE_KEY_TRUE, this.body, 1, FlowGraph.EDGE_KEY_FALSE, this, 0);
        }
        v.push(this).visitCFG(this.body, this.cond, 1);
        return succs;
    }

    @Override
    public Term continueTarget() {
        return this.cond;
    }

    @Override
    public Node copy(NodeFactory nf) {
        return nf.While(this.position, this.cond, this.body);
    }
}

