/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import polyglot.ast.Ext;
import polyglot.ast.Lang;
import polyglot.ast.Lit_c;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.StringLit;
import polyglot.types.SemanticException;
import polyglot.util.CodeWriter;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.util.SerialVersionUID;
import polyglot.util.StringUtil;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeChecker;

public class StringLit_c
extends Lit_c
implements StringLit {
    private static final long serialVersionUID = SerialVersionUID.generate();
    protected String value;
    protected int MAX_LENGTH = 60;

    public StringLit_c(Position pos, String value) {
        this(pos, value, null);
    }

    public StringLit_c(Position pos, String value, Ext ext) {
        super(pos, ext);
        assert (value != null);
        this.value = value;
    }

    @Override
    public String value() {
        return this.value;
    }

    @Override
    public StringLit value(String value) {
        return this.value(this, value);
    }

    protected <N extends StringLit_c> N value(N n, String value) {
        if (n.value == value) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.value = value;
        return n;
    }

    @Override
    public Node typeCheck(TypeChecker tc) throws SemanticException {
        return this.type(tc.typeSystem().String());
    }

    @Override
    public String toString() {
        if (StringUtil.unicodeEscape(this.value).length() > 11) {
            return "\"" + StringUtil.unicodeEscape(this.value).substring(0, 8) + "...\"";
        }
        return "\"" + StringUtil.unicodeEscape(this.value) + "\"";
    }

    @Override
    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        List<String> l = this.breakupString();
        if (l.size() > 1) {
            w.write("(");
        }
        w.begin(0);
        Iterator<String> i = l.iterator();
        while (i.hasNext()) {
            String s = i.next();
            w.write("\"");
            w.write(StringUtil.escape(s));
            w.write("\"");
            if (!i.hasNext()) continue;
            w.write(" +");
            w.allowBreak(0);
        }
        w.end();
        if (l.size() > 1) {
            w.write(")");
        }
    }

    protected List<String> breakupString() {
        LinkedList<String> result = new LinkedList<String>();
        int n = this.value.length();
        int i = 0;
        while (i < n) {
            char c;
            int k;
            int j;
            int len = 0;
            for (j = i; j < n && len + (k = StringUtil.unicodeEscape(c = this.value.charAt(j)).length()) <= this.MAX_LENGTH; ++j) {
                len += k;
            }
            result.add(this.value.substring(i, j));
            i = j;
        }
        if (result.isEmpty()) {
            if (!this.value.equals("")) {
                throw new InternalCompilerError("breakupString failed");
            }
            result.add(this.value);
        }
        return result;
    }

    @Override
    public Object constantValue(Lang lang) {
        return this.value;
    }

    @Override
    public Node copy(NodeFactory nf) {
        return nf.StringLit(this.position, this.value);
    }
}

