/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import java.util.List;
import polyglot.ast.Expr_c;
import polyglot.ast.Ext;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Precedence;
import polyglot.ast.Special;
import polyglot.ast.Term;
import polyglot.ast.TypeNode;
import polyglot.types.ClassType;
import polyglot.types.Context;
import polyglot.types.SemanticException;
import polyglot.types.TypeSystem;
import polyglot.util.CodeWriter;
import polyglot.util.Position;
import polyglot.util.SerialVersionUID;
import polyglot.visit.CFGBuilder;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeChecker;

public class Special_c
extends Expr_c
implements Special {
    private static final long serialVersionUID = SerialVersionUID.generate();
    protected Special.Kind kind;
    protected TypeNode qualifier;

    public Special_c(Position pos, Special.Kind kind, TypeNode qualifier) {
        this(pos, kind, qualifier, null);
    }

    public Special_c(Position pos, Special.Kind kind, TypeNode qualifier, Ext ext) {
        super(pos, ext);
        assert (kind != null);
        this.kind = kind;
        this.qualifier = qualifier;
    }

    @Override
    public Precedence precedence() {
        return Precedence.LITERAL;
    }

    @Override
    public Special.Kind kind() {
        return this.kind;
    }

    @Override
    public Special kind(Special.Kind kind) {
        return this.kind(this, kind);
    }

    protected <N extends Special_c> N kind(N n, Special.Kind kind) {
        if (n.kind == kind) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.kind = kind;
        return n;
    }

    @Override
    public TypeNode qualifier() {
        return this.qualifier;
    }

    @Override
    public Special qualifier(TypeNode qualifier) {
        return this.qualifier(this, qualifier);
    }

    protected <N extends Special_c> N qualifier(N n, TypeNode qualifier) {
        if (n.qualifier == qualifier) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.qualifier = qualifier;
        return n;
    }

    protected <N extends Special_c> N reconstruct(N n, TypeNode qualifier) {
        n = this.qualifier(n, qualifier);
        return n;
    }

    @Override
    public Node visitChildren(NodeVisitor v) {
        TypeNode qualifier = this.visitChild(this.qualifier, v);
        return this.reconstruct(this, qualifier);
    }

    @Override
    public Node typeCheck(TypeChecker tc) throws SemanticException {
        TypeSystem ts = tc.typeSystem();
        Context c = tc.context();
        ClassType t = null;
        if (this.qualifier == null) {
            t = c.currentClass();
        } else {
            if (!this.qualifier.isDisambiguated()) {
                return this;
            }
            if (this.qualifier.type().isClass()) {
                t = this.qualifier.type().toClass();
                if (!c.currentClass().hasEnclosingInstance(t)) {
                    throw new SemanticException("The nested class \"" + c.currentClass() + "\" does not have " + "an enclosing instance of type \"" + t + "\".", this.qualifier.position());
                }
            } else {
                throw new SemanticException("Invalid qualifier for \"this\" or \"super\".", this.qualifier.position());
            }
        }
        if (t == null || c.inStaticContext() && ts.equals(t, c.currentClass())) {
            throw new SemanticException("Cannot access a non-static field or method, or refer to \"this\" or \"super\" from a static context.", this.position());
        }
        if (this.kind == THIS) {
            return this.type(t);
        }
        if (this.kind == SUPER) {
            return this.type(t.superType());
        }
        return this;
    }

    @Override
    public Term firstChild() {
        if (this.qualifier != null) {
            return this.qualifier;
        }
        return null;
    }

    @Override
    public <T> List<T> acceptCFG(CFGBuilder<?> v, List<T> succs) {
        if (this.qualifier != null) {
            v.visitCFG(this.qualifier, this, 0);
        }
        return succs;
    }

    @Override
    public String toString() {
        if (this.qualifier != null) {
            if (this.qualifier.name() != null) {
                return this.qualifier.name() + "." + this.kind;
            }
            return this.qualifier + "." + this.kind;
        }
        return String.valueOf(this.kind);
    }

    @Override
    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        if (this.qualifier != null) {
            if (this.qualifier.name() != null) {
                w.write(this.qualifier.name());
            } else {
                tr.lang().prettyPrint((Node)this.qualifier, w, tr);
            }
            w.write(".");
        }
        w.write(this.kind.toString());
    }

    @Override
    public void dump(CodeWriter w) {
        super.dump(w);
        if (this.kind != null) {
            w.allowBreak(4, " ");
            w.begin(0);
            w.write("(kind " + this.kind + ")");
            w.end();
        }
    }

    @Override
    public Node copy(NodeFactory nf) {
        return nf.Special(this.position, this.kind, this.qualifier);
    }
}

