/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import java.util.LinkedList;
import java.util.List;
import polyglot.ast.Block;
import polyglot.ast.CodeBlock;
import polyglot.ast.Ext;
import polyglot.ast.Formal;
import polyglot.ast.Id;
import polyglot.ast.JLang;
import polyglot.ast.Javadoc;
import polyglot.ast.Node;
import polyglot.ast.ProcedureDecl;
import polyglot.ast.ProcedureDeclOps;
import polyglot.ast.Term;
import polyglot.ast.Term_c;
import polyglot.ast.TypeNode;
import polyglot.types.CodeInstance;
import polyglot.types.Flags;
import polyglot.types.ProcedureInstance;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.util.CodeWriter;
import polyglot.util.CollectionUtil;
import polyglot.util.ListUtil;
import polyglot.util.Position;
import polyglot.util.SerialVersionUID;
import polyglot.visit.AmbiguityRemover;
import polyglot.visit.ExceptionChecker;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeBuilder;

public abstract class ProcedureDecl_c
extends Term_c
implements ProcedureDecl,
ProcedureDeclOps {
    private static final long serialVersionUID = SerialVersionUID.generate();
    protected Flags flags;
    protected Id name;
    protected List<Formal> formals;
    protected List<TypeNode> throwTypes;
    protected Block body;
    protected Javadoc javadoc;

    @Deprecated
    public ProcedureDecl_c(Position pos, Flags flags, Id name, List<Formal> formals, List<TypeNode> throwTypes, Block body) {
        this(pos, flags, name, formals, throwTypes, body, null, null);
    }

    public ProcedureDecl_c(Position pos, Flags flags, Id name, List<Formal> formals, List<TypeNode> throwTypes, Block body, Javadoc javadoc) {
        this(pos, flags, name, formals, throwTypes, body, javadoc, null);
    }

    @Deprecated
    public ProcedureDecl_c(Position pos, Flags flags, Id name, List<Formal> formals, List<TypeNode> throwTypes, Block body, Ext ext) {
        this(pos, flags, name, formals, throwTypes, body, null, ext);
    }

    public ProcedureDecl_c(Position pos, Flags flags, Id name, List<Formal> formals, List<TypeNode> throwTypes, Block body, Javadoc javadoc, Ext ext) {
        super(pos, ext);
        assert (flags != null && name != null && formals != null && throwTypes != null);
        this.flags = flags;
        this.name = name;
        this.formals = ListUtil.copy(formals, true);
        this.throwTypes = ListUtil.copy(throwTypes, true);
        this.body = body;
        this.javadoc = javadoc;
    }

    @Override
    public Flags flags() {
        return this.flags;
    }

    @Override
    public ProcedureDecl flags(Flags flags) {
        return this.flags(this, flags);
    }

    protected <N extends ProcedureDecl_c> N flags(N n, Flags flags) {
        if (n.flags.equals(flags)) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.flags = flags;
        return n;
    }

    @Override
    public Id id() {
        return this.name;
    }

    @Override
    public ProcedureDecl id(Id name) {
        return this.id(this, name);
    }

    protected <N extends ProcedureDecl_c> N id(N n, Id name) {
        if (n.name == name) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.name = name;
        return n;
    }

    @Override
    public String name() {
        return this.name.id();
    }

    @Override
    public ProcedureDecl name(String name) {
        return this.id(this.name.id(name));
    }

    @Override
    public List<Formal> formals() {
        return this.formals;
    }

    @Override
    public ProcedureDecl formals(List<Formal> formals) {
        return this.formals(this, formals);
    }

    protected <N extends ProcedureDecl_c> N formals(N n, List<Formal> formals) {
        if (CollectionUtil.equals(n.formals, formals)) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.formals = ListUtil.copy(formals, true);
        return n;
    }

    @Override
    public List<TypeNode> throwTypes() {
        return this.throwTypes;
    }

    @Override
    public ProcedureDecl throwTypes(List<TypeNode> throwTypes) {
        return this.throwTypes(this, throwTypes);
    }

    protected <N extends ProcedureDecl_c> N throwTypes(N n, List<TypeNode> throwTypes) {
        if (CollectionUtil.equals(n.throwTypes, throwTypes)) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.throwTypes = ListUtil.copy(throwTypes, true);
        return n;
    }

    @Override
    public Term codeBody() {
        return this.body();
    }

    @Override
    public Block body() {
        return this.body;
    }

    @Override
    public CodeBlock body(Block body) {
        return this.body(this, body);
    }

    protected <N extends ProcedureDecl_c> N body(N n, Block body) {
        if (n.body == body) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.body = body;
        return n;
    }

    @Override
    public CodeInstance codeInstance() {
        return this.procedureInstance();
    }

    @Override
    public abstract ProcedureInstance procedureInstance();

    @Override
    public NodeVisitor buildTypesEnter(TypeBuilder tb) throws SemanticException {
        return tb.pushCode();
    }

    protected <N extends ProcedureDecl_c> N reconstruct(N n, Id name, List<Formal> formals, List<TypeNode> throwTypes, Block body) {
        n = this.id(n, name);
        n = this.formals(n, formals);
        n = this.throwTypes(n, throwTypes);
        n = this.body(n, body);
        return n;
    }

    @Override
    public Node disambiguate(AmbiguityRemover ar) throws SemanticException {
        ProcedureInstance pi = this.procedureInstance();
        if (pi.isCanonical()) {
            return this;
        }
        LinkedList<Type> formalTypes = new LinkedList<Type>();
        LinkedList<Type> throwTypes = new LinkedList<Type>();
        for (Formal f : this.formals) {
            if (!f.isDisambiguated()) {
                return this;
            }
            formalTypes.add(f.declType());
        }
        pi.setFormalTypes(formalTypes);
        for (TypeNode tn : this.throwTypes()) {
            if (!tn.isDisambiguated()) {
                return this;
            }
            throwTypes.add(tn.type());
        }
        pi.setThrowTypes(throwTypes);
        return this;
    }

    @Override
    public NodeVisitor exceptionCheckEnter(ExceptionChecker ec) throws SemanticException {
        return ec.push(this.procedureInstance().throwTypes());
    }

    @Override
    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        if (this.javadoc != null) {
            this.javadoc.prettyPrint(w, tr);
        }
        w.begin(0);
        ((JLang)tr.lang()).prettyPrintHeader(this, this.flags(), w, tr);
        if (this.body != null) {
            this.printSubStmt(this.body, w, tr);
        } else {
            w.write(";");
        }
        w.end();
    }

    @Override
    public void dump(CodeWriter w) {
        ProcedureInstance pi;
        super.dump(w);
        if (this.javadoc != null) {
            w.allowBreak(4, " ");
            w.begin(0);
            w.write("(javadoc ...)");
            w.end();
        }
        if ((pi = this.procedureInstance()) != null) {
            w.allowBreak(4, " ");
            w.begin(0);
            w.write("(instance " + pi + ")");
            w.end();
        }
    }

    @Override
    public ProcedureDecl javadoc(Javadoc javadoc) {
        return this.javadoc(this, javadoc);
    }

    protected <N extends ProcedureDecl_c> N javadoc(N n, Javadoc javadoc) {
        if (n.javadoc == javadoc) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.javadoc = javadoc;
        return n;
    }

    @Override
    public Javadoc javadoc() {
        return this.javadoc;
    }
}

