/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import java.util.Collections;
import java.util.List;
import polyglot.ast.ArrayInit;
import polyglot.ast.Expr;
import polyglot.ast.Expr_c;
import polyglot.ast.Ext;
import polyglot.ast.NewArray;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Term;
import polyglot.ast.TypeNode;
import polyglot.types.ArrayType;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.CodeWriter;
import polyglot.util.CollectionUtil;
import polyglot.util.InternalCompilerError;
import polyglot.util.ListUtil;
import polyglot.util.Position;
import polyglot.util.SerialVersionUID;
import polyglot.visit.AscriptionVisitor;
import polyglot.visit.CFGBuilder;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeChecker;

public class NewArray_c
extends Expr_c
implements NewArray {
    private static final long serialVersionUID = SerialVersionUID.generate();
    protected TypeNode baseType;
    protected List<Expr> dims;
    protected int addDims;
    protected ArrayInit init;

    public NewArray_c(Position pos, TypeNode baseType, List<Expr> dims, int addDims, ArrayInit init) {
        this(pos, baseType, dims, addDims, init, null);
    }

    public NewArray_c(Position pos, TypeNode baseType, List<Expr> dims, int addDims, ArrayInit init, Ext ext) {
        super(pos, ext);
        assert (baseType != null && dims != null);
        assert (addDims >= 0);
        assert (!dims.isEmpty() || init != null);
        assert (addDims > 0 || init == null);
        assert (dims.size() + addDims > 0);
        this.baseType = baseType;
        this.dims = ListUtil.copy(dims, true);
        this.addDims = addDims;
        this.init = init;
    }

    @Override
    public TypeNode baseType() {
        return this.baseType;
    }

    @Override
    public NewArray baseType(TypeNode baseType) {
        return this.baseType(this, baseType);
    }

    protected <N extends NewArray_c> N baseType(N n, TypeNode baseType) {
        if (n.baseType == baseType) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.baseType = baseType;
        return n;
    }

    @Override
    public List<Expr> dims() {
        return this.dims;
    }

    @Override
    public NewArray dims(List<Expr> dims) {
        return this.dims(this, dims);
    }

    protected <N extends NewArray_c> N dims(N n, List<Expr> dims) {
        if (CollectionUtil.equals(n.dims, dims)) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.dims = ListUtil.copy(dims, true);
        return n;
    }

    @Override
    public int numDims() {
        return this.dims.size() + this.addDims;
    }

    @Override
    public int additionalDims() {
        return this.addDims;
    }

    @Override
    public NewArray additionalDims(int addDims) {
        return this.additionalDims(this, addDims);
    }

    protected <N extends NewArray_c> N additionalDims(N n, int addDims) {
        if (n.addDims == addDims) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.addDims = addDims;
        return n;
    }

    @Override
    public ArrayInit init() {
        return this.init;
    }

    @Override
    public NewArray init(ArrayInit init) {
        return this.init(this, init);
    }

    protected <N extends NewArray_c> N init(N n, ArrayInit init) {
        if (n.init == init) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.init = init;
        return n;
    }

    protected <N extends NewArray_c> N reconstruct(N n, TypeNode baseType, List<Expr> dims, ArrayInit init) {
        n = this.baseType(n, baseType);
        n = this.dims(n, dims);
        n = this.init(n, init);
        return n;
    }

    @Override
    public Node visitChildren(NodeVisitor v) {
        TypeNode baseType = this.visitChild(this.baseType, v);
        List<Expr> dims = this.visitList(this.dims, v);
        ArrayInit init = this.visitChild(this.init, v);
        return this.reconstruct(this, baseType, dims, init);
    }

    @Override
    public Node typeCheck(TypeChecker tc) throws SemanticException {
        TypeSystem ts = tc.typeSystem();
        for (Expr expr : this.dims) {
            if (ts.isImplicitCastValid(expr.type(), ts.Int())) continue;
            throw new SemanticException("Array dimension must be an integer.", expr.position());
        }
        ArrayType type = this.arrayOf(ts, this.baseType.type(), this.dims.size() + this.addDims);
        if (this.init != null) {
            this.init.typeCheckElements(tc, type);
        }
        return this.type(type);
    }

    protected ArrayType arrayOf(TypeSystem ts, Type baseType, int dims) {
        return ts.arrayOf(baseType, dims);
    }

    @Override
    public Type childExpectedType(Expr child, AscriptionVisitor av) {
        if (child == this.init) {
            return this.type;
        }
        if (this.dims() != null && this.dims().contains(child)) {
            return av.typeSystem().Int();
        }
        return child.type();
    }

    @Override
    public String toString() {
        return "new " + this.baseType + "[...]";
    }

    @Override
    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        w.write("new ");
        this.print(this.baseType, w, tr);
        for (Expr e : this.dims) {
            w.write("[");
            this.printBlock(e, w, tr);
            w.write("]");
        }
        for (int i = 0; i < this.addDims; ++i) {
            w.write("[]");
        }
        if (this.init != null) {
            w.write(" ");
            this.print(this.init, w, tr);
        }
    }

    @Override
    public Term firstChild() {
        return this.baseType;
    }

    @Override
    public <T> List<T> acceptCFG(CFGBuilder<?> v, List<T> succs) {
        if (this.init != null) {
            v.visitCFG(this.baseType, (Term)NewArray_c.listChild(this.dims, this.init), 1);
            v.visitCFGList(this.dims, this.init, 1);
            v.visitCFG(this.init, this, 0);
        } else {
            v.visitCFG(this.baseType, (Term)NewArray_c.listChild(this.dims, null), 1);
            v.visitCFGList(this.dims, this, 0);
        }
        return succs;
    }

    @Override
    public List<Type> throwTypes(TypeSystem ts) {
        if (this.dims != null && !this.dims.isEmpty()) {
            try {
                return CollectionUtil.list(ts.typeForName("java.lang.NegativeArraySizeException"));
            }
            catch (SemanticException e) {
                throw new InternalCompilerError("Cannot find class java.lang.NegativeArraySizeException", e);
            }
        }
        return Collections.emptyList();
    }

    @Override
    public Node copy(NodeFactory nf) {
        return nf.NewArray(this.position, this.baseType, this.dims, this.addDims, this.init);
    }
}

