/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import polyglot.ast.Expr;
import polyglot.ast.Ext;
import polyglot.ast.JLang;
import polyglot.ast.Loop;
import polyglot.ast.LoopOps;
import polyglot.ast.Stmt;
import polyglot.ast.Stmt_c;
import polyglot.util.Position;
import polyglot.util.SerialVersionUID;

public abstract class Loop_c
extends Stmt_c
implements Loop,
LoopOps {
    private static final long serialVersionUID = SerialVersionUID.generate();
    protected Expr cond;
    protected Stmt body;

    public Loop_c(Position pos, Expr cond, Stmt body) {
        this(pos, cond, body, null);
    }

    public Loop_c(Position pos, Expr cond, Stmt body, Ext ext) {
        super(pos, ext);
        assert (body != null);
        this.body = body;
        this.cond = cond;
    }

    @Override
    public Expr cond() {
        return this.cond;
    }

    @Override
    public Loop cond(Expr cond) {
        return this.cond(this, cond);
    }

    protected <N extends Loop_c> N cond(N n, Expr cond) {
        if (n.cond == cond) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.cond = cond;
        return n;
    }

    @Override
    public boolean condIsConstant(JLang lang) {
        return lang.isConstant(this.cond(), lang);
    }

    @Override
    public boolean condIsConstantTrue(JLang lang) {
        return Boolean.TRUE.equals(lang.constantValue(this.cond(), lang));
    }

    @Override
    public boolean condIsConstantFalse(JLang lang) {
        return Boolean.FALSE.equals(lang.constantValue(this.cond(), lang));
    }

    @Override
    public Stmt body() {
        return this.body;
    }

    @Override
    public Loop body(Stmt body) {
        return this.body(this, body);
    }

    protected <N extends Loop_c> N body(N n, Stmt body) {
        if (n.body == body) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.body = body;
        return n;
    }

    protected <N extends Loop_c> N reconstruct(N n, Expr cond, Stmt body) {
        n = this.cond(n, cond);
        n = this.body(n, body);
        return n;
    }
}

