/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import java.util.List;
import polyglot.ast.Expr_c;
import polyglot.ast.Ext;
import polyglot.ast.Id;
import polyglot.ast.Lang;
import polyglot.ast.Local;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Precedence;
import polyglot.ast.Term;
import polyglot.translate.ExtensionRewriter;
import polyglot.types.Context;
import polyglot.types.Flags;
import polyglot.types.LocalInstance;
import polyglot.types.SemanticException;
import polyglot.types.TypeSystem;
import polyglot.types.VarInstance;
import polyglot.util.CodeWriter;
import polyglot.util.Position;
import polyglot.util.SerialVersionUID;
import polyglot.visit.CFGBuilder;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeBuilder;
import polyglot.visit.TypeChecker;

public class Local_c
extends Expr_c
implements Local {
    private static final long serialVersionUID = SerialVersionUID.generate();
    protected Id name;
    protected LocalInstance li;

    public Local_c(Position pos, Id name) {
        this(pos, name, null);
    }

    public Local_c(Position pos, Id name, Ext ext) {
        super(pos, ext);
        assert (name != null);
        this.name = name;
    }

    @Override
    public Precedence precedence() {
        return Precedence.LITERAL;
    }

    @Override
    public Id id() {
        return this.name;
    }

    @Override
    public Local id(Id name) {
        return this.id(this, name);
    }

    protected <N extends Local_c> N id(N n, Id name) {
        if (n.name == name) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.name = name;
        return n;
    }

    @Override
    public String name() {
        return this.name.id();
    }

    @Override
    public Local name(String name) {
        return this.id(this.name.id(name));
    }

    @Override
    public Flags flags() {
        return this.li.flags();
    }

    @Override
    public VarInstance varInstance() {
        return this.localInstance();
    }

    @Override
    public LocalInstance localInstance() {
        return this.li;
    }

    @Override
    public Local localInstance(LocalInstance li) {
        return this.localInstance(this, li);
    }

    protected <N extends Local_c> N localInstance(N n, LocalInstance li) {
        if (n.li == li) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.li = li;
        return n;
    }

    protected <N extends Local_c> N reconstruct(N n, Id name) {
        n = this.id(n, name);
        return n;
    }

    @Override
    public Node visitChildren(NodeVisitor v) {
        Id name = this.visitChild(this.name, v);
        return this.reconstruct(this, name);
    }

    @Override
    public Node buildTypes(TypeBuilder tb) throws SemanticException {
        Local_c n = (Local_c)super.buildTypes(tb);
        TypeSystem ts = tb.typeSystem();
        LocalInstance li = ts.localInstance(this.position(), Flags.NONE, ts.unknownType(this.position()), this.name.id());
        n = this.localInstance(n, li);
        return n;
    }

    @Override
    public Node typeCheck(TypeChecker tc) throws SemanticException {
        LocalInstance li;
        Context c = tc.context();
        if (!c.isLocal((li = c.findLocal(this.name.id())).name()) && !li.flags().isFinal()) {
            throw new SemanticException("Local variable \"" + li.name() + "\" is accessed from an inner class, and must be declared " + "final.", this.position());
        }
        Local_c n = this;
        n = this.localInstance(n, li);
        n = this.type(n, li.type());
        return n;
    }

    @Override
    public Node extRewrite(ExtensionRewriter rw) throws SemanticException {
        Local_c n = (Local_c)super.extRewrite(rw);
        n = this.localInstance(n, null);
        return n;
    }

    @Override
    public Term firstChild() {
        return null;
    }

    @Override
    public <T> List<T> acceptCFG(CFGBuilder<?> v, List<T> succs) {
        return succs;
    }

    @Override
    public String toString() {
        return this.name.toString();
    }

    @Override
    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        tr.print(this, this.name, w);
    }

    @Override
    public void dump(CodeWriter w) {
        super.dump(w);
        if (this.li != null) {
            w.allowBreak(4, " ");
            w.begin(0);
            w.write("(instance " + this.li + ")");
            w.end();
        }
    }

    @Override
    public boolean constantValueSet(Lang lang) {
        return this.li != null && this.li.constantValueSet();
    }

    @Override
    public boolean isConstant(Lang lang) {
        return this.li != null && this.li.isConstant();
    }

    @Override
    public Object constantValue(Lang lang) {
        if (!lang.isConstant(this, lang)) {
            return null;
        }
        return this.li.constantValue();
    }

    @Override
    public Node copy(NodeFactory nf) {
        return nf.Local(this.position, this.name);
    }
}

