/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import java.util.List;
import polyglot.ast.ArrayInit;
import polyglot.ast.Expr;
import polyglot.ast.Ext;
import polyglot.ast.Field;
import polyglot.ast.Id;
import polyglot.ast.JLang;
import polyglot.ast.Local;
import polyglot.ast.LocalDecl;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Stmt_c;
import polyglot.ast.Term;
import polyglot.ast.TypeNode;
import polyglot.frontend.MissingDependencyException;
import polyglot.frontend.Scheduler;
import polyglot.frontend.goals.Goal;
import polyglot.translate.ExtensionRewriter;
import polyglot.types.Context;
import polyglot.types.Flags;
import polyglot.types.LocalInstance;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.types.VarInstance;
import polyglot.util.CodeWriter;
import polyglot.util.Position;
import polyglot.util.SerialVersionUID;
import polyglot.visit.AmbiguityRemover;
import polyglot.visit.AscriptionVisitor;
import polyglot.visit.CFGBuilder;
import polyglot.visit.ConstantChecker;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeBuilder;
import polyglot.visit.TypeChecker;

public class LocalDecl_c
extends Stmt_c
implements LocalDecl {
    private static final long serialVersionUID = SerialVersionUID.generate();
    protected Flags flags;
    protected TypeNode type;
    protected Id name;
    protected Expr init;
    protected LocalInstance li;

    public LocalDecl_c(Position pos, Flags flags, TypeNode type, Id name, Expr init) {
        this(pos, flags, type, name, init, null);
    }

    public LocalDecl_c(Position pos, Flags flags, TypeNode type, Id name, Expr init, Ext ext) {
        super(pos, ext);
        assert (flags != null && type != null && name != null);
        this.flags = flags;
        this.type = type;
        this.name = name;
        this.init = init;
    }

    @Override
    public boolean isDisambiguated() {
        return this.li != null && this.li.isCanonical() && super.isDisambiguated();
    }

    @Override
    public Type declType() {
        return this.type.type();
    }

    @Override
    public Flags flags() {
        return this.flags;
    }

    @Override
    public LocalDecl flags(Flags flags) {
        return this.flags(this, flags);
    }

    protected <N extends LocalDecl_c> N flags(N n, Flags flags) {
        if (n.flags.equals(flags)) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.flags = flags;
        return n;
    }

    @Override
    public TypeNode type() {
        return this.type;
    }

    @Override
    public LocalDecl type(TypeNode type) {
        return this.type(this, type);
    }

    protected <N extends LocalDecl_c> N type(N n, TypeNode type) {
        if (n.type == type) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.type = type;
        return n;
    }

    @Override
    public Id id() {
        return this.name;
    }

    @Override
    public LocalDecl id(Id name) {
        return this.id(this, name);
    }

    protected <N extends LocalDecl_c> N id(N n, Id name) {
        if (n.name == name) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.name = name;
        return n;
    }

    @Override
    public String name() {
        return this.name.id();
    }

    @Override
    public LocalDecl name(String name) {
        return this.id(this.name.id(name));
    }

    @Override
    public Expr init() {
        return this.init;
    }

    @Override
    public LocalDecl init(Expr init) {
        return this.init(this, init);
    }

    protected <N extends LocalDecl_c> N init(N n, Expr init) {
        if (n.init == init) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.init = init;
        return n;
    }

    @Override
    public VarInstance varInstance() {
        return this.localInstance();
    }

    @Override
    public LocalInstance localInstance() {
        return this.li;
    }

    @Override
    public LocalDecl localInstance(LocalInstance li) {
        return this.localInstance(this, li);
    }

    protected <N extends LocalDecl_c> N localInstance(N n, LocalInstance li) {
        if (n.li == li) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.li = li;
        return n;
    }

    protected <N extends LocalDecl_c> N reconstruct(N n, TypeNode type, Id name, Expr init) {
        n = this.type(n, type);
        n = this.id(n, name);
        n = this.init(n, init);
        return n;
    }

    @Override
    public Node visitChildren(NodeVisitor v) {
        TypeNode type = this.visitChild(this.type, v);
        Id name = this.visitChild(this.name, v);
        Expr init = this.visitChild(this.init, v);
        return this.reconstruct(this, type, name, init);
    }

    @Override
    public Context enterChildScope(Node child, Context c) {
        if (child == this.init) {
            c.addVariable(this.li);
        }
        return super.enterChildScope(child, c);
    }

    @Override
    public void addDecls(Context c) {
        c.addVariable(this.li);
    }

    @Override
    public Node buildTypes(TypeBuilder tb) throws SemanticException {
        LocalDecl_c n = (LocalDecl_c)super.buildTypes(tb);
        TypeSystem ts = tb.typeSystem();
        LocalInstance li = ts.localInstance(this.position(), this.flags(), ts.unknownType(this.position()), this.name());
        n = this.localInstance(n, li);
        return n;
    }

    @Override
    public Node disambiguate(AmbiguityRemover ar) throws SemanticException {
        if (this.li.isCanonical()) {
            return this;
        }
        if (this.declType().isCanonical()) {
            this.li.setType(this.declType());
        }
        return this;
    }

    @Override
    public NodeVisitor typeCheckEnter(TypeChecker tc) throws SemanticException {
        Context c = tc.context();
        LocalInstance outerLocal = c.findLocalSilent(this.li.name());
        if (outerLocal != null && c.isLocal(this.li.name())) {
            throw new SemanticException("Local variable \"" + this.name + "\" multiply defined.  " + "Previous definition at " + outerLocal.position() + ".", this.position());
        }
        return super.typeCheckEnter(tc);
    }

    @Override
    public Node typeCheck(TypeChecker tc) throws SemanticException {
        TypeSystem ts = tc.typeSystem();
        LocalInstance li = this.li;
        try {
            ts.checkLocalFlags(this.flags);
        }
        catch (SemanticException e) {
            throw new SemanticException(e.getMessage(), this.position());
        }
        if (this.init != null) {
            if (this.init instanceof ArrayInit) {
                ((ArrayInit)this.init).typeCheckElements(tc, this.type.type());
            } else if (!(ts.isImplicitCastValid(this.init.type(), this.type.type()) || ts.typeEquals(this.init.type(), this.type.type()) || ts.numericConversionValid(this.type.type(), tc.lang().constantValue(this.init, tc.lang())))) {
                throw new SemanticException("The type of the variable initializer \"" + this.init.type() + "\" does not match that of " + "the declaration \"" + this.type.type() + "\".", this.init.position());
            }
        }
        return this.localInstance(li);
    }

    @Override
    public Node checkConstants(ConstantChecker cc) throws SemanticException {
        if (this.init == null || !cc.lang().isConstant(this.init, cc.lang()) || !this.li.flags().isFinal()) {
            this.li.setNotConstant();
        } else {
            this.li.setConstantValue(cc.lang().constantValue(this.init, cc.lang()));
        }
        return this;
    }

    @Override
    public boolean constantValueSet() {
        return this.li != null && this.li.constantValueSet();
    }

    @Override
    public Type childExpectedType(Expr child, AscriptionVisitor av) {
        if (child == this.init) {
            return this.type.type();
        }
        return child.type();
    }

    @Override
    public Node extRewrite(ExtensionRewriter rw) throws SemanticException {
        LocalDecl_c n = (LocalDecl_c)super.extRewrite(rw);
        n = this.localInstance(n, null);
        return n;
    }

    @Override
    public String toString() {
        return this.flags.translate() + this.type + " " + this.name + (this.init != null ? " = " + this.init : "") + ";";
    }

    @Override
    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        boolean printSemi = tr.appendSemicolon(true);
        boolean printType = tr.printType(true);
        w.write(this.flags.translate());
        if (printType) {
            this.print(this.type, w, tr);
            w.allowBreak(2, 3, " ", 1);
        }
        tr.print(this, this.name, w);
        if (this.init != null) {
            w.write(" =");
            w.allowBreak(2, 2, " ", 1);
            this.print(this.init, w, tr);
        }
        if (printSemi) {
            w.write(";");
        }
        tr.printType(printType);
        tr.appendSemicolon(printSemi);
    }

    @Override
    public void dump(CodeWriter w) {
        super.dump(w);
        if (this.li != null) {
            w.allowBreak(4, " ");
            w.begin(0);
            w.write("(instance " + this.li + ")");
            w.end();
        }
    }

    @Override
    public Term firstChild() {
        return this.type();
    }

    @Override
    public <T> List<T> acceptCFG(CFGBuilder<?> v, List<T> succs) {
        if (this.init() != null) {
            v.visitCFG(this.type(), this.init(), 1);
            v.visitCFG(this.init(), this, 0);
        } else {
            v.visitCFG(this.type(), this, 0);
        }
        return succs;
    }

    @Override
    public Node copy(NodeFactory nf) {
        return nf.LocalDecl(this.position, this.flags, this.type, this.name, this.init);
    }

    protected static class AddDependenciesVisitor
    extends NodeVisitor {
        protected ConstantChecker cc;
        protected LocalInstance li;

        AddDependenciesVisitor(JLang lang, ConstantChecker cc, LocalInstance li) {
            super(lang);
            this.cc = cc;
            this.li = li;
        }

        @Override
        public Node leave(Node old, Node n, NodeVisitor v) {
            Local l;
            Field f;
            if (n instanceof Field && !(f = (Field)n).fieldInstance().orig().constantValueSet()) {
                Scheduler scheduler = this.cc.job().extensionInfo().scheduler();
                Goal g = scheduler.FieldConstantsChecked(f.fieldInstance().orig());
                throw new MissingDependencyException(g);
            }
            if (n instanceof Local && !(l = (Local)n).localInstance().orig().constantValueSet()) {
                this.li.setNotConstant();
            }
            return n;
        }
    }
}

