/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import java.util.List;
import polyglot.ast.ClassDecl;
import polyglot.ast.Ext;
import polyglot.ast.LocalClassDecl;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Stmt_c;
import polyglot.ast.Term;
import polyglot.types.Context;
import polyglot.util.CodeWriter;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.util.SerialVersionUID;
import polyglot.visit.CFGBuilder;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;

public class LocalClassDecl_c
extends Stmt_c
implements LocalClassDecl {
    private static final long serialVersionUID = SerialVersionUID.generate();
    protected ClassDecl decl;

    public LocalClassDecl_c(Position pos, ClassDecl decl) {
        this(pos, decl, null);
    }

    public LocalClassDecl_c(Position pos, ClassDecl decl, Ext ext) {
        super(pos, ext);
        assert (decl != null);
        this.decl = decl;
    }

    @Override
    public ClassDecl decl() {
        return this.decl;
    }

    @Override
    public LocalClassDecl decl(ClassDecl decl) {
        return this.decl(this, decl);
    }

    protected <N extends LocalClassDecl_c> N decl(N n, ClassDecl decl) {
        if (n.decl == decl) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.decl = decl;
        return n;
    }

    protected <N extends LocalClassDecl_c> N reconstruct(N n, ClassDecl decl) {
        n = this.decl(n, decl);
        return n;
    }

    @Override
    public Node visitChildren(NodeVisitor v) {
        ClassDecl decl = this.visitChild(this.decl, v);
        return this.reconstruct(this, decl);
    }

    @Override
    public Term firstChild() {
        return this.decl();
    }

    @Override
    public <T> List<T> acceptCFG(CFGBuilder<?> v, List<T> succs) {
        v.visitCFG(this.decl(), this, 0);
        return succs;
    }

    @Override
    public void addDecls(Context c) {
        if (this.decl.type() == null) {
            return;
        }
        if (!this.decl.type().toClass().isLocal()) {
            throw new InternalCompilerError("Non-local " + this.decl.type() + " found in method body.");
        }
        c.addNamed(this.decl.type().toClass());
    }

    @Override
    public String toString() {
        return this.decl.toString();
    }

    @Override
    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        this.printBlock(this.decl, w, tr);
        w.write(";");
    }

    @Override
    public Node copy(NodeFactory nf) {
        return nf.LocalClassDecl(this.position, this.decl);
    }
}

