/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import java.util.Collection;
import java.util.List;
import polyglot.ast.Block;
import polyglot.ast.CodeBlock;
import polyglot.ast.Ext;
import polyglot.ast.Initializer;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Term;
import polyglot.ast.Term_c;
import polyglot.translate.ExtensionRewriter;
import polyglot.types.ClassType;
import polyglot.types.CodeInstance;
import polyglot.types.ConstructorInstance;
import polyglot.types.Context;
import polyglot.types.Flags;
import polyglot.types.InitializerInstance;
import polyglot.types.MemberInstance;
import polyglot.types.ParsedClassType;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.CodeWriter;
import polyglot.util.Position;
import polyglot.util.SerialVersionUID;
import polyglot.util.SubtypeSet;
import polyglot.visit.CFGBuilder;
import polyglot.visit.ExceptionChecker;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeBuilder;
import polyglot.visit.TypeChecker;

public class Initializer_c
extends Term_c
implements Initializer {
    private static final long serialVersionUID = SerialVersionUID.generate();
    protected Flags flags;
    protected Block body;
    protected InitializerInstance ii;

    public Initializer_c(Position pos, Flags flags, Block body) {
        this(pos, flags, body, null);
    }

    public Initializer_c(Position pos, Flags flags, Block body, Ext ext) {
        super(pos, ext);
        assert (flags != null && body != null);
        this.flags = flags;
        this.body = body;
    }

    @Override
    public boolean isDisambiguated() {
        return this.ii != null && this.ii.isCanonical() && super.isDisambiguated();
    }

    @Override
    public Flags flags() {
        return this.flags;
    }

    @Override
    public Initializer flags(Flags flags) {
        return this.flags(this, flags);
    }

    protected <N extends Initializer_c> N flags(N n, Flags flags) {
        if (n.flags.equals(flags)) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.flags = flags;
        return n;
    }

    @Override
    public CodeInstance codeInstance() {
        return this.initializerInstance();
    }

    @Override
    public MemberInstance memberInstance() {
        return this.initializerInstance();
    }

    @Override
    public InitializerInstance initializerInstance() {
        return this.ii;
    }

    @Override
    public Initializer initializerInstance(InitializerInstance ii) {
        return this.initializerInstance(this, ii);
    }

    protected <N extends Initializer_c> N initializerInstance(N n, InitializerInstance ii) {
        if (n.ii == ii) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.ii = ii;
        return n;
    }

    @Override
    public Term codeBody() {
        return this.body();
    }

    @Override
    public Block body() {
        return this.body;
    }

    @Override
    public CodeBlock body(Block body) {
        return this.body(this, body);
    }

    protected <N extends Initializer_c> N body(N n, Block body) {
        if (n.body == body) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.body = body;
        return n;
    }

    protected <N extends Initializer_c> N reconstruct(N n, Block body) {
        n = this.body(n, body);
        return n;
    }

    @Override
    public Node visitChildren(NodeVisitor v) {
        Block body = this.visitChild(this.body, v);
        return this.reconstruct(this, body);
    }

    @Override
    public Context enterScope(Context c) {
        return c.pushCode(this.ii);
    }

    @Override
    public NodeVisitor buildTypesEnter(TypeBuilder tb) throws SemanticException {
        return tb.pushCode();
    }

    @Override
    public Node buildTypes(TypeBuilder tb) throws SemanticException {
        TypeSystem ts = tb.typeSystem();
        ParsedClassType ct = tb.currentClass();
        InitializerInstance ii = ts.initializerInstance(this.position(), ct, this.flags);
        return this.initializerInstance(ii);
    }

    @Override
    public Node typeCheck(TypeChecker tc) throws SemanticException {
        TypeSystem ts = tc.typeSystem();
        try {
            ts.checkInitializerFlags(this.flags());
        }
        catch (SemanticException e) {
            throw new SemanticException(e.getMessage(), this.position());
        }
        if (this.flags().isStatic() && this.initializerInstance().container().toClass().isInnerClass()) {
            throw new SemanticException("Inner classes cannot declare static initializers.", this.position());
        }
        return this;
    }

    @Override
    public NodeVisitor exceptionCheckEnter(ExceptionChecker ec) throws SemanticException {
        if (this.initializerInstance().flags().isStatic()) {
            return ec.push(new ExceptionChecker.CodeTypeReporter("static initializer block"));
        }
        if (!this.initializerInstance().container().toClass().isAnonymous()) {
            ec = ec.push(new ExceptionChecker.CodeTypeReporter("instance initializer block"));
            SubtypeSet allowed = null;
            ClassType throwable = ec.typeSystem().Throwable();
            ClassType container = this.initializerInstance().container().toClass();
            for (ConstructorInstance constructorInstance : container.constructors()) {
                if (allowed == null) {
                    allowed = new SubtypeSet(throwable);
                    allowed.addAll((Collection<? extends Type>)constructorInstance.throwTypes());
                    continue;
                }
                SubtypeSet other = new SubtypeSet(throwable);
                other.addAll((Collection<? extends Type>)constructorInstance.throwTypes());
                SubtypeSet inter = new SubtypeSet(throwable);
                for (Type t : allowed) {
                    if (!other.contains(t)) continue;
                    inter.add(t);
                }
                for (Type t : other) {
                    if (!allowed.contains(t)) continue;
                    inter.add(t);
                }
                allowed = inter;
            }
            ec = ec.push(allowed);
            return ec;
        }
        return ec.push();
    }

    @Override
    public Node extRewrite(ExtensionRewriter rw) throws SemanticException {
        Initializer_c n = (Initializer_c)super.extRewrite(rw);
        n = this.initializerInstance(n, null);
        return n;
    }

    @Override
    public Term firstChild() {
        return this.body();
    }

    @Override
    public <T> List<T> acceptCFG(CFGBuilder<?> v, List<T> succs) {
        v.visitCFG(this.body(), this, 0);
        return succs;
    }

    @Override
    public String toString() {
        return this.flags.translate() + "{ ... }";
    }

    @Override
    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        w.begin(0);
        w.write(this.flags.translate());
        this.print(this.body, w, tr);
        w.end();
    }

    @Override
    public void dump(CodeWriter w) {
        super.dump(w);
        if (this.ii != null) {
            w.allowBreak(4, " ");
            w.begin(0);
            w.write("(instance " + this.ii + ")");
            w.end();
        }
    }

    @Override
    public Node copy(NodeFactory nf) {
        return nf.Initializer(this.position, this.flags, this.body);
    }
}

