/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import polyglot.ast.Ext;
import polyglot.ast.Import;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Node_c;
import polyglot.main.Options;
import polyglot.types.Named;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.util.CodeWriter;
import polyglot.util.Position;
import polyglot.util.SerialVersionUID;
import polyglot.util.StringUtil;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeBuilder;
import polyglot.visit.TypeChecker;

public class Import_c
extends Node_c
implements Import {
    private static final long serialVersionUID = SerialVersionUID.generate();
    protected Import.Kind kind;
    protected String name;

    public Import_c(Position pos, Import.Kind kind, String name) {
        this(pos, kind, name, null);
    }

    public Import_c(Position pos, Import.Kind kind, String name, Ext ext) {
        super(pos, ext);
        assert (kind != null && name != null);
        this.name = name;
        this.kind = kind;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Import name(String name) {
        return this.name(this, name);
    }

    protected <N extends Import_c> N name(N n, String name) {
        if (n.name == name) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.name = name;
        return n;
    }

    @Override
    public Import.Kind kind() {
        return this.kind;
    }

    @Override
    public Import kind(Import.Kind kind) {
        return this.kind(this, kind);
    }

    protected <N extends Import_c> N kind(N n, Import.Kind kind) {
        if (n.kind == kind) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.kind = kind;
        return n;
    }

    @Override
    public Node buildTypes(TypeBuilder tb) {
        Import_c n = this;
        if (n.kind() == Import.SINGLE_TYPE) {
            tb.importTable().addClassImport(n.name(), n.position());
        } else if (n.kind() == Import.TYPE_IMPORT_ON_DEMAND) {
            tb.importTable().addTypeOnDemandImport(n.name(), n.position());
        }
        return n;
    }

    @Override
    public Node typeCheck(TypeChecker tc) throws SemanticException {
        Type t;
        if (this.kind == TYPE_IMPORT_ON_DEMAND && tc.typeSystem().packageExists(this.name)) {
            return this;
        }
        String pkgName = StringUtil.getFirstComponent(this.name);
        if (!tc.typeSystem().packageExists(pkgName)) {
            throw new SemanticException("Package \"" + pkgName + "\" not found.", this.position());
        }
        Named nt = tc.typeSystem().forName(this.name);
        String fullName = nt.fullName();
        if (!fullName.equals(this.name)) {
            throw new SemanticException("The imported type " + this.name + " is not canonical; use " + fullName + " instead.");
        }
        if (nt instanceof Type && (t = (Type)((Object)nt)).isClass() && !tc.typeSystem().classAccessibleFromPackage(t.toClass(), tc.context().package_())) {
            throw new SemanticException("The imported type " + t + " is not visible.");
        }
        return this;
    }

    @Override
    public String toString() {
        return "import " + this.name + (this.kind == TYPE_IMPORT_ON_DEMAND ? ".*" : "");
    }

    @Override
    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        if (!Options.global.fully_qualified_names) {
            w.write("import ");
            w.write(this.name);
            if (this.kind == TYPE_IMPORT_ON_DEMAND) {
                w.write(".*");
            }
            w.write(";");
            w.newline(0);
        }
    }

    @Override
    public Node copy(NodeFactory nf) {
        return nf.Import(this.position, this.kind, this.name);
    }
}

