/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import java.util.List;
import polyglot.ast.Block;
import polyglot.ast.Expr;
import polyglot.ast.Ext;
import polyglot.ast.If;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Stmt;
import polyglot.ast.Stmt_c;
import polyglot.ast.Term;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.CodeWriter;
import polyglot.util.Position;
import polyglot.util.SerialVersionUID;
import polyglot.visit.AscriptionVisitor;
import polyglot.visit.CFGBuilder;
import polyglot.visit.FlowGraph;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeChecker;

public class If_c
extends Stmt_c
implements If {
    private static final long serialVersionUID = SerialVersionUID.generate();
    protected Expr cond;
    protected Stmt consequent;
    protected Stmt alternative;

    public If_c(Position pos, Expr cond, Stmt consequent, Stmt alternative) {
        this(pos, cond, consequent, alternative, null);
    }

    public If_c(Position pos, Expr cond, Stmt consequent, Stmt alternative, Ext ext) {
        super(pos, ext);
        assert (cond != null && consequent != null);
        this.cond = cond;
        this.consequent = consequent;
        this.alternative = alternative;
    }

    @Override
    public Expr cond() {
        return this.cond;
    }

    @Override
    public If cond(Expr cond) {
        return this.cond(this, cond);
    }

    protected <N extends If_c> N cond(N n, Expr cond) {
        if (n.cond == cond) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.cond = cond;
        return n;
    }

    @Override
    public Stmt consequent() {
        return this.consequent;
    }

    @Override
    public If consequent(Stmt consequent) {
        return this.consequent(this, consequent);
    }

    protected <N extends If_c> N consequent(N n, Stmt consequent) {
        if (n.consequent == consequent) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.consequent = consequent;
        return n;
    }

    @Override
    public Stmt alternative() {
        return this.alternative;
    }

    @Override
    public If alternative(Stmt alternative) {
        return this.alternative(this, alternative);
    }

    protected <N extends If_c> N alternative(N n, Stmt alternative) {
        if (n.alternative == alternative) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.alternative = alternative;
        return n;
    }

    protected <N extends If_c> N reconstruct(N n, Expr cond, Stmt consequent, Stmt alternative) {
        n = this.cond(n, cond);
        n = this.consequent(n, consequent);
        n = this.alternative(n, alternative);
        return n;
    }

    @Override
    public Node visitChildren(NodeVisitor v) {
        Expr cond = this.visitChild(this.cond, v);
        Stmt consequent = this.visitChild(this.consequent, v);
        Stmt alternative = this.visitChild(this.alternative, v);
        return this.reconstruct(this, cond, consequent, alternative);
    }

    @Override
    public Node typeCheck(TypeChecker tc) throws SemanticException {
        TypeSystem ts = tc.typeSystem();
        if (!ts.isImplicitCastValid(this.cond.type(), ts.Boolean())) {
            throw new SemanticException("Condition of if statement must have boolean type.", this.cond.position());
        }
        return this;
    }

    @Override
    public Type childExpectedType(Expr child, AscriptionVisitor av) {
        TypeSystem ts = av.typeSystem();
        if (child == this.cond) {
            return ts.Boolean();
        }
        return child.type();
    }

    @Override
    public String toString() {
        return "if (" + this.cond + ") " + this.consequent + (this.alternative != null ? " else " + this.alternative : "");
    }

    @Override
    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        w.write("if (");
        this.printBlock(this.cond, w, tr);
        w.write(")");
        this.printSubStmt(this.consequent, w, tr);
        if (this.alternative != null) {
            if (this.consequent instanceof Block) {
                w.allowBreak(0, 2, " ", 1);
            } else {
                w.allowBreak(0, " ");
            }
            if (this.alternative instanceof Block) {
                w.write("else ");
                this.print(this.alternative, w, tr);
            } else {
                w.write("else");
                this.printSubStmt(this.alternative, w, tr);
            }
        }
    }

    @Override
    public Term firstChild() {
        return this.cond;
    }

    @Override
    public <T> List<T> acceptCFG(CFGBuilder<?> v, List<T> succs) {
        if (v.lang().isConstant(this.cond, v.lang()) && v.skipDeadIfBranches()) {
            boolean condConstantValue = (Boolean)v.lang().constantValue(this.cond, v.lang());
            if (condConstantValue) {
                v.visitCFG((Term)this.cond, FlowGraph.EDGE_KEY_TRUE, this.consequent, 1);
                v.visitCFG(this.consequent, this, 0);
            } else if (this.alternative == null) {
                v.visitCFG(this.cond, this, 0);
            } else {
                v.visitCFG((Term)this.cond, FlowGraph.EDGE_KEY_FALSE, this.alternative, 1);
                v.visitCFG(this.alternative, this, 0);
            }
        } else if (this.alternative == null) {
            v.visitCFG(this.cond, FlowGraph.EDGE_KEY_TRUE, this.consequent, 1, FlowGraph.EDGE_KEY_FALSE, this, 0);
            v.visitCFG(this.consequent, this, 0);
        } else {
            v.visitCFG(this.cond, FlowGraph.EDGE_KEY_TRUE, this.consequent, 1, FlowGraph.EDGE_KEY_FALSE, this.alternative, 1);
            v.visitCFG(this.consequent, this, 0);
            v.visitCFG(this.alternative, this, 0);
        }
        return succs;
    }

    @Override
    public Node copy(NodeFactory nf) {
        return nf.If(this.position, this.cond, this.consequent, this.alternative);
    }
}

