/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import java.util.List;
import polyglot.ast.Ext;
import polyglot.ast.Formal;
import polyglot.ast.Id;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Term;
import polyglot.ast.Term_c;
import polyglot.ast.TypeNode;
import polyglot.translate.ExtensionRewriter;
import polyglot.types.Context;
import polyglot.types.Flags;
import polyglot.types.LocalInstance;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.CodeWriter;
import polyglot.util.Position;
import polyglot.util.SerialVersionUID;
import polyglot.visit.AmbiguityRemover;
import polyglot.visit.CFGBuilder;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeBuilder;
import polyglot.visit.TypeChecker;

public class Formal_c
extends Term_c
implements Formal {
    private static final long serialVersionUID = SerialVersionUID.generate();
    protected LocalInstance li;
    protected Flags flags;
    protected TypeNode type;
    protected Id name;

    public Formal_c(Position pos, Flags flags, TypeNode type, Id name) {
        this(pos, flags, type, name, null);
    }

    public Formal_c(Position pos, Flags flags, TypeNode type, Id name, Ext ext) {
        super(pos, ext);
        assert (flags != null && type != null && name != null);
        this.flags = flags;
        this.type = type;
        this.name = name;
    }

    @Override
    public boolean isDisambiguated() {
        return this.li != null && this.li.isCanonical() && super.isDisambiguated();
    }

    @Override
    public Type declType() {
        return this.type.type();
    }

    @Override
    public Flags flags() {
        return this.flags;
    }

    @Override
    public Formal flags(Flags flags) {
        return this.flags(this, flags);
    }

    protected <N extends Formal_c> N flags(N n, Flags flags) {
        if (n.flags.equals(flags)) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.flags = flags;
        return n;
    }

    @Override
    public TypeNode type() {
        return this.type;
    }

    @Override
    public Formal type(TypeNode type) {
        return this.type(this, type);
    }

    protected <N extends Formal_c> N type(N n, TypeNode type) {
        if (n.type == type) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.type = type;
        return n;
    }

    @Override
    public Id id() {
        return this.name;
    }

    @Override
    public Formal id(Id name) {
        return this.id(this, name);
    }

    protected <N extends Formal_c> N id(N n, Id name) {
        if (n.name == name) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.name = name;
        return n;
    }

    @Override
    public String name() {
        return this.name.id();
    }

    @Override
    public Formal name(String name) {
        return this.id(this.name.id(name));
    }

    @Override
    public LocalInstance localInstance() {
        return this.li;
    }

    @Override
    public Formal localInstance(LocalInstance li) {
        return this.localInstance(this, li);
    }

    protected <N extends Formal_c> N localInstance(N n, LocalInstance li) {
        if (n.li == li) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.li = li;
        return n;
    }

    protected <N extends Formal_c> N reconstruct(N n, TypeNode type, Id name) {
        n = this.type(n, type);
        n = this.id(n, name);
        return n;
    }

    @Override
    public Node visitChildren(NodeVisitor v) {
        TypeNode type = this.visitChild(this.type, v);
        Id name = this.visitChild(this.name, v);
        return this.reconstruct(this, type, name);
    }

    @Override
    public void addDecls(Context c) {
        c.addVariable(this.li);
    }

    @Override
    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        w.write(this.flags.translate());
        this.print(this.type, w, tr);
        w.write(" ");
        tr.print(this, this.name, w);
    }

    @Override
    public Node buildTypes(TypeBuilder tb) throws SemanticException {
        Formal_c n = (Formal_c)super.buildTypes(tb);
        TypeSystem ts = tb.typeSystem();
        LocalInstance li = ts.localInstance(this.position(), this.flags(), ts.unknownType(this.position()), this.name());
        n = this.localInstance(n, li);
        return n;
    }

    @Override
    public Node disambiguate(AmbiguityRemover ar) throws SemanticException {
        if (this.li.isCanonical()) {
            return this;
        }
        if (this.declType().isCanonical()) {
            this.li.setType(this.declType());
        }
        this.li.setNotConstant();
        return this;
    }

    @Override
    public Node typeCheck(TypeChecker tc) throws SemanticException {
        Context c = tc.context();
        LocalInstance outerLocal = c.findLocalSilent(this.li.name());
        if (outerLocal != null && outerLocal != this.li && c.isLocal(this.li.name())) {
            throw new SemanticException("Local variable \"" + this.name + "\" multiply defined.  " + "Previous definition at " + outerLocal.position() + ".", this.position());
        }
        TypeSystem ts = tc.typeSystem();
        try {
            ts.checkLocalFlags(this.flags());
        }
        catch (SemanticException e) {
            throw new SemanticException(e.getMessage(), this.position());
        }
        return this;
    }

    @Override
    public Node extRewrite(ExtensionRewriter rw) throws SemanticException {
        Formal_c n = (Formal_c)super.extRewrite(rw);
        n = this.localInstance(n, null);
        return n;
    }

    @Override
    public Term firstChild() {
        return this.type;
    }

    @Override
    public <T> List<T> acceptCFG(CFGBuilder<?> v, List<T> succs) {
        v.visitCFG(this.type, this, 0);
        return succs;
    }

    @Override
    public void dump(CodeWriter w) {
        super.dump(w);
        if (this.li != null) {
            w.allowBreak(4, " ");
            w.begin(0);
            w.write("(instance " + this.li + ")");
            w.end();
        }
        w.allowBreak(4, " ");
        w.begin(0);
        w.write("(name " + this.name + ")");
        w.end();
    }

    @Override
    public String toString() {
        return this.flags.translate() + this.type + " " + this.name;
    }

    @Override
    public Node copy(NodeFactory nf) {
        return nf.Formal(this.position, this.flags, this.type, this.name);
    }
}

