/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import java.util.Iterator;
import java.util.List;
import polyglot.ast.Expr;
import polyglot.ast.Ext;
import polyglot.ast.For;
import polyglot.ast.ForInit;
import polyglot.ast.ForUpdate;
import polyglot.ast.LocalDecl;
import polyglot.ast.Loop_c;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Stmt;
import polyglot.ast.Term;
import polyglot.types.Context;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.CodeWriter;
import polyglot.util.CollectionUtil;
import polyglot.util.InternalCompilerError;
import polyglot.util.ListUtil;
import polyglot.util.Position;
import polyglot.util.SerialVersionUID;
import polyglot.visit.AscriptionVisitor;
import polyglot.visit.CFGBuilder;
import polyglot.visit.FlowGraph;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeChecker;

public class For_c
extends Loop_c
implements For {
    private static final long serialVersionUID = SerialVersionUID.generate();
    protected List<ForInit> inits;
    protected List<ForUpdate> iters;

    public For_c(Position pos, List<ForInit> inits, Expr cond, List<ForUpdate> iters, Stmt body) {
        this(pos, inits, cond, iters, body, null);
    }

    public For_c(Position pos, List<ForInit> inits, Expr cond, List<ForUpdate> iters, Stmt body, Ext ext) {
        super(pos, cond, body, ext);
        assert (inits != null && iters != null);
        this.inits = ListUtil.copy(inits, true);
        this.iters = ListUtil.copy(iters, true);
    }

    @Override
    public List<ForInit> inits() {
        return this.inits;
    }

    @Override
    public For inits(List<ForInit> inits) {
        return this.inits(this, inits);
    }

    protected <N extends For_c> N inits(N n, List<ForInit> inits) {
        if (CollectionUtil.equals(n.inits, inits)) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.inits = ListUtil.copy(inits, true);
        return n;
    }

    @Override
    public For cond(Expr cond) {
        return this.cond(this, cond);
    }

    @Override
    public List<ForUpdate> iters() {
        return this.iters;
    }

    @Override
    public For iters(List<ForUpdate> iters) {
        return this.iters(this, iters);
    }

    protected <N extends For_c> N iters(N n, List<ForUpdate> iters) {
        if (CollectionUtil.equals(n.iters, iters)) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.iters = ListUtil.copy(iters, true);
        return n;
    }

    @Override
    public For body(Stmt body) {
        return this.body(this, body);
    }

    protected <N extends For_c> N reconstruct(N n, List<ForInit> inits, Expr cond, List<ForUpdate> iters, Stmt body) {
        n = super.reconstruct(n, cond, body);
        n = this.inits(n, inits);
        n = this.iters(n, iters);
        return n;
    }

    @Override
    public Node visitChildren(NodeVisitor v) {
        List<ForInit> inits = this.visitList(this.inits, v);
        Expr cond = this.visitChild(this.cond, v);
        List<ForUpdate> iters = this.visitList(this.iters, v);
        Stmt body = this.visitChild(this.body, v);
        return this.reconstruct(this, inits, cond, iters, body);
    }

    @Override
    public Context enterScope(Context c) {
        return c.pushBlock();
    }

    @Override
    public Node typeCheck(TypeChecker tc) throws SemanticException {
        TypeSystem ts = tc.typeSystem();
        Type t = null;
        for (ForInit s : this.inits) {
            if (!(s instanceof LocalDecl)) continue;
            LocalDecl d = (LocalDecl)s;
            Type dt = d.type().type();
            if (t == null) {
                t = dt;
                continue;
            }
            if (t.typeEquals(dt)) continue;
            throw new InternalCompilerError("Local variable declarations in a for loop initializer must all be the same type, in this case " + t + ", not " + dt + ".", d.position());
        }
        if (this.cond != null && !ts.isImplicitCastValid(this.cond.type(), ts.Boolean())) {
            throw new SemanticException("The condition of a for statement must have boolean type.", this.cond.position());
        }
        return this;
    }

    @Override
    public Type childExpectedType(Expr child, AscriptionVisitor av) {
        TypeSystem ts = av.typeSystem();
        if (child == this.cond) {
            return ts.Boolean();
        }
        return child.type();
    }

    @Override
    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        w.write("for (");
        w.begin(0);
        if (this.inits != null) {
            boolean first = true;
            Iterator<ForInit> i = this.inits.iterator();
            while (i.hasNext()) {
                ForInit s = i.next();
                this.printForInit(s, w, tr, first);
                first = false;
                if (!i.hasNext()) continue;
                w.write(",");
                w.allowBreak(2, " ");
            }
        }
        w.write(";");
        w.allowBreak(0);
        if (this.cond != null) {
            this.printBlock(this.cond, w, tr);
        }
        w.write(";");
        w.allowBreak(0);
        if (this.iters != null) {
            Iterator<ForUpdate> i = this.iters.iterator();
            while (i.hasNext()) {
                ForUpdate s = i.next();
                this.printForUpdate(s, w, tr);
                if (!i.hasNext()) continue;
                w.write(",");
                w.allowBreak(2, " ");
            }
        }
        w.end();
        w.write(")");
        this.printSubStmt(this.body, w, tr);
    }

    @Override
    public String toString() {
        return "for (...) ...";
    }

    private void printForInit(ForInit s, CodeWriter w, PrettyPrinter tr, boolean printType) {
        boolean oldSemiColon = tr.appendSemicolon(false);
        boolean oldPrintType = tr.printType(printType);
        this.printBlock(s, w, tr);
        tr.printType(oldPrintType);
        tr.appendSemicolon(oldSemiColon);
    }

    private void printForUpdate(ForUpdate s, CodeWriter w, PrettyPrinter tr) {
        boolean oldSemiColon = tr.appendSemicolon(false);
        this.printBlock(s, w, tr);
        tr.appendSemicolon(oldSemiColon);
    }

    @Override
    public Term firstChild() {
        return For_c.listChild(this.inits, this.cond != null ? this.cond : this.body);
    }

    @Override
    public <T> List<T> acceptCFG(CFGBuilder<?> v, List<T> succs) {
        v.visitCFGList(this.inits, this.cond != null ? this.cond : this.body, 1);
        if (this.cond != null) {
            if (v.lang().condIsConstantTrue(this, v.lang())) {
                v.visitCFG(this.cond, this.body, 1);
            } else {
                if (v.lang().condIsConstantFalse(this, v.lang()) && v.skipDeadLoopBodies()) {
                    v.visitCFG((Term)this.cond, FlowGraph.EDGE_KEY_FALSE, this, 0);
                    return succs;
                }
                v.visitCFG(this.cond, FlowGraph.EDGE_KEY_TRUE, this.body, 1, FlowGraph.EDGE_KEY_FALSE, this, 0);
            }
        }
        v.push(this).visitCFG(this.body, this.lang().continueTarget(this), 1);
        v.visitCFGList(this.iters, this.cond != null ? this.cond : this.body, 1);
        return succs;
    }

    @Override
    public Term continueTarget() {
        return For_c.listChild(this.iters, this.cond != null ? this.cond : this.body);
    }

    @Override
    public Node copy(NodeFactory nf) {
        return nf.For(this.position, this.inits, this.cond, this.iters, this.body);
    }
}

