/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import polyglot.ast.Ext;
import polyglot.ast.FloatLit;
import polyglot.ast.Lang;
import polyglot.ast.Lit_c;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Precedence;
import polyglot.types.SemanticException;
import polyglot.util.CodeWriter;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.util.SerialVersionUID;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeChecker;

public class FloatLit_c
extends Lit_c
implements FloatLit {
    private static final long serialVersionUID = SerialVersionUID.generate();
    protected FloatLit.Kind kind;
    protected double value;

    public FloatLit_c(Position pos, FloatLit.Kind kind, double value) {
        this(pos, kind, value, null);
    }

    public FloatLit_c(Position pos, FloatLit.Kind kind, double value, Ext ext) {
        super(pos, ext);
        assert (kind != null);
        this.kind = kind;
        this.value = value;
    }

    @Override
    public FloatLit.Kind kind() {
        return this.kind;
    }

    @Override
    public FloatLit kind(FloatLit.Kind kind) {
        return this.kind(this, kind);
    }

    protected <N extends FloatLit_c> N kind(N n, FloatLit.Kind kind) {
        if (n.kind == kind) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.kind = kind;
        return n;
    }

    @Override
    public double value() {
        return this.value;
    }

    @Override
    public FloatLit value(double value) {
        return this.value(this, value);
    }

    protected <N extends FloatLit_c> N value(N n, double value) {
        if (n.value == value) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.value = value;
        return n;
    }

    @Override
    public Node typeCheck(TypeChecker tc) throws SemanticException {
        if (this.kind == FLOAT) {
            return this.type(tc.typeSystem().Float());
        }
        if (this.kind == DOUBLE) {
            return this.type(tc.typeSystem().Double());
        }
        throw new InternalCompilerError("Unrecognized FloatLit kind " + this.kind);
    }

    @Override
    public String toString() {
        return Double.toString(this.value);
    }

    @Override
    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        if (this.kind == FLOAT) {
            w.write(Float.toString((float)this.value) + "F");
        } else if (this.kind == DOUBLE) {
            w.write(Double.toString(this.value));
        } else {
            throw new InternalCompilerError("Unrecognized FloatLit kind " + this.kind);
        }
    }

    @Override
    public Object constantValue(Lang lang) {
        if (this.kind == FLOAT) {
            return new Float(this.value);
        }
        return new Double(this.value);
    }

    @Override
    public Precedence precedence() {
        if (this.value < 0.0) {
            return Precedence.UNARY;
        }
        return Precedence.LITERAL;
    }

    @Override
    public Node copy(NodeFactory nf) {
        return nf.FloatLit(this.position, this.kind, this.value);
    }
}

