/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import java.util.Collections;
import java.util.List;
import polyglot.ast.AmbReceiver;
import polyglot.ast.Expr;
import polyglot.ast.Expr_c;
import polyglot.ast.Ext;
import polyglot.ast.Field;
import polyglot.ast.Id;
import polyglot.ast.Lang;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Precedence;
import polyglot.ast.Receiver;
import polyglot.ast.Special;
import polyglot.ast.Term;
import polyglot.ast.TypeNode;
import polyglot.translate.ExtensionRewriter;
import polyglot.types.Context;
import polyglot.types.FieldInstance;
import polyglot.types.Flags;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.types.VarInstance;
import polyglot.util.CodeWriter;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.util.SerialVersionUID;
import polyglot.visit.AscriptionVisitor;
import polyglot.visit.CFGBuilder;
import polyglot.visit.ConstantChecker;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeBuilder;
import polyglot.visit.TypeChecker;

public class Field_c
extends Expr_c
implements Field {
    private static final long serialVersionUID = SerialVersionUID.generate();
    protected Receiver target;
    protected Id name;
    protected FieldInstance fi;
    protected boolean targetImplicit;

    public Field_c(Position pos, Receiver target, Id name) {
        this(pos, target, name, null);
    }

    public Field_c(Position pos, Receiver target, Id name, Ext ext) {
        super(pos, ext);
        assert (target != null && name != null);
        this.target = target;
        this.name = name;
        this.targetImplicit = false;
        if (target == null) {
            throw new InternalCompilerError("Cannot create a field with a null target.  Use AmbExpr or prefix with the appropriate type node or this.");
        }
    }

    @Override
    public Precedence precedence() {
        return Precedence.LITERAL;
    }

    @Override
    public Receiver target() {
        return this.target;
    }

    @Override
    public Field target(Receiver target) {
        return this.target(this, target);
    }

    protected <N extends Field_c> N target(N n, Receiver target) {
        if (n.target == target) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.target = target;
        return n;
    }

    @Override
    public Id id() {
        return this.name;
    }

    @Override
    public Field id(Id name) {
        return this.id(this, name);
    }

    protected <N extends Field_c> N id(N n, Id name) {
        if (n.name == name) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.name = name;
        return n;
    }

    @Override
    public String name() {
        return this.name.id();
    }

    @Override
    public Field name(String name) {
        return this.id(this.name.id(name));
    }

    @Override
    public Flags flags() {
        return this.fi.flags();
    }

    @Override
    public VarInstance varInstance() {
        return this.fieldInstance();
    }

    @Override
    public FieldInstance fieldInstance() {
        return this.fi;
    }

    @Override
    public Field fieldInstance(FieldInstance fi) {
        return this.fieldInstance(this, fi);
    }

    protected <N extends Field_c> N fieldInstance(N n, FieldInstance fi) {
        if (n.fi == fi) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.fi = fi;
        return n;
    }

    @Override
    public boolean isTargetImplicit() {
        return this.targetImplicit;
    }

    @Override
    public Field targetImplicit(boolean targetImplicit) {
        return this.targetImplicit(this, targetImplicit);
    }

    protected <N extends Field_c> N targetImplicit(N n, boolean targetImplicit) {
        if (n.targetImplicit == targetImplicit) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.targetImplicit = targetImplicit;
        return n;
    }

    protected <N extends Field_c> N reconstruct(N n, Receiver target, Id name) {
        n = this.target(n, target);
        n = this.id(n, name);
        return n;
    }

    @Override
    public Node visitChildren(NodeVisitor v) {
        Receiver target = this.visitChild(this.target, v);
        Id name = this.visitChild(this.name, v);
        return this.reconstruct(this, target, name);
    }

    @Override
    public Node buildTypes(TypeBuilder tb) throws SemanticException {
        Field_c n = (Field_c)super.buildTypes(tb);
        TypeSystem ts = tb.typeSystem();
        FieldInstance fi = ts.fieldInstance(this.position(), tb.currentClass(), Flags.NONE, ts.unknownType(this.position()), this.name.id());
        n = this.fieldInstance(n, fi);
        return n;
    }

    @Override
    public Node typeCheck(TypeChecker tc) throws SemanticException {
        Context c = tc.context();
        TypeSystem ts = tc.typeSystem();
        if (this.target.type().isReference()) {
            FieldInstance fi = ts.findField(this.target.type().toReference(), this.name.id(), c.currentClass(), !(this.target instanceof Special));
            if (fi == null) {
                throw new InternalCompilerError("Cannot access field on node of type " + this.target.getClass().getName() + ".");
            }
            Field_c f = this;
            f = this.fieldInstance(f, fi);
            f = this.type(f, fi.type());
            f.checkConsistency(c);
            if (!fi.flags().isStatic() && this.target instanceof TypeNode) {
                throw new SemanticException("Non-static field " + this.name.id() + " cannot be referenced " + "from a static context.", f.position());
            }
            return f;
        }
        throw new SemanticException("Cannot access field \"" + this.name.id() + "\" " + (this.target instanceof Expr ? "on an expression " : "") + "of non-reference type \"" + this.target.type() + "\".", this.target.position());
    }

    @Override
    public Node checkConstants(ConstantChecker cc) throws SemanticException {
        cc.lang().isConstant(this, cc.lang());
        return this;
    }

    @Override
    public Type childExpectedType(Expr child, AscriptionVisitor av) {
        if (child == this.target) {
            return this.fi.container();
        }
        return child.type();
    }

    @Override
    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        w.begin(0);
        if (!this.targetImplicit) {
            if (this.target instanceof Expr) {
                this.printSubExpr((Expr)this.target, w, tr);
            } else if (this.target instanceof TypeNode || this.target instanceof AmbReceiver) {
                this.print(this.target, w, tr);
            }
            w.write(".");
            w.allowBreak(2, 3, "", 0);
        }
        tr.print(this, this.name, w);
        w.end();
    }

    @Override
    public void dump(CodeWriter w) {
        super.dump(w);
        if (this.fi != null) {
            w.allowBreak(4, " ");
            w.begin(0);
            w.write("(instance " + this.fi + ")");
            w.end();
        }
        w.allowBreak(4, " ");
        w.begin(0);
        w.write("(name \"" + this.name + "\")");
        w.end();
    }

    @Override
    public Term firstChild() {
        if (this.target instanceof Term) {
            return (Term)((Object)this.target);
        }
        return null;
    }

    @Override
    public <T> List<T> acceptCFG(CFGBuilder<?> v, List<T> succs) {
        if (this.target instanceof Term) {
            v.visitCFG((Term)((Object)this.target), this, 0);
        }
        return succs;
    }

    @Override
    public String toString() {
        return (this.target != null ? this.target + "." : "") + this.name;
    }

    @Override
    public List<Type> throwTypes(TypeSystem ts) {
        if (this.target instanceof Expr && !(this.target instanceof Special)) {
            return Collections.singletonList(ts.NullPointerException());
        }
        return Collections.emptyList();
    }

    @Override
    public NodeVisitor extRewriteEnter(ExtensionRewriter rw) throws SemanticException {
        if (this.isTargetImplicit()) {
            return rw.bypass(this.target());
        }
        return super.extRewriteEnter(rw);
    }

    @Override
    public Node extRewrite(ExtensionRewriter rw) throws SemanticException {
        if (this.isTargetImplicit()) {
            return rw.nodeFactory().AmbExpr(this.position, this.name);
        }
        Field_c n = (Field_c)super.extRewrite(rw);
        n = this.fieldInstance(n, null);
        return n;
    }

    @Override
    public boolean constantValueSet(Lang lang) {
        if (this.fi != null && (this.target instanceof TypeNode || this.target instanceof Special && this.targetImplicit)) {
            return this.fi.constantValueSet();
        }
        return this.fi != null;
    }

    @Override
    public boolean isConstant(Lang lang) {
        if (this.fi != null && (this.target instanceof TypeNode || this.target instanceof Special && this.targetImplicit)) {
            return this.fi.isConstant();
        }
        return false;
    }

    @Override
    public Object constantValue(Lang lang) {
        if (lang.isConstant(this, lang)) {
            return this.fi.constantValue();
        }
        return null;
    }

    protected void checkConsistency(Context c) {
        if (this.targetImplicit) {
            VarInstance vi = c.findVariableSilent(this.name.id());
            if (vi instanceof FieldInstance) {
                FieldInstance rfi = (FieldInstance)vi;
                if (c.typeSystem().equals(rfi.orig(), this.fi.orig())) {
                    return;
                }
                System.out.println("(found) rfi is " + rfi.orig());
                System.out.println("(actual) fi is " + this.fi.orig());
            }
            throw new InternalCompilerError("Field " + this + " has an " + "implicit target, but the name " + this.name.id() + " resolves to " + vi + " instead of " + this.target, this.position());
        }
    }

    @Override
    public Node copy(NodeFactory nf) {
        return nf.Field(this.position, this.target, this.name);
    }
}

