/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import java.util.ArrayList;
import java.util.List;
import polyglot.ast.Assign;
import polyglot.ast.Assign_c;
import polyglot.ast.Expr;
import polyglot.ast.Ext;
import polyglot.ast.Field;
import polyglot.ast.FieldAssign;
import polyglot.ast.Node;
import polyglot.ast.Term;
import polyglot.translate.ExtensionRewriter;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.util.SerialVersionUID;
import polyglot.visit.CFGBuilder;
import polyglot.visit.NodeVisitor;

public class FieldAssign_c
extends Assign_c
implements FieldAssign {
    private static final long serialVersionUID = SerialVersionUID.generate();

    public FieldAssign_c(Position pos, Field left, Assign.Operator op, Expr right) {
        this(pos, left, op, right, null);
    }

    public FieldAssign_c(Position pos, Field left, Assign.Operator op, Expr right, Ext ext) {
        super(pos, left, op, right, ext);
    }

    @Override
    public Field left() {
        return (Field)super.left();
    }

    @Override
    public Assign left(Expr left) {
        FieldAssign_c.assertLeftType(left);
        return super.left(left);
    }

    private static void assertLeftType(Expr left) {
        if (!(left instanceof Field)) {
            throw new InternalCompilerError("left expression of an FieldAssign must be a field");
        }
    }

    @Override
    public Term firstChild() {
        Field f = this.left();
        if (f.target() instanceof Expr) {
            return (Expr)f.target();
        }
        if (this.operator() != Assign.ASSIGN) {
            return f;
        }
        return this.right();
    }

    @Override
    protected void acceptCFGAssign(CFGBuilder<?> v) {
        Field f = this.left();
        if (f.target() instanceof Expr) {
            Expr o = (Expr)f.target();
            v.visitCFG(o, this.right(), 1);
            v.visitCFG(this.right(), this, 0);
        } else {
            v.visitCFG(this.right(), this, 0);
        }
    }

    @Override
    protected void acceptCFGOpAssign(CFGBuilder<?> v) {
        v.visitCFG(this.left(), this.right(), 1);
        v.visitCFG(this.right(), this, 0);
    }

    @Override
    public List<Type> throwTypes(TypeSystem ts) {
        ArrayList<Type> l = new ArrayList<Type>(super.throwTypes(ts));
        Field f = this.left();
        if (f.target() instanceof Expr) {
            l.add(ts.NullPointerException());
        }
        return l;
    }

    @Override
    public NodeVisitor extRewriteEnter(ExtensionRewriter rw) throws SemanticException {
        return rw.bypass(this.left());
    }

    @Override
    public Node extRewrite(ExtensionRewriter rw) throws SemanticException {
        Expr left = this.visitChild(this.left(), rw);
        if (!left.isDisambiguated()) {
            return rw.nodeFactory().AmbAssign(this.position, left, this.op, this.right);
        }
        FieldAssign_c n = (FieldAssign_c)super.extRewrite(rw);
        n = this.left(n, left);
        return n;
    }
}

