/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import polyglot.ast.Expr;
import polyglot.ast.ExprOps;
import polyglot.ast.Ext;
import polyglot.ast.JLangToJLDel;
import polyglot.ast.Lang;
import polyglot.ast.Node;
import polyglot.ast.Precedence;
import polyglot.ast.Term_c;
import polyglot.translate.ExtensionRewriter;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.util.CodeWriter;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.util.SerialVersionUID;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeBuilder;

public abstract class Expr_c
extends Term_c
implements Expr,
ExprOps {
    private static final long serialVersionUID = SerialVersionUID.generate();
    protected Type type;

    @Deprecated
    public Expr_c(Position pos) {
        this(pos, null);
    }

    public Expr_c(Position pos, Ext ext) {
        super(pos, ext);
    }

    @Override
    public Type type() {
        return this.type;
    }

    @Override
    public Expr type(Type type) {
        return this.type(this, type);
    }

    protected <N extends Expr_c> N type(N n, Type type) {
        if (n.type == type) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.type = type;
        return n;
    }

    @Override
    public void dump(CodeWriter w) {
        super.dump(w);
        if (this.type != null) {
            w.allowBreak(4, " ");
            w.begin(0);
            w.write("(type " + this.type + ")");
            w.end();
        }
    }

    @Override
    public Precedence precedence() {
        return Precedence.UNKNOWN;
    }

    @Deprecated
    protected Lang lastLang() {
        Lang lang = this.lang();
        for (Ext ext = this.ext(); ext != null; ext = ext.ext()) {
            try {
                lang = ext.lang();
                continue;
            }
            catch (InternalCompilerError e) {
                return JLangToJLDel.instance;
            }
        }
        return lang;
    }

    @Override
    @Deprecated
    public boolean constantValueSet() {
        return this.lastLang().constantValueSet(this, this.lastLang());
    }

    @Override
    @Deprecated
    public boolean isConstant() {
        return this.lastLang().isConstant(this, this.lastLang());
    }

    @Override
    @Deprecated
    public Object constantValue() {
        return this.lastLang().constantValue(this, this.lastLang());
    }

    @Override
    public boolean constantValueSet(Lang lang) {
        return true;
    }

    @Override
    public boolean isConstant(Lang lang) {
        return false;
    }

    @Override
    public Object constantValue(Lang lang) {
        return null;
    }

    public String stringValue(Lang lang) {
        return (String)lang.constantValue(this, lang);
    }

    public boolean booleanValue(Lang lang) {
        return (Boolean)lang.constantValue(this, lang);
    }

    public byte byteValue(Lang lang) {
        return (Byte)lang.constantValue(this, lang);
    }

    public short shortValue(Lang lang) {
        return (Short)lang.constantValue(this, lang);
    }

    public char charValue(Lang lang) {
        return ((Character)lang.constantValue(this, lang)).charValue();
    }

    public int intValue(Lang lang) {
        return (Integer)lang.constantValue(this, lang);
    }

    public long longValue(Lang lang) {
        return (Long)lang.constantValue(this, lang);
    }

    public float floatValue(Lang lang) {
        return ((Float)lang.constantValue(this, lang)).floatValue();
    }

    public double doubleValue(Lang lang) {
        return (Double)lang.constantValue(this, lang);
    }

    @Override
    public boolean isTypeChecked() {
        return super.isTypeChecked() && this.type != null && this.type.isCanonical();
    }

    @Override
    public Node buildTypes(TypeBuilder tb) throws SemanticException {
        return this.type(tb.typeSystem().unknownType(this.position()));
    }

    @Override
    public Node extRewrite(ExtensionRewriter rw) throws SemanticException {
        Expr n = (Expr)super.extRewrite(rw);
        return n.type(null);
    }

    @Override
    public void printSubExpr(Expr expr, CodeWriter w, PrettyPrinter pp) {
        this.printSubExpr(expr, true, w, pp);
    }

    @Override
    public void printSubExpr(Expr expr, boolean associative, CodeWriter w, PrettyPrinter pp) {
        if (!associative && this.precedence().equals(expr.precedence()) || this.precedence().isTighter(expr.precedence())) {
            w.write("(");
            this.printBlock(expr, w, pp);
            w.write(")");
        } else {
            this.print(expr, w, pp);
        }
    }
}

