/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import java.util.List;
import polyglot.ast.Eval;
import polyglot.ast.Expr;
import polyglot.ast.Ext;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Stmt_c;
import polyglot.ast.Term;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.CodeWriter;
import polyglot.util.Position;
import polyglot.util.SerialVersionUID;
import polyglot.visit.AscriptionVisitor;
import polyglot.visit.CFGBuilder;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;

public class Eval_c
extends Stmt_c
implements Eval {
    private static final long serialVersionUID = SerialVersionUID.generate();
    protected Expr expr;

    public Eval_c(Position pos, Expr expr) {
        this(pos, expr, null);
    }

    public Eval_c(Position pos, Expr expr, Ext ext) {
        super(pos, ext);
        assert (expr != null);
        this.expr = expr;
    }

    @Override
    public Expr expr() {
        return this.expr;
    }

    @Override
    public Eval expr(Expr expr) {
        return this.expr(this, expr);
    }

    protected <N extends Eval_c> N expr(N n, Expr expr) {
        if (n.expr == expr) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.expr = expr;
        return n;
    }

    protected <N extends Eval_c> N reconstruct(N n, Expr expr) {
        n = this.expr(n, expr);
        return n;
    }

    @Override
    public Node visitChildren(NodeVisitor v) {
        Expr expr = this.visitChild(this.expr, v);
        return this.reconstruct(this, expr);
    }

    @Override
    public Type childExpectedType(Expr child, AscriptionVisitor av) {
        TypeSystem ts = av.typeSystem();
        if (child == this.expr) {
            return ts.Void();
        }
        return child.type();
    }

    @Override
    public String toString() {
        return "eval(" + this.expr.toString() + ");";
    }

    @Override
    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        boolean semi = tr.appendSemicolon(true);
        this.print(this.expr, w, tr);
        if (semi) {
            w.write(";");
        }
        tr.appendSemicolon(semi);
    }

    @Override
    public Term firstChild() {
        return this.expr;
    }

    @Override
    public <T> List<T> acceptCFG(CFGBuilder<?> v, List<T> succs) {
        v.visitCFG(this.expr, this, 0);
        return succs;
    }

    @Override
    public Node copy(NodeFactory nf) {
        return nf.Eval(this.position, this.expr);
    }
}

