/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import java.util.List;
import polyglot.ast.Do;
import polyglot.ast.Expr;
import polyglot.ast.Ext;
import polyglot.ast.Loop_c;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Stmt;
import polyglot.ast.Term;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.CodeWriter;
import polyglot.util.Position;
import polyglot.util.SerialVersionUID;
import polyglot.visit.AscriptionVisitor;
import polyglot.visit.CFGBuilder;
import polyglot.visit.FlowGraph;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeChecker;

public class Do_c
extends Loop_c
implements Do {
    private static final long serialVersionUID = SerialVersionUID.generate();

    public Do_c(Position pos, Stmt body, Expr cond) {
        this(pos, body, cond, null);
    }

    public Do_c(Position pos, Stmt body, Expr cond, Ext ext) {
        super(pos, cond, body, ext);
        assert (cond != null);
    }

    @Override
    public Do cond(Expr cond) {
        return this.cond(this, cond);
    }

    @Override
    public Do body(Stmt body) {
        return this.body(this, body);
    }

    @Override
    public Node visitChildren(NodeVisitor v) {
        Stmt body = this.visitChild(this.body, v);
        Expr cond = this.visitChild(this.cond, v);
        return this.reconstruct(this, cond, body);
    }

    @Override
    public Node typeCheck(TypeChecker tc) throws SemanticException {
        TypeSystem ts = tc.typeSystem();
        if (!ts.isImplicitCastValid(this.cond.type(), ts.Boolean())) {
            throw new SemanticException("Condition of do statement must have boolean type.", this.cond.position());
        }
        return this;
    }

    @Override
    public Type childExpectedType(Expr child, AscriptionVisitor av) {
        TypeSystem ts = av.typeSystem();
        if (child == this.cond) {
            return ts.Boolean();
        }
        return child.type();
    }

    @Override
    public String toString() {
        return "do { ... } while (" + this.cond + ")";
    }

    @Override
    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        w.write("do ");
        this.printSubStmt(this.body, w, tr);
        w.write("while(");
        this.printBlock(this.cond, w, tr);
        w.write("); ");
    }

    @Override
    public Term firstChild() {
        return this.body;
    }

    @Override
    public <T> List<T> acceptCFG(CFGBuilder<?> v, List<T> succs) {
        v.push(this).visitCFG(this.body, this.cond, 1);
        if (v.lang().condIsConstantTrue(this, v.lang())) {
            v.visitCFG(this.cond, this.body, 1);
        } else {
            v.visitCFG(this.cond, FlowGraph.EDGE_KEY_TRUE, this.body, 1, FlowGraph.EDGE_KEY_FALSE, this, 0);
        }
        return succs;
    }

    @Override
    public Term continueTarget() {
        return this.cond;
    }

    @Override
    public Node copy(NodeFactory nf) {
        return nf.Do(this.position, this.body, this.cond);
    }
}

