/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import polyglot.ast.ConstructorCall;
import polyglot.ast.Expr;
import polyglot.ast.Ext;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Precedence;
import polyglot.ast.ProcedureCall;
import polyglot.ast.ProcedureCallOps;
import polyglot.ast.Stmt_c;
import polyglot.ast.Term;
import polyglot.translate.ExtensionRewriter;
import polyglot.types.ClassType;
import polyglot.types.ConstructorInstance;
import polyglot.types.Context;
import polyglot.types.Flags;
import polyglot.types.ProcedureInstance;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.types.UnknownType;
import polyglot.util.CodeWriter;
import polyglot.util.CollectionUtil;
import polyglot.util.ListUtil;
import polyglot.util.Position;
import polyglot.util.SerialVersionUID;
import polyglot.visit.AscriptionVisitor;
import polyglot.visit.CFGBuilder;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeBuilder;
import polyglot.visit.TypeChecker;

public class ConstructorCall_c
extends Stmt_c
implements ConstructorCall,
ProcedureCallOps {
    private static final long serialVersionUID = SerialVersionUID.generate();
    protected ConstructorCall.Kind kind;
    protected Expr qualifier;
    protected List<Expr> arguments;
    protected ConstructorInstance ci;

    public ConstructorCall_c(Position pos, ConstructorCall.Kind kind, Expr qualifier, List<? extends Expr> arguments) {
        this(pos, kind, qualifier, arguments, null);
    }

    public ConstructorCall_c(Position pos, ConstructorCall.Kind kind, Expr qualifier, List<? extends Expr> arguments, Ext ext) {
        super(pos, ext);
        assert (kind != null && arguments != null);
        this.kind = kind;
        this.qualifier = qualifier;
        this.arguments = ListUtil.copy(arguments, true);
    }

    @Override
    public Expr qualifier() {
        return this.qualifier;
    }

    @Override
    public ConstructorCall qualifier(Expr qualifier) {
        return this.qualifier(this, qualifier);
    }

    protected <N extends ConstructorCall_c> N qualifier(N n, Expr qualifier) {
        if (n.qualifier == qualifier) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.qualifier = qualifier;
        return n;
    }

    @Override
    public ConstructorCall.Kind kind() {
        return this.kind;
    }

    @Override
    public ConstructorCall kind(ConstructorCall.Kind kind) {
        return this.kind(this, kind);
    }

    protected <N extends ConstructorCall_c> N kind(N n, ConstructorCall.Kind kind) {
        if (n.kind == kind) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.kind = kind;
        return n;
    }

    @Override
    public List<Expr> arguments() {
        return this.arguments;
    }

    @Override
    public ProcedureCall arguments(List<Expr> arguments) {
        return this.arguments(this, arguments);
    }

    protected <N extends ConstructorCall_c> N arguments(N n, List<Expr> arguments) {
        if (CollectionUtil.equals(n.arguments, arguments)) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.arguments = ListUtil.copy(arguments, true);
        return n;
    }

    @Override
    public ProcedureInstance procedureInstance() {
        return this.constructorInstance();
    }

    @Override
    public ConstructorInstance constructorInstance() {
        return this.ci;
    }

    @Override
    public ConstructorCall constructorInstance(ConstructorInstance ci) {
        return this.constructorInstance(this, ci);
    }

    protected <N extends ConstructorCall_c> N constructorInstance(N n, ConstructorInstance ci) {
        if (n.ci == ci) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.ci = ci;
        return n;
    }

    @Override
    public Context enterScope(Context c) {
        return c.pushStatic();
    }

    protected <N extends ConstructorCall_c> N reconstruct(N n, Expr qualifier, List<Expr> arguments) {
        n = this.qualifier(n, qualifier);
        n = this.arguments(n, arguments);
        return n;
    }

    @Override
    public Node visitChildren(NodeVisitor v) {
        Expr qualifier = this.visitChild(this.qualifier, v);
        List<Expr> arguments = this.visitList(this.arguments, v);
        return this.reconstruct(this, qualifier, arguments);
    }

    @Override
    public Node buildTypes(TypeBuilder tb) throws SemanticException {
        TypeSystem ts = tb.typeSystem();
        if (this.kind == SUPER && tb.currentClass().fullName().equals("java.lang.Object")) {
            return tb.nodeFactory().Empty(this.position());
        }
        ConstructorCall_c n = (ConstructorCall_c)super.buildTypes(tb);
        ArrayList<UnknownType> l = new ArrayList<UnknownType>(this.arguments.size());
        for (int i = 0; i < this.arguments.size(); ++i) {
            l.add(ts.unknownType(this.position()));
        }
        ConstructorInstance ci = ts.constructorInstance(this.position(), tb.currentClass(), Flags.NONE, l, Collections.emptyList());
        n = this.constructorInstance(n, ci);
        return n;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Node typeCheck(TypeChecker tc) throws SemanticException {
        ConstructorCall_c n = this;
        TypeSystem ts = tc.typeSystem();
        Context c = tc.context();
        ClassType ct = c.currentClass();
        Type superType = ct.superType();
        Expr qualifier = n.qualifier;
        ConstructorCall.Kind kind = n.kind;
        if (qualifier != null) {
            if (!qualifier.isDisambiguated()) {
                return n;
            }
            if (kind != SUPER) {
                throw new SemanticException("Can only qualify a \"super\"constructor invocation.", this.position());
            }
            if (!superType.isClass() || !superType.toClass().isInnerClass() || superType.toClass().inStaticContext()) {
                throw new SemanticException("The class \"" + superType + "\"" + " is not an inner class, or was declared in a static " + "context; a qualified constructor invocation cannot " + "be used.", this.position());
            }
            Type qt = qualifier.type();
            if (!qt.isClass() || !qt.isSubtype(superType.toClass().outer())) {
                throw new SemanticException("The type of the qualifier \"" + qt + "\" does not match the immediately enclosing " + "class  of the super class \"" + superType.toClass().outer() + "\".", qualifier.position());
            }
        }
        if (kind == SUPER) {
            if (!superType.isClass()) {
                throw new SemanticException("Super type of " + ct + " is not a class.", this.position());
            }
            Expr q = qualifier;
            if (q == null && superType.isClass() && superType.toClass().isInnerClass() && !superType.toClass().inStaticContext()) {
                void var11_12;
                ClassType superContainer = superType.toClass().outer();
                ClassType classType = ct;
                while (var11_12 != null) {
                    if (var11_12.isSubtype(superContainer) && ct.hasEnclosingInstance((ClassType)var11_12)) {
                        NodeFactory nf = tc.nodeFactory();
                        q = var11_12.isAnonymous() ? null : nf.This(this.position(), nf.CanonicalTypeNode(this.position(), (Type)var11_12)).type((Type)var11_12);
                        break;
                    }
                    ClassType classType2 = var11_12.outer();
                }
                if (var11_12 == null) {
                    throw new SemanticException(ct + " must have an enclosing instance" + " that is a subtype of " + superContainer, this.position());
                }
                if (var11_12 == ct) {
                    throw new SemanticException(ct + " is a subtype of " + superContainer + "; an enclosing instance that is a subtype of " + superContainer + " must be specified in the super constructor call.", this.position());
                }
            }
            n = this.qualifier(n, q);
        }
        LinkedList<Type> argTypes = new LinkedList<Type>();
        for (Expr expr : n.arguments) {
            if (!expr.isDisambiguated()) {
                return this;
            }
            argTypes.add(expr.type());
        }
        if (kind == SUPER) {
            ct = ct.superType().toClass();
        }
        ConstructorInstance ci = ts.findConstructor(ct, argTypes, c.currentClass(), false);
        n = this.constructorInstance(n, ci);
        return n;
    }

    @Override
    public Type childExpectedType(Expr child, AscriptionVisitor av) {
        TypeSystem ts = av.typeSystem();
        if (child == this.qualifier) {
            return ts.Object();
        }
        Iterator<Expr> i = this.arguments.iterator();
        Iterator<? extends Type> j = this.ci.formalTypes().iterator();
        while (i.hasNext() && j.hasNext()) {
            Expr e = i.next();
            Type t = j.next();
            if (e != child) continue;
            return t;
        }
        return child.type();
    }

    @Override
    public Node extRewrite(ExtensionRewriter rw) throws SemanticException {
        ConstructorCall_c n = (ConstructorCall_c)super.extRewrite(rw);
        n = this.constructorInstance(n, null);
        return n;
    }

    @Override
    public String toString() {
        return (this.qualifier != null ? this.qualifier + "." : "") + this.kind + "(...)";
    }

    @Override
    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        if (this.qualifier != null) {
            this.printSubExpr(this.qualifier, w, tr);
            w.write(".");
        }
        w.write(this.kind.toString());
        this.printArgs(w, tr);
        w.write(";");
    }

    @Override
    public void printArgs(CodeWriter w, PrettyPrinter tr) {
        w.write("(");
        w.allowBreak(2, 2, "", 0);
        w.begin(0);
        Iterator<Expr> i = this.arguments.iterator();
        while (i.hasNext()) {
            Expr e = i.next();
            this.print(e, w, tr);
            if (!i.hasNext()) continue;
            w.write(",");
            w.allowBreak(0);
        }
        w.end();
        w.write(")");
    }

    @Override
    public Term firstChild() {
        if (this.qualifier != null) {
            return this.qualifier;
        }
        return ConstructorCall_c.listChild(this.arguments, null);
    }

    @Override
    public <T> List<T> acceptCFG(CFGBuilder<?> v, List<T> succs) {
        if (this.qualifier != null) {
            if (!this.arguments.isEmpty()) {
                v.visitCFG(this.qualifier, (Term)ConstructorCall_c.listChild(this.arguments, null), 1);
                v.visitCFGList(this.arguments, this, 0);
            } else {
                v.visitCFG(this.qualifier, this, 0);
            }
        } else if (!this.arguments.isEmpty()) {
            v.visitCFGList(this.arguments, this, 0);
        }
        return succs;
    }

    @Override
    public List<Type> throwTypes(TypeSystem ts) {
        LinkedList<Type> l = new LinkedList<Type>();
        l.addAll(this.ci.throwTypes());
        l.addAll(ts.uncheckedExceptions());
        return l;
    }

    @Override
    public Node copy(NodeFactory nf) {
        return nf.ConstructorCall(this.position, this.kind, this.qualifier, this.arguments);
    }

    protected void printSubExpr(Expr expr, CodeWriter w, PrettyPrinter pp) {
        if (Precedence.LITERAL.isTighter(expr.precedence())) {
            w.write("(");
            this.printBlock(expr, w, pp);
            w.write(")");
        } else {
            this.print(expr, w, pp);
        }
    }
}

