/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import polyglot.ast.Block;
import polyglot.ast.ClassBody;
import polyglot.ast.ClassDecl;
import polyglot.ast.ClassDeclOps;
import polyglot.ast.ClassMember;
import polyglot.ast.ConstructorCall;
import polyglot.ast.ConstructorDecl;
import polyglot.ast.Ext;
import polyglot.ast.Id;
import polyglot.ast.JLang;
import polyglot.ast.Javadoc;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Stmt;
import polyglot.ast.Term;
import polyglot.ast.Term_c;
import polyglot.ast.TypeNode;
import polyglot.frontend.MissingDependencyException;
import polyglot.frontend.Scheduler;
import polyglot.frontend.goals.Goal;
import polyglot.main.Report;
import polyglot.translate.ExtensionRewriter;
import polyglot.types.ClassType;
import polyglot.types.ConstructorInstance;
import polyglot.types.Context;
import polyglot.types.Flags;
import polyglot.types.MemberInstance;
import polyglot.types.MethodInstance;
import polyglot.types.Named;
import polyglot.types.NoClassException;
import polyglot.types.ParsedClassType;
import polyglot.types.ReferenceType;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.CodeWriter;
import polyglot.util.CollectionUtil;
import polyglot.util.Copy;
import polyglot.util.InternalCompilerError;
import polyglot.util.ListUtil;
import polyglot.util.Position;
import polyglot.util.SerialVersionUID;
import polyglot.visit.AmbiguityRemover;
import polyglot.visit.CFGBuilder;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeBuilder;
import polyglot.visit.TypeChecker;

public class ClassDecl_c
extends Term_c
implements ClassDecl,
ClassDeclOps {
    private static final long serialVersionUID = SerialVersionUID.generate();
    protected Flags flags;
    protected Id name;
    protected TypeNode superClass;
    protected List<TypeNode> interfaces;
    protected ClassBody body;
    protected ConstructorInstance defaultCI;
    protected boolean implicitMembersAdded;
    protected ParsedClassType type;
    protected Javadoc javadoc;

    @Deprecated
    public ClassDecl_c(Position pos, Flags flags, Id name, TypeNode superClass, List<TypeNode> interfaces, ClassBody body) {
        this(pos, flags, name, superClass, interfaces, body, null, null);
    }

    public ClassDecl_c(Position pos, Flags flags, Id name, TypeNode superClass, List<TypeNode> interfaces, ClassBody body, Javadoc javadoc) {
        this(pos, flags, name, superClass, interfaces, body, javadoc, null);
    }

    @Deprecated
    public ClassDecl_c(Position pos, Flags flags, Id name, TypeNode superClass, List<TypeNode> interfaces, ClassBody body, Ext ext) {
        this(pos, flags, name, superClass, interfaces, body, null, ext);
    }

    public ClassDecl_c(Position pos, Flags flags, Id name, TypeNode superClass, List<TypeNode> interfaces, ClassBody body, Javadoc javadoc, Ext ext) {
        super(pos, ext);
        assert (flags != null && name != null && interfaces != null && body != null);
        this.flags = flags;
        this.name = name;
        this.superClass = superClass;
        this.interfaces = ListUtil.copy(interfaces, true);
        this.body = body;
        this.javadoc = javadoc;
    }

    @Override
    public boolean isDisambiguated() {
        return super.isDisambiguated() && this.type != null && this.type.isCanonical() && this.type.supertypesResolved() && this.type.signaturesResolved();
    }

    @Override
    public MemberInstance memberInstance() {
        return this.type;
    }

    @Override
    public ParsedClassType type() {
        return this.type;
    }

    @Override
    public ClassDecl type(ParsedClassType type) {
        return this.type(this, type);
    }

    protected <N extends ClassDecl_c> N type(N n, ParsedClassType type) {
        if (n.type == type) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.type = type;
        return n;
    }

    @Override
    public Flags flags() {
        return this.flags;
    }

    @Override
    public ClassDecl flags(Flags flags) {
        return this.flags(this, flags);
    }

    protected <N extends ClassDecl_c> N flags(N n, Flags flags) {
        if (n.flags.equals(flags)) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.flags = flags;
        return n;
    }

    @Override
    public ClassDecl javadoc(Javadoc javadoc) {
        return this.javadoc(this, javadoc);
    }

    protected <N extends ClassDecl_c> N javadoc(N n, Javadoc javadoc) {
        if (n.javadoc == javadoc) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.javadoc = javadoc;
        return n;
    }

    @Override
    public Id id() {
        return this.name;
    }

    @Override
    public ClassDecl id(Id name) {
        return this.id(this, name);
    }

    protected <N extends ClassDecl_c> N id(N n, Id name) {
        if (n.name == name) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.name = name;
        return n;
    }

    @Override
    public String name() {
        return this.name.id();
    }

    @Override
    public ClassDecl name(String name) {
        return this.id(this.name.id(name));
    }

    @Override
    public TypeNode superClass() {
        return this.superClass;
    }

    @Override
    public ClassDecl superClass(TypeNode superClass) {
        return this.superClass(this, superClass);
    }

    protected <N extends ClassDecl_c> N superClass(N n, TypeNode superClass) {
        if (n.superClass == superClass) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.superClass = superClass;
        return n;
    }

    @Override
    public List<TypeNode> interfaces() {
        return this.interfaces;
    }

    @Override
    public ClassDecl interfaces(List<TypeNode> interfaces) {
        return this.interfaces(this, interfaces);
    }

    protected <N extends ClassDecl_c> N interfaces(N n, List<TypeNode> interfaces) {
        if (CollectionUtil.equals(n.interfaces, interfaces)) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.interfaces = ListUtil.copy(interfaces, true);
        return n;
    }

    @Override
    public ClassBody body() {
        return this.body;
    }

    @Override
    public ClassDecl body(ClassBody body) {
        return this.body(this, body);
    }

    protected <N extends ClassDecl_c> N body(N n, ClassBody body) {
        if (n.body == body) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.body = body;
        return n;
    }

    protected <N extends ClassDecl_c> N reconstruct(N n, Id name, TypeNode superClass, List<TypeNode> interfaces, ClassBody body) {
        n = this.id(n, name);
        n = this.superClass(n, superClass);
        n = this.interfaces(n, interfaces);
        n = this.body(n, body);
        return n;
    }

    @Override
    public Node visitChildren(NodeVisitor v) {
        Id name = this.visitChild(this.name, v);
        TypeNode superClass = this.visitChild(this.superClass, v);
        List<TypeNode> interfaces = this.visitList(this.interfaces, v);
        ClassBody body = this.visitChild(this.body, v);
        return this.reconstruct(this, name, superClass, interfaces, body);
    }

    @Override
    public NodeVisitor buildTypesEnter(TypeBuilder tb) throws SemanticException {
        ParsedClassType type = (tb = tb.pushClass(this.position(), this.flags, this.name.id())).currentClass();
        if (type.isMember() && type.outer().flags().isInterface()) {
            type.flags(type.flags().Public().Static());
        }
        if (type.isMember() && type.flags().isInterface()) {
            type.flags(type.flags().Static());
        }
        if (type.flags().isInterface()) {
            type.flags(type.flags().Abstract());
        }
        return tb;
    }

    @Override
    public Node buildTypes(TypeBuilder tb) throws SemanticException {
        ParsedClassType type = tb.currentClass();
        if (type == null) {
            return this;
        }
        ConstructorInstance ci = null;
        type.setMembersAdded(true);
        if (type.defaultConstructorNeeded()) {
            ci = tb.typeSystem().defaultConstructor(this.position(), type);
            type.addConstructor(ci);
        }
        ClassDecl_c n = this;
        if (n.defaultCI != ci) {
            n = Copy.Util.copy(n);
            n.defaultCI = ci;
        }
        n = this.type(n, type);
        n = this.flags(n, type.flags());
        return n;
    }

    @Override
    public Context enterChildScope(Node child, Context c) {
        if (child == this.body) {
            TypeSystem ts = c.typeSystem();
            c = c.pushClass(this.type, ts.staticTarget(this.type).toClass());
        } else {
            c = c.pushBlock();
            c.addNamed(this.type);
        }
        return super.enterChildScope(child, c);
    }

    @Override
    public Node disambiguate(AmbiguityRemover ar) throws SemanticException {
        if (this.type == null) {
            throw new InternalCompilerError("Missing type.", this.position());
        }
        TypeSystem ts = ar.typeSystem();
        ClassDecl_c n = this.disambiguateSupertypes(ar);
        this.checkSupertypeCycles(ts);
        ParsedClassType type = n.type();
        if (!type.signaturesResolved()) {
            Scheduler scheduler = ar.job().extensionInfo().scheduler();
            Goal g = scheduler.SignaturesResolved(type);
            throw new MissingDependencyException(g);
        }
        Context ctxt = ar.context();
        type.inStaticContext(ctxt.inStaticContext());
        if (!this.implicitMembersAdded && this.flags.isInterface() && this.interfaces.isEmpty()) {
            List<? extends MethodInstance> objectMethods = ts.Object().methods();
            ArrayList<MethodInstance> implicitlyDeclaredMethods = new ArrayList<MethodInstance>(objectMethods.size());
            for (MethodInstance methodInstance : objectMethods) {
                Flags flags = methodInstance.flags();
                if (!flags.isPublic()) continue;
                boolean methodNeeded = true;
                List<? extends MethodInstance> mjs = type.methods(methodInstance.name(), methodInstance.formalTypes());
                for (MethodInstance methodInstance2 : mjs) {
                    ts.checkOverride(methodInstance2, methodInstance);
                    methodNeeded = false;
                }
                if (!methodNeeded) continue;
                implicitlyDeclaredMethods.add(methodInstance.container(type).flags(flags.Abstract().clearFinal()));
            }
            for (MethodInstance methodInstance : implicitlyDeclaredMethods) {
                type.addMethod(methodInstance);
            }
            this.implicitMembersAdded = true;
        }
        return this.addDefaultConstructorIfNeeded(ts, ar.nodeFactory());
    }

    protected ClassDecl_c disambiguateSupertypes(AmbiguityRemover ar) throws SemanticException {
        boolean supertypesResolved = true;
        if (!this.type.supertypesResolved()) {
            if (this.superClass != null && !this.superClass.isDisambiguated()) {
                supertypesResolved = false;
            }
            for (TypeNode tn : this.interfaces) {
                if (tn.isDisambiguated()) continue;
                supertypesResolved = false;
            }
            if (!supertypesResolved) {
                Scheduler scheduler = ar.job().extensionInfo().scheduler();
                Goal g = scheduler.SupertypesResolved(this.type);
                throw new MissingDependencyException(g);
            }
            this.setSuperClass(ar, this.superClass);
            this.setInterfaces(ar, this.interfaces);
            this.type.setSupertypesResolved(true);
        }
        return this;
    }

    protected void checkSupertypeCycles(TypeSystem ts) throws SemanticException {
        if (this.type.superType() != null) {
            if (!this.type.superType().isReference()) {
                throw new SemanticException("Cannot extend type " + this.type.superType() + ".", this.superClass != null ? this.superClass.position() : this.position());
            }
            ReferenceType t = (ReferenceType)this.type.superType();
            ts.checkCycles(t);
        }
        for (Type type : this.type.interfaces()) {
            if (!type.isReference()) {
                String s = this.type.flags().isInterface() ? "extend" : "implement";
                throw new SemanticException("Cannot " + s + " type " + type + ".", this.position());
            }
            ReferenceType t = (ReferenceType)type;
            ts.checkCycles(t);
        }
    }

    protected void setSuperClass(AmbiguityRemover ar, TypeNode superClass) throws SemanticException {
        TypeSystem ts = ar.typeSystem();
        if (superClass != null) {
            Type t = superClass.type();
            if (Report.should_report("types", 3)) {
                Report.report(3, "setting superclass of " + this.type + " to " + t);
            }
            this.type.superType(t);
        } else if (this.type.equals(ts.Object()) || this.type.fullName().equals(ts.Object().fullName()) || this.flags.isInterface()) {
            if (Report.should_report("types", 3)) {
                Report.report(3, "setting superclass of " + this.type + " to " + null);
            }
            this.type.superType(null);
        } else {
            if (Report.should_report("types", 3)) {
                Report.report(3, "setting superclass of " + this.type + " to " + ts.Object());
            }
            this.type.superType(ts.Object());
        }
    }

    protected void setInterfaces(AmbiguityRemover ar, List<TypeNode> newInterfaces) throws SemanticException {
        for (TypeNode tn : newInterfaces) {
            ClassType t = (ClassType)tn.type();
            if (Report.should_report("types", 3)) {
                Report.report(3, "adding interface of " + this.type + " to " + t);
            }
            this.type.addInterface(t);
        }
    }

    protected Node addDefaultConstructorIfNeeded(TypeSystem ts, NodeFactory nf) throws SemanticException {
        if (this.defaultConstructorNeeded()) {
            return nf.lang().addDefaultConstructor(this, ts, nf, this.defaultCI);
        }
        return this;
    }

    protected boolean defaultConstructorNeeded() {
        if (this.defaultCI == null) {
            return false;
        }
        for (ClassMember cm : this.body().members()) {
            ConstructorDecl cd;
            if (!(cm instanceof ConstructorDecl) || (cd = (ConstructorDecl)cm).constructorInstance() != this.defaultCI) continue;
            return false;
        }
        return true;
    }

    @Override
    public Node addDefaultConstructor(TypeSystem ts, NodeFactory nf, ConstructorInstance defaultCI) throws SemanticException {
        ConstructorInstance ci = defaultCI;
        if (ci == null) {
            throw new InternalCompilerError("addDefaultConstructor called without defaultCI set");
        }
        Block block = null;
        if (this.type.superType() instanceof ClassType) {
            ConstructorInstance sci = ts.findConstructor((ClassType)this.type.superType(), Collections.emptyList(), this.type, false);
            ConstructorCall cc = nf.SuperCall(this.position().startOf(), Collections.emptyList());
            cc = cc.constructorInstance(sci);
            block = nf.Block(this.position().startOf(), cc);
        } else {
            block = nf.Block(this.position().startOf(), new Stmt[0]);
        }
        ConstructorDecl cd = nf.ConstructorDecl(this.body().position().startOf(), Flags.PUBLIC, nf.Id(this.body().position().startOf(), this.name.id()), Collections.emptyList(), Collections.emptyList(), block);
        cd = cd.constructorInstance(ci);
        return this.body(this.body.addMember(cd));
    }

    @Override
    public Node typeCheck(TypeChecker tc) throws SemanticException {
        if (this.type().isNested() && this.type() != null) {
            Object ctxt;
            for (ClassType container = this.type.outer(); container != null; container = container.outer()) {
                String name;
                if (!container.isAnonymous() && (name = container.name()).equals(this.name.id())) {
                    throw new SemanticException("Cannot declare member class \"" + this.type + "\" inside class with the " + "same name.", this.position());
                }
                if (!container.isNested()) break;
            }
            if (this.type().isLocal() && (ctxt = tc.context()).isLocal(this.name.id())) {
                try {
                    Type another;
                    Named nm = ctxt.find(this.name.id());
                    if (nm instanceof Type && (another = (Type)((Object)nm)).isClass() && another.toClass().isLocal()) {
                        throw new SemanticException("Cannot declare local class \"" + this.type + "\" within the same " + "method, constructor or initializer as another " + "local class of the same name.", this.position());
                    }
                }
                catch (NoClassException nm) {
                    // empty catch block
                }
            }
        }
        if (this.type().isMember() && this.flags().isInterface() && this.type().outer().isInnerClass()) {
            throw new SemanticException("Inner classes cannot declare member interfaces.", this.position());
        }
        if (this.type().isMember() && this.type().flags().isStatic() && this.type().outer().isInnerClass()) {
            throw new SemanticException("Inner classes cannot declare static member classes.", this.position());
        }
        if (this.type.superType() != null) {
            if (!this.type.superType().isClass() || this.type.superType().toClass().flags().isInterface()) {
                throw new SemanticException("Cannot extend non-class \"" + this.type.superType() + "\".", this.position());
            }
            if (this.type.superType().toClass().flags().isFinal()) {
                throw new SemanticException("Cannot extend final class \"" + this.type.superType() + "\".", this.position());
            }
            if (this.type.equals(tc.typeSystem().Object()) || this.type.fullName().equals(tc.typeSystem().Object().fullName())) {
                throw new SemanticException("Class \"" + this.type + "\" cannot have a superclass.", this.superClass.position());
            }
        }
        HashSet<Type> superInterfaces = new HashSet<Type>();
        for (TypeNode tn : this.interfaces) {
            Type t = tn.type();
            if (!t.isClass() || !t.toClass().flags().isInterface()) {
                throw new SemanticException("Superinterface " + t + " of " + this.type + " is not an interface.", tn.position());
            }
            if (this.type.equals(tc.typeSystem().Object()) || this.type.fullName().equals(tc.typeSystem().Object().fullName())) {
                throw new SemanticException("Class " + this.type + " cannot have a superinterface.", tn.position());
            }
            if (superInterfaces.contains(t)) {
                throw new SemanticException("Duplicate interface " + t, tn.position());
            }
            superInterfaces.add(t);
        }
        TypeSystem ts = tc.typeSystem();
        try {
            if (this.type.isTopLevel()) {
                ts.checkTopLevelClassFlags(this.type.flags());
            }
            if (this.type.isMember()) {
                ts.checkMemberClassFlags(this.type.flags());
            }
            if (this.type.isLocal()) {
                ts.checkLocalClassFlags(this.type.flags());
            }
        }
        catch (SemanticException e) {
            throw new SemanticException(e.getMessage(), this.position());
        }
        ts.checkClassConformance(this.type);
        ts.checkInterfaceFieldFlags(this.type);
        return this;
    }

    @Override
    public Node extRewrite(ExtensionRewriter rw) throws SemanticException {
        ClassDecl_c n = (ClassDecl_c)super.extRewrite(rw);
        n = this.copyIfNeeded(n);
        n = this.type(n, null);
        n.defaultCI = null;
        return n;
    }

    @Override
    public Term firstChild() {
        return this.body();
    }

    @Override
    public <T> List<T> acceptCFG(CFGBuilder<?> v, List<T> succs) {
        v.visitCFG(this.body(), this, 0);
        return succs;
    }

    @Override
    public String toString() {
        return this.flags.clearInterface().translate() + (this.flags.isInterface() ? "interface " : "class ") + this.name + " " + this.body;
    }

    @Override
    public void prettyPrintHeader(CodeWriter w, PrettyPrinter tr) {
        if (this.javadoc != null) {
            this.javadoc.prettyPrint(w, tr);
        }
        w.begin(0);
        if (this.flags.isInterface()) {
            w.write(this.flags.clearInterface().clearAbstract().translate());
        } else {
            w.write(this.flags.translate());
        }
        if (this.flags.isInterface()) {
            w.write("interface ");
        } else {
            w.write("class ");
        }
        tr.print(this, this.name, w);
        if (this.superClass() != null) {
            w.allowBreak(0);
            w.write("extends ");
            this.print(this.superClass(), w, tr);
        }
        if (!this.interfaces.isEmpty()) {
            w.allowBreak(2);
            if (this.flags.isInterface()) {
                w.write("extends ");
            } else {
                w.write("implements ");
            }
            w.begin(0);
            Iterator<TypeNode> i = this.interfaces().iterator();
            while (i.hasNext()) {
                TypeNode tn = i.next();
                this.print(tn, w, tr);
                if (!i.hasNext()) continue;
                w.write(",");
                w.allowBreak(0);
            }
            w.end();
        }
        w.unifiedBreak(0);
        w.end();
        w.write("{");
    }

    @Override
    public void prettyPrintFooter(CodeWriter w, PrettyPrinter tr) {
        w.write("}");
        w.newline(0);
    }

    @Override
    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        ((JLang)tr.lang()).prettyPrintHeader(this, w, tr);
        this.print(this.body(), w, tr);
        ((JLang)tr.lang()).prettyPrintFooter(this, w, tr);
    }

    @Override
    public void dump(CodeWriter w) {
        super.dump(w);
        w.allowBreak(4, " ");
        w.begin(0);
        w.write("(name " + this.name + ")");
        w.end();
        if (this.javadoc != null) {
            w.allowBreak(4, " ");
            w.begin(0);
            w.write("(javadoc ...)");
            w.end();
        }
        if (this.type != null) {
            w.allowBreak(4, " ");
            w.begin(0);
            w.write("(type " + this.type + ")");
            w.end();
        }
    }

    @Override
    public Node disambiguateOverride(Node parent, AmbiguityRemover ar) throws SemanticException {
        return null;
    }

    @Override
    public Node copy(NodeFactory nf) {
        return nf.ClassDecl(this.position, this.flags, this.name, this.superClass, this.interfaces, this.body, this.javadoc);
    }

    @Override
    public Javadoc javadoc() {
        return this.javadoc;
    }
}

