/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import java.util.Collections;
import java.util.List;
import polyglot.ast.Cast;
import polyglot.ast.Expr;
import polyglot.ast.Expr_c;
import polyglot.ast.Ext;
import polyglot.ast.Lang;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Precedence;
import polyglot.ast.Term;
import polyglot.ast.TypeNode;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.CodeWriter;
import polyglot.util.Position;
import polyglot.util.SerialVersionUID;
import polyglot.visit.AscriptionVisitor;
import polyglot.visit.CFGBuilder;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeChecker;

public class Cast_c
extends Expr_c
implements Cast {
    private static final long serialVersionUID = SerialVersionUID.generate();
    protected TypeNode castType;
    protected Expr expr;

    public Cast_c(Position pos, TypeNode castType, Expr expr) {
        this(pos, castType, expr, null);
    }

    public Cast_c(Position pos, TypeNode castType, Expr expr, Ext ext) {
        super(pos, ext);
        assert (castType != null && expr != null);
        this.castType = castType;
        this.expr = expr;
    }

    @Override
    public Precedence precedence() {
        return Precedence.CAST;
    }

    @Override
    public TypeNode castType() {
        return this.castType;
    }

    @Override
    public Cast castType(TypeNode castType) {
        return this.castType(this, castType);
    }

    protected <N extends Cast_c> N castType(N n, TypeNode castType) {
        if (n.castType == castType) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.castType = castType;
        return n;
    }

    @Override
    public Expr expr() {
        return this.expr;
    }

    @Override
    public Cast expr(Expr expr) {
        return this.expr(this, expr);
    }

    protected <N extends Cast_c> N expr(N n, Expr expr) {
        if (n.expr == expr) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.expr = expr;
        return n;
    }

    protected <N extends Cast_c> N reconstruct(N n, TypeNode castType, Expr expr) {
        n = this.castType(n, castType);
        n = this.expr(n, expr);
        return n;
    }

    @Override
    public Node visitChildren(NodeVisitor v) {
        TypeNode castType = this.visitChild(this.castType, v);
        Expr expr = this.visitChild(this.expr, v);
        return this.reconstruct(this, castType, expr);
    }

    @Override
    public Node typeCheck(TypeChecker tc) throws SemanticException {
        TypeSystem ts = tc.typeSystem();
        if (!ts.isCastValid(this.expr.type(), this.castType.type())) {
            throw new SemanticException("Cannot cast the expression of type \"" + this.expr.type() + "\" to type \"" + this.castType.type() + "\".", this.position());
        }
        return this.type(this.castType.type());
    }

    @Override
    public Type childExpectedType(Expr child, AscriptionVisitor av) {
        TypeSystem ts = av.typeSystem();
        if (child == this.expr) {
            if (this.castType.type().isReference()) {
                return ts.Object();
            }
            if (this.castType.type().isNumeric()) {
                return ts.Double();
            }
            if (this.castType.type().isBoolean()) {
                return ts.Boolean();
            }
        }
        return child.type();
    }

    @Override
    public String toString() {
        return "(" + this.castType + ") " + this.expr;
    }

    @Override
    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        w.begin(0);
        w.write("(");
        this.print(this.castType, w, tr);
        w.write(")");
        w.allowBreak(2, " ");
        this.printSubExpr(this.expr, w, tr);
        w.end();
    }

    @Override
    public Term firstChild() {
        return this.expr;
    }

    @Override
    public <T> List<T> acceptCFG(CFGBuilder<?> v, List<T> succs) {
        v.visitCFG(this.expr, this.castType, 1);
        v.visitCFG(this.castType, this, 0);
        return succs;
    }

    @Override
    public List<Type> throwTypes(TypeSystem ts) {
        if (this.expr.type().isReference()) {
            return Collections.singletonList(ts.ClassCastException());
        }
        return Collections.emptyList();
    }

    @Override
    public boolean isConstant(Lang lang) {
        return lang.isConstant(this.expr, lang) && (this.castType.type().isPrimitive() || this.castType.type().typeEquals(this.castType.type().typeSystem().String()));
    }

    @Override
    public Object constantValue(Lang lang) {
        Object v = lang.constantValue(this.expr, lang);
        if (v == null) {
            return null;
        }
        if (v instanceof Boolean && this.castType.type().isBoolean()) {
            return v;
        }
        if (v instanceof String) {
            TypeSystem ts = this.castType.type().typeSystem();
            if (this.castType.type().typeEquals(ts.String())) {
                return v;
            }
        }
        if (v instanceof Double) {
            double vv = (Double)v;
            if (this.castType.type().isDouble()) {
                return new Double(vv);
            }
            if (this.castType.type().isFloat()) {
                return new Float((float)vv);
            }
            if (this.castType.type().isLong()) {
                return new Long((long)vv);
            }
            if (this.castType.type().isInt()) {
                return new Integer((int)vv);
            }
            if (this.castType.type().isChar()) {
                return new Character((char)vv);
            }
            if (this.castType.type().isShort()) {
                return new Short((short)vv);
            }
            if (this.castType.type().isByte()) {
                return new Byte((byte)vv);
            }
        }
        if (v instanceof Float) {
            float vv = ((Float)v).floatValue();
            if (this.castType.type().isDouble()) {
                return new Double(vv);
            }
            if (this.castType.type().isFloat()) {
                return new Float(vv);
            }
            if (this.castType.type().isLong()) {
                return new Long((long)vv);
            }
            if (this.castType.type().isInt()) {
                return new Integer((int)vv);
            }
            if (this.castType.type().isChar()) {
                return new Character((char)vv);
            }
            if (this.castType.type().isShort()) {
                return new Short((short)vv);
            }
            if (this.castType.type().isByte()) {
                return new Byte((byte)vv);
            }
        }
        if (v instanceof Number) {
            long vv = ((Number)v).longValue();
            if (this.castType.type().isDouble()) {
                return new Double(vv);
            }
            if (this.castType.type().isFloat()) {
                return new Float(vv);
            }
            if (this.castType.type().isLong()) {
                return new Long(vv);
            }
            if (this.castType.type().isInt()) {
                return new Integer((int)vv);
            }
            if (this.castType.type().isChar()) {
                return new Character((char)vv);
            }
            if (this.castType.type().isShort()) {
                return new Short((short)vv);
            }
            if (this.castType.type().isByte()) {
                return new Byte((byte)vv);
            }
        }
        if (v instanceof Character) {
            char vv = ((Character)v).charValue();
            if (this.castType.type().isDouble()) {
                return new Double(vv);
            }
            if (this.castType.type().isFloat()) {
                return new Float(vv);
            }
            if (this.castType.type().isLong()) {
                return new Long(vv);
            }
            if (this.castType.type().isInt()) {
                return new Integer(vv);
            }
            if (this.castType.type().isChar()) {
                return new Character(vv);
            }
            if (this.castType.type().isShort()) {
                return new Short((short)vv);
            }
            if (this.castType.type().isByte()) {
                return new Byte((byte)vv);
            }
        }
        return null;
    }

    @Override
    public Node copy(NodeFactory nf) {
        return nf.Cast(this.position, this.castType, this.expr);
    }
}

