/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import java.util.List;
import polyglot.ast.Case;
import polyglot.ast.Expr;
import polyglot.ast.Ext;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Stmt_c;
import polyglot.ast.Term;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.CodeWriter;
import polyglot.util.Position;
import polyglot.util.SerialVersionUID;
import polyglot.visit.AscriptionVisitor;
import polyglot.visit.CFGBuilder;
import polyglot.visit.ConstantChecker;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeChecker;

public class Case_c
extends Stmt_c
implements Case {
    private static final long serialVersionUID = SerialVersionUID.generate();
    protected Expr expr;
    protected long value;

    public Case_c(Position pos, Expr expr) {
        this(pos, expr, null);
    }

    public Case_c(Position pos, Expr expr, Ext ext) {
        super(pos, ext);
        this.expr = expr;
    }

    @Override
    public boolean isDefault() {
        return this.expr == null;
    }

    @Override
    public Expr expr() {
        return this.expr;
    }

    @Override
    public Case expr(Expr expr) {
        return this.expr(this, expr);
    }

    protected <N extends Case_c> N expr(N n, Expr expr) {
        if (n.expr == expr) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.expr = expr;
        return n;
    }

    @Override
    public long value() {
        return this.value;
    }

    @Override
    public Case value(long value) {
        return this.value(this, value);
    }

    protected <N extends Case_c> N value(N n, long value) {
        if (n.value == value) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.value = value;
        return n;
    }

    protected <N extends Case_c> N reconstruct(N n, Expr expr) {
        n = this.expr(n, expr);
        return n;
    }

    @Override
    public Node visitChildren(NodeVisitor v) {
        Expr expr = this.visitChild(this.expr, v);
        return this.reconstruct(this, expr);
    }

    @Override
    public Node typeCheck(TypeChecker tc) throws SemanticException {
        if (this.expr == null) {
            return this;
        }
        TypeSystem ts = tc.typeSystem();
        if (!ts.isImplicitCastValid(this.expr.type(), ts.Int())) {
            throw new SemanticException("Case label must be an byte, char, short, or int.", this.position());
        }
        return this;
    }

    @Override
    public Node checkConstants(ConstantChecker cc) throws SemanticException {
        if (this.expr == null) {
            return this;
        }
        if (!cc.lang().constantValueSet(this.expr, cc.lang())) {
            return this;
        }
        if (cc.lang().isConstant(this.expr, cc.lang())) {
            Object o = cc.lang().constantValue(this.expr, cc.lang());
            if (o instanceof Number && !(o instanceof Long) && !(o instanceof Float) && !(o instanceof Double)) {
                return this.value(((Number)o).longValue());
            }
            if (o instanceof Character) {
                return this.value(((Character)o).charValue());
            }
        }
        throw new SemanticException("Case label must be an integral constant.", this.position());
    }

    @Override
    public Type childExpectedType(Expr child, AscriptionVisitor av) {
        TypeSystem ts = av.typeSystem();
        if (child == this.expr) {
            return ts.Int();
        }
        return child.type();
    }

    @Override
    public String toString() {
        if (this.expr == null) {
            return "default:";
        }
        return "case " + this.expr + ":";
    }

    @Override
    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        if (this.expr == null) {
            w.write("default:");
        } else {
            w.write("case ");
            this.print(this.expr, w, tr);
            w.write(":");
        }
    }

    @Override
    public Term firstChild() {
        if (this.expr != null) {
            return this.expr;
        }
        return null;
    }

    @Override
    public <T> List<T> acceptCFG(CFGBuilder<?> v, List<T> succs) {
        if (this.expr != null) {
            v.visitCFG(this.expr, this, 0);
        }
        return succs;
    }

    @Override
    public Node copy(NodeFactory nf) {
        return nf.Case(this.position, this.expr).value(this.value);
    }
}

