/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import polyglot.ast.Call;
import polyglot.ast.CallOps;
import polyglot.ast.Expr;
import polyglot.ast.Expr_c;
import polyglot.ast.Ext;
import polyglot.ast.Id;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Precedence;
import polyglot.ast.ProcedureCall;
import polyglot.ast.Receiver;
import polyglot.ast.Special;
import polyglot.ast.Term;
import polyglot.ast.TypeNode;
import polyglot.translate.ExtensionRewriter;
import polyglot.types.ClassType;
import polyglot.types.Context;
import polyglot.types.Flags;
import polyglot.types.MethodInstance;
import polyglot.types.ProcedureInstance;
import polyglot.types.ReferenceType;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.types.UnknownType;
import polyglot.util.CodeWriter;
import polyglot.util.CollectionUtil;
import polyglot.util.InternalCompilerError;
import polyglot.util.ListUtil;
import polyglot.util.Position;
import polyglot.util.SerialVersionUID;
import polyglot.visit.AscriptionVisitor;
import polyglot.visit.CFGBuilder;
import polyglot.visit.ExceptionChecker;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeBuilder;
import polyglot.visit.TypeChecker;

public class Call_c
extends Expr_c
implements Call,
CallOps {
    private static final long serialVersionUID = SerialVersionUID.generate();
    protected Receiver target;
    protected Id name;
    protected List<Expr> arguments;
    protected MethodInstance mi;
    protected boolean targetImplicit;

    public Call_c(Position pos, Receiver target, Id name, List<Expr> arguments) {
        this(pos, target, name, arguments, null);
    }

    public Call_c(Position pos, Receiver target, Id name, List<Expr> arguments, Ext ext) {
        super(pos, ext);
        assert (name != null && arguments != null);
        this.target = target;
        this.name = name;
        this.arguments = ListUtil.copy(arguments, true);
        this.targetImplicit = target == null;
    }

    @Override
    public Precedence precedence() {
        return Precedence.LITERAL;
    }

    @Override
    public Receiver target() {
        return this.target;
    }

    @Override
    public Call target(Receiver target) {
        return this.target(this, target);
    }

    protected <N extends Call_c> N target(N n, Receiver target) {
        if (n.target == target) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.target = target;
        return n;
    }

    @Override
    public Id id() {
        return this.name;
    }

    @Override
    public Call id(Id name) {
        return this.id(this, name);
    }

    protected <N extends Call_c> N id(N n, Id name) {
        if (n.name == name) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.name = name;
        return n;
    }

    @Override
    public String name() {
        return this.name.id();
    }

    @Override
    public Call name(String name) {
        return this.id(this.name.id(name));
    }

    @Override
    public ProcedureInstance procedureInstance() {
        return this.methodInstance();
    }

    @Override
    public MethodInstance methodInstance() {
        return this.mi;
    }

    @Override
    public Call methodInstance(MethodInstance mi) {
        return this.methodInstance(this, mi);
    }

    protected <N extends Call_c> N methodInstance(N n, MethodInstance mi) {
        if (n.mi == mi) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.mi = mi;
        return n;
    }

    @Override
    public boolean isTargetImplicit() {
        return this.targetImplicit;
    }

    @Override
    public Call targetImplicit(boolean targetImplicit) {
        return this.targetImplicit(this, targetImplicit);
    }

    protected <N extends Call_c> N targetImplicit(N n, boolean targetImplicit) {
        if (n.targetImplicit == targetImplicit) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.targetImplicit = targetImplicit;
        return n;
    }

    @Override
    public List<Expr> arguments() {
        return this.arguments;
    }

    @Override
    public ProcedureCall arguments(List<Expr> arguments) {
        return this.arguments(this, arguments);
    }

    protected <N extends Call_c> N arguments(N n, List<Expr> arguments) {
        if (CollectionUtil.equals(n.arguments, arguments)) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.arguments = ListUtil.copy(arguments, true);
        return n;
    }

    protected <N extends Call_c> N reconstruct(N n, Receiver target, Id name, List<Expr> arguments) {
        n = this.target(n, target);
        n = this.id(n, name);
        n = this.arguments(n, arguments);
        return n;
    }

    @Override
    public Node visitChildren(NodeVisitor v) {
        Receiver target = this.visitChild(this.target, v);
        Id name = this.visitChild(this.name, v);
        List<Expr> arguments = this.visitList(this.arguments, v);
        return this.reconstruct(this, target, name, arguments);
    }

    @Override
    public Node buildTypes(TypeBuilder tb) throws SemanticException {
        Call_c n = (Call_c)super.buildTypes(tb);
        TypeSystem ts = tb.typeSystem();
        ArrayList<UnknownType> l = new ArrayList<UnknownType>(this.arguments.size());
        for (int i = 0; i < this.arguments.size(); ++i) {
            l.add(ts.unknownType(this.position()));
        }
        MethodInstance mi = ts.methodInstance(this.position(), tb.currentClass(), Flags.NONE, ts.unknownType(this.position()), this.name.id(), l, Collections.emptyList());
        return this.methodInstance(n, mi);
    }

    @Override
    public Node typeCheckNullTarget(TypeChecker tc, List<Type> argTypes) throws SemanticException {
        Receiver r;
        TypeSystem ts = tc.typeSystem();
        NodeFactory nf = tc.nodeFactory();
        Context c = tc.context();
        MethodInstance mi = c.findMethod(this.name.id(), argTypes);
        if (mi.flags().isStatic()) {
            Type container = tc.lang().findContainer(this, ts, mi);
            r = nf.CanonicalTypeNode(this.position().startOf(), container).type(container);
        } else {
            ClassType scope = c.findMethodScope(this.name.id());
            r = !ts.equals(scope, c.currentClass()) ? nf.This(this.position().startOf(), nf.CanonicalTypeNode(this.position().startOf(), scope)).type(scope) : nf.This(this.position().startOf()).type(scope);
        }
        Call_c call = this;
        call = this.targetImplicit(call, true);
        call = this.target(call, r);
        return call.visit(tc.rethrowMissingDependencies(true));
    }

    @Override
    public Type findContainer(TypeSystem ts, MethodInstance mi) {
        return ts.staticTarget(mi.container());
    }

    @Override
    public Node typeCheck(TypeChecker tc) throws SemanticException {
        TypeSystem ts = tc.typeSystem();
        Context c = tc.context();
        ArrayList<Type> argTypes = new ArrayList<Type>(this.arguments.size());
        for (Expr e : this.arguments) {
            if (!e.type().isCanonical()) {
                return this;
            }
            argTypes.add(e.type());
        }
        if (this.target == null) {
            return tc.lang().typeCheckNullTarget(this, tc, argTypes);
        }
        if (!this.target.type().isCanonical()) {
            return this;
        }
        ReferenceType targetType = tc.lang().findTargetType(this);
        MethodInstance mi = ts.findMethod(targetType, this.name.id(), argTypes, c.currentClass(), !(this.target instanceof Special));
        boolean staticContext = this.target instanceof TypeNode;
        if (staticContext && !mi.flags().isStatic()) {
            throw new SemanticException("Cannot call non-static method " + this.name.id() + " of " + this.target.type() + " in static " + "context.", this.position());
        }
        if (this.target instanceof Special && ((Special)this.target).kind() == Special.SUPER && mi.flags().isAbstract()) {
            throw new SemanticException("Cannot call an abstract method of the super class", this.position());
        }
        Call_c call = this;
        call = this.methodInstance(call, mi);
        call = this.type(call, mi.returnType());
        return call;
    }

    @Override
    public ReferenceType findTargetType() throws SemanticException {
        Type t = this.target.type();
        if (t.isReference()) {
            return t.toReference();
        }
        if (this.target instanceof Expr) {
            throw new SemanticException("Cannot invoke method \"" + this.name + "\" on " + "an expression of non-reference type " + t + ".", this.target.position());
        }
        if (this.target instanceof TypeNode) {
            throw new SemanticException("Cannot invoke static method \"" + this.name + "\" on non-reference type " + t + ".", this.target.position());
        }
        throw new SemanticException("Cannot invoke method \"" + this.name + "\" on non-reference type " + t + ".", this.target.position());
    }

    @Override
    public Type childExpectedType(Expr child, AscriptionVisitor av) {
        if (child == this.target) {
            return this.mi.container();
        }
        Iterator<Expr> i = this.arguments.iterator();
        Iterator<? extends Type> j = this.mi.formalTypes().iterator();
        while (i.hasNext() && j.hasNext()) {
            Expr e = i.next();
            Type t = j.next();
            if (e != child) continue;
            return t;
        }
        return child.type();
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.targetImplicit ? "" : this.target.toString() + ".");
        sb.append(this.name);
        sb.append("(");
        int count = 0;
        Iterator<Expr> i = this.arguments.iterator();
        while (i.hasNext()) {
            if (count++ > 2) {
                sb.append("...");
                break;
            }
            Expr n = i.next();
            sb.append(n.toString());
            if (!i.hasNext()) continue;
            sb.append(", ");
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        if (!this.targetImplicit) {
            if (this.target instanceof Expr) {
                this.printSubExpr((Expr)this.target, w, tr);
            } else if (this.target != null) {
                this.print(this.target, w, tr);
            }
            w.write(".");
            w.allowBreak(2, 3, "", 0);
        }
        w.begin(0);
        w.write(this.name.id());
        this.printArgs(w, tr);
        w.end();
    }

    @Override
    public void printArgs(CodeWriter w, PrettyPrinter tr) {
        w.write("(");
        w.allowBreak(2, 2, "", 0);
        w.begin(0);
        Iterator<Expr> i = this.arguments.iterator();
        while (i.hasNext()) {
            Expr e = i.next();
            w.begin(2);
            this.print(e, w, tr);
            w.end();
            if (!i.hasNext()) continue;
            w.write(",");
            w.allowBreak(0);
        }
        w.end();
        w.write(")");
    }

    @Override
    public void dump(CodeWriter w) {
        super.dump(w);
        w.allowBreak(4, " ");
        w.begin(0);
        w.write("(targetImplicit " + this.targetImplicit + ")");
        w.end();
        if (this.mi != null) {
            w.allowBreak(4, " ");
            w.begin(0);
            w.write("(instance " + this.mi + ")");
            w.end();
        }
        w.allowBreak(4, " ");
        w.begin(0);
        w.write("(name " + this.name + ")");
        w.end();
        w.allowBreak(4, " ");
        w.begin(0);
        w.write("(arguments " + this.arguments + ")");
        w.end();
    }

    @Override
    public Term firstChild() {
        if (this.target instanceof Term) {
            return (Term)((Object)this.target);
        }
        return Call_c.listChild(this.arguments, null);
    }

    @Override
    public <T> List<T> acceptCFG(CFGBuilder<?> v, List<T> succs) {
        if (this.target instanceof Term) {
            Term t = (Term)((Object)this.target);
            if (!this.arguments.isEmpty()) {
                v.visitCFG(t, (Term)Call_c.listChild(this.arguments, null), 1);
                v.visitCFGList(this.arguments, this, 0);
            } else {
                v.visitCFG(t, this, 0);
            }
        } else {
            v.visitCFGList(this.arguments, this, 0);
        }
        return succs;
    }

    @Override
    public Node exceptionCheck(ExceptionChecker ec) throws SemanticException {
        if (this.mi == null) {
            throw new InternalCompilerError(this.position(), "Null method instance after type check.");
        }
        return super.exceptionCheck(ec);
    }

    @Override
    public List<Type> throwTypes(TypeSystem ts) {
        LinkedList<Type> l = new LinkedList<Type>();
        l.addAll(this.mi.throwTypes());
        l.addAll(ts.uncheckedExceptions());
        if (this.target instanceof Expr && !(this.target instanceof Special)) {
            l.add(ts.NullPointerException());
        }
        return l;
    }

    @Override
    public NodeVisitor extRewriteEnter(ExtensionRewriter rw) throws SemanticException {
        if (this.isTargetImplicit()) {
            return rw.bypass(this.target());
        }
        return super.extRewriteEnter(rw);
    }

    @Override
    public Node extRewrite(ExtensionRewriter rw) throws SemanticException {
        Call_c c = (Call_c)super.extRewrite(rw);
        c = this.methodInstance(c, null);
        if (this.isTargetImplicit()) {
            c = this.target(c, null);
        }
        return c;
    }

    @Override
    public Node copy(NodeFactory nf) {
        return nf.Call(this.position, this.target, this.name, this.arguments);
    }
}

