/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import java.util.Collections;
import java.util.List;
import polyglot.ast.Branch;
import polyglot.ast.Ext;
import polyglot.ast.Id;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Stmt_c;
import polyglot.ast.Term;
import polyglot.util.CodeWriter;
import polyglot.util.Position;
import polyglot.util.SerialVersionUID;
import polyglot.visit.CFGBuilder;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;

public class Branch_c
extends Stmt_c
implements Branch {
    private static final long serialVersionUID = SerialVersionUID.generate();
    protected Branch.Kind kind;
    protected Id label;

    public Branch_c(Position pos, Branch.Kind kind, Id label) {
        this(pos, kind, label, null);
    }

    public Branch_c(Position pos, Branch.Kind kind, Id label, Ext ext) {
        super(pos, ext);
        assert (kind != null);
        this.kind = kind;
        this.label = label;
    }

    @Override
    public Branch.Kind kind() {
        return this.kind;
    }

    @Override
    public Branch kind(Branch.Kind kind) {
        return this.kind(this, kind);
    }

    protected <N extends Branch_c> N kind(N n, Branch.Kind kind) {
        if (n.kind == kind) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.kind = kind;
        return n;
    }

    @Override
    public Id labelNode() {
        return this.label;
    }

    @Override
    public Branch labelNode(Id label) {
        return this.labelNode(this, label);
    }

    protected <N extends Branch_c> N labelNode(N n, Id label) {
        if (n.label == label) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.label = label;
        return n;
    }

    @Override
    public String label() {
        return this.label != null ? this.label.id() : null;
    }

    @Override
    public Branch label(String label) {
        return this.labelNode(this.label.id(label));
    }

    protected <N extends Branch_c> N reconstruct(N n, Id label) {
        n = this.labelNode(n, label);
        return n;
    }

    @Override
    public Node visitChildren(NodeVisitor v) {
        Id label = this.visitChild(this.label, v);
        return this.reconstruct(this, label);
    }

    @Override
    public String toString() {
        return this.kind.toString() + (this.label != null ? " " + this.label.toString() : "");
    }

    @Override
    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        w.write(this.kind.toString());
        if (this.label != null) {
            w.write(" " + this.label);
        }
        w.write(";");
    }

    @Override
    public Term firstChild() {
        return null;
    }

    @Override
    public <T> List<T> acceptCFG(CFGBuilder<?> v, List<T> succs) {
        v.visitBranchTarget(this);
        return Collections.emptyList();
    }

    @Override
    public Node copy(NodeFactory nf) {
        return nf.Branch(this.position, this.kind, this.label);
    }
}

