/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import java.util.Collections;
import java.util.List;
import polyglot.ast.Binary;
import polyglot.ast.Expr;
import polyglot.ast.Expr_c;
import polyglot.ast.Ext;
import polyglot.ast.Lang;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Precedence;
import polyglot.ast.StringLit;
import polyglot.ast.Term;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.CodeWriter;
import polyglot.util.Position;
import polyglot.util.SerialVersionUID;
import polyglot.visit.AscriptionVisitor;
import polyglot.visit.CFGBuilder;
import polyglot.visit.FlowGraph;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeChecker;

public class Binary_c
extends Expr_c
implements Binary {
    private static final long serialVersionUID = SerialVersionUID.generate();
    protected Expr left;
    protected Binary.Operator op;
    protected Expr right;
    protected Precedence precedence;

    public Binary_c(Position pos, Expr left, Binary.Operator op, Expr right) {
        this(pos, left, op, right, null);
    }

    public Binary_c(Position pos, Expr left, Binary.Operator op, Expr right, Ext ext) {
        super(pos, ext);
        assert (left != null && op != null && right != null);
        this.left = left;
        this.op = op;
        this.right = right;
        this.precedence = op.precedence();
        if (op == ADD && (left instanceof StringLit || right instanceof StringLit)) {
            this.precedence = Precedence.STRING_ADD;
        }
    }

    @Override
    public Expr left() {
        return this.left;
    }

    @Override
    public Binary left(Expr left) {
        return this.left(this, left);
    }

    protected <N extends Binary_c> N left(N n, Expr left) {
        if (n.left == left) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.left = left;
        return n;
    }

    @Override
    public Binary.Operator operator() {
        return this.op;
    }

    @Override
    public Binary operator(Binary.Operator op) {
        return this.operator(this, op);
    }

    protected <N extends Binary_c> N operator(N n, Binary.Operator op) {
        if (n.op == op) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.op = op;
        return n;
    }

    @Override
    public Expr right() {
        return this.right;
    }

    @Override
    public Binary right(Expr right) {
        return this.right(this, right);
    }

    protected <N extends Binary_c> N right(N n, Expr right) {
        if (n.right == right) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.right = right;
        return n;
    }

    @Override
    public Precedence precedence() {
        return this.precedence;
    }

    @Override
    public Binary precedence(Precedence precedence) {
        return this.precedence(this, precedence);
    }

    protected <N extends Binary_c> N precedence(N n, Precedence precedence) {
        if (n.precedence == precedence) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.precedence = precedence;
        return n;
    }

    protected <N extends Binary_c> N reconstruct(N n, Expr left, Expr right) {
        n = this.left(n, left);
        n = this.right(n, right);
        return n;
    }

    @Override
    public Node visitChildren(NodeVisitor v) {
        Expr left = this.visitChild(this.left, v);
        Expr right = this.visitChild(this.right, v);
        return this.reconstruct(this, left, right);
    }

    @Override
    public boolean constantValueSet(Lang lang) {
        return lang.constantValueSet(this.left, lang) && lang.constantValueSet(this.right, lang);
    }

    @Override
    public boolean isConstant(Lang lang) {
        return lang.isConstant(this.left, lang) && lang.isConstant(this.right, lang);
    }

    @Override
    public Object constantValue(Lang lang) {
        if (!lang.isConstant(this, lang)) {
            return null;
        }
        Object lv = lang.constantValue(this.left, lang);
        Object rv = lang.constantValue(this.right, lang);
        if (this.op == ADD && (lv instanceof String || rv instanceof String)) {
            if (lv == null) {
                lv = "null";
            }
            if (rv == null) {
                rv = "null";
            }
            return lv.toString() + rv.toString();
        }
        if (this.op == EQ && lv instanceof String && rv instanceof String) {
            return ((String)lv).intern() == ((String)rv).intern();
        }
        if (this.op == NE && lv instanceof String && rv instanceof String) {
            return ((String)lv).intern() != ((String)rv).intern();
        }
        if (lv instanceof Character) {
            lv = new Integer(((Character)lv).charValue());
        }
        if (rv instanceof Character) {
            rv = new Integer(((Character)rv).charValue());
        }
        try {
            if (lv instanceof Number && rv instanceof Number) {
                long r;
                long l;
                if (lv instanceof Double || rv instanceof Double) {
                    double l2 = ((Number)lv).doubleValue();
                    double r2 = ((Number)rv).doubleValue();
                    if (this.op == ADD) {
                        return new Double(l2 + r2);
                    }
                    if (this.op == SUB) {
                        return new Double(l2 - r2);
                    }
                    if (this.op == MUL) {
                        return new Double(l2 * r2);
                    }
                    if (this.op == DIV) {
                        return new Double(l2 / r2);
                    }
                    if (this.op == MOD) {
                        return new Double(l2 % r2);
                    }
                    if (this.op == EQ) {
                        return l2 == r2;
                    }
                    if (this.op == NE) {
                        return l2 != r2;
                    }
                    if (this.op == LT) {
                        return l2 < r2;
                    }
                    if (this.op == LE) {
                        return l2 <= r2;
                    }
                    if (this.op == GE) {
                        return l2 >= r2;
                    }
                    if (this.op == GT) {
                        return l2 > r2;
                    }
                    return null;
                }
                if (lv instanceof Float || rv instanceof Float) {
                    float l3 = ((Number)lv).floatValue();
                    float r3 = ((Number)rv).floatValue();
                    if (this.op == ADD) {
                        return new Float(l3 + r3);
                    }
                    if (this.op == SUB) {
                        return new Float(l3 - r3);
                    }
                    if (this.op == MUL) {
                        return new Float(l3 * r3);
                    }
                    if (this.op == DIV) {
                        return new Float(l3 / r3);
                    }
                    if (this.op == MOD) {
                        return new Float(l3 % r3);
                    }
                    if (this.op == EQ) {
                        return l3 == r3;
                    }
                    if (this.op == NE) {
                        return l3 != r3;
                    }
                    if (this.op == LT) {
                        return l3 < r3;
                    }
                    if (this.op == LE) {
                        return l3 <= r3;
                    }
                    if (this.op == GE) {
                        return l3 >= r3;
                    }
                    if (this.op == GT) {
                        return l3 > r3;
                    }
                    return null;
                }
                if (lv instanceof Long && rv instanceof Number) {
                    l = (Long)lv;
                    r = ((Number)rv).longValue();
                    if (this.op == SHL) {
                        return new Long(l << (int)r);
                    }
                    if (this.op == SHR) {
                        return new Long(l >> (int)r);
                    }
                    if (this.op == USHR) {
                        return new Long(l >>> (int)r);
                    }
                }
                if (lv instanceof Long || rv instanceof Long) {
                    l = ((Number)lv).longValue();
                    r = ((Number)rv).longValue();
                    if (this.op == ADD) {
                        return new Long(l + r);
                    }
                    if (this.op == SUB) {
                        return new Long(l - r);
                    }
                    if (this.op == MUL) {
                        return new Long(l * r);
                    }
                    if (this.op == DIV) {
                        return new Long(l / r);
                    }
                    if (this.op == MOD) {
                        return new Long(l % r);
                    }
                    if (this.op == EQ) {
                        return l == r;
                    }
                    if (this.op == NE) {
                        return l != r;
                    }
                    if (this.op == LT) {
                        return l < r;
                    }
                    if (this.op == LE) {
                        return l <= r;
                    }
                    if (this.op == GE) {
                        return l >= r;
                    }
                    if (this.op == GT) {
                        return l > r;
                    }
                    if (this.op == BIT_AND) {
                        return new Long(l & r);
                    }
                    if (this.op == BIT_OR) {
                        return new Long(l | r);
                    }
                    if (this.op == BIT_XOR) {
                        return new Long(l ^ r);
                    }
                    return null;
                }
                int l4 = ((Number)lv).intValue();
                int r4 = ((Number)rv).intValue();
                if (this.op == ADD) {
                    return new Integer(l4 + r4);
                }
                if (this.op == SUB) {
                    return new Integer(l4 - r4);
                }
                if (this.op == MUL) {
                    return new Integer(l4 * r4);
                }
                if (this.op == DIV) {
                    return new Integer(l4 / r4);
                }
                if (this.op == MOD) {
                    return new Integer(l4 % r4);
                }
                if (this.op == EQ) {
                    return l4 == r4;
                }
                if (this.op == NE) {
                    return l4 != r4;
                }
                if (this.op == LT) {
                    return l4 < r4;
                }
                if (this.op == LE) {
                    return l4 <= r4;
                }
                if (this.op == GE) {
                    return l4 >= r4;
                }
                if (this.op == GT) {
                    return l4 > r4;
                }
                if (this.op == BIT_AND) {
                    return new Integer(l4 & r4);
                }
                if (this.op == BIT_OR) {
                    return new Integer(l4 | r4);
                }
                if (this.op == BIT_XOR) {
                    return new Integer(l4 ^ r4);
                }
                if (this.op == SHL) {
                    return new Integer(l4 << r4);
                }
                if (this.op == SHR) {
                    return new Integer(l4 >> r4);
                }
                if (this.op == USHR) {
                    return new Integer(l4 >>> r4);
                }
                return null;
            }
        }
        catch (ArithmeticException e) {
            return null;
        }
        if (lv instanceof Boolean && rv instanceof Boolean) {
            boolean l = (Boolean)lv;
            boolean r = (Boolean)rv;
            if (this.op == EQ) {
                return l == r;
            }
            if (this.op == NE) {
                return l != r;
            }
            if (this.op == BIT_AND) {
                return l & r;
            }
            if (this.op == BIT_OR) {
                return l | r;
            }
            if (this.op == BIT_XOR) {
                return l ^ r;
            }
            if (this.op == COND_AND) {
                return l && r;
            }
            if (this.op == COND_OR) {
                return l || r;
            }
        }
        return null;
    }

    @Override
    public Node typeCheck(TypeChecker tc) throws SemanticException {
        Type l = this.left.type();
        Type r = this.right.type();
        TypeSystem ts = tc.typeSystem();
        if (this.op == GT || this.op == LT || this.op == GE || this.op == LE) {
            if (!l.isNumeric()) {
                throw new SemanticException("The " + this.op + " operator must have numeric operands, not type " + l + ".", this.left.position());
            }
            if (!r.isNumeric()) {
                throw new SemanticException("The " + this.op + " operator must have numeric operands, not type " + r + ".", this.right.position());
            }
            return this.type(ts.Boolean());
        }
        if (this.op == EQ || this.op == NE) {
            if (!ts.isCastValid(l, r) && !ts.isCastValid(r, l)) {
                throw new SemanticException("The " + this.op + " operator must have operands of similar type.", this.position());
            }
            return this.type(ts.Boolean());
        }
        if (this.op == COND_OR || this.op == COND_AND) {
            if (!l.isBoolean()) {
                throw new SemanticException("The " + this.op + " operator must have boolean operands, not type " + l + ".", this.left.position());
            }
            if (!r.isBoolean()) {
                throw new SemanticException("The " + this.op + " operator must have boolean operands, not type " + r + ".", this.right.position());
            }
            return this.type(ts.Boolean());
        }
        if (this.op == ADD && (ts.typeEquals(l, ts.String()) || ts.typeEquals(r, ts.String()))) {
            if (!ts.canCoerceToString(r, tc.context())) {
                throw new SemanticException("Cannot coerce an expression of type " + r + " to a String.", this.right.position());
            }
            if (!ts.canCoerceToString(l, tc.context())) {
                throw new SemanticException("Cannot coerce an expression of type " + l + " to a String.", this.left.position());
            }
            Binary_c n = this;
            n = this.precedence(n, Precedence.STRING_ADD);
            n = this.type(n, ts.String());
            return n;
        }
        if ((this.op == BIT_AND || this.op == BIT_OR || this.op == BIT_XOR) && l.isBoolean() && r.isBoolean()) {
            return this.type(ts.Boolean());
        }
        if (this.op == ADD) {
            if (!l.isNumeric()) {
                throw new SemanticException("The " + this.op + " operator must have numeric or String operands, not type " + l + ".", this.left.position());
            }
            if (!r.isNumeric()) {
                throw new SemanticException("The " + this.op + " operator must have numeric or String operands, not type " + r + ".", this.right.position());
            }
        }
        if (this.op == BIT_AND || this.op == BIT_OR || this.op == BIT_XOR) {
            if (!ts.isImplicitCastValid(l, ts.Long())) {
                throw new SemanticException("The " + this.op + " operator must have numeric or boolean operands, not type " + l + ".", this.left.position());
            }
            if (!ts.isImplicitCastValid(r, ts.Long())) {
                throw new SemanticException("The " + this.op + " operator must have numeric or boolean operands, not type " + r + ".", this.right.position());
            }
        }
        if (this.op == SUB || this.op == MUL || this.op == DIV || this.op == MOD) {
            if (!l.isNumeric()) {
                throw new SemanticException("The " + this.op + " operator must have numeric operands, not type " + l + ".", this.left.position());
            }
            if (!r.isNumeric()) {
                throw new SemanticException("The " + this.op + " operator must have numeric operands, not type " + r + ".", this.right.position());
            }
        }
        if (this.op == SHL || this.op == SHR || this.op == USHR) {
            if (!ts.isImplicitCastValid(l, ts.Long())) {
                throw new SemanticException("The " + this.op + " operator must have numeric operands, not type " + l + ".", this.left.position());
            }
            if (!ts.isImplicitCastValid(r, ts.Long())) {
                throw new SemanticException("The " + this.op + " operator must have numeric operands, not type " + r + ".", this.right.position());
            }
        }
        if (this.op == SHL || this.op == SHR || this.op == USHR) {
            return this.type(ts.promote(l));
        }
        return this.type(ts.promote(l, r));
    }

    @Override
    public Type childExpectedType(Expr child, AscriptionVisitor av) {
        Expr other;
        if (child == this.left) {
            other = this.right;
        } else if (child == this.right) {
            other = this.left;
        } else {
            return child.type();
        }
        TypeSystem ts = av.typeSystem();
        try {
            if (this.op == EQ || this.op == NE) {
                if ((child.type().isReference() || child.type().isNull()) && (other.type().isReference() || other.type().isNull())) {
                    return ts.leastCommonAncestor(child.type(), other.type());
                }
                if (child.type().isBoolean() && other.type().isBoolean()) {
                    return ts.Boolean();
                }
                if (child.type().isNumeric() && other.type().isNumeric()) {
                    return ts.promote(child.type(), other.type());
                }
                if (child.type().isImplicitCastValid(other.type())) {
                    return other.type();
                }
                return child.type();
            }
            if (this.op == ADD && ts.typeEquals(this.type, ts.String())) {
                return ts.String();
            }
            if (this.op == GT || this.op == LT || this.op == GE || this.op == LE) {
                if (child.type().isNumeric() && other.type().isNumeric()) {
                    return ts.promote(child.type(), other.type());
                }
                return child.type();
            }
            if (this.op == COND_OR || this.op == COND_AND) {
                return ts.Boolean();
            }
            if (this.op == BIT_AND || this.op == BIT_OR || this.op == BIT_XOR) {
                if (other.type().isBoolean()) {
                    return ts.Boolean();
                }
                if (child.type().isNumeric() && other.type().isNumeric()) {
                    return ts.promote(child.type(), other.type());
                }
                return child.type();
            }
            if (this.op == ADD || this.op == SUB || this.op == MUL || this.op == DIV || this.op == MOD) {
                if (child.type().isNumeric() && other.type().isNumeric()) {
                    return ts.promote(child.type(), other.type());
                }
                return child.type();
            }
            if (this.op == SHL || this.op == SHR || this.op == USHR) {
                if (child.type().isNumeric() && other.type().isNumeric()) {
                    return ts.promote(child.type());
                }
                return child.type();
            }
            return child.type();
        }
        catch (SemanticException semanticException) {
            return child.type();
        }
    }

    @Override
    public boolean throwsArithmeticException() {
        return this.op == DIV || this.op == MOD;
    }

    @Override
    public String toString() {
        return this.left + " " + this.op + " " + this.right;
    }

    @Override
    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        this.printSubExpr(this.left, true, w, tr);
        w.write(" ");
        w.write(this.op.toString());
        w.allowBreak(this.type() == null || this.type().isPrimitive() ? 2 : 0, " ");
        this.printSubExpr(this.right, false, w, tr);
    }

    @Override
    public void dump(CodeWriter w) {
        super.dump(w);
        if (this.type != null) {
            w.allowBreak(4, " ");
            w.begin(0);
            w.write("(type " + this.type + ")");
            w.end();
        }
        w.allowBreak(4, " ");
        w.begin(0);
        w.write("(operator " + this.op + ")");
        w.end();
    }

    @Override
    public Term firstChild() {
        return this.left;
    }

    @Override
    public <T> List<T> acceptCFG(CFGBuilder<?> v, List<T> succs) {
        if (this.op == COND_AND || this.op == COND_OR) {
            if (this.op == COND_AND) {
                v.visitCFG(this.left, FlowGraph.EDGE_KEY_TRUE, this.right, 1, FlowGraph.EDGE_KEY_FALSE, this, 0);
            } else {
                v.visitCFG(this.left, FlowGraph.EDGE_KEY_FALSE, this.right, 1, FlowGraph.EDGE_KEY_TRUE, this, 0);
            }
            v.visitCFG(this.right, FlowGraph.EDGE_KEY_TRUE, this, 0, FlowGraph.EDGE_KEY_FALSE, this, 0);
        } else if (this.left.type().isBoolean() && this.right.type().isBoolean()) {
            v.visitCFG(this.left, FlowGraph.EDGE_KEY_TRUE, this.right, 1, FlowGraph.EDGE_KEY_FALSE, this.right, 1);
            v.visitCFG(this.right, FlowGraph.EDGE_KEY_TRUE, this, 0, FlowGraph.EDGE_KEY_FALSE, this, 0);
        } else {
            v.visitCFG(this.left, this.right, 1);
            v.visitCFG(this.right, this, 0);
        }
        return succs;
    }

    @Override
    public List<Type> throwTypes(TypeSystem ts) {
        if (this.throwsArithmeticException()) {
            return Collections.singletonList(ts.ArithmeticException());
        }
        return Collections.emptyList();
    }

    @Override
    public Node copy(NodeFactory nf) {
        return nf.Binary(this.position, this.left, this.op, this.right);
    }
}

