/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import polyglot.ast.Expr;
import polyglot.ast.Precedence;
import polyglot.util.Enum;
import polyglot.util.SerialVersionUID;

public interface Binary
extends Expr {
    public static final Operator GT = new Operator(">", Precedence.RELATIONAL);
    public static final Operator LT = new Operator("<", Precedence.RELATIONAL);
    public static final Operator EQ = new Operator("==", Precedence.EQUAL);
    public static final Operator LE = new Operator("<=", Precedence.RELATIONAL);
    public static final Operator GE = new Operator(">=", Precedence.RELATIONAL);
    public static final Operator NE = new Operator("!=", Precedence.EQUAL);
    public static final Operator COND_OR = new Operator("||", Precedence.COND_OR);
    public static final Operator COND_AND = new Operator("&&", Precedence.COND_AND);
    public static final Operator ADD = new Operator("+", Precedence.ADD);
    public static final Operator SUB = new Operator("-", Precedence.ADD);
    public static final Operator MUL = new Operator("*", Precedence.MUL);
    public static final Operator DIV = new Operator("/", Precedence.MUL);
    public static final Operator MOD = new Operator("%", Precedence.MUL);
    public static final Operator BIT_OR = new Operator("|", Precedence.BIT_OR);
    public static final Operator BIT_AND = new Operator("&", Precedence.BIT_AND);
    public static final Operator BIT_XOR = new Operator("^", Precedence.BIT_XOR);
    public static final Operator SHL = new Operator("<<", Precedence.SHIFT);
    public static final Operator SHR = new Operator(">>", Precedence.SHIFT);
    public static final Operator USHR = new Operator(">>>", Precedence.SHIFT);

    public Expr left();

    public Binary left(Expr var1);

    public Operator operator();

    public Binary operator(Operator var1);

    public Expr right();

    public Binary right(Expr var1);

    public boolean throwsArithmeticException();

    public Binary precedence(Precedence var1);

    public static class Operator
    extends Enum {
        private static final long serialVersionUID = SerialVersionUID.generate();
        protected Precedence prec;

        public Operator(String name, Precedence prec) {
            super(name);
            this.prec = prec;
        }

        public Precedence precedence() {
            return this.prec;
        }
    }
}

