/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import polyglot.ast.ArrayTypeNode;
import polyglot.ast.Ext;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.TypeNode;
import polyglot.ast.TypeNode_c;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.CodeWriter;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.util.SerialVersionUID;
import polyglot.visit.AmbiguityRemover;
import polyglot.visit.ExceptionChecker;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeBuilder;
import polyglot.visit.TypeChecker;

public class ArrayTypeNode_c
extends TypeNode_c
implements ArrayTypeNode {
    private static final long serialVersionUID = SerialVersionUID.generate();
    protected TypeNode base;

    public ArrayTypeNode_c(Position pos, TypeNode base) {
        this(pos, base, null);
    }

    public ArrayTypeNode_c(Position pos, TypeNode base, Ext ext) {
        super(pos, ext);
        assert (base != null);
        this.base = base;
    }

    @Override
    public boolean isDisambiguated() {
        return false;
    }

    @Override
    public TypeNode base() {
        return this.base;
    }

    @Override
    public ArrayTypeNode base(TypeNode base) {
        return this.base(this, base);
    }

    protected <N extends ArrayTypeNode_c> N base(N n, TypeNode base) {
        if (n.base == base) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.base = base;
        return n;
    }

    protected <N extends ArrayTypeNode_c> N reconstruct(N n, TypeNode base) {
        n = this.base(n, base);
        return n;
    }

    @Override
    public Node visitChildren(NodeVisitor v) {
        TypeNode base = this.visitChild(this.base, v);
        return this.reconstruct(this, base);
    }

    @Override
    public Node buildTypes(TypeBuilder tb) throws SemanticException {
        TypeSystem ts = tb.typeSystem();
        return this.type(ts.arrayOf(this.position(), this.base.type()));
    }

    @Override
    public Node disambiguate(AmbiguityRemover ar) throws SemanticException {
        TypeSystem ts = ar.typeSystem();
        NodeFactory nf = ar.nodeFactory();
        if (!this.base.isDisambiguated()) {
            return this;
        }
        Type baseType = this.base.type();
        if (!baseType.isCanonical()) {
            return this;
        }
        return nf.CanonicalTypeNode(this.position(), ts.arrayOf(this.position(), baseType));
    }

    @Override
    public Node typeCheck(TypeChecker tc) throws SemanticException {
        throw new InternalCompilerError(this.position(), "Cannot type check ambiguous node " + this + ".");
    }

    @Override
    public Node exceptionCheck(ExceptionChecker ec) throws SemanticException {
        throw new InternalCompilerError(this.position(), "Cannot exception check ambiguous node " + this + ".");
    }

    @Override
    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        this.print(this.base, w, tr);
        w.write("[]");
    }

    @Override
    public String toString() {
        return this.base.toString() + "[]";
    }

    @Override
    public Node copy(NodeFactory nf) {
        return nf.ArrayTypeNode(this.position, this.base);
    }
}

