/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import java.util.Iterator;
import java.util.List;
import polyglot.ast.ArrayInit;
import polyglot.ast.Expr;
import polyglot.ast.Expr_c;
import polyglot.ast.Ext;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Term;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.CodeWriter;
import polyglot.util.CollectionUtil;
import polyglot.util.InternalCompilerError;
import polyglot.util.ListUtil;
import polyglot.util.Position;
import polyglot.util.SerialVersionUID;
import polyglot.visit.AscriptionVisitor;
import polyglot.visit.CFGBuilder;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeChecker;

public class ArrayInit_c
extends Expr_c
implements ArrayInit {
    private static final long serialVersionUID = SerialVersionUID.generate();
    protected List<Expr> elements;

    public ArrayInit_c(Position pos, List<Expr> elements) {
        this(pos, elements, null);
    }

    public ArrayInit_c(Position pos, List<Expr> elements, Ext ext) {
        super(pos, ext);
        assert (elements != null);
        this.elements = ListUtil.copy(elements, true);
    }

    @Override
    public List<Expr> elements() {
        return this.elements;
    }

    @Override
    public ArrayInit elements(List<Expr> elements) {
        return this.elements(this, elements);
    }

    protected <N extends ArrayInit_c> N elements(N n, List<Expr> elements) {
        if (CollectionUtil.equals(n.elements, elements)) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.elements = ListUtil.copy(elements, true);
        return n;
    }

    protected <N extends ArrayInit_c> N reconstruct(N n, List<Expr> elements) {
        n = this.elements(n, elements);
        return n;
    }

    @Override
    public Node visitChildren(NodeVisitor v) {
        List<Expr> elements = this.visitList(this.elements, v);
        return this.reconstruct(this, elements);
    }

    @Override
    public Node typeCheck(TypeChecker tc) throws SemanticException {
        TypeSystem ts = tc.typeSystem();
        Type type = null;
        for (Expr e : this.elements) {
            if (type == null) {
                type = e.type();
                continue;
            }
            type = ts.leastCommonAncestor(type, e.type());
        }
        if (type == null) {
            return this.type(ts.Null());
        }
        return this.type(this.arrayOf(ts, type));
    }

    protected Type arrayOf(TypeSystem ts, Type baseType) {
        return ts.arrayOf(baseType);
    }

    @Override
    public Type childExpectedType(Expr child, AscriptionVisitor av) {
        if (this.elements.isEmpty()) {
            return child.type();
        }
        Type t = av.toType();
        if (!t.isArray()) {
            throw new InternalCompilerError("Type of array initializer must be an array.", this.position());
        }
        t = t.toArray().base();
        for (Expr e : this.elements) {
            if (e != child) continue;
            return t;
        }
        return child.type();
    }

    @Override
    public void typeCheckElements(TypeChecker tc, Type lhsType) throws SemanticException {
        TypeSystem ts = lhsType.typeSystem();
        if (!lhsType.isArray()) {
            throw new SemanticException("Cannot initialize " + lhsType + " with " + this.type + ".", this.position());
        }
        Type t = lhsType.toArray().base();
        for (Expr e : this.elements) {
            Type s = e.type();
            if (e instanceof ArrayInit) {
                ((ArrayInit)e).typeCheckElements(tc, t);
                continue;
            }
            if (ts.isImplicitCastValid(s, t) || ts.typeEquals(s, t) || ts.numericConversionValid(t, tc.lang().constantValue(e, tc.lang()))) continue;
            throw new SemanticException("Cannot assign " + s + " to " + t + ".", e.position());
        }
    }

    @Override
    public String toString() {
        return "{ ... }";
    }

    @Override
    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        w.write("{ ");
        Iterator<Expr> i = this.elements.iterator();
        while (i.hasNext()) {
            Expr e = i.next();
            this.print(e, w, tr);
            if (!i.hasNext()) continue;
            w.write(",");
            w.allowBreak(0, " ");
        }
        w.write(" }");
    }

    @Override
    public Term firstChild() {
        return ArrayInit_c.listChild(this.elements, null);
    }

    @Override
    public <T> List<T> acceptCFG(CFGBuilder<?> v, List<T> succs) {
        v.visitCFGList(this.elements, this, 0);
        return succs;
    }

    @Override
    public Node copy(NodeFactory nf) {
        return nf.ArrayInit(this.position, this.elements);
    }
}

