/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import java.util.ArrayList;
import java.util.List;
import polyglot.ast.ArrayAccess;
import polyglot.ast.ArrayAccessAssign;
import polyglot.ast.Assign;
import polyglot.ast.Assign_c;
import polyglot.ast.Expr;
import polyglot.ast.Ext;
import polyglot.ast.Term;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.util.SerialVersionUID;
import polyglot.visit.CFGBuilder;

public class ArrayAccessAssign_c
extends Assign_c
implements ArrayAccessAssign {
    private static final long serialVersionUID = SerialVersionUID.generate();

    public ArrayAccessAssign_c(Position pos, ArrayAccess left, Assign.Operator op, Expr right) {
        this(pos, left, op, right, null);
    }

    public ArrayAccessAssign_c(Position pos, ArrayAccess left, Assign.Operator op, Expr right, Ext ext) {
        super(pos, left, op, right, ext);
    }

    @Override
    public ArrayAccess left() {
        return (ArrayAccess)super.left();
    }

    @Override
    public Assign left(Expr left) {
        this.assertLeftType(left);
        return super.left(left);
    }

    private void assertLeftType(Expr left) {
        if (!(left instanceof ArrayAccess)) {
            throw new InternalCompilerError("left expression of an ArrayAccessAssign must be an array access");
        }
    }

    @Override
    public Term firstChild() {
        if (this.operator() == ASSIGN) {
            return this.left().array();
        }
        return this.left();
    }

    @Override
    protected void acceptCFGAssign(CFGBuilder<?> v) {
        ArrayAccess a = this.left();
        v.visitCFG(a.array(), a.index(), 1);
        v.visitCFG(a.index(), this.right(), 1);
        v.visitCFG(this.right(), this, 0);
    }

    @Override
    protected void acceptCFGOpAssign(CFGBuilder<?> v) {
        v.visitCFG(this.left(), this.right(), 1);
        v.visitCFG(this.right(), this, 0);
    }

    @Override
    public List<Type> throwTypes(TypeSystem ts) {
        ArrayList<Type> l = new ArrayList<Type>(super.throwTypes(ts));
        if (this.op == ASSIGN && this.left.type().isReference()) {
            l.add(ts.ArrayStoreException());
        }
        l.add(ts.NullPointerException());
        l.add(ts.OutOfBoundsException());
        return l;
    }
}

