/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import polyglot.ast.Block;
import polyglot.ast.Ext;
import polyglot.ast.Node;
import polyglot.ast.Stmt;
import polyglot.ast.Stmt_c;
import polyglot.ast.Term;
import polyglot.types.Context;
import polyglot.util.CodeWriter;
import polyglot.util.CollectionUtil;
import polyglot.util.ListUtil;
import polyglot.util.Position;
import polyglot.util.SerialVersionUID;
import polyglot.visit.CFGBuilder;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;

public abstract class AbstractBlock_c
extends Stmt_c
implements Block {
    private static final long serialVersionUID = SerialVersionUID.generate();
    protected List<Stmt> statements;

    @Deprecated
    public AbstractBlock_c(Position pos, List<Stmt> statements) {
        this(pos, statements, null);
    }

    public AbstractBlock_c(Position pos, List<Stmt> statements, Ext ext) {
        super(pos, ext);
        assert (statements != null);
        this.statements = ListUtil.copy(statements, true);
    }

    @Override
    public List<Stmt> statements() {
        return this.statements;
    }

    @Override
    public Block statements(List<Stmt> statements) {
        return this.statements(this, statements);
    }

    protected <N extends AbstractBlock_c> N statements(N n, List<Stmt> statements) {
        if (CollectionUtil.equals(n.statements, statements)) {
            return n;
        }
        n = this.copyIfNeeded(n);
        n.statements = ListUtil.copy(statements, true);
        return n;
    }

    @Override
    public Block append(Stmt stmt) {
        ArrayList<Stmt> l = new ArrayList<Stmt>(this.statements.size() + 1);
        l.addAll(this.statements);
        l.add(stmt);
        return this.statements(l);
    }

    @Override
    public Block prepend(Stmt stmt) {
        ArrayList<Stmt> l = new ArrayList<Stmt>(this.statements.size() + 1);
        l.add(stmt);
        l.addAll(this.statements);
        return this.statements(l);
    }

    protected <N extends AbstractBlock_c> N reconstruct(N n, List<Stmt> statements) {
        n = this.statements(n, statements);
        return n;
    }

    @Override
    public Node visitChildren(NodeVisitor v) {
        List<Stmt> statements = this.visitList(this.statements, v);
        return this.reconstruct(this, statements);
    }

    @Override
    public Context enterScope(Context c) {
        return c.pushBlock();
    }

    @Override
    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        w.begin(0);
        Iterator<Stmt> i = this.statements.iterator();
        while (i.hasNext()) {
            Stmt n = i.next();
            this.printBlock(n, w, tr);
            if (!i.hasNext()) continue;
            w.newline();
        }
        w.end();
    }

    @Override
    public Term firstChild() {
        return AbstractBlock_c.listChild(this.statements, null);
    }

    @Override
    public <T> List<T> acceptCFG(CFGBuilder<?> v, List<T> succs) {
        v.visitCFGList(this.statements, this, 0);
        return succs;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("{");
        int count = 0;
        for (Stmt n : this.statements) {
            if (count++ > 2) {
                sb.append(" ...");
                break;
            }
            sb.append(" ");
            sb.append(n.toString());
        }
        sb.append(" }");
        return sb.toString();
    }
}

