package jif.util;

public class LinkedList2 extends AbstractList2 {
    private LinkedListEntry2 head;
    private LinkedListEntry2 tail;
    
    public LinkedList2 jif$util$LinkedList2$() {
        this.jif$init();
        {
            this.head = null;
            this.tail = null;
            this.jif$util$AbstractList2$();
        }
        return this;
    }
    
    public void clear() {
        this.head = null;
        this.tail = null;
    }
    
    public int size() {
        int s = 0;
        LinkedListEntry2 e = this.head;
        while (e != null) {
            e = e.next;
            s++;
        }
        return s;
    }
    
    public boolean add(final jif.lang.JifObject o) {
        LinkedListEntry2 n =
          new LinkedListEntry2(
            this.jif$jif_util_LinkedList2_S, this.jif$jif_util_LinkedList2_C).
            jif$util$LinkedListEntry2$();
        LinkedListEntry2 m = this.tail;
        n.data = o;
        if (m == null) {
            this.head = (this.tail = n);
            return true;
        }
        m.next = n;
        n.prev = m;
        this.tail = n;
        return true;
    }
    
    public boolean removeByRef(final jif.lang.JifObject o) {
        LinkedListEntry2 e = this.head;
        while (e != null) {
            if (e.data == o) {
                LinkedListEntry2 f = e.prev;
                if (f != null) { f.next = e.next; }
                f = e.next;
                if (f != null) { f.prev = e.prev; }
                if (this.tail == e) { this.tail = e.prev; }
                if (this.head == e) { this.head = e.next; }
                return true;
            }
            e = e.next;
        }
        return false;
    }
    
    public boolean remove(final jif.lang.JifObject o) {
        LinkedListEntry2 e = this.head;
        while (e != null) {
            if (e.data == o || o != null && o.equals(e.data)) {
                LinkedListEntry2 f = e.prev;
                if (f != null) { f.next = e.next; }
                f = e.next;
                if (f != null) { f.prev = e.prev; }
                if (this.tail == e) { this.tail = e.prev; }
                if (this.head == e) { this.head = e.next; }
                return true;
            }
            e = e.next;
        }
        return false;
    }
    
    public jif.lang.JifObject remove(final int index)
          throws IndexOutOfBoundsException {
        int s = 0;
        int size = this.size();
        if (index < 0 || index >= size) {
            throw new IndexOutOfBoundsException();
        }
        LinkedListEntry2 e = this.head;
        while (e != null && s != index) {
            e = e.next;
            s++;
        }
        if (e != null) {
            LinkedListEntry2 f = e.prev;
            if (f != null) { f.next = e.next; }
            f = e.next;
            if (f != null) { f.prev = e.prev; }
            if (this.tail == e) { this.tail = e.prev; }
            if (this.head == e) { this.head = e.next; }
            return e.data;
        }
        return null;
    }
    
    public int hashCode() {
        int hashCode = 1;
        LinkedListEntry2 e = this.head;
        while (e != null) {
            jif.lang.JifObject mobj = e.data;
            hashCode = 31 * hashCode + (mobj == null ? 0 : mobj.hashCode());
        }
        return hashCode;
    }
    
    public jif.lang.JifObject get(final int index)
          throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        int s = 0;
        LinkedListEntry2 e = this.head;
        while (e != null) {
            if (s == index) { return e.data; }
            e = e.next;
            s++;
        }
        return null;
    }
    
    public jif.lang.JifObject getFirst() throws IndexOutOfBoundsException {
        LinkedListEntry2 m = this.head;
        if (m != null) { return m.data; }
        throw new IndexOutOfBoundsException();
    }
    
    public jif.lang.JifObject getLast() throws IndexOutOfBoundsException {
        LinkedListEntry2 m = this.tail;
        if (m != null) { return m.data; }
        throw new IndexOutOfBoundsException();
    }
    
    public jif.lang.JifObject set(final int index,
                                  final jif.lang.JifObject element)
          throws IndexOutOfBoundsException {
        int s = 0;
        LinkedListEntry2 e = this.head;
        while (e != null) {
            if (s == index) {
                jif.lang.JifObject old = e.data;
                e.data = element;
                return old;
            }
            e = e.next;
            s++;
        }
        throw new IndexOutOfBoundsException();
    }
    
    public void add(final int index, final jif.lang.JifObject element)
          throws IndexOutOfBoundsException {
        LinkedListEntry2 n =
          new LinkedListEntry2(
            this.jif$jif_util_LinkedList2_S, this.jif$jif_util_LinkedList2_C).
            jif$util$LinkedListEntry2$();
        n.data = element;
        if (index == 0) {
            this.head = n;
            if (this.tail == null) { this.tail = n; }
            return;
        }
        int s = 0;
        LinkedListEntry2 e = this.head;
        while (e != null) {
            if (s == index) {
                n.next = e;
                n.prev = e.prev;
                e.prev = n;
                LinkedListEntry2 p = n.prev;
                if (p != null) { p.next = e; }
                if (n.next == null) { this.tail = n; }
                if (n.prev == null) { this.head = n; }
                return;
            }
            if (s == index - 1 && e.next == null) {
                n.next = null;
                n.prev = e;
                e.next = n;
                this.tail = n;
                return;
            }
            e = e.next;
            s++;
        }
        throw new IndexOutOfBoundsException();
    }
    
    public int indexOf(final jif.lang.JifObject o) {
        int s = 0;
        LinkedListEntry2 e = this.head;
        while (e != null) {
            if (o == e.data || o != null && o.equals(e.data)) { return s; }
            e = e.next;
            s++;
        }
        return -1;
    }
    
    public int lastIndexOf(final jif.lang.JifObject o) {
        int s = 0;
        int last = -1;
        LinkedListEntry2 e = this.head;
        while (e != null) {
            if (o == e.data || o != null && o.equals(e.data)) { last = s; }
            e = e.next;
            s++;
        }
        return last;
    }
    
    final public static String jlc$CompilerVersion$jif = "3.0.0";
    final public static long jlc$SourceLastModified$jif = 1147893510000L;
    final public static String jlc$ClassType$jif =
      ("H4sIAAAAAAAAALVdB3gVVb6fW5IACYQSWmihCQEJRRQxrtIVDCQmgIpP4mQy" +
       "Sa7cfichYHmWpwi2\ndVFcFcXGsg8Lrn5PWXxvrWtZdO39Q13ctSxr/VTQ1f" +
       "Wd//9MOXOm3Jnhbr5vzp2cOeXff/9zZube\nez4TinJZYcQ5sbYaZV1aztUs" +
       "ibU1iNmc3NqQiq9bTqqapVcuu/X2Px77yTNhIVIn9BQ7lY5UNqas\nU4S+de" +
       "eIXeLUTiUWn1oXyym1dULfWDKniEklJipy66JsKqEIo+vSZKj2eEqZKncrU9" +
       "NiVkxMxcmm\nNsyPi7kc6VaMtbmMcIEQ6s4KVVoPlShKETamJB039se1z29Y" +
       "MiwilK8SymPJJkVUYtL8VFIhU6wS\nyhJyokXO5ua2tsqtq4R+SVlubZKzMT" +
       "EeW08appKrhP65WHtSVDqzcq5RzqXiXdCwf64zLWdxTq2y\nTiiTUoSnbKek" +
       "pLKUQkJvW0yOt2r/FbXFxfacIgwyOKX8LYJ6wl6vGCEs2yZKstYluiaWbFWE" +
       "UXwP\nncdxp5AGpGtJQiby1qeKJkVSIfSnko+LyfapTUo2lmwnTYtSnWQWRa" +
       "h0HJQ06pEWpTViu9ysCEP4\ndg30EmnVEwUBXRRhIN8MRyJaquS0xOinvrjs" +
       "p00NB6vCSHOrLMWB/hLSaSTXqVFuk7NyUpJpx0Od\nNdctPqNzeFgQSOOBXG" +
       "PaZu74h1fUffLoKNpmmE2b+pZzZElpln48ZviIV+b+tWcEyOiRTuVioHwT\n" +
       "52i8DeqV2u408YZB+ohwsUa7+Fjj02dcuFM+EBZ6LBaKpVS8M5FcLPSUk63z" +
       "1fMScl4XS8q0tr6t\nLScri4VoHKuKU/g/EUdbLC6DOIrJeVpUOvC8Oy0IQg" +
       "k5hqifgvapCOVk0DXEFImLzaghrqoIVfFY\ny5RcVppK/tP8z9SkGwYtXxsK" +
       "EX6G894UJ4Z4cireKmebpR0f/um8hadsvDysW5dKjiJUQFRAETCD\nC6EQDj" +
       "rYLCSQOjb4xwO1fa+eknuIBItVQs9YItGpiC1xmbiRGI+n1sqtzQpaVT/Ggr" +
       "UoUNZCDJDY\ncnOcDERjQVroygpjeEMzHHIxhhtJfuWCn1/6vHntg2AToMMK" +
       "GJ0nvqy66awlZ18+JgKN1kaJbIGT\nMabgZzN2s7Tu8YHH7Xns+0fCQtEqEu" +
       "JyC+Q2sTOuNMyfl+pMkrhRoVc1yiSkJOvEFjleJ5TSyCES\n79f8tyQtYR9F" +
       "GFwHuqMeFYf2U7EXEUNp1hgEuo0iVj4uvwiapc83LX3wjb37JhpepwjjLMHA" +
       "2hOc\nmZdxQzYlya0kPBrD3/DDyV9uLpr9P2EhSiIE4U0hnEHAGcnPYXLqWi" +
       "1AAi+kZ2lbKpsQ43BJk0ov\npSObWmvUoPX2xvO+REulqluUqW6Bn3CxPxQD" +
       "qK2D0jkeMPweuqR42pv/W/rHMBupyxnkapIV6vf9\nDJtZnpVlUr/v1w2br/" +
       "9sw5loMKrFKASsOlviMakb6RscIgY6wCYG1QypuG5L9dY3NYscYIw+N5sV\n" +
       "14FBdl/0yogbnxFvIfGJxIlcbL2MYUDAmQRtAihr8HwqcxH+H0dc0SDCsOO5" +
       "uRzRC4lZxw++fP+L\nI/68nBLBD0GoGmZ0QiMkUBvLouU1S2/uP/+5B5Y+cV" +
       "dYCBMVEX23kZwgJhHgH26x3fn6VTBggLt2\nrfEIS+PFxmUwvcE8Der8Cy4Z" +
       "v6bHD4kdaG+lrXJOysbSwJUaPHvlYol0PEaguBXdhMCyklpCpAy4\ninNmxW" +
       "QuTjIR6lrL8eLC7nQWEK5LJPkAiUwolQnU4qAY352Gj+OJcMYiYdoghmiMgZ" +
       "qloy/85JsH\nX39oAgWjUeYeltaj7xvx5bh7Vo9HfYBVjOR5b5RFEpepcJql" +
       "a06PjT114tCTUAVFqbXobqMYgaYJ\n9kuxtEgwTDuDdCqLowAfcwlVQyxKVo" +
       "efWFe8+96fvzwBfYMRJyAkrzRNX4ygoFxgjqA6PTXLU2md\npGbp5L888f6l" +
       "NwzZy4qJ68C0/jRx881Xrh1yO7KtK3Usp1S9g1fFElKPMCuIJZLV01sXVb43" +
       "+chr\nnqXk8nZg1+POuw/etX7Cb9pVzcKEC9VZ4WOxrbJPI3m0oezUtV8cdd" +
       "0li7YxykYNEhGsxYZUn1DO\nMxRQTwYebyfPeSlFSSUYqc54dtrgub9d+ruw" +
       "Gj0W6VKpNjPI9WTZnF52xx/+tvO/b9PGWEJZbWBY\nbaRVs9LUkVbif7+glX" +
       "PS2Ot02ilt6sD9u4w2PYuKMq2L0fyvGiMhS+DTnEWQomvolWg599snb+1V\n" +
       "ZQTC4RgEw5AfmRIAU7dm6ao+HT8tG/xGgihlldCnQ8wtTpJsEBYScpZoKc6C" +
       "NJ/bckOt/8OKWw+9\noLyH3mbgJ/Qe222lf6XIQPuxb3T1K75/GyGjhGQgmF" +
       "eQVdZKMd4JOLWKrDBy89XKOqG36bp5tUBT\n41o9PxjOYzczLY/cRnpIzqE1" +
       "nPfkwBrAeRI5eqpg3ZMD65CAZrEGOxyBZbUOrSXEfImrk0WcEO0g\nMSxnQg" +
       "cMp3IrXQW8XHrU5VVHt1Wgt/REPZBloqIiQQ/oof1PSSwzkTjOhUSzTWi4SB" +
       "aoKjDdeeGh\n7+/YIO1HRfbGpasmMkUYykTOBvYSDZ3H6VSMIcdYFyoUgUbe" +
       "KpxAJv5f1VSVaquSIFuussvNoV9X\nzoJCSAXrxBdtbz/40+M7v9VRaKjBrY" +
       "nkZunpt97vm/j01huplJmcjwUISJuZJaa6th3pJAi6tEVp\ndOjSGEqOKn7p" +
       "w0hDoGZzgdVsIgqx0lhSRDecTNKzHG4GEPmFmnJWpyRhLUE8uEtdcF478q6P" +
       "Hvyw\nsSLMrMrHWhbGbB+G/LI02Mpotxmw9VOTR99zQeN7LRRO+puXTguTnY" +
       "mjt70lV88pk2xWYUaIKTfb\npVWmVw3d/mm8+O5SXHv1hYiAWEhCAgyBVYuT" +
       "5qrSWE6P88jSRiiuEEKCZVuoqbMlpzBr/IrjM7NX\nxOpPpUxV60wR561Bk1" +
       "W78v22VB/omjzt4lvQpKItYg55LSGxJgctyeLWecMIx6Ky76WbDvwNIuFj\n" +
       "PD2ln9zy4FpsXaFQU+ccZ2FSya6bgatGC8PN0iP7vt78+cr156FuypFGFF4T" +
       "pfYIsyOoncY1mdvV\nmna1bEXULI3/oO8X3/3n/sm4XaFJg12qLBXTlqXKyW" +
       "Kug9QXlbzz+JODzn45IoQXCb3iKbF1kYhr\nPKEnWVzJuQ6y3u9OnziHLqDW" +
       "9iBlX8Q/kMu5uizBBSe4yFJ1w602bgjnF6MPQnEJ+N98ONsAxWYo\nrsL2ij" +
       "7ZKHVCHxFwfv4IeDuOvy7NcQbhtjp/gNnul7NygzNjssHkGJlfjDu9TdbkLs" +
       "YRdLICA8ku\nVYwYdbshzo2z8w7e0Bf1/Ln21dJ9S9FbipWOWG7cNNgZtXOS" +
       "Wpoh3ohiFCh6QdlmSSZ6qaz1sk8m\nHoIiQXIGgk5x7JyxgL3TEJwwNVR2ah" +
       "5MmI+wwsTzq6H4FcamR1GzWHs9ljdZ3dRwOqv7+CDVg/s8\nwZC63TBSq7kV" +
       "VkJPc+YGnw9C8ZhhHY+guCaqKT+UNUwqj/sZI5z2pBEgN5z+Vdll4lNnaauX" +
       "jQqJ\njqn0lLjcJceNlQQ/yFLcgtegtvy0UX9ZdMyO8/mlRB8LYpr7NUt73y" +
       "7/cuHMvR8VbhsR/h1lv2M4\nypWJZqlf17BTIx2xZ/GujroYsNyOMHeqNS8B" +
       "etFZl5sWAmNMu3YDydFftZP+NrBczijUYZ8r7ybY\nmyRHkuKySG/OXKouCS" +
       "8n0aArFWsVQswAR9uPbtj2IDV2O9EczLY/ZG0bCromfs0kKm1qQfv8N4jq\n" +
       "Y4XuMnIhEqbv5zI9J6RyNSg5NQ8mpC8tIZJRZYTYfsiDJmdB8QmFle9NGw/0" +
       "ApT/NDZnPjHvKlir\nlundSEIM5w1Mm8a0TZWTeoeq2CJon97VG1JvVZiVBm" +
       "H4SJdBSTSq5Bexc7Pt6hJ24xmVD9z2xMDP\ncG81LMVgm9Zyo6BVdvL8znRa" +
       "zrIRKNwVg7NzuDVudR4iFeEUmDWRyqY7YlIVNRtiKvQWQZWYbe9M\nyEmlKg" +
       "WV9E5oldjaWjWxBeaWyT8tqS65qmVd1blN51en9a0wfe07X0wmU4plH/bv9Z" +
       "8/tj4tP6sB\nwQlUla+Boot96QN69ELlh0qh6IPGUg52EOoXZFTrRtCK5Jpk" +
       "am2Srp5mvPHC868u6L5Po5wsQfP6\nfaiIeBARG5wOEwR3N7LZplQJUE0nMv" +
       "aLOWcNvGqRRsFxlD266RnqSz9Gc5Uki01xYQTyusmuthEg\njIQmmMIIv7lX" +
       "l5LEuIGBFefPm7Vjn/w7em/IdS+P6/n0lvaZ23btKtKE0GHyyxoXtmjKGppi" +
       "s/8F\n5xd366JSbcvg6mp9Eli8VApcDqYIvQmLdIOP3iYeyd4mxu0/UwMc+i" +
       "htZdwfJAWNavRGrjlpiFvz\nDFN9nc8LQ0dDcYy65gnVelvz1MEZrHlCs7Dp" +
       "lWQlLGn7GTRQhFRTNkyKrFyFif5MKn9GHJrHZsRM\nahqabXF7KE5C18edS+" +
       "4eNCzVm2Tlrfibq67fN2kk3TjhlvLk+p4Fl16/ZffDM+ltali/9FWFT70Z\n" +
       "mAlNR7NAS0IteggCUIy0gf6BbihiFvAAclQU3Gfr3aC/pCWVItld0l8iV6ka" +
       "ZGEJPd2SyClCODXh\nsFQBp8uwth6Kpjx8IhkZhyRjNDmOUTk+huPYI/yYzQ" +
       "P2LWa6DEodQG8+PU9zRWjyDfdZOUEgft66\nRrnNEfYN4KFgK/mG8HYGwmMo" +
       "5HMwWq0JMCq0HZbfCFoUWLfpzGW8gHNGg1bJDm8lV7ydQY6jXJUT\nxCUu4H" +
       "03NNlkPce4zKhC4cUeobC925gQtk9CM7Hi8owOEo5QldGBx5AHCHaaP3l4AI" +
       "srnMBio8XA\noPglGhleOtkm1EM6EroM2UZJIb8eTAuKLodQ7+bLNqG+sOay" +
       "hYugeeMdR5W2PVdYqrY6x/XAcofT\n67F2ixc+kYyMTVyH3VxAs+Uqx8s5jv" +
       "1EOn1Q2L+b4jIoF9cn5WmuCMsCxnXPIX2H75B+NxPS70X5\n3ofhZleAUTPe" +
       "QvpvFHj0BvjK+IrmO+yi+Q7XaA4rpyNdVRLEEdjNXz6aj1RjptOMajR/2mM0" +
       "v7vb\nmJCJ5s9ngkVzSPur/cnDQzR/0Smav2CxLSjQpnY5RvP7ofgTso2SQn" +
       "49WBUUezgP7qmGaDcPZsQD\n23v9C24u73iN5szmBvc4R52sP6zYLA1cNWjC" +
       "3zbfex3eGo7E6aJ6FDnNqqfcsyazyDHXuxCOJcfs\ngtsIu7u7nZvxRHLMKb" +
       "jYP2bFzjMJq57hBZ/ygDNCBrZlOH0ba9/xYjvQ5gMo9mOfD1ESeHogY4Ob\n" +
       "2noopcohxckhEwQ3IaOd7DIoh5sT8zRXhEZPuBkjCNkdHDsP+sbOfzLY+RPK" +
       "+F8Y3H8OMGrGGTtN\nLaD8LiCAHrQD0IMsgBahDDlfAcCY5KqfAL4S7u8Com" +
       "BA011mpCAaHuQCogwnqq5wUvj/G4vW4NJw\n1JwTKoVh+nClNkZ4EA7kqi/O" +
       "KWrJcVoep2CEvoIcKwsu9DG80GFLcyzureGe5mIQWn2nUt+Gty1y\nC7slGR" +
       "8mp3YHQ/SyWTBVeucL3lAYWnC+Jln4MpKlcE0mWLIEy8BB/kjND4Th6Q7JUn" +
       "hqsDVeYQV5\nLIdg4TEk1qArTfBv+9B4NKpgDBRHWIwITquxwSRUVP7VX/hY" +
       "w4zNKAZovlmVxWZOFhn3EOz1znB4\nviL06BBzHXDTz8YNBriQYPcWyZJUTL" +
       "tdtP+Km+W/F112lPYWSSKdSsrqkwwTSE0SsS62Xn2Jg7uB\n2CfP5Bgtl1rf" +
       "1dAJYO/67X39mj9/dmjPJfpdP9uYiDcR9T35+al4XJYgUOTGrUgmUq2xNny7" +
       "oElW\nLhzxq5evufnCFXQf/8j8fYz6ofOEC/euPjgSbzyFJHxASn/Kz2hWSx" +
       "8w4UgMc/6i3Y93klEwfznN\nEnisqwkfM3qIH2ea4gcqFv3R643/8AJqDiLW" +
       "MDf+yQUoJaxYSCvwnLnxz1UtM7rRpUcD04a58W9U\nQWmXg8KzZ7eocrrFn/" +
       "c656ATXQbVc4Bwliji1EAJZrus2GWXk6accH41jJyjeZW9/6AMoFXSb95J\n" +
       "KGaph1JBlXam/Y+a8Z53hhOKECE8Z/wknYQQa9LJVppStVkm/dW46A8Z3mix" +
       "4U1I6JWGwW6y2vAm\nqw3TbtcaBrvJasOmqtBkWqVmolvyZqLooxa1QXETqs" +
       "4x8VwLxY3ILc6U8Qi+uiTnkaM1jyeE6/Tm\nZ+ZpThUXrqcfjR4i73+Q4yyX" +
       "EYNF3u2W9YONP0B5HqMCVYbUeo6gRg3FRTZoXuVdZoPzNPcvMy1N\nLqzMHj" +
       "gsmfF59e7M4eXVPnjzgIvsw8OmvPr3ofyhiiKjFpVMESXZzYSOpDWaJK3RBG" +
       "Nv+DkjdCSt\n0cRUxZgS3GubXVBTgoX0jIKb0quHZUqmRYW/uAaNt6kOCMXt" +
       "1Jn3UbE4Yq29qPRAYonK+zPuUdmG\nA7ywzz6ywOk9DNX3Uao/Ckz1A7ZUHw" +
       "hI9Ufoz34cBT6+tHEWKL8O5jAH/TgMFC9SMn4MLMRX7YQY\nCQUU4o80+zKB" +
       "CKzQ71cd737O8TLuCZrrqtQe6sHNl7nMyEWGOnIsdWkeKDJEytjIoHtDJErW" +
       "ziR5\nXBTL5hQbtK30TraGjYUlewAf0BioiwzOHB7U+SA1P9RFKh2gLjLEqw" +
       "dHitB1IqN5DyYXoByruyup\n4D2Yq1pmdJuou6vWhvFgrsr6PGJh9TnFok+z" +
       "Z8L+2W51xt3/ds+crrqa04ycSE5RvdOpeTCRzLb3\nzOmKUEI8s050dEyPVG" +
       "uOWViq57g55oLDdEwfpHpwzJOcHHOhZ8ecQR1zmcUxZyC/DYYXzrA65gyr\n" +
       "Y9JuKwwvnGF1zBkOjnmE6pyF1eeqPI4JT1A8rs74uD/HDKvfVmG24jFqfHEa" +
       "lCYBevPxeZorQn2g\n3aKc/W6R3b3ISLMvTqGHZOwJRTDXjrShIbUHGBUGGp" +
       "bxvjEUWa0IkZzPjSFCjXVjiK10uBupGaWz\neoIY5XreKJm7kWA/NS4z0j2g" +
       "iM2XLjjdjYzgQ7KR9fD/Nxa9QfFfqDunHDQC34YXuVgbI3KBPhBj\n9rCSPN" +
       "G72R+fp7nXTVI5LtOn2HwYPvCQICik9uU0/gtynFBwjV/lonEQ3Un5NX6ti8" +
       "ZNvKDON3Qb\n0zIIdkMmGIIdJ9B7yj6k4gHBbnJCsF8bZroR6d4ExTYornA3" +
       "0+uRbZQX8usnbVqBPLnbMCMTuAea\nLrilmHYaM3ratBqKrEPG5JFgLWMqLM" +
       "F3u2VMuwLam5YxFdbeHnCyt/s94IjNW/6FFeTvLYI0Zlwi\n0DS9sDP+Hzsj" +
       "u9FgDfQ0pljcEiPTFVh2kCW3GoYm+HdCaHcXjrnd3ujhdCfW3o2GlUdjKFCD" +
       "R3PS\nB3evX1Yl+TInyYyPVEgfFLbkR7gMyqFfZZ7mQZM+t9dwM1zS97zvpO" +
       "8lRv2voIBfRcW/FmDUjN+k\nb6+P12UzWn73vF3S93zepE97XNNZPUGczfSE" +
       "KJcCgP2MdZlRTQEO+Ej6XkKxfay7sElvUHyFunNE\n09eh+EIbI3KAiQWmxc" +
       "tM72Y/PU/z4ElffsMHHt5xTPq097AKq/EfXDQOojs+v8b/5Svp+6bbmNYA\n" +
       "4Wg0EwyEtbexfEglPwhHSxxAOFpkmOl3yMhBqC2Ds0OuZhoNI9soL+TXT9IH" +
       "yNqWx4YZmcDNarnQ\nlhI1PZ6a0fFvLxTvQ+V7/hIUeElsYMGpHOKSoGhP1R" +
       "d2xuGOCYolKFH7t5gQetEhLF/nEhR/BgPt\n+qE79Q+iIJSfwZI5HyG5QKiY" +
       "yo1+MoLLuOOp87tkE1wG1cUUrfEcddkXxVAP9bYv/2rPI0Wn0shr\n67l6wh" +
       "Cd5Pd5JEIxSz2U00C90elp/6NmnDMQVnHVJNiqLGf8JCCEDmsCwlbqr1/NMq" +
       "nuSBfVIa8L\nsTmzYRtdhISejBULaQWeMxu2XNUyo9tSrGhg2jAbtuYqfBSJ" +
       "VFF8ija64JPKGgNEKzPBgEh9kcxR\nJsGA6AwnIDrNYmBQrEYjcwKi6FFQrE" +
       "DloGCQXw+mBcUvOPdVXwt2dV/mKY4+eZrnf4ojwglcfXzV\nj8A9RPOYC36o" +
       "j68WWMUJVsVOYQPKY8");
    final public static String jlc$ClassType$jif$1 =
      ("FcDeXRb6vy/JSr7tIml5zEPMtD/rG44ySrO2Lcip5n+N4k\nqzvqVVDqr3wF" +
       "tzo4lYyHRaIyDTGXUptxDN/2doRq1iVv8aFNeXyI4wYrL/WtCvi4xkYdUF4b" +
       "TCVb\nfKjEBuBHE4uuUC27grPsTBCAh7sEk10GNaR/G3GdFb4BnniVstgDyN" +
       "/uCeS3+gb520wcQHkHqvXO\ntP9RM95A/mZFKGXYzvgC+q12QL/VFehBhdNc" +
       "VIj8Pmwx491I7B7DZndbzXi31Yxpt0cNm91tNePd\nVqDfrQH9U76A/tlMMK" +
       "CHt+enuMgkGArsdQL65yxGBsVLaGiOQQr2J6PPoHJQMMivB/OCYpcD0Lu5\n" +
       "sQ3QO5pMYKD3IXAPQP+uB6AvrIrftwd6c+iAcqcG9FR5foF+qx3Qb2WBfqvV" +
       "Hbda3RFjV/Rzw/e2\nWt1xqz3QB7Y6OH2dAfo3aYg5GBjo39Ulb/GhH/P4EM" +
       "cNVh70rQryURSyUQfURwKppKiHD5UQWy1l\n7BC+6nKI5VcS6S/7SWNeOXvi" +
       "k+l+z+GXe+q/vtejTujR1hmPsz/iwZwXp7NyG34zkdADy974AyxF\n5YrQQ/" +
       "MERYjCB9BV1Ide7q8IEXIZTgeoz9Hr7gcH7DSreTb9VIR+c1vg64wlhflBuz" +
       "GWH7SzNMLp\nKnDwCkUYpHunqaErDPBfdg9faTOTpw9mgfdAiwar31hYNNwK" +
       "R65fCV8Eey+Wb2mfT44FgvP3zweK\nRUWj+VjEsAdvnk3Oz954b+w1ubMHX8" +
       "Mxzx97+YN7kentZwZNiyrVcIRf1+36a1Ibn9r21eqXftnP\n8SfQmB+Yge/s" +
       "7qQ/Stos/SO9+qR3G9/fqf4GlOOPNxg99jw5fuM777w9lv6AE+FsPT4HU1In" +
       "lND8\nF6eHHzgd7TiaNlbsgzfaNl3y13LtXVX8Cat+NAs1WB/pPA6cr+xd+9" +
       "Ype/b8lv+qcoGRHsO+6RdF\nZk78tuTQC1/PMcvNuKVGvwZke/f/A3CcitlD" + "dgAA");
    
    public LinkedList2(final jif.lang.Label jif$S, final jif.lang.Label jif$C) {
        super(jif$S, jif$C);
        this.jif$jif_util_LinkedList2_S = jif$S;
        this.jif$jif_util_LinkedList2_C = jif$C;
    }
    
    public void jif$invokeDefConstructor() { this.jif$util$LinkedList2$(); }
    
    private void jif$init() {  }
    
    public static boolean jif$Instanceof(final jif.lang.Label jif$S,
                                         final jif.lang.Label jif$C,
                                         final Object o) {
        if (o instanceof LinkedList2) {
            LinkedList2 c = (LinkedList2) o;
            boolean ok = true;
            ok =
              ok &&
                jif.lang.LabelUtil.singleton().equivalentTo(
                  c.jif$jif_util_LinkedList2_S, jif$S);
            ok =
              ok &&
                jif.lang.LabelUtil.singleton().equivalentTo(
                  c.jif$jif_util_LinkedList2_C, jif$C);
            return ok;
        }
        return false;
    }
    
    public static LinkedList2 jif$cast$jif_util_LinkedList2(
      final jif.lang.Label jif$S, final jif.lang.Label jif$C, final Object o) {
        if (o == null) return null;
        if (LinkedList2.jif$Instanceof(jif$S, jif$C, o)) return (LinkedList2) o;
        throw new ClassCastException();
    }
    
    final private jif.lang.Label jif$jif_util_LinkedList2_S;
    final private jif.lang.Label jif$jif_util_LinkedList2_C;
    final public static String jlc$CompilerVersion$jl = "2.4.0";
    final public static long jlc$SourceLastModified$jl = 1147893510000L;
    final public static String jlc$ClassType$jl =
      ("H4sIAAAAAAAAAL17eazsWHrX7e7pnpmaJjPdM5MMk1leZpqoGyftWr2kWVJ2" +
       "ubyUd5ftsqNRx3vZ\n5X23QyIQiAAjsSUQQCQICQmEIhSIgPyBgIh9kyBCgI" +
       "TYEQKxCyECYnPVva/79evXGQhprnTsUz7n\nfOd3zreeq+/8+L+9e7Eq7x7l" +
       "WTwEcVa/WQ+5V70pWmXluXhsVdVx+vC2811f/e/dX/9B5ltfuPuk\neffJMF" +
       "Vqqw4dPEtrr6/Nu5cTL7G9stq6ruead6+knucqXhlacThOHbPUvHu1CoPUqp" +
       "vSq2SvyuL2\n2vHVqsm98jbn44/s3ctOllZ12Th1Vlb13afYyGotsKnDGGTD" +
       "qn6LvXvJD73YrYq7H7h7jr170Y+t\nYOr4zezjVYA3iuD++n3qPgsnmKVvOd" +
       "7jIR+5hKlb33356RHvrPi1w9RhGvrRxKvP2TtTfSS1pg93\nr95Diq00AJW6" +
       "DNNg6vpi1kyz1Hef/0CiU6eP5ZZzsQLv7fruc0/3E++bpl4fv23LdUh999mn" +
       "u90o\n9eXd55/i2RPcEl56+X/8JvG/PHr+htn1nPiK/8Vp0JeeGiR7vld6qe" +
       "PdD/zZ5s0fpo3mC8/f3U2d\nP/tU5/s+21/yJ1X2X/6ZL9/3+dZn9BHsyHPq" +
       "t53/Dn3hiz+z/ecff+EK42N5VoVXUXjPym9cFR9a\n3urzSRa/+R2K18Y3Hz" +
       "f+WfkvGr/6D3v/+vm7j9F3LzlZ3CQpffdxL3Xxh/pHpzobpt79V8H3K6+m\n" +
       "7z4S3z69lN1+T9vhh7F33Y6PTPXcqs+3ep/f3d19dCqfe3jfPX7Xd5+ciF4m" +
       "wZxkb/lmFPr13aM4\ntL+zKh1w+vVYMN/Tpb8S/UXdc89N6/nC07oVT4JIZb" +
       "HrlW87f/Cf/dVfRRx+4294/h3peoBT331m\nonO/BU8Qv3vuuRvRb3nvJl13" +
       "/dbh3/yxtz71m7+z+hPP371g3n08TJKmtuzYm5TKiuOs89y365tU\nvfKEBN" +
       "8EZ5K6l+1JACdZfjueCN0EftqVtrz7ytOC9q560lPNmqTnZ37gf/3Nf/d295" +
       "NXmbjy8DNX\n6k+Df/kN5WvM9/6Gr7xw7dR9ZNrb60pe+8bU33b+3W/ifvLv" +
       "/LV/8Pq7Al3fvfY+PXv/yKuePA1f\nLDPHcyc79C75H/lv1H/4oRfRP/78VS" +
       "g+Ppmf2pqEZtLlLz09x3v05a3Htue6Wc+zd5/wszKx4mvT\nY4Mxq89l1r37" +
       "5SYYn7jVv+l/3f/9z2u5Str1x73EvYpnST6JafmI9CYcVu25+b1IXff2qfXc" +
       "rNzP\n/tqX5n/3T33iLzz/pEH85BOWU/Hqe/V65V3WHEvPm77/g98l/tDv+L" +
       "c/+D03vjwwpr57KW/sOHT6\nG9bPPjfJwaefoepvfu4zP/w73/i9f/cx4z/9" +
       "LvVtWVrDle/9r/mZL/7uv2T96GQGJnWswtG7advz\nt5mev9F/tb77pqu4X+" +
       "XxTdayvZvBevPx5NcncKt/x3WDbgPvbhvy6KHLVU6fVrT91Uk8ZnJif99/\n" +
       "/nM/Nnt0D/Q65vM3Mh+r3m8U3zPwbWf80+qP/ezfqP/hbW/flY4rjS/3759W" +
       "s54QXOTvtK+89BO/\nL3n+7qPm3adujs1Ka82Km+vOm5NrqvCHj+zdL3pP+3" +
       "vdzL1Nfesd6f/C05L5xLRPy+W7dmWqX3tf\n6x99UhSnjXh5Kr90Kh9/MH63" +
       "97XxU9fHK/1zd/m18l23AV+9Pb/9HWH5aF6GrXWNBe4+cvYs9zFT\nf/EzbB" +
       "iR1uWwvJfm6xN6H4TZA4TZsyFg18cvm2aa+HCTk+9+gtj18W39cxOmF1dvzt" +
       "+cX38T78f8\nwtTuh6l1G//6JO3VLaCZ8H9LFDuvPdY/bYppJt/z2rSMx0v6" +
       "1E3Cb4J67/qfMfkkU9/0bjc2m+KD\nr//z3/rXf8tX/9EkQ8zdi+2Vv5PoPE" +
       "GLb64B1K//8d/xxU/88D/++k1Kp539BP6X//1tzfz1QU7B\nxRWdkjWl47FW" +
       "VXOZG06xkHsD+H5BFsswmZxn++Ddf9uX/sC/+Ml/Jn/m+SdCoK++Lwp5csx9" +
       "GHST\nlFneTzN82881w633nwe+7cd/QP6H9n148Op7/RSRNsnm9/09743vft" +
       "l5hsv7SJw9cz/rR3fUuqK3\nj/9YzcVWgabZkK9v6C1uSIqehGdcIhhZlvqy" +
       "prUdLiUBnYvrRBoUC3b80DkbVKLnXbicudre2Tsn\nsgoQtkw3on7q21KvTV" +
       "dYodJi5dRKX4LaUVr4uguCKCechGTFpGe73LRjvnQE7+T7IDqaje3NvHF9\n" +
       "DFPGNBxpU9mGZWoLa6zVKrTVRcgnzoovpLBA7WNRWLnmNA14Woo9DA9H/kxr" +
       "dIpiEhwbG5UvrGqm\nrhXA9Tz65LHqMVT1dJGdhiFZuCrr67tDGhKXmAnzAY" +
       "KY6lAQdAa0inmIlh5RmIfUKVWUD7VLz/VO\nksz4ahBD+OJAmsXVdsI5NCFB" +
       "1fqgaZkYK+cDcbQSBpuv0MpbjEvU4MIujA+IMiQiw1w01ahZRNvT\nZxXqlN" +
       "lwZobschI2jbWsq6Iu1jKgaHFjm4eROxKePkesPD+UZxHa6FStaLtidIqNPB" +
       "an8OTinQ+t\nR1Z3+2OxHGbHMDyqmZLaB++SswdVujCtPh+EelmCe/u076dg" +
       "nQ66QTicENZgoC6GWhInquVgHqra\niJvQ0u29TqinTpyljtvnmy2ZkzUjhf" +
       "awKLzDBF+hfSW9ZAA7+FY+zbaMky49GrWS6pIuW+c5xUhz\nKCf0/KiFDTpU" +
       "OCGuZ26wmhNJqhGdip1k+UzzCCcPjFU0yrwXwrQtoyqfz3kManGFEkqW0zHw" +
       "zCqW\ncjwV2r65wPyg5kzezwV3xrtOLRb86O0DSREE7ESKltnA6/PCV32fzQ" +
       "58niTE0gZyczSJOI/TNWK2\nIa0BNlDrDjEIoXxstDCjuuNsswyRnVdoy2Y9" +
       "RwwTA7JzV6kWDOyjaL50nWbPAQRmQixmHXJNQbjN\n3mFFRb1Aq3Hhc4oTr0" +
       "8KUszrEqpnrOKU4VrLqENzUMEAJFTXZnFoJ9Al42m5KrQ4IgxzWgoum3MR\n" +
       "+kFr5bigXea7E7GnE3a0gnNZZLTm743ZsJEdbeI9WIvIiCoXsjPqU18diBNE" +
       "IuhaZdbm2glL75B4\ndi7Pp5A5Qc6Tk2h3Q6Vv3EMUMqq0l7fEEd/NcIiQdl" +
       "FpsLgiCZG97jth4VuAd0kbGqNrTapQg67J\nPMQXfWKHMkkD6WKSx1HKLe0I" +
       "kkGpZipv4jtmZ8ycVHB2hBxJWpkNQR55BDdSFN2fzzXjNzqeLkCo\npdI6WG" +
       "6PGccdSGaetsWkXVYXmwsEYIIDv7hYjE2Txxln2YE58ssKPjaIQVHwKa2AuY" +
       "9LNVEQDTPg\ngLSsjkLDc4MfAzl3Kc9ypjmLIVQujNAS+yj2mM1RGXBCmcGo" +
       "j9SDVBsyuif3HdUUnLc3/KUKEydC\n5fPFOSCabB5q0bppu9DKHWTFnlZdZK" +
       "9g5px7eRdFLEdtl2fBmSWm20ujEQ/W/CJi5W4F7naDhjZs\nXqLikjgrIU2s" +
       "1fk5Jagt6aSicWILPVxstyFwMZexfcgrab3CmMs8a2e5Ith60qqZeFr2rQDI" +
       "RBMX\ncaMWOoSlK7wXe2lXHJa7eXTxOLHzmkJeL/MW1MGS4rAmH/r0YuW0Br" +
       "U+OtsxtZnmWqyWYLvolnYJ\nolW3iTPuUO4PW6US4jbkrIsNydWk8AbU4Qa5" +
       "kIa8ITcs6hor3qgcg+4AflNps8V6j7kxOB+ywE77\nfUv7JNPTsWOzS85Qd9" +
       "tEkutteC4RqiucngKouevMlR1eCZPVkkcZX8dm3wGALwLsjAYhJMVYbDcn\n" +
       "MzIx51LIXVSsZbNGXShLsBFBYINtDMDRXAPHOI04LVcXswuYMxVQS6hf+Smk" +
       "HbEgYOvlrPQJWgHE\nfZ+oXesQk56WCD6szRayqd364lokEJcnRhgqW+kY1R" +
       "KpNjayeC4SVtBgJ/fM4cMlzvF8O6xnYcon\nvS41x4iWobhkEY/F4VTSicOG" +
       "ZcTLNlS7LJZSdV1sjdVmSUaAwDicERpuFpyTkAvMIs4GENkwFTU7\nrdBsG+" +
       "iR6hleXFsR3Lf9xj7DWoZSvoFpkSBv7I28JyaRcpgituaQGB0Xi3WNH9Wtti" +
       "/sU2YXnBFY\nBjNDL01fE0F33DU7Fy/YrNv6Thdr0tAftMzz9b2HACjkt2OH" +
       "+QYnM8P2Uo4yf1oPQbbvg6jYQuLx\nxKrLxJ3lpJ1vWARBfCjmu9Ec1gUDIf" +
       "gcjOQeQRan8rwYBPhQH1ZqlS8UNFj4eyI+iBze0IzJavNF\nddLs9QpwzuUs" +
       "LU4XJDWDBSAKTQd69QnGbTTXRudA4KhmrnWhL21GpFfJPPNGtdYQx3XncQgb" +
       "/XAx\neOJMVr1hquliJ8y4XpaOneHZgy96SrxXFNUonM3arcugsVEXKJuOjO" +
       "Y6pB1yPhJpVD+a6X6z7HsQ\nqFsBtFGR1AnGtHXMmNmWrFUoq140O/RhIIhP" +
       "orIU6vkyjGuo2qHNuluKRnPgiiU794eWDLmzAuyO\nKaFLWdJmsR5sULRKbW" +
       "ChzUzpiK/lgOg2Wz+R6a0KuwlkZQB1RGoS7MkgPMexi6cS0tXHnKkIzFCc\n" +
       "3MwODoTzDGg7F6EGEeGgdwA6y9iBWiV2wICSt1wuYx860ZLY9PbquDjAG5Ac" +
       "yOhMSkGy9yTNNQ+c\nu2YEVj+UO2xA0NNBKMgVNPGwVrHjbL3IULGPBGN0Rt" +
       "YAHTnN6bEgFqnoXzqs3HoyvfGKPFiZ3A7a\n4FuzJEihHzDTVoVSORE+nZSX" +
       "+eTzhHkw45Q+lQKHy1d0eZJ05ESV6kbTqHqhBzUoE6KJxVlBh5IE\nZpm/EB" +
       "WlGy/HSDirynjUw7WCWdkh2k2BFHmewQBo0MKCkn2bzK0qmdTcGC5HAWsNZW" +
       "euKEhTONpx\njf2QqYFqe4e83zLtxl9oinZ1+/S+aaqq5TMNPc3GjMGV7ans" +
       "Mbe2R3A9Bzi4RTXZOkRYaaQXs0nz\nGoXbBIzmi3OTx0ziRJ1KK0xjMpYF1e" +
       "dVzmxDqCa0fOYKkUIShXBI4bybn3cZaY6Bq1V0UPTz+KzI\nO8858oeRItck" +
       "ISb7JGX0fJDPrEogDVG7zn4NIwU0GZOhm1UKy5VcSelnm7QxgARZer7k8qzu" +
       "kw7V\nhKOMoqPk8TArywKQN6dj0BxTI4lqeB5rCJJflr1uqBZ9OPr2LNf0RO" +
       "tWLpgkCCBslBPVLs5GuNWJ\nM74NBkwzmuOmKBWdgEQEiRQ5DBuCOOCm1mSF" +
       "zcX5iJUgXUYczJ9mvZCLudpr0LyTN9ACuyx0GGmX\nSw0DsyQa63XcSvmBro" +
       "1gs2EVsmcCpx48Vvccju6hwwBDur1rO55u9tFM3C3jFB2H9T6vTtZeUgHH\n" +
       "MZd7ZbAgO7BqEkdEfh6KcFvDCOCUiw20b4Z8crH79TH3DboahCx1jEXittos" +
       "Sa2FTZxUll6BmYCc\nVuAqBatkPRFmgsWyYLHTMS5Oh0E/NAEqnWJ7HAFG2I" +
       "3pekNn0gm3V+HB3i8uxmSCxAOR6trINBI0\nrBpUSMeQYoudjoZYfEIk8MI1" +
       "myYcMUzx1sOeWXTQfGkHUbqHOFFKCQbgUUTgq+3EhmxWVuwyjGDz\nQGk41e" +
       "87v13T3q4R2gHmHck+11EOBnzaxFO4GYx8VFXUhWRiP9o16NG1L2xlyC5L41" +
       "vk0sw0ozNc\nuzqP2XJEOtibY/4CZNPlwmVQBd3bYa4LOgk7PB+Y9UlQ9Dw7" +
       "r7JzuMfPkOTGiaKYUGGNi+qCJDMq\nm/TuRJNTYNjDzNAH7OpIMF3Ha/LSOm" +
       "+4hAa6rjqOBUSt946VyAty1KkKjSPXXLlyJxQtDOA7LQAr\nZNaZOLQ6YkoB" +
       "XzTtwogOYJBph+KIeT5TBhA0uFUcjoDKq10RgZVJb8ZljhEBvxkBzY3jdcyn" +
       "ltWc\nIqlgZlGRzmM2chjH4+PJNAx71glqL6jbYa6eUNPlBgEBk1jGpjNFXs" +
       "K8WsOrAQadhuJaGdHscyWD\n50XcLrn1bMh1ZvKj/gLGjnS/7E2QbKIyMyp+" +
       "EDjKK3gFwbx6b8abSt8mPNesjN3g7v3aFAG+xJwx\njFTDREp4sI1ZMsjUpT" +
       "kMCgkKp0PW4AqSzq1tuderKZ7ttjLaiHYdLemdthRQ4mZBTXJu42WW+NX8\n" +
       "ckgWheS3CL+OipmxPjVcSp+Jwm43I40ykDzwSrDhJSTJcaSmTUY2jaPhV+GO" +
       "SVwMkZJ97KE82YHz\nbX4E+Z2ZihHVHuKwnMVN6ioEzW26BZcg1vxo6kcv84" +
       "olzmQpCmvkgmk1M9SwhForjIspR6XYYF7v\nwGINnZnluk+0HToue24nzhwS" +
       "WbCcFiSoOWQQprkti4ypbI0lLR/4Tgtgfmx2WuPK63DvEWqy0+Wh\nMGAjpj" +
       "VersNDK+mSqRu2h3KzgUjiQ6BrKLHJYjey9EjvMc/Sh8nVFQq0KRLNXdgxv1" +
       "l4KWrNO9+b\nw6d5l6jrPKZAu0VNBKyjdS1CFTbrpFiNLQDLshqFJB5CCTY+" +
       "z4szRIukGmyWhJCdzP2xlGv8sGHy\ni5UslTLfJK1I4QiENBC7EbNNV0m+CM" +
       "18K6Q9bCuTm04gOnk12VQzjyVGJeYp11qsoDt8SxayXO37\neLeEIDktlBEl" +
       "nY16CeeL3pCOQ1MlTX0mgllES0nC0XQLx6d4wxINTWJ7zxcTWItScFLWBKTd" +
       "KbSE\nwEm4W8tcrux6iomIOUkNQ5+d6iQ6kHkeViCyn216dwVBjGI7bQAlOU" +
       "rEIaJtc2dXGHQrJaxLC+Iq\nNLzBXSd9MwfVjnOA8FybbuczW523WpksozgP" +
       "9+042+15NHUQVpq7O8cYoE2Qal7cjguOMEsqxit4\nl8e6FLNkCpNHWTrv5S" +
       "N/GabAftiH/oY7pChJMSVlVjI3s86FNZ3r4QOxwReIN61o7fH4qCXLY1z6\n" +
       "oV1AsM8vL5fVMTrHLXsB8vU+XkCg6fs7DpgC1zgE0b2+P8Jzc5ZsY16G+a0y" +
       "pyf1DnCVHuaBD2F2\nONmsdrt1YkldkX65snAwx3WNruMp1ENCDbpYJkkwor" +
       "ucDmExLuxO51m1l7Acabr6DB3yqEfo88U8\nD3LE7xJBPV6AcyMaNDgYoyQu" +
       "Wd2CdkTmSiQCiCo6yno07HzXFFQi8GsImsllyhO+wa8P++AAJiRC\nGWSXcN" +
       "mG4jq9mDMcXswp0/bxfabqrJ+PpI4EFE8GC5vZJUiswYMrGVB0YtTjrMfVZk" +
       "3NVzwfX0TH\nW4+HM752VC+zcXS5CaT6guIcTIVINslhtpFil8T6zZbCKcsS" +
       "V/F6S1dlymFhhpy2s0wMYvIce0J9\nSRYEBxFlxi1Vk6FtxDtumwM7rQoGbJ" +
       "YvSKASrOFsNIHnca680ZfidAQqSgPqwdPWyfzjDIL3y7B3\ngIsxcEdtiiK1" +
       "flsBatEj1SZqF4SQLqQlC9jriM72qJNu9KTBuQrv05NIn5YUvMEAvhcVeH7a" +
       "zFaZ\nfzZjb6seRU9q83ZPRXOsjQ4AXSYCMISABJ+s7brMB97VZJYg3Ig/jZ" +
       "AVLeQorwXOimRwmXDzFm7t\nWcLgzKZC0+CijYrYlKCT7qRRBudKYrVLvGeV" +
       "SMpTYyO3Ipz5wbHKloqUrlEdU1VvDES4SEhr54hm\nJe1my1WL4st1A6/C6f" +
       "w5JljrrOXNshKh0WC3C4fXI3w12r7XrzwygwnIYqD9LuWLwneqwRqHHXVq\n" +
       "enw6nfnVLKgruoEbODXbXqZY7mBHhri092PEMcUGPmMmOAQ7HsdKMxaouW2h" +
       "YG9ErbQJuAxNBH+3\nIBSPygJjLdizZZpluZOde+dyJjppRVuCC+/o7Lypjs" +
       "gon86EKTbYJcL5i0vtKhGobMGfvAogiwdg\njxgrChE4siTJY83PWGuHsCG+" +
       "pUppN6e5KsCs824X+1sHNzaHwt+yawVuEDxLsO18sZiczNaiGgnP\ngi4tik" +
       "2nthFIrlt9zTPdbMF0x0OmnYEUj/mLuSa28KUIwenIUTLOdEbMlzjRZrRz6K" +
       "oG3ZHInJy8\n9DA2pUd6m4SW9HSZqjVA1sNimOFwFZPy5NZWBiWByqAfMc1r" +
       "HHYVbw09xQEmTtdcfogdYp7oLE0M\nCIaBl0l118cpcoEZNT0X1U7zDEnbzF" +
       "jaDdZH4rIotuXRx1oAxdb8IQ92mEzpdEcfi6bvFFnVRFg7\ngWejW4/8YWtm" +
       "bZxovW4K+3O6IoRxMa");
    final public static String jlc$ClassType$jl$1 =
      ("bYetaG7BzCsJE67Y4jYvBYGUqG6OiDOWkuW7u1CBwSQAf3\ni8UyFg1dUQ6u" +
       "UpXFpeuOCjFXKgVantIlE8ANNlvivrjBgjpelP7C3TKGAELwdHBPIhR0k0hk" +
       "/NwV\n0cYId46MHlcbwIrXJ8YIVOFIlmqQqMWy59MBzohYn7HnsS82Xtv4Kb" +
       "4/ST6IRIhvjFDmCwQOeo0Y\nBYo9TgEo1W+VFDyMy7Ou9Ei3VgPOAaFwZaCr" +
       "S0x0/pjyMyINq6K7+NyqoKmlZ60Dp9i3Kxlar0Bk\nyxS7kNW5nQ8MkpoxVm" +
       "8oeNulbNqPC7Xm4FLOVWc3X1sbREfVmaQnpwA5jCbsZU5Z7lPQgTbQ9niS\n" +
       "bM1ZY10cRuGC2DJm2VRLUj9dIMtxqPUiYobIM3UUhLZctj8pNrphZgfSys8L" +
       "ZgqtrQQ0AAsxN6vz\nWZhO+wRigt0lNSTJQllGy3Ol1i4J6OpraIuYqyTs1+" +
       "qChhid7HRoWLbbZFZ0q6NdOxZWtoxVCUlR\nYxe90JIsbgezYLOstxbSiTgW" +
       "1bpHtI7tjRXNOpCKSCHQhMf0YnGLaPAICDwmMxMw8+NZPZWF40dT\npAOvAG" +
       "k9DCfC4PerZqmjhsCLc2xDFRyuGfZkz6FADlaT9zSzUzMdtDNx5EWn5YbFpJ" +
       "vFyFFRUCX+\nfoN6MLf2TpqYRmNAt1WHCFOAUk72cziH4SHa5xpHKCdzNBQh" +
       "3+kWc1jJGMm3wO4SubhSz+aOrPZm\noKzIxj5p2DHITvOIPtjzoqFMtUhkQw" +
       "ebrcXX0EXAuVO9YNKVahNro1iihShvjSw9AKPYqG5Czrbw\n0I0jNHTCBd3x" +
       "p5VqZSB+GRdb2FSp7kyjqp+Nq7WDHSGgpgj9wCLCJtpS4DHg9jiqcJPqspx8" +
       "gg3J\nmOGSqq4zZA6MBww/jBK8cFx4BQvIkW1wsyyLWvKgiuJjOOUGQieFlK" +
       "5c/eIddgwx1JOXoeqpVupj\nKG9mJ+zIbs7SFCet5sfSIiNDjb1u688nVxh2" +
       "o0BhsAoo24WIyvvDeRmwEUsUnUuFNbagC36zG4xT\nhg1lMzT5bL1bGsUiT1" +
       "ymyRqo1c/tPiirEhJJ5owe0312AUYTYYGlvln09Qp0q+nUWRbWfD04CjH5\n" +
       "GVfIvSMuj6y9mo1CclAJGqnmm7lLDKJGNoKuhZP5n46+GbtzJ7XLqbwbGcGh" +
       "KOFsIp4jyYsxcSa+\nDTi4M4zTWG6nUGwoZwbKNIeua1NyvxixixClCQHlw3" +
       "7heYVIr5njYouUFbxudiC1O7S+lpDLdbQv\nfIqwYtzAvFbsPTMrpXQZzFbW" +
       "wQF1SF7ZK1phufZYkJQpdIx83J2iUjnTtkqRmEqSud23EaHq1py+\nmKMYKX" +
       "s8OmlReFjMG6zJSUsfZ15GG5tT6R2YBL7oW5BX1uM8WgYhtzyxUeRGxhhI8E" +
       "FG/R3I9xYq\n+Xu/2DUptZPw1dqYlCCw6dUBE89YNENLXBF5El7KgJ/D6emo" +
       "0Ru2FtIl1Rlii0s0Hl7QRp2DQT2k\ne6yLNDDOUkJaqemGP0F1iJh8e9gJ/E" +
       "qyZ/ORpt0Ll5DTi0ExeIigyzqgMDtl8GqP2GaZyZC7Jvqj\nkZXpdjUHGtk2" +
       "pRPSVKmtFZjIpjaHc8dm61kztgzjhDIsblVaNVYcSkIkN8w+mExiwXJXXde4" +
       "pmOt\nZGP0e9f2qBQfarBC13TE6yC033vHljXouRl34Wy+U9BqJwLUWEUNug" +
       "92vjTP48ghQvG4187LC66v\nyMxIAMrFLcqZmJK6qyY6u7ivr7IlGatudNjj" +
       "O3klKjNs5bWnhREDRzodjEnOpvB0z9oXGQ64odj7\npgknkskBNep23GJUUH" +
       "hscwGJ5XY5+WbMl53JcyU7NeKBy8yGAHGxVEc9hVftfqWgq9HLCRQ+8bwp\n" +
       "qqQz+gpxYBw8EJeca8byUSIEgIig0+XQ+9YAV0TcqtSwb6bQeDZHvTNA0Ff2" +
       "bsPJIfTO5CeWBiiq\n4LgmYt+vOIqqN/1RLOYovD0UIOGfdpKQRRXQIja4Ud" +
       "ocgGw74Y3tbK0Hc6IbiNr2ep8IYrE7U0rf\nb4V9fkmEeDVwZ6zAl7tqLjTm" +
       "OeNptMpY4Hg6ojQ18IXerw0zcXa8VabSLD7TC9GErLm/b9n+2EqA\nBoNnWv" +
       "WIuDI4MqeEg5KRZ3Ehu8u+IQXcyOLDnoLrKRL3auLM7sGUOMsgFoj1DCgIGJ" +
       "WAkGYUvzPp\nDTWQG+kQGkO2ALiMZRtByBG4vhCLjlw4qlr6hOO6l1OvbUXU" +
       "NlpwWYr0XE/n1bmcou0Y6s64uxHd\nDUPQvTIu1fkcR+denIMQn6Q7TtJSSm" +
       "P4sGBJH2FwnNglFd7FdlEuQJ4r0kbBfI22EHZWHZPRkGv3\nTCtehKmsJeke" +
       "1zfLE68OGVorJXkOltHWrhuj8DGF0fZ7JIwsaM2IBzLgicMoYgFxRi9OL8+Y" +
       "itxC\n2y6ldyVvJJhUEkbkdIdwku2pvoszEpdOHZBgjtoKoqudunrpamByMN" +
       "aAZ5apv86iLogd/zRqswjZ\norIoGPgKyiII0XVOZbRKEwxJPBjINRXAfEiC" +
       "eOWWovFOqmYU+tcG9lmJAy/8p72z806yDbUDyCgl\nXNNJvBkJkat3YEmu14" +
       "NSCkvWCfNNCvDry6wY20LTdkW56vb1mK1jY6Bkix52R/Kk5nW/48Glm8nF\n" +
       "ItRaxNrz3mmg151RsqBe42247i+Gq+7X9hHX7Jl/iAiswShi3TQqvoSDUqyO" +
       "GL49T0pxWcxJ3pJB\nckW6e3uNpWmoVXWwG3iwwT1lBQT2ZjnvHIm6UEV7Em" +
       "b15K84dLMFE3N/IE/G2AY4UCyWEgtqe++M\nnV3e0egIEZOuX6MLGsbgnZm6" +
       "9ngKVwujz+u5wyfoouY90Z1pxc4vJQpVYWgL1jHHHXCqBry04YIL\nuS0rV2" +
       "KhzdCTWKWxFhkKklQuGUgUM4qROC5sMXBSgHwK7thmM6uklSRscs447Fb0aS" +
       "tKItBg0LYt\n6dKvOxdygHDrFA6J7uWNn+2Bop9s8VLH/KLVKNu1VvJ+stry" +
       "2IHecqbXi74YVxIGG5BALd2tn60s\nI9iQWJStUDW2QfJMgeKa4BxeO8PzUi" +
       "oHVVYGVfJVuTvk+SGkdhtV0odFPIMxHIDSA73RHAVSQFjR\neU84teEFiIER" +
       "IE8eUIBt7UXHJpIX50SsRjDszO6Uw/xArtbjxd3uBhReb4d+P9sYpSSBHCEb" +
       "EY6h\nmLagXQ8uEJo40eYx8LIRpUo4cCh4p5Te0UY1WgacRRtA6y4++zHWTK" +
       "d9ClZGnmPz2SHddfhFNXKq\nSQuLKHci5rsB6ltH4Zh3aBL47jbsrHK1OBs8" +
       "3x1kaOPjGkJ4A6Dby8Q/rtf7oBVXY+cdZrKqR4AW\nEdXWbdPLShjRzdoGuk" +
       "Vjc9QJ4fqxR2HA4OGLl9ZmZ/LhUGoOLfsLYAVZC9pO0XK58IqTX6fiDFF8\n" +
       "KcEAI/DACi6mY1edVaAioEAhr0gU9At/TcaCIPJ9gKJRt/EbDobhDo1baEsA" +
       "+0o8rqkpwE5jfofM\n9pBHUWPgwsfQ4mO7CkZ/eq+GxYqtT9oJwa0a4LfVQs" +
       "fAXNxCTgn0LoAauQfaSNwChZORMlUJACS7\n+5l5gZG6OUr4AhQ5p+Wbg0a2" +
       "nXnxQB/crnAnrOOdG2y3V+3/2oOt+PT7bMVriw+wFvfZZd/7/mSx\n5691+v" +
       "r4Ff01BWuiMZW3rxlNbz+Rm/u2ckta/CDC7s+fMP4u4Vsu1i95SHp8Ny/y8w" +
       "85kVV598UP\nygu/pWf94Ok/vvzrrT//tecfEij1+u7jdZZ/Z+y1XvxuLuXT" +
       "RLhbGvzjBMNP6l/+J3voD37/08mU\nn56m//LPOfJt55X2W6UXzuFffv7uhX" +
       "eSGd+Xh//eQW+9N4VxVnp1U6bH9yQyfumdLMJPPGRxv/yQ\nRfjyU1mEt218" +
       "Yhc/ILv0G6aeVvXdZ68cu3LrtSe49dq7AlC8B9Rnp/LqA6hXPyRQY333ohN7" +
       "Vnlr\nVfL7EVp995E2C91ngPrmqXzLA6hv+ZBA/br6Pu33aUwvhGn9DEi/eC" +
       "pfeYD0lf87SM89pJU/5Gq+\n+k5OMRP69xm03xjtb56AWa77NNiP2lk2bWz6" +
       "DMDfNhXoATD08wJ8/fnbvzG031PffaL0kqz1sEH2\nblHPjzyF55q2+/mpHB" +
       "/wHD9MPL+/vnvpHs+zoDzemuwBSvbzhvL1Z0N5ittffTeblk5drxeaWvCx\n" +
       "rEndiugdL7/eIrlN+ofeA/u3PwP2F6byQw+wf+hD0oo/Wt997GxVZzxzbzi+" +
       "/gwcr03lRx9w/OiH\ntH3Xn3/kRu2nJskPvPqDNuWrU/mJBzA/8Qu4Ke/D8W" +
       "emnZlw7MOy+kAwV8PwUw9gfurDBPMXJ9Wf\nwFyzrT8Iy5em8tMPWH76/w7L" +
       "8+/GAV//OZTufaj+xsSq6oNZ9emp/K0HRH/r/w+iv31vNq/VX/MM\nRF+cOr" +
       "90D+j+/WHZpL8/8Su8qb//QVo1GaXnPvOA5TMfJpZ/OtnrKfqq6Q/Gc71j9u" +
       "1Xkg/cur3r\nO//9N4C+61HRWFVYNFntvX5/OefR1ak/ugYhYdpmF2/n+U9c" +
       "gnr9jUffV5/D6s1nRimvv/HW97+R\n/4JZs39V333ug4A8SyY+NpVX3r/uX/" +
       "mN1n1/z+TJhYf1daGPvudryqP3LOiX/b8t6D9ORujxBM9a\nwDfdC/VTC3ju" +
       "p7/BAu7vmTx64N9DTHFbyeNoN/Nf/57b1ZRH770R9X1WYn//rafyHY9+7g74" +
       "4w73\nMc99Q/a1/bRPof/o9exR+M5cj56Qies2PvHzkfPolz96/cn27K13EG" +
       "eXqXHir/fWrTY9vv3bn8Kj\nXm98VGEaxF6dpa+/8aZXNBP34ukQesxed978" +
       "4HPUd9xW+caHQBq/kcbfeOv+DDERf+v7H6q+FVfe\nuzrxAae1168P5tni88" +
       "L91aLrz9th7c3HkckT93z+T6PQ/3p/I+4Jqbh+fU+I9XBf8HOPhe/x/cFr\n" +
       "41d+AVcxPZ77xgrz3Iv13ReviJ3J4D1z82+ApnPuJ574dr0z+Ln3XT6/vyLt" +
       "fOVnvvf1P5e/8ldu\n1zLfucb8Env3Mb+J4ycvtT1RfykvPT+8rf6l+ytut6" +
       "147lP3+ny7hzSdR66v6zKe++R986cn93X/\nj8TnPpM/5ts3v3N9bWtPxsxy" +
       "6hvo/n8D8LX66DY/AAA=");
}

class LinkedListEntry2 {
    
    LinkedListEntry2 jif$util$LinkedListEntry2$() {
        this.jif$init();
        {  }
        return this;
    }
    
    LinkedListEntry2 next;
    LinkedListEntry2 prev;
    jif.lang.JifObject data;
    final public static String jlc$CompilerVersion$jif = "3.0.0";
    final public static long jlc$SourceLastModified$jif = 1147893510000L;
    final public static String jlc$ClassType$jif =
      ("H4sIAAAAAAAAAK0ZC3AV1fXm5f/BJBBIgCQEkkAySEL9jRqnEiOR4IuEBFDT" +
       "ynOz775kYd/bdfe+\n5JEqYmn5tWodKNaxQhX8FGxrZWo72LEg+NdW6RSpHf" +
       "ygtTr+nVrR0bHnnrv/94Iwmpncd3f3nHPP\n/7N7/3sk1zRIzQol1sJW6dRs" +
       "WajEeiTDpNEeTV21BG5F5EPrtt352LlvPREi2WFSKCXZkGYobBUj\nZeEV0r" +
       "DUmmSK2hpWTNYWJmVKwmRSgikSo9FOQ4szMj2sA6lBVWOtNMVadcmQ4q14WG" +
       "tPhyqZJqDl\n4V3zGrKaZKUMUmdjWEwJjhBYsHR+/Rcjz65fODWblPaTUiXR" +
       "xySmyB1agsER/aQkTuMD1DDbo1Ea\n7SflCUqjfdRQJFUZBUAt0U/Gm8pgQm" +
       "JJg5q91NTUYQ443kzq1MAz7ZthUiJrIJORlJlmCA6B35hC\n1ah9lRtTpUGT" +
       "kUmupEK+Tn4fxCtSgDEjJsnURslZqSSijEwLYjgyNlwKAICaH6egb+eonIQE" +
       "N8h4\noXlVSgy29jFDSQwCaK6WhFMYmTImUQAq0CV5pTRII4xUBeF6xCOAKk" +
       "RFcBRGJgbBkBJYaUrASh77\nLMor+XJTz6d1IeQ5SmWV858PSLUBpF4aowZN" +
       "yFQgHk+2bOm6MlkdIgSAJwaABUx74x+Xht/6yzQB\nMzUDzKKBFVRmEfmLc6" +
       "prDrW/UZjN2SjQNVPhxvdJjs7bYz1pS+kQDZMcivxhi/1wX+/jV67ZRd8J\n" +
       "kYIukidrajKe6CKFNBHtsPb5sA8rCSruLorFTMq6SI6Kt/I0vAZ1xBSVcnXk" +
       "wV6X2BDuUzoRf5MI\nyWoUW/HLSCkQXQmuCCF2RguEKiN1qjIwxzTkVriy48" +
       "8HkuJES0eyskCe6mA0qeCICzQ1So2IfO/r\nT187/9KNG0KOd1nsMDKZZwVU" +
       "gUt8foIZq84gWVlIudKvKa56hHr3wbaym+aYD0HG6CeFSjyeZNKA\nSiGWJF" +
       "XVRmg0wtC1yj1ubKeCkgHwQnDoiAqERELQybBBZgS9zY3KLsw5Mj20+qvn34" +
       "+M7OGOwQ1Z\nwakHJShp7rtq4dUbZmRzoJEcrmYAneHLgBloR+RV+yeev3ff" +
       "Zw+HSG4/5DnzYhqTkirr6bhISyYg\neVQ4t3op5JVEWBqgapgUi/QhQQqwgz" +
       "hflxGHkcowN6AIK5XDtyIWqKHYcIlwtGng6g1fr4KI/P6m\n7j2Hnzna5IYe" +
       "Iw1pGSEdk0d0UMc9hibTKORIl/ytny/4cHPueX8IkRxIEyAbA8l41qkNnuGL" +
       "7DY7\nS3JZALM4phlxSeWPbK0UsSFDG3HvoAuPw30ZWCnHio2ZVmzgL384ni" +
       "8ThMNzowdkwBx8fG3e3Bf/\nXPxYyJuuSz3lq48yEfzlrs8sMSiF+0d/0bP5" +
       "5++t/x46jPAYkkK2KrPALydkyD8tVRVbtjb/8kXb\nESe4RNsNQ1rF/TB1w6" +
       "Ga256Q7oDcBDnCVEapSAH+A/g6B/ctnof8ugEi0GXCdd920wRzQL66oHLD\n" +
       "sb/V/HWJYCJIAria6iKh70GZVQx0uIj84rHrnnqw+9GdIRICy4CZY9APKDIU" +
       "/eo0l+1wnnK/5aVu\n0AauSQPuch9zj6sM8mCdf/HaxpUFn8fvRTcrjlJTNh" +
       "SdS2UlziJTieuqAmU4itEBJZlpC0HLvKbi\nmYaUMFXoQkRELcGH81O6wavb" +
       "sAS9ACQk1Mos4Wh8aUzp/KcNlFOPjNlEXNW4hCLy2Wve+u+efzw0\nSxSiaX" +
       "6MNOjpv635sOH+5Y1oD+4VtUHZe6kEOVkoJyLffIVSv7hp8iVoglxtBKNsmk" +
       "ehOtR9WdEl\nqF/2jrdSBlLhcswDrqrSjGyRbwrn/ek3X334XQwJjzp5dQwa" +
       "zbaXR1F87fAnToefliWa7rAUkRe8\n9ugrP7616hmvmgIIHui347ff/tORqj" +
       "tRbMeo9QGjOggna1hgdabfQF4mvXY6csOUl2effvOTgt2g\nH2TC2LH7052j" +
       "s+4ZtCzLD7zYOpX/LMho7Muhh3aNrd3ywZlb1nZu9xgbLQgqGEFAYU++trsG" +
       "uAwI\nN2bS50UaY1rco9Uznpxb2X5f9+9DVvaY72il2S9gANMr5ndK7nrk37" +
       "t+/SubRpcQdZFH1MXi1jm6\nCKSleHWBuHmhjliXCyTdhxC47Bag3xeq1B01" +
       "+i+tHMmbg2CL08nbc7toxQd+8MmBbUV1biKsxiSY\nzXsjX933oUXkG08b+v" +
       "KyysNxMEo/OW1IMrsS0AnyIYIaYCXVW5uDfW2A1OgjS7cdf469jNHmlk2O\n" +
       "XZ9K53+Z5Kno5x4eLs97YDuwkQ+NB7YTMGEtk9QkL0/9MF2YHdbNMBnne+6f" +
       "FERb3Oa0BdXBku05\nNliw3dYQ9hya7wsz1OgZUJtnWTV6VqBGZxF0ixV8aW" +
       "JAE6Y101cEMGvSqGj0Xyg+c0Pd2bEKDIpC\nVDdMgsxK+AUcw74WnJT4OKk+" +
       "ASd+09vlD2ZQq/7sWHP8s7vWy8fQXuNwOrU1A42xJ0H2eB+JDHme\nw8UU+J" +
       "96Ai4YOQuPrsMDKIR5XV+dFquTeS9cN2b7zZENM63iICvegL3h7sFPv9y/6x" +
       "On4kx2Rfbx\nHZEfP/JKWfztbbcJVXvaOm8x4J2xZ5S0ZtjasbQhRlhUyaCj" +
       "kkr4rw2OOB6VEOEio4gwE9dm0XRl\nM/BIJSGB4+bpyQHIm7AxcfAHRWb1me" +
       "lBCGksDhE7bA2Xt9TufHPP670VIc8EXp82BHtxPCKU6Nxp\npp/oBIQ+OHv6" +
       "/at7Xx4Q5WO8f0Kan0jGz95+hDbPK5EzTFxuSin1O2i6Xm+cfPfbat7uYhyx" +
       "yngG\nwNoHKYCTwFtdCf+tYsV08jqKtI4vG0gWSXsF1JccMJlnnq+44Jrzli" +
       "qLFguhmh2hIH5b0Hct1CDe\n1uZ3hmfP/eEd6FY5A5KJsuZDbjE5JAyyY78c" +
       "QlpC90V8KcftTU6fn85wRH746Meb3182ei3qthTP\nQOH7xGkz/c5sITX0+e" +
       "HafG+gMooYkRtfLfvgf9cfm42vFmxpvBNFt6SnTRQLJHMI7ufmv7T/wKSr\n" +
       "X8gmoU5SpGpStFPCUYwUwgxEzSGYzVP6hfMwQkpGCmDloRPCaBhxQqkO/md9" +
       "fShtzRBKfL+aL9fz\nZQ2Pnw6++xFqly+bEF73xW3VqaWyjpNIZeKApGDUDX" +
       "z33InW2Pctp1DvuaMpHtkNmfwp6BqdhV+1\n/b34aDf6Vx4bUsyGufy9Xya3" +
       "ahM90GZUKRE5m680rVw2WbI1ZS6X99jlUjfoMCLH0+rcWCQC2rQL\n0ljg36" +
       "Ag7fZqFPc/caP2dyJq+XozrlvSvdv11XSvOwV+v1Wv+5b1FPQ6/ruDLw+4Tr" +
       "I7g5NMBhaa\nLVaaMzvJw7aTRCUmZXCSCScgERC+HP7HnwD8GzjJvnQncY7N" +
       "t/yzSBwrfhkZBxElGlfx6rPW++oT\n21ofALrbQSRaAd0v54YDtThAJ3TCrE" +
       "CKhVghpwd54g8f58sTdop99uRSbNhJsU8i6EaoGLJdt+tQ\np1mEBKxxGvyX" +
       "npo1TjkEvK74tOuK+1CZTdaYxdc5nvEJ3yHVjPUNAJuU9Vd8VLJOOniVPTGu" +
       "Y1Dh\nNH2OSoep6k5vQSLd+MnDbndKL5/2Wuc5914XHN9Iin+BShPLIFVpX4" +
       "/EFw95xqGrmw7o5U/hSyXn\nq0QBjBKxpKp6BxzPPg+ybkxB9gvEuCOG09cZ" +
       "KbC1C2HHf5C5Y+Lxm4xkw2O+/Y9uu2MZtgLoj8IZ\nPSOspwHL8F5k48HtHy" +
       "1//mflY77Mq/SVr+6k+LQWkd/Vl1/yr95XdllvM8Zsa1yMvQcaN7700j/r\n" +
       "xasIcKPRUX4eNG354qWt85lu+pjUbFrKq4djm9a+UWo7wDi3JJS6oteOTYfv" +
       "l41rO3Lp3r33pTuA\nS6JyjF75rKZP8o8/9/E8v95CiI8VZ1QEwP8BUUqQZQ" +
       "kdAAA=");
    
    public LinkedListEntry2(final jif.lang.Label jif$S,
                            final jif.lang.Label jif$C) {
        super();
        this.jif$jif_util_LinkedListEntry2_S = jif$S;
        this.jif$jif_util_LinkedListEntry2_C = jif$C;
    }
    
    public void jif$invokeDefConstructor() {
        this.jif$util$LinkedListEntry2$();
    }
    
    private void jif$init() {  }
    
    public static boolean jif$Instanceof(final jif.lang.Label jif$S,
                                         final jif.lang.Label jif$C,
                                         final Object o) {
        if (o instanceof LinkedListEntry2) {
            LinkedListEntry2 c = (LinkedListEntry2) o;
            boolean ok = true;
            ok =
              ok &&
                jif.lang.LabelUtil.singleton().equivalentTo(
                  c.jif$jif_util_LinkedListEntry2_S, jif$S);
            ok =
              ok &&
                jif.lang.LabelUtil.singleton().equivalentTo(
                  c.jif$jif_util_LinkedListEntry2_C, jif$C);
            return ok;
        }
        return false;
    }
    
    public static LinkedListEntry2 jif$cast$jif_util_LinkedListEntry2(
      final jif.lang.Label jif$S, final jif.lang.Label jif$C, final Object o) {
        if (o == null) return null;
        if (LinkedListEntry2.jif$Instanceof(jif$S, jif$C, o))
            return (LinkedListEntry2) o;
        throw new ClassCastException();
    }
    
    final private jif.lang.Label jif$jif_util_LinkedListEntry2_S;
    final private jif.lang.Label jif$jif_util_LinkedListEntry2_C;
    final public static String jlc$CompilerVersion$jl = "2.4.0";
    final public static long jlc$SourceLastModified$jl = 1147893510000L;
    final public static String jlc$ClassType$jl =
      ("H4sIAAAAAAAAALVae8wj11X37iabxEmbbPpK0zy+JmnY1bQ7Hnte7rYq9njs" +
       "efkxHs/YnhJt5z3j\neXoenrFLKh6iKa1EQX0AErT/IBVQkBAV8A8CpBYoUC" +
       "SUP1qE1AJqhZCgBf5AVKhQZuzv2/32+zbJ\nHwVLvr6ee+4595zzO+den+uX" +
       "v1O7N4lrR1HobS0vTK+n28hIrk+UODF0wlOSZFY+uKm999nv5199\niXnHpd" +
       "rDcu1hJxBSJXU0IgxSo0jl2kO+4atGnHR03dDl2pXAMHTBiB3Fc3YlYRjItU" +
       "cTxwqUNIuN\nZGokobepCB9NssiI9zJPHnK1h7QwSNI409IwTtLaI9xK2Shg" +
       "ljoeyDlJeoOrXTYdw9OTde0jtQtc\n7V7TU6yS8K3ciRbgniPYr56X5HWnXG" +
       "ZsKppxMuUe1wn0tPb02Rm3NH6OLQnKqff5RmqHt0TdEyjl\ng9qjhyV5SmCB" +
       "Qho7gVWS3htmpZS09virMi2J7o8UzVUs42Zae+ws3eQwVFI9sDdLNSWtveUs" +
       "2Z5T\nEdceP+OzU94aX37ovz8++c+ji/s164bmVeu/t5z01JlJU8M0YiPQjM" +
       "PE72XXP00vsycu1mol8VvO\nEB9oOu/6fZH7pz96+kDzjrvQjNWVoaU3te+j" +
       "Tzz5SufbD1yqlnF/FCZOBYU7NN97dXI8cqOISiy+\n9RbHavD6yeAfT/90+R" +
       "O/afzzxdr9dO2yFnqZH9C1B4xAJ47795V9zgmMw9OxaSZGStfu8faPLof7\n" +
       "76U5TMczKnPcU/YjJbX3/SKqHV5vrdUuvOvQPXymtYdLpm4JzBJ7zesrx0xr" +
       "R56jvieJNbD8dgLM\nO0iKiukb8gsXSn2eOBtbXglEKvR0I76pfeFbf/HjJP" +
       "uzH7t4C13Hy0lrby/5HExwmzkZpPG2Wbtw\nYc/5bXdaqjL9nupffufGIz/3" +
       "nuT3LtYuybUHHN/PUkX1jDKyFM8Lc0O/me6hdeUUjPfoKaH3kFqi\nsAT0Ta" +
       "9ktEd9aZpNXHvmLNpuxyhd9pQSQq985Ad//d2b+RcrYFSOfHPF/awGD10TXm" +
       "A+9LFnLlVE\n+T2VmUvS516f+03tux8ffvFrf/mNq7dRndaeOxds52dWwXJ2" +
       "+ZM41Ay9TEa32f/if1H/9ql72797\nsULGA2UOSpUSOWVAP3VWxh1Bc+MkAV" +
       "XGusjVHjTD2Fe8augka9RTOw7z20/26Hhw33/jDw6v/6ne\nFdyqLwfYPUqE" +
       "flRiNT4aGOU6lNTQowOuKtue0Wef6r7305cbX/+DB//k4ums+PCp9CkY6SHG" +
       "rtx2\nzSw2jPL5N35p8qnPfOelD+79cuyYtHY5ylTP0Yr9Wt9yocTBm+4S79" +
       "cfe/OnP3vtV75+4vg33ebe\niWNlW/m9+MlXnvzlP1N+tcwFZUwmzs7Yh9zF" +
       "vaSLe/6PprU3Vpiv8HidU1Rjn7WunwivWmDff3dl\noP3E2t4gR8ckFU7PRl" +
       "u/2ilOnOyrH/6PL32ufnRYaDXn8T2b+5PzmfGOiTe13R+Kn/veX6Xf3Nv2\n" +
       "NjoqHk8X58VKying4l/bXLn825/3L9buk2uP7Hc3JUglxcsqy8vl/pQQxw+5" +
       "2hvuGL9zrzkk1hu3\n0P/EWWSeEnsWl7eTS9mvqKv+faehWBqiMsYzped/5D" +
       "gD7j+rwUeq5kpxoRZVnffuJzy7b5+Pjj2R\nliLKw8AeoQeYVi16jvfVY95X" +
       "7877A1XzvpJZFBub12T29pLJtWNm1+7OrHvCTFdS5QRkj94CGeOY\nB5OeEl" +
       "E17ywulOC/t3W9cb1RfR+c1/dSOW46gbLH6NUyUpL9iai0wttWnvbcSexK5a" +
       "Go3LyeK0We\niH9kHx17+Yezw12El3h8420yLiwPGJ/49s9/9ZPP/l2JP6Z2" +
       "76bCRgm7U7xGWXUC++jLn3nywU//\n/Sf2CC/t8iDxlX/dW2JSNXR5OqlWJ4" +
       "RZrBmckqTDUHfKw5S+X+D5IJjEjl/uvpvj48EvPPVr//jF\nb03ffPHUGerZ" +
       "c8eY03MO56g9yupRUUp452tJ2FN/GXjnyx+ZflM9nC8evXOPI4PMRz7/N8a1" +
       "H31I\nu8ueeY8X3tWe6cMvUXBCd05ebEMmWh0JMhc+YoJdptulLYInXbezFU" +
       "iuvZquA9IZT2E6I7v93mwb\njHcYhrhLHVR10wDqCEOul36ApPNQZ0dKwdsL" +
       "vD8oYnkeYk2OtICRPkenQkSZWyudxUAgxdOGSgVB\nvAHbMJ37UaDpLbMVUJ" +
       "NJHcRGGNhKXGg3pXd86EEJM0f1aTJXVqThzHrRiDRmUhPqDpA+Qk7iNG0h\n" +
       "Tc7bTKak05z3BZZYyO5gGapdcVWXDVJqxD3R9wW2aUfz2Wg5Z3yJzf2pYDmu" +
       "ELb7Yx5OdsNVM+mg\nXleaj9PRUFJ0zefhNQTPB+nE3q5lZt3z6rDU2g1iVp" +
       "FZcSj6+mpO5szK7i4TagqAU221QxFz3Jur\n3kSZic5iWmwFf9uFyqRDTkGF" +
       "d2fZsAf1emoIkUodE0yPENcrU5/yTF+Uu2InbYjgwMcji/cZxkLW\nbWg0E5" +
       "c8DLfc3RoadnaYnNqiw8Q0M556jOcTHbTbQmyiDil225ums0gczFzRzyKSBW" +
       "YBbBZEKlg9\ncsUkgThNPHktCM6KzLnlytqOvJzt0IRCoYalAkYY0Dw5wm24" +
       "Hi48SbC2zfaq3xP4nFBYdG73h0t/\nRvsi31k3CAmJZlOahguxa/TRghh3WH" +
       "fa17rTAWOpXbfLLBUx7gg2htW5YRgDC2a2Q3WINnhE8OcS\njuATgRO7UR9W" +
       "wlwebfu8RblAUx376NBzddoSOkyudLpigcEFsLBTEN3u+G59uBN7O5bt9qWp" +
       "T5o+\np6FR3IvnoCivRk1hxY+kiV1sdGaVYOpyB0UC4PI9eag5m8J2QChfAO" +
       "BKQjF5quNM3V3SmevosbJi\nDZRg+6MulSYTFUk6eEwIccaFcX82XKMCjbIp" +
       "SDc2HRkquoKkBQs3l9BFs9vLxF04NZEhXd/OQ3EO\nUpxAuPyC9zOC6DenVk" +
       "ayzghar+i82M1cKXa2MI5TbsaQQsPYJi5hoH6nsTYImtjxkBA2aXMMxvUZ\n" +
       "hGNgmx0NGuxYh4Jk2GNlOZdES0xxM6TlNQ5bc8mjM53dsAqC2lTcylVl6wPK" +
       "stegBihh9IXV1pBH\nbKcuOIM501+UFrMaeUpA2xWUqaxBuBaV80EvdDprck" +
       "py/FbtdmVLaO+WLZZLcqSMiAaw3gQtGBhi\n48E45yG5nisuxQh2hMXpGtZF" +
       "Vfanu5AhtdhfdgKD4qyuF06BqQRsDWPTMk05ByhhAINIL9gt7fXM\ndeIYVW" +
       "1a2C6tuiHxcNoKI4SRyHl3bSmRJTogb/P8Ord2tukVA8rVwnyEdmgWWfTSLT" +
       "1fs9RSo708\nHQQWakFmDLM0OEH9OrZqUsEuUBB6adA5FA0EUncbekMcam3b" +
       "UWfseEp74DYNtiCsUZPMWOC0Oy1o\ncttRO7gHQ2t3FGQDDustsbrQYuQON4" +
       "Qj2ysEYz5R2YaYCP3eoEVtwk42yVsNeU4ElBM2ZcnfWVwL\nhwMHn9nD0S7M" +
       "dTfvFrg5aBmtrgnWF5NiuWWyTNi1vDWMb0lz58UJngwFpw80dLChThAEAFKw" +
       "gNHV\npLN0XbbJxpMOt9XdbQ9PpamkpisVxN2FWicFA56OkhEPxX1w1oVydK" +
       "A0EZTHwp7W7QWERCqR0KGA\nDmihXVBLg9DEM4t0GoMFoevtZiOf7ngORUOK" +
       "69UTFZRAas4sCYbuxI6COqyNNQayxBeNjF7hcEzF\nQbDOgfZAp6c0sYUJed" +
       "nuTNgeLYJG2PAAKA8CFkQUKas3Okom8JNMs9u7FZoMcZ/QTZBSikjsB7i5\n" +
       "mc60eOUxs5Et6EJT9HYOM3OMbN3xRdhJyS4jexHRoLgNqzp1v0wgw/4i5N0S" +
       "mtqAwqExmisbNekI\n7Q7Bu9AwTOC5jSviLgJZbeT1x5PVyCMXozlsE9y2Od" +
       "8YQAYY5i5v1IVCcJQFOhyNV9EGbSHJmAKQ\nJRT2AFhKRUo2UJccS27IbDnT" +
       "pCVhg9kR7kih5RVplx0lvmvY43TanuukV1/3weYq1oWux9lakvfi\ndSysBt" +
       "upmscBaLitRasFL/hyX9hFiM7nyk5VFlOoj2NmJ5iFhuk5cwWLO6I7NfB6O7" +
       "PiCYZCqO1v\nfIumqcxpwZhpgul4ul6lU3VohG1+sBpbVqBAtqUrqsn3YX+z" +
       "WKJaMha9pmGam/HMSptWnWrOiCZH\nYQ2kuUoAWE6JHdfDdstxtAC5oR1iw8" +
       "y2W8oo1lvbXPZUKJCzdmGpHG+tB2S/sxRLEMbJIOvkdH3U\nVAWkISpLKNbC" +
       "trgLokJtLhCzDbR70kZZYk3HawptqzMaxkigs1gQuy0sBUAhU6eRxutyn4KG" +
       "Cwda\n+WidYAXPoObdjPLtlecsiO1MtwsCxrqK1SqMNdRtQIADpNTQV60mwT" +
       "XwQNWwNCx4HcCHflcVJUh1\n2KRwhGV9t0hWi3arFYoLd9DAVWDDbrfJqBiS" +
       "ITieQ/QwToRGJ9jSS1pZEgtpjmQ9c97sQGNrJWCa\nbsJoezWifM9tjusLuc" +
       "0iLUBG2CBECtjgkja27GW5ywOjLracDQdk6rZ5l2uA7WG/uaR0dTTsBoEB\n" +
       "oGafnKqtsdLo6ouumzWQ+shz8pa+5Nv2VsHyZFdKlEUmDeYzCZXW3YFc9BtO" +
       "IeHKnOmQ6BJqQBo5\nHGyE9WDVWGwtQGtM9KZKltEVEXWppw+tpGCBjqjlGD" +
       "wPmBk8Zl2gI+hAo73xek2ZX4NYMqcmeIJt\n5lvc5BfZKB/HItSBmwXToJpG" +
       "F2B6lG/Uc1wUAaaNdhx4OeazSVxtKfQUWUiA3l9nM0Noa6XHsZ1M\njoZoy6" +
       "GJjVEmNRtL+pNNewuixTiA3aI5NdWiTsmkOQEZdm7uUlXVGGmxUcY+XsBMs5" +
       "ARoSGnKyVR\neXvq2eJWIVauG8Nx3hyPu6hEjkknhK2cbOt+YzH16kOwSzPC" +
       "oAsDarTlKdrHOoVmdqjpXIV8w+sS\nAzfp2SSmdpqLtD3LzPKEiGINidZwch" +
       "HhzXLPLiYEK6KjIqpHERh2aR4YUxsUVFJsUcA8Mh/jZoNV\ngsZqsGsjgN1T" +
       "JyxC7mb9IhOcABo3HXThA5o5MdVySra0t8U2sAb1fBRS7JKY5f1UJ0wgXSZS" +
       "A1+t\n2ZSGN4OGNRcWSR9iNG3IeGWOBGCYiXees+b6Vmb7dtOmKURtUFoKET" +
       "2jDmVyy/ZLsxmkjvaXSAdh\nmSSTe+qKRJjOdrvEcI0v81+7IeGsZqYzETUD" +
       "HMmnFAajQ0NtQXjTcFrr1J5N6vyYwoqBuwM1JKFn\niwZgUIo5AKxhGC7daW" +
       "py5sYy25rpw81N3y+iTXfUT1EhmE15jqGGNJaZ/gabgTkrxPUFbvmhiAjR\n" +
       "IBLS/oQQl7mYWwW5EwbLnTRBbXOY8240IPxeubVPCKVrF/zaHYO+3jYFO91N" +
       "u6zJAQrXNnd1mW9O\nghwFgKK/9raASvaxVjFvSWtlvl1FI1o22E406Im9xa" +
       "7VooN5c6KlEdTbZMowolJ35Jt5hHbXui0B\nUB1UW7DSM1GpgFUx2Q4yc9te" +
       "bJWWYg/b5SYlslMS8VG8EUt5c67SkCygi3Z75YkrMxwSHNUAYm1O\n8EQz5r" +
       "l6w1tZLbRjYaa87k80UFMmTX3LrIFFuIu9jbDRNxC0EDbjXAI20HwDICrUn/" +
       "AoGGc9Lgfg\nWUxjFlLGvq0odU5SlOFuw+SYMpsSoi8vCIEQNIucEgA1wagg" +
       "7+GD3YrZBHygLbFRCm53QjePTduV\nuwXpDTyzQOPJHADCWb0JhWaHi1VemC" +
       "odvbFB4GUvndkdpjUjYpJgbcmyo1xHYAs3ETyZ6WHUbmdT\nQR3ZTCLiDkoq" +
       "4YBj9BRI+XoE+WSXLYrBZrsIohCarVxyw2JwOs5YACLkma4sC11Dgg3JtLaU" +
       "tJqI\now6TiW1JxyWOGY8DR5rMBtkS6tn1EdUcC6ERoS6y4QVOB4ZBTy1zPY" +
       "eAzXmmIW0IXlCjNu0EQFew\nJxzdl6IFDJL9vI0U60Hs51iIiKAtlGuprxt8" +
       "d1UuLWJLDxe7ycQCtqpbdNvWhsyI8aDR1mRWJSCi\nSVEmQiBLgCt8uHDLxA" +
       "GAy3aWNYdyanHhCqfl+kQYJ1FOcXgfcWGcSqktBIK+6S0xbLgGBSkGUBfg\n" +
       "+Lmrg5IHgdu4jSx0z9sMcTlRoO1ww2vKCMMajVV52i6UhNbYyVRcwMZo0ELg" +
       "9TzFES8DopWo9mO2\nPOiu/LYCiOWP2bzntBhGQMPUGM+W5qY8N8bjFhe14l" +
       "YrmmXlaRtltqs+hsSsPMFDHGyDJL5pI4RD\n45IM8WQ+wbuiuOZl3tXLH97v" +
       "r36R/9hxLeLKvlJy68pl5ZjVwOj87/dDMefm+SrMxarPprX7otjZ\nKNVdVO" +
       "3pkk3F6mZVL7h5tnR+U9jXFF9NhP5qIqpGfX3uxG3u+5rH+44Lk7drl48fV8" +
       "uSuPbkq13g\n7MsgLy3+/aGPKl9+4eJxkXOZ1h5Iw+g9nrExvNv1zrNMhvv7" +
       "qpMi4MPzp/+hj37hxbMFz+rO7+nX\nnHlTu7J5B3/Jdr5ysXbpVsHx3IXZnZ" +
       "Nu3FlmrMdGmsXB7I5i41N31PCq65bnj2t4z5+p4d0q/r3v\nNSvAr1seTqqq" +
       "V+m2ymXPnXXZc7ehsL61svvKd7WaC8eXQhcOFXn3fEX+vUfrTEmcdVYGyNVD" +
       "sfxo\nEzr6USXQCTaha/QM89SlxNVrRx9ObSe5/uorunrtxovXotvqv+uHU3" +
       "+X1h57tdXsJ4jRgckird1T\nrf2MMe4v31fOG+MDr2eMQ0SetoaTVtofffAF" +
       "4eiWgucD7sIh1n44pX8mrd1/IrT6/lNnlKreT55T\n6sLfvo5ShyLv0bGj1T" +
       "D0DCXYa3cSAqF59YP7uvDRnVcZH1Z89cU9pfDuo9cmIE4IDrXpw0D4Qr+0\n" +
       "nWMeXQ2PnFuyjs6Cp7Lv2WdH2tH7j66eowxv3FIgdEuKEhLGjX2vbJ5//szy" +
       "xKr6mjiB5RlpGFy9\ndt1YZ6WDPSNIZ+FV7frrZN137zW/9v/Fn9jzJ67dOG" +
       "ScUsKNF4+7puIlxo3XwNs+wV+tGu7uuLp0\nKPjfSu3X71LJP7jq9XH5ycMd" +
       "1ym4nA3B+46dchqwx5eCj50A9eSSsBp85v9Qsar57Osr8bm09kyl\nhKYk6a" +
       "s75bALVv/fODNQXRE+du4PJ4e/RWjPvPKhq1+Krvz5/hb21l8XLnO1+83M80" +
       "7fYZ3qX45i\nw3T2a7t8uNE6GOU3Dllgf3VQJrfqY6/Qrx+GX05rl44PHb8V" +
       "HXT/X8TxOKEQIwAA");
}
