package jif.lang;

final public class JifInteger implements JifObject {
    public Integer s;
    
    public JifInteger jif$lang$JifInteger$(final Integer s) {
        this.jif$init();
        { this.s = s; }
        return this;
    }
    
    public JifInteger jif$lang$JifInteger$(final int value) {
        this.jif$init();
        { this.s = new Integer(value); }
        return this;
    }
    
    public JifInteger jif$lang$JifInteger$(final String s)
          throws NumberFormatException {
        this.jif$init();
        {
            int i = JifInteger.parseInt(this.jif$jif_lang_JifInteger_L, s);
            this.s = new Integer(i);
        }
        return this;
    }
    
    final public static int MIN_VALUE = -2147483648;
    final public static int MAX_VALUE = 2147483647;
    
    public static String toString(final Label jif$L, final int i) {
        return Integer.toString(i);
    }
    
    public static int parseInt(final Label jif$L, final String s,
                               final int radix)
          throws NumberFormatException {
        return Integer.parseInt(s, radix);
    }
    
    public static int parseInt(final Label jif$L, final String s)
          throws NumberFormatException {
        return Integer.parseInt(s);
    }
    
    public static Integer valueOf(final Label jif$L, final String s,
                                  final int radix)
          throws NumberFormatException {
        return Integer.valueOf(s, radix);
    }
    
    public static Integer valueOf(final Label jif$L, final String s)
          throws NumberFormatException {
        return Integer.valueOf(s);
    }
    
    public int intValue() {
        if (this.s != null) { return this.s.intValue(); } else { return 0; }
    }
    
    public boolean equals(final Object anObject) {
        if (anObject == null) return this.s == null;
        if (IDComparable_JIF_IMPL.jif$Instanceof(
              this.jif$jif_lang_JifInteger_L, anObject)) {
            return this.equals(
                     IDComparable_JIF_IMPL.jif$cast$jif_lang_IDComparable(
                       this.jif$jif_lang_JifInteger_L, anObject));
        }
        return false;
    }
    
    public boolean equals(final IDComparable other) {
        return this.equals(this.jif$jif_lang_JifInteger_L, other);
    }
    
    public boolean equals(final Label lbl, final IDComparable obj) {
        if (JifInteger.jif$Instanceof(lbl, obj)) {
            JifInteger that = JifInteger.jif$cast$jif_lang_JifInteger(lbl, obj);
            if (this.s == null) return that.s == null;
            return this.s.equals(that.s);
        }
        return false;
    }
    
    public int hashCode() {
        if (this.s == null) return 9473621;
        return this.s.hashCode();
    }
    
    public String toString() {
        if (this.s != null) { return this.s.toString(); } else { return ""; }
    }
    
    final public static String jlc$CompilerVersion$jif = "3.0.0";
    final public static long jlc$SourceLastModified$jif = 1186254440000L;
    final public static String jlc$ClassType$jif =
      ("H4sIAAAAAAAAAM1dCZgU1bWuXodlkF3WWVgHJMy4IKLjM8DAyDLIyCYSZaam" +
       "p2ampae7p7tmpsGo\n+Ca4YNQYxeUZxQR9JoREIl+MHzEEFYwJiksUET5Fjc" +
       "nTJCCYZ8QkxnfPubXcure6uqoZHsz39e3q\nW3c55/xnu7dqqrYclkLplFR0" +
       "TbSpXF2dVNLl86JNtXIqrTTWJmKrl5CqusjrNz38/d3TPvqNXwrU\nSD3ldr" +
       "UlkYqqq1WpX801codc0a5GYxU10bRaWSP1i8bTqhxXo7KqNFanEq2qNKomSY" +
       "ZqjiXUCiWj\nViTllNxagZNV1FbF5HSadAtjbbpNul7yZVJSqd5DI4pShI0p" +
       "SReN+VfnSzfPGxGQ+q6Q+kbji1VZ\njUaqEnGVTLFCKmxVWhuUVHpGY6PSuE" +
       "LqH1eUxsVKKirHomtIw0R8hTQgHW2Oy2p7SkkvUtKJWAc0\nHJBuTyopnFOv" +
       "rJEKIwnCU6o9oiZSlEJCb1NUiTXqv0JNMbk5rUpnmpxS/qqhnrDXK0oISzXJ" +
       "EUXv\nElwVjTeqUgnfw+Bx7HzSgHQtaFWIvI2pgnGZVEgDqORjcry5YrGais" +
       "abSdNQop3MokrDsw5KGvVI\nypFVcrNSp0pD+Xa19BRp1RMFAV1UaTDfDEci" +
       "KA3nUGLwWRgu/HJ97eelfqS5UYnEgP4C0qmY67RI\naVJSSjyi0I7H28vvmX" +
       "tl+0i/JJHGg7nGtM2Mcb9YWvPRr0tomxE2bRY2XKNE1LrIv6aOLHp9xoc9\n" +
       "A0BGj2QiHQXwLZyj8tZqZyozSWINZxojwsly/eTORS9cuXaz8he/1GOuFI4k" +
       "Yu2t8blSTyXeWKUd\nF5DjmmhcobULm5rSijpXCsawKpzA30QcTdGYAuIIk+" +
       "OkrLbgcSYpSVIf8ikinwKJ/uG3Kp1BjHIu\n0aBmJVVOLJWoTSzaMDmdilSQ" +
       "X1QJrC0yMGTfTp+PcDOSt6UYUcM5iVijkqqLPP6H331z9vxbb/Eb\nuqURo0" +
       "oDwSfA2OXm2JLPh2MOsUoIRN4IDuCvT1b2u2Ny+iniKVZIPaOtre2q3BBTiA" +
       "3JsViiU2ms\nU1Gl+jPqq7uAwgaifUSR62JkIOoIklJHShrNa5lpjXPR10SU" +
       "16//6tUjdZ3bQCEAwEEwOiWNwLGK\n0lY4cfHV8+pvGR2ARp1BItgAaTra4v" +
       "lsxq6LrH528EXbd37xS78UWkH8W3qW0iS3x9TaqpmJ9jhx\nGoOMqkUK8Sfx" +
       "GrlBidVIvanbkInp68ZbkIxgH1UaUgPIUXOKQfsK7EXE0DtlDgLdSoiKj80t" +
       "grrI\nkfULtu3b884E0+RUaazgCcSeYMm8jGtTiYjSSHyjOfx9/5hz9O7QhT" +
       "/3S0HiHghvKuEMvE0xP4fF\noit17wi8kJ69mxKpVjkGp3Sp9FJbUolOswaV" +
       "tw8e9yMo9SafMdq3pH/DyQFQDKSqDqBzPKDvPd4V\nPvutZ3rv9rNuui8Tth" +
       "YrKjX6/qbOLEkpCql/5/7auzccvvkbqDBUY3wqiVTtDbFoJIP0DfERBR1o\n" +
       "44DKhw66596J33tL18iB5ugzUil5NShk5sbXix74jfwQcU7ESaSjaxT0AT46" +
       "E1iZqZuoDkoj9X+v\n9T7vltLzmwb5JT+BAtWHBEi0mRLi5qCH/rsniqfQEO" +
       "aZ5FPqIEwy63BzVhyaENyM09dFbr1y+JOP\nPDf4MOqAPxJVpSJRwRoNpalk" +
       "XQrBuT1JYgoagEaqv4MMMZIfYpls0c0hPD0aMbO6xq3q8Y/Wx5GY\n3o1KOp" +
       "KKJsFP69Olo63JWJQEan26sJqYR2CAqIvWl5Lj6RjJU6jtLcGTszPJFMS/Dp" +
       "lkC8R1oeTK\nOJUsyiFFVUKeWhOpZEs0UopklyaaSqnul8qp5vZWJa6WpqGS" +
       "yS5KJzSAdJTGUrkh0aGUNqwuvbbm\nuokw6IUEmXEoCZ3q8io5Hk+oHO11kT" +
       "8vPLJzTVJ5kUbHEmsfofWonxYdHbtl5ThdUYfwrnOOnG4h\nxrA/9taKDe+c" +
       "VUxHZYxFO7991roN9z79iynUuxYSefT7+nQqHRTeWJWotMEDg2ZVAkUdV2sh" +
       "A9Sw\nXTb/gWV/+/66l9Bs+2BuqKuEKg1jfGcte6oSZ7rAgKmYfEocYaI0lO" +
       "IECsmdSmsQEYhIpTbhDwTE\nCRQJYAV642PNn3/57ObPUKDQYZjJsYXausgL" +
       "+w/1a/344QeoHTMudSjDIUQlJn3T8sbibDKgaWNG\nDPuMVdVFpu3r6B/eur" +
       "HVLxWQkIYaSBBYJsfawfGtIPlqukqrJPK3nLfmnjTRqmRyvKmcw2c9QBBI\n" +
       "Md1SHwtSFXzewyAlSUk4WIgdxmM5UYvhKpkuGpdx7knEPadxJUCw9dWkxWyz" +
       "NhVtJclch5Zt3lX8\n6J+2/WHRID+Tko8RsmK2jyZf9KpJcJejnGbA1rsmjd" +
       "py/aJ3G6jpDLCmTrPj7a3nb9yvTJxeGLFJ\nwkIxPQ+AEDcyiyrhNLcPe+zj" +
       "WPjHvTH36gcAaoaFNoVVc+PWqt7RNCE3Hokm5RiytIIEx4jej/ot\nnyRZZy" +
       "YKWZOIyDFTmwZdN/OCx99RfkaDbIzNXHj5cz1fuLd5ysYnngj5NS+xwBKoRj" +
       "vYro9qRIOo\nET44XozDzcT6c6A4DytmY8UgVXNgaN6abaOThaJZD+1QluMx" +
       "qKaEg2vOjCTBZvg3RTMjnSbmS0LQ\nxUNu+eCVor1LqFflhyDyHMG7wVo5mt" +
       "Kc31sfXPfbJxc89yi6hV7E+JrIUjwaWQ2hks8aq4yzkDrC\nKrNZb1wkNJ5r" +
       "ntZcJRTjMijJFKFqDO/bNJpY/3b+2o/+d9ubT5XpkP0H+Lhinp1FikzWF3Su" +
       "usid\ny6NjLp8w7FLkKJToRCdXwtCX1LWwwtBH2BRI4SgwSwfRpaGCzLThJ9" +
       "SEn/7JV0cvQf1jwr7VkVIZ\nsOz3oexDudq6FDDoKV+SSBok1UXmvP/coXX3" +
       "Dd3DxlauA9P649YHH/x259DvI9tG8jGGSz6MDrkT\nEEovIXW8FSiWSBar/T" +
       "cOf3fS1+7UUgEeXbsem378+aNryv67WYteMOEabVb4ut4W7CtSUdUEO3HX\n" +
       "J+fd01W9kQEbESQi6MSGFE8oO00AvmXNDUx5zkyoaqKVkeq5L549ZMYPF/xM" +
       "V8BrDalMtDLI9WTZ\nPKfwBzv+uPlHj+hj3EBZXcewejOtSiSpedyGv9K0sj" +
       "2JvW6nnZKWDtzPLtr0u1SUSUOMNj+LhSVP\noeb8Cu2WPFBMsHVV+goCnZ/F" +
       "o450GBQbTjGaD8vRXJVqXeW4HZA0uM9zH0ICLsby6zZ55H0kJuKQ\n2KLKIH" +
       "c4+YxwJNdzrgcd5zB5R70QnLJNpgWnxx2D0w/M4PQ9rNiEFcs0pbhSlQLEn6" +
       "NMoNiSOyzd\nZ4QlKFvFuIMKDcX9VKm3WZSanoDy56bh32/VWLGqy+y23TSi" +
       "+602Yakyzcmq8SDRPppE+3SXxpc4\nDMpp/MgczU/Cqm53Dm3/Na6arJoOi8" +
       "9iRzK7WdNHOUymaforjpr+O1PTd2HFHj0N62emYXQXG4UC\nxRv26m4P9CTy" +
       "qcqhPbv1OUvMOS9rh6sE1YCfOjsTUXD7gAretSntpKb0rmBKO3Gg90y72Sma" +
       "0k7R\nlGi3P5p2s1M0pZ2sKe3WJAV7pfyirxquUujpdmvDtZ89/3CvUjMpHW" +
       "lsg1rze0u3usjtZ7R8edmQ\nfWS16F8hndEik3UEWeHAtRQllSvh54Zas2Pp" +
       "w8dfVt/FVM1c8kLvMdwKoL+m5z01UHvaq95RUfX8\nqHpQTMoYBnSOZeARDg" +
       "Nz9jZMiy7Zmnu2N+j2OWtzUKDm95XMc0cMAoaSTyX5DNAIGMALwmdsX7IL\n" +
       "mgEfPPLo5zfePM0P24s0ZhJ8+vHaf9OWDUW973nvNtSKtdrI/7RZaJtChWIJ" +
       "4bvngrmX1S2bUbN0\nNifhoZrXyEYxtR6j+YgczUFKvhBvYL4wKIyvh2EWpI" +
       "K3FK6qy+LrSx2mhL50e2KNpU9RLq506zZ6\nleSYSesF5RbUAZ/JragDA7VR" +
       "Boo6AAdf3vDVV19B/8EuAZyx3BHAbNNlATBbcwSwSACwGMVcaqJV\nLAJYnA" +
       "PAbFNC33FZAHTkKiuAOXpxABZlnP2S5rOhLGd8sU+4GL+4vSGtMldWB13cdu" +
       "HS6MLL6Zpu\nouFulYxajh5I68r3u3fiXzomnf2fD+GyLNggp3GTqYD47zS0" +
       "VKXS7JfpcSy6Zu5lyAX26MAv9tLk\ngt+q1IfQTHcF6aXKYrtLlWYDBGqKHp" +
       "sHsO6SNsLLeYJA6iK/fOfTu48sW/NNjCR9kQfcq1hMuRlv\n3ULVOo1dbG1X" +
       "abnXwFaEdZFx7/X75O83fDAJLyLr0mKvIS2Qk8I1JNgWJ/WhggPPPn9m/WsB" +
       "yV8t\n9Yol5MZqGS++ST3VlpSSbknEGjNJLecr7OxByn6SnuDMsxjY13hZg+" +
       "SmQnGBtj/qm+HK6n01cLQc\nOkyDo5VcwKsmn0ul7JuxqjSN2yP0Evp81Wzo" +
       "y8C6fawdvjxU1T2/qvx973cWIN5htSWaHns23HFh\nB3Ml9TiXwOBF2W5SwE" +
       "3Tm5cfK7xJ3nW1vhGwgjhFNZGcHFM6lJiZV/GDLMB7MvS0pu8VJe9XT338\n" +
       "Oj6x6i0Ys7VfXWTP232Pzp6y50/dd2kZfpbYX0UucWSiLtK/Y8TlgZboi3ib" +
       "j3YBWbg/xdqJv8JH\nZ11i2eUfbSgWhL6xWnSR9G+rzyaWbO82Ne31sCgYRz" +
       "4THGajqz/Qk5VEpRe5WtpFoZLekFOqJuiS\nxW55d9bkS3CB56tzWOBBpW8J" +
       "FMuN9a3vytwcUpJZ8qGsR5WXk6fNqOJqZGl8VTzRGafx6Nx9L7/0\n+1mZn+" +
       "qWV5jM5Nzh8F2hSj10ucPvNklyXqbZ7FZqVGib7YExn0y/evDt1ToZF1Aetb" +
       "3PiynjnVwl\n8aFRLgUCbTvLQdtQjtcJKdD1yNZaY0VIKvhFIlfVZXZbZ6ZJ" +
       "14uZk7WqnlbRRZNvvWhl2nodWIOj\nLYImQHEHaoOtNsOZCBS3I6c4Cw7kAl" +
       "UoVM58B2hhz435spoKZavGBUPGG24X9CbOLE7LMwwgy0WM\nlosYoaH4NpqA" +
       "LBcxWs4u5G8TqfYoPDi821EyLaePZLZ5kow/WnYyRAPFMzmU2mZyTzKDr2dt" +
       "5Abl\n8/nJ7kUPsqOu22JXZZptSfo3Y1dQ5hOE/bQZZ8UQgMsdZjMBecN1EE" +
       "4zQTgJNwaT5NIxCL/pKgjv\nNQPbK7k5pCSz5EO5D8F+K3m6jAoN2rBwzJxo" +
       "CyhfVuEGYSrTNjcBtk0Pj3vtYuZeS8xMczETlONs\nB+VAto8KlnMMKf2baS" +
       "bHRMs5JloO7XbcNJNjouVYq+pplRYzv3SKmVj7hgAcKfwo3beyupe3oQ2u\n" +
       "5Y7iLOZAphWdSz7nu7Eif5AQs8yVFaXkxmjGiyXpQAKVf1ClEA7AIQqEVuZA" +
       "1N+TR9TfCyThLzTg\nIxU8olxVl9mtvwGf3oZBlKuqp1UUUf+ZDohS9uDXFl" +
       "a6UIahGA5FgTOqw5BbnKkte8SyX73MJp+I\nE+Q295DMS0T1tPaD2x5U/hy6" +
       "6Tz9HpLWZCKuaKvFMlITR22IrtHujeRunFuRY3K8r427ncCYnL3O\nvufNO/" +
       "cePr69y3KzyDhzl6QqEYspEbjqkh67NN6aaIw24U0PixV1bdF3X7vzwbVL6T" +
       "7X13L3MeuH\nzZTW7ln5eTFuFUD8PpPZrDGbVWqZixU/fzbvq+k9AqXZqqAZ" +
       "qFYFVhMxlYBeKTpAHS0UH3GgQ2wu\nzmHn/lKj+eAczanv9Y+hX+NOBbNbXC" +
       "dKe+2Sy71scrlXdPN7RTePodE/0/Tpe0U3b6nyl0Ix+lRL\ny9q9zYwCdAyn" +
       "8d4Vx3Prb6BxSaYbxfCuezHYkJ3NQuBkBUPmOacDmadKt7Mp8snT7ROVFllB" +
       "pcu8\nKDcUN7Q5R1hVCuNEZd2i9fC1jgrJdkoPgoOW69uckz5OIrYCuN27AL" +
       "DzOtc2BF93dR/T93YD0w/k\nyfRdni0Sej1sY5VQ/0h+lvlYHpYJX5u7D4Mn" +
       "ugGDJ/PEANngthrgsnCJlp+UcPkJlN233w+3j01w\nmM1k9ZmTttXg/xXOkm" +
       "Orwf+UsXz3/8Kdt3rGQj6UO1Bzfp08XUZtc7/L4P95vrsMhBpxl4GttNll\n" +
       "AL04y0EvkOP9vCPwv42UHjSsnlTwjoCr6jK7vWdYvd6GXZNaq+pplbYm/aNo" +
       "D1l3GXTMoPgYcctm\ns/5nofgIOcVZcCAv1jWFfGpcWherSFDu0Uhn5j5A9Q" +
       "CKV7mZwGsM7b6ZXMcEU41YNXiKydLID0EF\nnhJVAC3G/28T76dEFbBWueNG" +
       "5M0NgtD4iKPQXnADDxx+6nWYUyT7wJATl/0LvOxp2Owe4QONo9uc\nDdZmRt" +
       "eowPjjvY/vCS6YY5INZFA/OT/Yzs0TNuh7gTd2bTIViBFjNJ8zppsyFfuLIn" +
       "C78jkOsxkM\nBmYQr3+550wF7/Vc2OSUqARmuklUApVG8A9cnJtBSjFLPZRV" +
       "qCqzkqfLqNDByzWRwEWqVKCJtM1L\nskIoEpMVttImWQHVOM9BNZDrq3mzC+" +
       "DVzEC9YWOBlYLZcVVdZjfFsDG9DWN2XFU9raLJSuAaD8mK\njhsUccQum7EG" +
       "qqFoRU5xFnMg04bgcsg0VzbURohZmtclkVx2xFwRCdRmuSICdF6SC9AOAdBO" +
       "FMRq\nE71OEdBOEVDa7XoTvU4R0E4R0E4d0C4HQO2uiASohcDvwM1QqM6g3o" +
       "Tc4kw4kJcMdA75NOVAnNkc\nvzpHcy9bYpzP0fBGAjUVFSSCjVSrapjMM/uc" +
       "gYugWMoxCwFptHtmh+Vofhow2+w2uTA9JGsQlUwu\nSH4IxlApGgMGhMBmU/" +
       "MrRWOwVOGeTOCOUy0ta/c2id0sDbRlnMabL47n1s6g8bcz3SiG+e7FYEN2\n" +
       "NguBw/sYMh84Hcg8Vbq9//9dt09UWnoa7lq5ofifNufIwu5HnrjWw9dhKiTb" +
       "KT0IDopPUXhOxFsk\nYiuAz7wLAE8cdm1D8PVF9zH97xNnOujLk+kvPFskzB" +
       "a2sUqo75GXZQb75GGZ0G9At2EQHNINGAzP\nDwPKBre+hjv/y7T8pIzLT6Ds" +
       "3jv/JznMZrAaHHuy1tdBilOO9XWw2FizBktcOStCMUs9lONRccqS\np8uobe" +
       "6X1sGiPJfWhBhxac1W2iytQSsmO2gFMjyddwNBtKhglWHzwRmCG+Cqusxucw" +
       "yb19swboCr\nqqdVdCUWXCBaQ9altQ4ZFJcjbNksNoi6WYuc4iw4kBfbuoB8" +
       "Frq0LVaPoDxPI52Z+wBVAyimcTOB\nzxjZfTO5jgimGrFqUMzkaMFiUQWKRR" +
       "VAgwk2mXiL/97KVbnjRuTN5VZ0cJmj0MrdwAOHK7wOc6pk\nf8OJy76clz0N" +
       "mt0jfCjWtzkbrM2MrlGB4g7v43uCC77utoEMyg35wfZfecIGxUZv7HJ5CjyG" +
       "Bv6n\neYrmc6bY5SlQ2D+GxiIgh/9MCf5AlXpEtQcqcm4PSOjvQAI2NP9Zt6" +
       "8kGddn7Zrn83SK4I9xeObp\nFK6vDAU3UY34maARm5DxbSb8m0SN2CRqBO32" +
       "tAn/JlEjjCoo+f93AXmOl+j2oaR/u4fUPgqWablE\ntkFN1XyOIHCFqwxTjt" +
       "N/eGcSTaWtXY6lHfNM+g9EufLMHZ7YpHSzPEC5C4HdnTxdRm3LnmeypvYr\n" +
       "skahcmzzlGHusMswd7AZZg8dMar9FuWY6qAcyLHwvKDgIST3fdMaDokGckg0" +
       "ENrtT6Y1HBINxFpV\nT6u0RPMvWGefaFo5tD6viTnBwgnFMYQ0qw/+DRRHUA" +
       "hIABSfuAASin023rIkhyEy++QDcjR3uztm\n+l94GsgghxHz8r//Yv1vNouB" +
       "8jUGI1OgWrrEPEmuoCGRiCly3LUb32GXh+1g87AdonbuELUTjTl0\nhqmKO0" +
       "Tt3GFx37Yc5aEicPh3c5MreNwNuKbwswj8pSwCBy79p0i64z1Jt6dOfll3ix" +
       "doqaAizhqO\nvIgdxsPfDq7Enh8US4VnTKDDhTa4QH1lfthM94CNTeIC1/EW" +
       "ap5lIedZ2jzEXmNQ2IQ722FQA4TQ\nPOK6lrhKXBJqC/FqXrKW0Hw3WUuo2m" +
       "t+QYhmGYCyBlFdkDxdRm1zlbWEZueXtRAyxKyFrVSlEMLF\npSygFhc6qAWy" +
       "28SbRqgZaY0adhBqFk");
    final public static String jlc$ClassType$jif$1 =
      ("yDq+oyu8UNO9DbMKbBVdXTKpqyhNIOKYvJns/UeniCUZHE\nPUycZDNzZ1Ul" +
       "WiEwN8QU+rSqUcLTqvg2SHunnhANNiI42w6nvwjLr+d8tpP+7Hv+Seeh1VCs" +
       "0Z7t\nFLpBZNrx2U4hfC4y/2wnuO3sXAegT+zZTqFvsYkLfZ6Lbx6cuE6wIC" +
       "huRSvK5t1DsPQMdaDqIewo\neRe2A8VKzvGBVEfmcHxcoujUPP9EMbvkvSeK" +
       "oXtYeWdzUlBeqVuGKU2PSYvpRVgPUM0kLeSHYP3V\novWjpwxtMk29WrT+ai" +
       "5p4WnPQxPg8A4zYQl9x2U+qMk4i1yXnG5y/aUnuYaR9rLuFix87aLCzRri\n" +
       "vQgcit+2OfsKG2bwxC7PaMDXXhtEoHw1P1Te9IAKzSksjgse/bdY8xuLOb8B" +
       "pUPaYX8H8mQtDGQb\n1ETgkOv/lYo1xLwlgfSfZHIlgQc9cUhJZsmH8n3E9I" +
       "NkN48KxWEcOatafqhKASIYLt0C8U91ED+S\ne1RQQXyCSch88ElIfPBJSHzw" +
       "idbtuKlv4oNPQuKDT0L6g09C2R98Amc/gcPluiik5ZymwT26s9xo\nWtjnWt" +
       "MSDdd40rSw30HTdJTIoBxKQPqCHCiFC3iUwj1gyHAvAxJSwaPEVXWZ3foakO" +
       "htGJS4qnpa\nRVEKD3JCKYy3t/hQkTNYAXeHhK7F2qyJahumnTaP0Ju1Oi63" +
       "RiPas0a+eL3oJnnDVQ/T1xfBCy3t\n3lQzIxJR0ulacpZ/TRc86mSOg5xVaW" +
       "ojnVBTiZSSTClpogkEbYIz8fql+AqoUhnnKAUSwB0lxTel\nsJSzDyrxDdtw" +
       "0fzpPX5ieVBJCc+3yQO+x+hHS3YO+sbla+vp2y7jSoeSuqw9FquR/LGozXsR" +
       "Le8+\nsjw5M2MjY3OuRYmE2vHhDz/59PfXVNCnoYiv6DMab649q9fIsuBf/Z" +
       "Y3nsIsZ1CFLcK1xZdoukyG\nHh6KhoKqkTv+H8hzeXrQbnl6kF2egrdE76dT" +
       "qXsU6iJYdwFlAHkKop/6mFoxWqVhEazOT2F1Psur\n7hbIySk7L7uqX2znP4" +
       "kIV0i9qU4tTDUqqYyjncAMw1HCJ6KxMEAJ/RrFwEUFk5EYwM53ARO0m8h5\n" +
       "ZEgoxuXwyNxKyKl57iw6iHXiSii7vXtfCYUvxeGZlVB4uDHhEIle1T0JDoaH" +
       "q4aFK1saoiurRdU9\nabbXNcZBuzXGQXaNcVBMJQ6KqQSmTeGVZt5wUEwlDl" +
       "qyWVUKEjbLvJg0FAoy7xSwg0QgZdltvYW1\ndaiYejLtFrqvosqQNZ3l7BnF" +
       "YjHoqDeDhsMZ5rorXEX9ezs1x6xk2JuoYUJUFDUnJoo1rkRRYxGF\nXXYdXt" +
       "uWK7vmtMtWmbq8KhN2bfdsYtDrFhszg/r1+ZnanR5MDTVJvJflKs3rXcV5PS" +
       "i74V6W8D2q\n1KOFRE54869NqOnvQAIXGPR7WbI1zyswPMQGBihc38sS3kAh" +
       "3SSk+BuQ8cfMfH6DmOJvECDVupn/\nkKS3YVP8DbkghX3sek1A9ScJ0ieYx2" +
       "zbQDrIgQQOUsgeBjo0zwvSp3lIXT+ON7yVQrpDgHQrMr7T\nxG+rCOlWEVLa" +
       "bbeJ31YR0q0WSAnLvaxvFB7Kv0FWjqySm5W6yOjX6yc8n+z/W3zDtfGC3R4k" +
       "r28i\nywz2vbrMcZi46Sb6f5q4pJT64BsIw3DlWpcnuE2ZQhveQ0+/QlIMch" +
       "oOX8Ur3fr1YHz9geOLLm/d\ntfHYyle/0z/ry06ZN3jDOxDaa/EdDHWRvyZX" +
       "Xnpw0aHN2usps76Hw+yx/flxtx448PYY+m5JoiRr\n8DVaBTVSAd0kwOl9Gf" +
       "a1vPxo+ljR9/Y1re/6sK++5MO3a/anNmSyXpx9HDhe1qdy//zt23/Iv/pB\n" +
       "YqTHsG95a++UCZ8VHH/50+lWuZnXCaWFmf8DH3iFUZ+FAAA=");
    
    public JifInteger(final Label jif$L) {
        super();
        this.jif$jif_lang_JifInteger_L = jif$L;
    }
    
    private void jif$init() {  }
    
    public static boolean jif$Instanceof(final Label jif$L, final Object o) {
        if (o instanceof JifInteger) {
            JifInteger c = (JifInteger) o;
            return LabelUtil.singleton().relabelsTo(c.jif$jif_lang_JifInteger_L,
                                                    jif$L);
        }
        return false;
    }
    
    public static JifInteger jif$cast$jif_lang_JifInteger(final Label jif$L,
                                                          final Object o) {
        if (o == null) return null;
        if (JifInteger.jif$Instanceof(jif$L, o)) return (JifInteger) o;
        throw new ClassCastException();
    }
    
    final private Label jif$jif_lang_JifInteger_L;
    private Label jif$jif_lang_JifObject_L;
    
    final public Label jif$getjif_lang_JifObject_L() {
        if (this.jif$jif_lang_JifObject_L == null)
            this.jif$jif_lang_JifObject_L = this.jif$jif_lang_JifInteger_L;
        return this.jif$jif_lang_JifObject_L;
    }
    
    private Label jif$jif_lang_IDComparable_L;
    
    final public Label jif$getjif_lang_IDComparable_L() {
        if (this.jif$jif_lang_IDComparable_L == null)
            this.jif$jif_lang_IDComparable_L = this.jif$jif_lang_JifObject_L;
        return this.jif$jif_lang_IDComparable_L;
    }
    
    private Label jif$jif_lang_Hashable_L;
    
    final public Label jif$getjif_lang_Hashable_L() {
        if (this.jif$jif_lang_Hashable_L == null)
            this.jif$jif_lang_Hashable_L = this.jif$jif_lang_JifObject_L;
        return this.jif$jif_lang_Hashable_L;
    }
    
    private Label jif$jif_lang_ToStringable_L;
    
    final public Label jif$getjif_lang_ToStringable_L() {
        if (this.jif$jif_lang_ToStringable_L == null)
            this.jif$jif_lang_ToStringable_L = this.jif$jif_lang_JifObject_L;
        return this.jif$jif_lang_ToStringable_L;
    }
    
    final public static String jlc$CompilerVersion$jl = "2.4.0";
    final public static long jlc$SourceLastModified$jl = 1186254440000L;
    final public static String jlc$ClassType$jl =
      ("H4sIAAAAAAAAAM28eaws2XkfdmeGHJLNkUQOSYvhNk8kLQ3T0nQtXdXVGhhy" +
       "dVdVV9feXXvJxKjW\nrn1fW5Fiw4ClyEASw/IGJHICGDBg6A/Dgp1/jCSA7a" +
       "xOEAiInfxhJY6dIEhiI/4jsBA4UarvvW/e\nmzdvOBJtxbpA7ed853e+7zvf" +
       "cu937q/+o7tPNvXdk7JIp0tatO+0U+k370h23fjePrWbRplfvOf+\n5Lf+2f" +
       "C3f4H56mt3P2Td/VCUy63dRu6+yFt/bK27NzI/c/y6wT3P96y7z+e+78l+Hd" +
       "lpdJ0bFrl1\n92YTXXK77Wq/OftNkfa3hm82XenX92M+fcndveEWedPWndsW" +
       "ddPefY6L7d5edW2Urrioad/l7l4P\nIj/1muru5+9e4e4+GaT2ZW74+7ins1" +
       "jdU1xRt/dz80U0w6wD2/WfdvlEEuVee/fWiz3en/G32bnB\n3PVTmd+GxftD" +
       "fSK35xd3bz5ASu38spLbOsovc9NPFt08Snv3lY8kOjf6dGm7iX3x32vvvvxi" +
       "O+nh\n09zqM/dsuXVp7770YrN7SmN995UXZPactMTX3/h/fkn6p09evcfs+W" +
       "56w//JudM3Xuh09gO/9nPX\nf+j4m907v3w0u6+9enc3N/7SC40f2uC//z9Q" +
       "uf/1P3rroc1XX9JGdGLfbd9z/xn6ta//Ov4PP/Pa\nDcany6KJbqrwgZnfS1" +
       "V6/PLuWM66+Pvep3j7+M7Tj//x+T8x//Bf8v/3V+8+fbx73S3SLsuPd5/x\n" +
       "c2//eP+p+Z6Lcv/hrRgEjd8e7z6R3r96vbh/ntkRRKl/Y8cn5vvSbsP7+7G8" +
       "u7v7gfn4+nx86u7h\n5/7a3v0gEwXHWYMufv1OHAWz2qSR8xNN7a7mpwcl+G" +
       "CL8UbyB4ZXXpln87UXV1Y6qyFdpJ5fv+f+\nxX/wX/xrJPtv/OKr7+vWI5j2" +
       "7gsznXdutN95RvvulVfuaf7wBzl0Y7l3Wxn/x19593P/5k80f+3V\nu9esu8" +
       "9EWda1tpP684qy07QYfO+99l6lPv+c+t5rzaxybziz9s2K/F46E7rX9pklfX" +
       "33zRe17Nna\nPM539qw6v/7zv/Xf/OP3hl+7KcRNgF+8UX+ANosjecD2xnfk" +
       "7zI/84vffO3WaPjEzNjbTL798dTf\nc//xL/G/9nf+y7/39jNtbu++/aFF9u" +
       "Get0XyInypLlzfm43QM/J/5v+m/88/+cntX331phGfmW1P\na88aMy/kb7w4" +
       "xgcWy7tPDc+NWa9yd58Nijqz09unp9Zi0YZ1MTx7c68Xn72//8Hfevj5f2/H" +
       "Tc1u\nDw/q9ua+yMpZR+snB3/GYbe+Vz5o1I23L8zn3sT95h99Hfi7f/2zf+" +
       "vV563hDz1nNmW/fVhbn38m\nGqX2/fn93/uz0p/8U//oF376Xi6PgmnvXi87" +
       "J43c8R7rl16Z9eALL1nn73z5i7/8p7/z7/zdp4L/\nwjPqeF3b003u4x/59a" +
       "//uf/U/ndnGzCvxSa6+vdL7ZVHFbjRf3NeYu9rO2c7fvp03Nt5eX//4zfe\n" +
       "3Pe5u+fFk8cmNxV9cYlRN+fwVL6Z87P/19/4lcWTB4y3Pl+5J/NG82Fj+IGO" +
       "77nX/1D9ld/8r9rf\nuGfrM8W40Xhr/PCwmv2czmJ/p//863/5z2ev3n3Kuv" +
       "vcvUOz81az0+7GdGt2Sc3+8SV39wMf+P5B\n9/JgS999X/G/9qJSPjfsiyr5" +
       "zKLM97fWt/tPPa+FMyM+Px/fmI/PPBq9++vt4+dup8+Pr9yVt5uf\nvO/wrf" +
       "vzjz7qye3+7bGdxfhUjg/6dS/IR5v1oLi3M/r+kF+ej3fn483HId98cchX3l" +
       "fV50m9+T/9\ne3/hn/6RX8BevanSJ/sbr2YxfO5ZO6G7BSF/7Ff/1Nc/+8v/" +
       "4x+/l/gffqSMfxj+a+3MrSi3733j\n27PON/cxzTyfz/BH4T0N51TyJUoi1V" +
       "E2O6T+0WP+iW/8hf/l1/7B+YuvPhdWfOtDnv35Pg+hxb0U\nFuU4j/Aj32uE" +
       "+9Z/c/kjv/rz599wHlzumx80/2TeZcif/+/87/zBN9yXOJLX5uDnewnhC49C" +
       "+MKH\nhXC72f/rs2G63ZxfwsHbPX3PvtvpeM863Hhg3e0N/9zAt9OPzFRnrs" +
       "PvAO8At2fjt0Xzh+PU/fZT\no6jNUeYcDXx7NhhPle45DXgIxl4y6szmH3zW" +
       "jCvmiO2P/8N/+2//W9/6H2aWMU+16daamBX7ixBF\n/cHbw3u3kzXHdDcIct" +
       "HVrs/ZTcsXXjSHoN77KNjywR4J7RxvFC9F0D65o9fNEX/6w4Pe3rqooKN3\n" +
       "RuGlCQXrunahGX5aH1ku5jECnwjuOO1N2bLtrITmw/Y35abNyuZQLJZ7e20K" +
       "J3P0VWs8nbdMcSaP\n6ZKnryRJmQMTJY1KKggVu7nC7PemhZ2SMQ+kzjHc2f" +
       "+hXVVYdHOFtz5cLXTYRZDVmHcbr6pq000T\nrkypM6A4cmlQkKcJXIqhjNAa" +
       "x6pWFJ3J2DpF9lXXxLVwhbGVBytSXwnGUKsLmYBTr1bTxKyqCtRL\nAwNAt/" +
       "BcwEYO5qiCgHO2dVkCI8xRqnA0ig1bCZSdkxVUCWyRyaZVxZGh7iM9XmiRkq" +
       "bCaF8sQQMp\nh0Jo2fbwNnacUujSzWRpjFx5CHFcl3J4BEr57AtLLcjlayAd" +
       "xsNpWaGnZeLEEahZi1i1KzI/aApH\n7dls1PSwUzW6PJioJHckV9Ggr46Nxr" +
       "JRTRdZexyAMxYqpwutQ+IElRs5SXq1ZRkdd4EFzew6ZSrK\nnBL7miHZ45Dv" +
       "VbTYFpElpySzd0BBjRSj6gFG4J0EqdUyz8pRXlVVmNeEwQLFUb4aDKka/YJM" +
       "By1W\n/Eq95MGw3I0b+ipf6FNrU/qxP0LlJT9YGnkhKvEcu/WEmPXBjhrbkT" +
       "3hVJQwXyQ10QwIe+i142Iq\nKc2tBbkESmJp2OB2dy7BM0/hGqjaChEQpBux" +
       "OJyrB27Qz5duRTPbje+nQSUjqpmTF2m9B6rMRDfn\n48KeGSzHUwQcNzSE9X" +
       "1mtOkSiFYMQx8um/zQ8hDvOltT76VzDbRFNpKQczYhgxVIkKuPPWqLHF1u\n" +
       "x8LdLnBgd4ihU0SfjIGzphhrrcqaiqusHwVrLOKhSaeVr4hneet2hn3FQn8F" +
       "HsSOOq4Ts4NazEll\nZTJ8nVW9BYUQcZaFbuGoXIbUchSXxr6xB7a84jBwch" +
       "XvYOLd8ZgsxaTmnIsrm6WsHQMsms30wDKr\n7gCzJbiL6WO3AOxdxmiayDF6" +
       "ochXmycyL0rlkwGemHoPTPxBCZRyKbmEKLeoaqouj0RaFCdVxUkS\nSsMweN" +
       "32o+OsSGfRVeq5AApikAMcEo0MYjgphHixUYvjWVgfiW7fK6ADdZAwLaM8Yj" +
       "XrKNliW/tQ\nBe92SoTDTKNFkQplzUIFD+kylqpq0+HDxY4CVT6jEJMcxeKY" +
       "pAwth7VgI2kZG9IZBGQVRFcrtFVj\nz4Kd057EB5IcxEgXBu7ALoDUXLsBrW" +
       "HLsj+cIXxWjN2xveC2UtvrPm3GCuVqGoEw0nA8eDPKG0zV\nExrT4UoHIhke" +
       "t4pdlRmzjcNxcShEvkpUFpOD8VCnu8jTjr2dO8kxL1HMmq/jhZ5VTr1IR9UQ" +
       "2VPQ\nsBvSIAGiTYkL58lFxMYY0F7q+rhIApVrO9jBsDUJLM+qbV8ve1f2TT" +
       "7D4kOrRGYsy/QUi8G4XSHh\ndStuTqGygmWAjuhL2LMdyfckMErrgFoUUQtu" +
       "hghLGHSbjWypxcmhhOVySzGOWqRiM9haO2D+duKL\nrWwHvFfBJb0iphN1Il" +
       "i5IqrdVWKJXvLW2kLqu9aC635bC10XYUobmjUbG+iqckSOTMp9la6Q1cbu\n" +
       "rq7b94lTETvVhIcq0pSWcKiCOUoAEZDn3RksFus1wYYDiiJblIHhlgOxaId0" +
       "l6sapYgghwnSOEY0\nbtZxMJxcdUPKthzbowLgyholwWheLl1BJEW8NZb9Yq" +
       "ts+rTlrtngIIyy3OGtTu/ICMjOXIRUe3pV\nN3lUBSdStC2EkqojOUwovLtq" +
       "4WSTwsQDW49yanBaMqK0kIhgzYsVLo2MVsrMeTgXQmmniXGqZ0MH\nMualsC" +
       "+kXfVrnuetY2CWaQO4QCgRgM07IjpWcIWZK32crfwCLkBWLFmWaSgJ3Yppgc" +
       "KMzpxIO4fQ\nhqnMM7THq2OvpwgXo+eYUdG45dyD0lwlhuLlFVGmyR6bGeYr" +
       "7EJk1GaKKEpTWV8PxdIiG0AtyiSd\nbFuu8i7FqhLpLZ2xUb2sDvIkIyxzlX" +
       "GPUQ5qnYSAfVCFauh6x8kWXZEM6FElM4Ms9tYMOSoQOlkW\ntAiCiYL1Esdc" +
       "FY1BEtWhyawJikAv8tH0aKdNESX0VDMY6lwU88M6XIw1vtq2Nkv4S1dTR9oy" +
       "R0rc\nbLdgXQjb62YbTbnajabsB8pmmZ8q+qz4+mxhWp4kLpCl4YnqaVAT4l" +
       "t5WBiKs7ro2mq5QtF0u2uW\n0K6rZrVmL2AcHNzWRwvZ2tT4hc3MgCxc0z4C" +
       "qXgk903myVlzIs3wWCpOSAwKudifT4yJa+gakoQc\nXiEb0ZFUljiZVsw0pm" +
       "F3zYVbDivQXsHr9ckvaIXvPDkmjuopZXJYwRoncgj2YuvCYUFIHa95GlV2\n" +
       "cI3uVn5X0xo36qfkaNrybmcyTWAPwaE9SmnVJVXNSCycc0GWx8q5ys5Tz2bu" +
       "ALnb0253XPAeKNND\nK1PG1R8mPJXVZK0fL96Y8bP36UO2TLpD6Y2bJCcl2x" +
       "sZdT9sPT0Z9ekqhFrLuKkbIlYLpwa2QJkl\ntNLp85FYKkmBnZuMheLJCrZs" +
       "ybiMH+cHBwfrJou9clrZDHxA45Lg9plSS/HGhnNnO/UKM/oHjmIW\nw2ywpN" +
       "MSJwl3iqY6FDhX8pfXWJdiuldoGL24uF3YlFBomruU9KrdnIU9CdNFkiHnaG" +
       "qPR3Jcx368\nKtpFPp0tazJZ3RKPE0Ep2WB5wkrcj9vtOUhswjleBYOOEfcK" +
       "Bh3nIVNj5vklno3Achx2bHGOe7Mu\nttV5tvMLUlmvjeJKXF0FdVF8TUxtZm" +
       "LqRTOEiy2gtmOLSmgzFrEET2nHjxVrkxeoF+O9srP6C3xW\n+DiXnUwGuNNi" +
       "VIVu6e+1oga5igrScCImmj9sBq1AspZ1YbAJDClwmNHFtlOEhtqGXDL1UY0H" +
       "Wz9B\nYdJgdrWerglR7xdsLVgOOCQCg9R5a7nMWYn5KGYolqoIceUITGmuYG" +
       "cJFault+0cBTHKRALoJRdG\neQlSUXLVKVjuuibyFhMqxFyJDRuKS1hGKc57" +
       "zxjavQFy+jC0OxranY9r+TLIQ3Au7cP+yikhs5XJ\nfLVhNMDtTwEYD/VGS7" +
       "SjtWjEK1z4I9F5FUoRRMFqS1neFQmoGlkvrdzCMGDCg4kxtTt8K6HrrUnT\n" +
       "qxFCtkR/3LaH2esc5CvKE3WiLEiy6I+GjlFypMs7u14prhjAgQwuN6p6IX3D" +
       "afwM3mBLW6inHt3o\nZuvzImk7mrPu2rW+2bey6qmkCNPGglkGHgDq2+REOq" +
       "R8ilBePlAkVogAgM/xlUCoI3JNpsKuWC3x\nK4RD1luLNyVqNfIatqsJO+Xb" +
       "OTfY6oq1kNhg2F37ZSeldLwMY5jcWYbrD34stnIkl743HfotCzQx\nxPQ6mu" +
       "cWqxPtVeLaGuhAWZVVkRfiWRyyJi0K38H2HaRL1I5vaE1bXop9bq2oYo0Ah9" +
       "3JUeKDTWD9\n2WC0ao7C1rSFAx2/vdLAcc81zoReLQShgYTp2NMCYjn2SLvr" +
       "pTkOjOBd64vrIdcdct4Ap5xjhPKi\n5+MIEcCw4tfSaXavEUm5DVA6oZyeOD" +
       "JHBb4QIlmcrt7CWp9Sluqp7sizhGtsNTaDdUu284KYENQJ\nYWil6dyhmpYT" +
       "BCtytEQByLST6epmFSYTZ6ksySUsG2PprhcEX5Yr/uJe1dW+yhCYyOCVYKN2" +
       "zRRi\nhG2j85Xd6J5Ai+qU2UFRx2W9FEFJ8SCaomNAQCE/M42TcVir+8V47i" +
       "E0W0vbvTJVbhVKTg+Kas+L\n8rYO0YYEzX0gxo2iGsTmgtd+K+dtyTpAne1Y" +
       "ET5ctsC0geTMBpLNeZEeIlhCSqgBeaC0oIb1YZ3B\ntU0ZTFE9Vp3axaWX9U" +
       "RrYdsVvO/VmC9pPW0uYH31gQ6eE7LW2pwx38tOi0CXQZTCwtwjowRWSd2n\n" +
       "8fZ8SlO5D5G1ZTeQVA6YF2jtitJ40MUSrue9gS24ZYZcAVCle7vaImc1mC1t" +
       "RZcnhS/MXS6Llo+f\niYtw3cYWH00bK8vnSHYZQ6LeXmcnk20Rg3cBl8cL+x" +
       "auI4SAHw88zg2Z1xibI7fILmQgSVyBXANf\n4gEJWjeAFTLYsqftYCvqhKpv" +
       "N3DeC63Mtl59XG3Ols20+1A/Mmunzy91ZoAy5KiOACyEKAgLqzYm\n0hzbMx" +
       "ovzZtkKbYPd73JrQf2OPUhROrlkYUpFp1VhKvlEcpCDgF8iBVKdXvmKgSYlR" +
       "ddpL48u+uG\nQs6OilsrprYvBL7RzruiQHHcC+Ce0LQ5o1phZIdb0wjvaNwR" +
       "hBRXdo47GyYZ3w8HXnPtitEWHM6Y\nOS7hDiXsYZiycFpJ2KjDRaMc8Z2V5h" +
       "IkI7UYcgcPa9Tl+sAt1708p1Spp+9A2PU6WkZ5jkOtslsU\nHdWl5mjHIXJE" +
       "sRru4CAyrkWWB1BALA8TJ1wuJXxQKpNYb64yoLGGvGGC0pUn1OqQdMINCOXx" +
       "ftty\nyeLSLivwGJwU2qVQ22DNuuVS3SR2h4qly4ZuRFQWGo7zTQZHI3YViI" +
       "HSrbFGXwlCvD/PpitwKzDk\nu3PaL2CV08QC9JwDaNhObgyUTXoWNW5WxgYR" +
       "MTggcIabuBrI2P4oQ6cEO4KMcNGZlR5eLpIk5dts\npTe7ScPaxdYsUoS35j" +
       "BuuZQVWEtLWXbmUOAQCwznu/VGHHdTjsp5R/DNGJsgHFqXpZyd8sOujVdV\n" +
       "tqRZNAdAlzu5CzGZiALR3IFtshzo0g3TjVUsC9AkAWRfYqB+LSZsj87hi9fH" +
       "owoq0Krqx1n33Dkj\nRcJW1m06byCYpsLFDubTrRIZg7ijIB2RBxJWMsQN2M" +
       "3IwLkO9uFhuMQhJVgHl6Z4NGUiS1sdCI7f\nbfheBsoO0xh/aygwjC3EGB3R" +
       "CDCbjRYYuiJBMCRdS3RCgJXnQYkVlI5pAGrn6nLEtezKxJT0YjlF\nBEdODJ" +
       "s73bmsRq9ieoyhFxYIRpCvBo580UMOHfVcPm8Py/o62bojYpDgzz59fzHP17" +
       "VCH+y4uq5O\nCaKR5dlH9LakCovzE0qsmC6SF6OOIN7WSWR4v0PQ9qqLu12p" +
       "Y3NY3glbG+6ndnDVkrGw6tCcEd1I\n0ECoRKayDimmKdfzwQ5GVBi33GYFLJ" +
       "ZgZuXLSteQmEeEa4hRUCjHINC5Ui/MAbxROdaGsirtEDkb\nkxxzYM7/Z/MG" +
       "KoVFgbjfOrA0B9Fxrg3pArOpM3dR947ScyevPcWty7AeAU6CZZuAdpxXPHVM" +
       "A80y\nLMdCLQZcd1ay0as8dc5nS+h7PUyhvPD0oxgvOPOYnWiStguxFRrR2u" +
       "9k+Ii66/2wSfBULTQewXZQ\nGF7XMNKUBWvZ/WGnSocDtDa2+1vmt+H4YbhM" +
       "gM4v0qIxC5teC2WFczt31Jt1hxwwpQrMQiIiDALJ\nibN9yeIsJCmGlZ6b0x" +
       "mXKP6azTm+NSlXlqghr0VwZ57mKmc2iSo1ldhBEGNYVtnKQQGboHdCQpFc\n" +
       "OSfLwtTThW88K+Z3viuAJLm+npQLIwy2ggjHcc+tSvYS9wvhJDnsJkHKvXxF" +
       "SBEhMGrJwhka44UA\n1bvhyozFfgoDrSMPplwrQuzu2gSQYrhvzc7yZWzk3S" +
       "uppKLQLHZLDW8LjE1znmcDyLFlhz7zDcKk\nhbgxHFdghLjoNLNalmV6Nq89" +
       "LLOZFm/CC+7OYUoBO/7UlT5cnKBugZibiBMtvAx1T75u8m5DRgGC\nnxps0i" +
       "jbSMYsPkSTUZ5wVgvAfUriG/x4qkits3BQWCrnrRLsJyXkrsplcRxVrEhHLd" +
       "1mbT8cAriw\ndinbVSWoqmqwtIgilLcdYVCpjapHOzzgCHVRxGpAdk7OJq2P" +
       "yZOxgXmmXB4X5PIEbRGClwEFbCWb\ngEZEXYUTiirXLV1yurVnO5vtKT49Km" +
       "cIOtYt3cX+ucup7mzCLFavoU3u7s2cg8VF3wWCuHJ9qUa3\nE8xeJyK8pug8" +
       "D7MpSSeukhDdCHMIbx");
    final public static String jlc$ClassType$jl$1 =
      ("8HaK0CUjRqoONRsLHpr4OjcaiyMUCYg3m/oxdXS9E3aY74\nCtVRKoFJpWTV" +
       "xMHR9MqKRnUVXJ2+WiZbvDKsqsKtijIpLeTH1Nz5rFLitAyo9BxznKChW1wz" +
       "Ol+l\nbLz0cfdq5/3WXIbGUhB3juAYe4/1l5A8bcDGrVPDk4TNnLtKhUeugJ" +
       "VS+oAKO2g+pcBxXKZnbjFt\nq+3VHPYePuWYt9ZGWKoddDfKtumMwb7zr7SZ" +
       "MLBw6nbJvIwy0XaJzPbYdsOXWJMrm7OoUWm6K90O\nW8wRnipsTsgZDLV9J5" +
       "CWB0XbYA/Gl5rxkkK6FKKObjs3uSLisTbnJtAG54ir2LrQjtrC3nmlbGHz\n" +
       "Flkmiyk4e3kEyH4MNiainVZAuEz71KRLkzGQbkOs+by7HAhmJZG4kF/asL40" +
       "+Z5Jy6XqSgmTChAM\nD0s4BsBhkfFgsrUypW2N2f4aYpKJ9RAs1ca4wiuM9V" +
       "q4PpxiVBXB3TUoAcxQrdbdrLg5PET6uuHD\nXTmm60PbCmm6wDlgPc1+KBGl" +
       "bb+Xhn4NqXQsN3mqDHGxr9GY3fS6Z/YeejAswb5fVo6ZrWyhIMAU\nPhhzQC" +
       "ZdTNdts0WzQvIiuBxFV7PcPd6DsU4Fh9LVQ7+WKaID1DBHYgTfnvastsms4d" +
       "DwGwe15kiN\nVNegKRgRO3nckQBIapGHjIbv4cMKwpQN6pGUs9M7XzggPCBc" +
       "WmIdsdLJyHGCGMclmuumOimbgcGV\ndAVwvTiWkDj465MoFLOQFoRnZefWLw" +
       "YpnnPaVb+XUdNEjoJF4StRWZnXBlCELtxc5vjaUY5atKNm\nX49dy7KZqDk3" +
       "Pub7DRYnYjMm/GKXmacaXiIIMFCbleZCoqxW+DnrklTFS+2A4Vs3Z9qdHFOc" +
       "ZJ21\nal9dkyrgKoHYTVf9PJB6pbF7puVBbtEkx4Isea1tj5l+ojWR3+4Ei6" +
       "grOLvul4R2Jfdbc/Z/qclZ\nrqbN1jagGuKwJXQBMih1W9scI3f4nBJl7CIO" +
       "G9V1T122IQ9VRRVnFRmpnL8Aa+fiNhdAuzrquQit\nrHXTRBuhkRrm/HZGLh" +
       "/3HoXK+y0u4t5OpPhztSA3oEjOD6RG2BujUHp1fQbI+8MD9mv6JEJdhMtF\n" +
       "6BL9wIOnikcvcKG462RYJ4zLe/gGEUQNz4XEXfTXknanrWOWVwkIdgc8VjVK" +
       "lvexJtd2GfP8qnMv\nZnfR+WLcD1TZ0m0WLrViDqsHaDlAnYJvmUNzStXZas" +
       "j0+jimeHm48IeQ32Xqiq/Pujho4sFXxP2c\nMgGtvXKhyAMawjnPrsJ2uPUm" +
       "Bxv0gjnuFZajw9LfUCYpQAvh0u2GVWPyIbam3QumOdV2tdp6LbBV\n9bywN2" +
       "mFFEEUCF1wHDqEzutYH7ZeyEaKwyrAkShKSTVCcaSaZGHOkfV1M3A4ibleBs" +
       "7WUaPm1HS7\nGYVc7GIuWSa9NDe87myoUatig8yr6uTMl4MFHLZ4C5EnWjgK" +
       "B/wqLYhBYne1PyfU/WraKFh5vHIK\nSjTw/Mxcc96qcZumuwlsvV2UiuLW0A" +
       "eIiq67pHVFud3zarOdfebZdSt5UWJd4fioATaHSGICPdyF\no+2COhRN7Ulu" +
       "MhG6UHw8ed4g7Fo2vKQ6fR3O2f6wvP2JbezcYXLAbTM4s1FYVJWneXtVN/Y7" +
       "+7S1\n0/a0tijGjR0haYQiQnWzc9fRrAa7wOmKHUbVFcBptlQQo3REIGs57D" +
       "R8ijJXEXeL6xhbgSIi8SXK\nDjVVqfw1sXkqUk86ez5r+GVIoMyIuNV2w2pO" +
       "Hp87RUA0C3CZLAb42htwkWY3g+iiZbIIMJGZNqib\nXgEha4E42MdzQpg4NQ" +
       "/xdXrYrS+bfg13+/1m07UFyU8XGBkCK/Dd42FUrX5DM8g+ng67Hs0Xvlln\n" +
       "LuqYiJyeoDm/GaPjJVxt+f0cI6RGSbYnt3LntFsW4/6EHyFB2lotiiUHz8s3" +
       "Vp1jc+yxPm5HX3TK\nxZz29QSuwqoJrzN7NhcIMTqyg2XAnAvsz9VOhKEWz1" +
       "dMSsbxviiWwRbGjUxM56S2sM+rbh2o0qXS\nbSclF21CCaAxiUd6T1XDqMSt" +
       "sPIPrqzYemuYaEoHAr+8bMku4Hja2pglLV8lco/My9bLlXFe8jCX\nZ/5U9m" +
       "Y9myA7dLPrNT3QXcM3g7fBLeuCebxdb6lON9EKdyeOHnqWuBznfCiYvxBFcn" +
       "CTC0AKdaug\nJkjvjsJIldpCQTvgLPG9fvADmyqQlkD7SMl3wyWnePMEVMNq" +
       "SZzPtIqHR3wnBx2Oy1EOQHB9TMKJ\nnJbLE+HGZ7i7zg5lmW7Xh+ZyCUf6it" +
       "WrldmDvVB0OyxWD0dQvOh1TUpk1hX7wznapxPMqQ4MHYxw\nCV6wDe4VudOR" +
       "nKrESgoswipjRUBp4QM1whvTRWwycqUQdhG+9oVB6FhnaIYYK+Vhv5s22xKI" +
       "0PUV\nZFrUE4M0haPRKyobj65hNYdUt98WN1JAVBsyDzFVXmu5whJEqNjrEw" +
       "2mQRvy2/VeUPzjHlyRul0i\n6dH3LCi+kkYmnKDjaQNB1AlfK6eFJLJoWoes" +
       "sWOq/YqqjJrVAXqAdbUroKxdnswwO5j7aZdSXkLc\npAdeU0cnrc432jM+je" +
       "xE1ZqckjxHLUp5ulChOwtNnyBMds7V5Zaa2F64q6jkVgoQPFYUfP6+qOH9\n" +
       "ctM4uv/w3ZcVDnzqz0xEtSymDlMFcUs4POvsNM9Q2LKaQuEosmbP5M1K9fNo" +
       "r1o0uZDUybUI4WqB\naqpH5CBgJ3VZy5XqckrVXyCZ7vI8xAUhOq6hAc37Ie" +
       "bqpYe1pbTc0P1S9v0Q1PYNYG3aBcWVO0uo\nR0hdh8F+Pa2gIe9EuDFw/6Is" +
       "54C0ovrGTLjAQjlnRN2ORIfjPuzOcs8iLUg00on3bKI6+kOx8M8+\nhGMae5" +
       "1zKY0MMpce3aKLVUnakrzTJ73ss4XRmr7uXdV051dad2BVSJLNvjxrF0nlgY" +
       "TzZdqUYG1R\n9HpcDmPLJ9BWr5WlHSHlWs+l0yhdMHx9NU/pdoa9rPhkHYGT" +
       "kR+QaWWreWfa523NdVQ0Yhub21/P\ndbToTxc3apeQGDTsAXKGcb+RbJ4wjL" +
       "AlC3oAJVDxt0ecvcpJE18af+V4JjZ2nOhgu1KVbNPAaCw7\ntcTh5CxAUrkk" +
       "Yr9KzQIcuSG9BHJg0cf0cnK3rhoyVpPRWA6T26OQCGuMHXXSFe3WDqqQxeWj" +
       "ybXA\nHlO3IEks5YUPnk8nY9rLbohhZHoMpB0jz/4h8py2Y9N+XQjSqWMJBe" +
       "DQC7DdQ+cthmfu6uJKaRdF\nCWJN2aBAaLMdi4Xexrne8jLheWuglgcYoBWP" +
       "UY7FbmRPUrWn9xG1hyN1iMHLROM9PjLyYEukZugW\nHBR2IobtgZHXVV7ai7" +
       "NGsgTM7FlzgttVeEoUwcQNnw7ZDQVVE2OHXZYrtgQwHShGKHyOJLsB7KXP\n" +
       "wQWT58QciyvgGOz2c/cFnJ6ux5E5A11qu6W1Us4uhmayeEFGzdaLONd2SmTJ" +
       "srJPy+KSkI55vGJB\nlS7xqphD25zFVXnYAemo+OmiYeQrMdUj4bUDEFxLyU" +
       "AiX9sxe3cJTydxOS5DWoZNcdk4qb3sS2ja\nxHLhy101bKmqO6+4Q3E1mjPn" +
       "Y8tFEw/I7MFiExbn/C4joZ4OiesK2UqBoQn7vDCjHiXmMAddz0lQ\ncGy6Xb" +
       "CyTDhvjo0F7inOZcHR8ooumQ4LOkTZsGCrROmXNBZefaM+OXmKJhTkX2qPnK" +
       "NtpTIaFY0Y\n0xuoFKcTtihXaEYV4xy5hqR9FRWIAqWmqxeb0DlOcrLhNl1l" +
       "QNdcWidHDYi2lbpuFUKtKnOKcxfn\nB5DeMyg78iTOrM41NZAqlSCkOfAIjJ" +
       "9FIMNCZGGRl2LsjGESZpPGpsgmGtCINiI5ija90QZ7U+1H\n/2Cl2m7dEXRI" +
       "HlMfVACGKGy6WtsUCzZ2EXX12VO3C9txDMG1dt3VOJwMW3C1Hc+cULY6yZni" +
       "HzSr\nRQaVHFIirSZdU1kydrieuQAUXkybUR4uwOlieWnbmzq48OzI9GOunS" +
       "OZvmiqk2DB6WaXU2ZMFxXh\nE2HDW0hd1AZpbP1rA47omEBMV5gqo1KEmjNF" +
       "AdbJ+WyOB2phGKZntJ0+p1ZZy7d65lQYGwqQE3iN\n2RI1FTbXy6oGl1Zu52" +
       "eEJxSN6ZkgZRu4NlwNkeRos9ZQHSOgagGyInUmkTWGboVKzG+BiHGQzhvd\n" +
       "OYLXqRkk/nTYRaELY40MJ3gIy3Ky3HUnzA34gEaJTGR6ck9oXZmvFgk7q6Qm" +
       "YYSTXEIDbvwExLey\nywCRb47Q1TkR9fFyOolqc/F3cQFch14u4fRoKEtR2E" +
       "zaqS6JC32q+XqjLMbDst6LqU5q3CwLn4FB\n8wxUgC7jOdfbY0/tNmwPUHpc" +
       "TXKG6OgkxgY6uVi+vK50+Eq0wWEPn9dJDWHRYhquUD+Hca4VrVHZ\nQQOkWp" +
       "eMgq53zXGAiVQv3bwjIesU9v4JWK5O6ZF3w0I0MLWGgxo06ev24oscl628RR" +
       "vQ5pT6K+C6\nqicAtQQ4JsSRsO0V6RG0fu4nyzDycgBsWoC6pmw2KD0sp3EV" +
       "pGM7rteYZJrLDGGK6FwvMEKzd4om\n4x6QDGK6PQQ22EtjsUzj83ZlgrW/Qh" +
       "t2uUR4EbZXdi5k8mSU45YmQh+svGm1urYQvDr2q3K3MCuF\nbg5bxF4u1b2F" +
       "aTS9QoBlqndWbuxtncoCjKDhiFKtJYXj+B+4eejo0Z9/4UP+/NvgR3j0h4La" +
       "9MO1\nj6/e1z62d58q66i3bztr7v6VG6H5eO9Wt/jes60A73G3tu98FPHqI6" +
       "p1i5nkl18k+bhd43tT7G6n\nur376gd6H4lbXaZd37YZfAyB4ZHAD3+AAG03" +
       "4W+j8/TS0ZXiod7zRQLjR7H2oWD5sXL8WXH5Vz5Y\njP7m81svHphzK9P9+k" +
       "ftt7kv0f0F45+88cfsv/ndVx8L1MX27jNtUf5E6vd++qxW/UUi/P32oqcF\n" +
       "3D+kv/X3KfQv/tyLxepfmod/63v2fM/9fP/V02th9J+9evfa+8XiH9rf9MFO" +
       "736wRHxR+21X58oH\nCsW/8X7B8Gfn41uP17un1+cKhu9Zfzv9/pdW77/yTA" +
       "t/6uPr+3+pvfviTdY3MXz7mdp/+5mC/OKH\ngL3xCOyN7xsY//HA/sTvENg3" +
       "H/cV3T29fl/AvvtyYC/sonjrxVJ46rYlpSVH1y9vW6juB/yzv4MJ\n3Arzv/" +
       "1YK3739PriBD5isT2Wb78U96vPmr3z2+T7v9/efbotntV3f/clUH9sPr76CP" +
       "Wr/4Kgvvas\nKv2d9+35R+B9TmC/cj/gX2pvG/7qxj8+1ODzLwH9I/Px1iPo" +
       "t36X+Pu91ecZ3l/7beD9Vx9X293T\n679sJv/12WHel++L9yn0T32EDv/YI+" +
       "Yf+5fM47/1veHebMZX5mP9CHf9O7MZT5fMx66n/3oWdfS4\n4+hlor7h+NH5" +
       "oB9x0N+X7XrJFo2nDvXjAP637d3rftXZafPiDotPOUWR+nb+EW5AfEQs/nMh" +
       "/tL7\nQcDzMc7Hw/7778O+Pf3GSzDeesiPGOXfGcYXde5//ng8/9vH4rlp2x" +
       "96xPOHfpe07Z/M2hbOod6+\n8D5S2247b3/mEcfP/C7h+M2P8SKfvnvYEPfK" +
       "I477a3v3Ux/ekvmTT2amNlHVFa3/9mO8/qQvIu/J\nzblGedS+/Z0nP/vkp7" +
       "8rP/m575TPJlD/803gt+YJPB3gQzuPbsO/MKEffGTsByf0ylsfM6GHrXBP\n" +
       "HnaBPnlcb/czexo7FsHbP32/e+7JB7du/qydOT9335L78ScPDR5W/MOH4rvU" +
       "zJYoePJ28SR6n9ST\nZ3HIjWnPnp64T/7Ak7ef+1q8++QhSn1hWPW2E66ZpZ" +
       "r6bZG//Z13aj+9vW+U4m33nY9Mon78Huh3\n3v25R6LBvE78d98X2L8At/Df" +
       "f6xMX1k87H99jrUfWqqPu4O//FSCT3cL3z5+8/9XsF9s7752A+va\nTfsynj" +
       "6D8kHoX/w+oH8gX/s+V8wrX3/MGi9++5FJ7+8lvD/a3n3jRbwvSbN/L0Fe3T" +
       "ZIvgD5hcT+\n9xJc7CUcfsmvEsb2bvFMr2/727/8of+S8vC/PNxv/vrPvP03" +
       "ys//5/f/QuD9/7fxOnf36aBL0+d3\nYT93/3pZ+0F0P93XH/Zk38/9lf2Dib" +
       "83brftpPPlNo1Xdg+fqfbutYe/Fr1yKB8W7f8HLgPP9cVF\nAAA=");
}
