/*
 * Decompiled with CFR 0.152.
 */
package polyglot.visit;

import java.util.ArrayList;
import java.util.Iterator;
import polyglot.ast.Cast;
import polyglot.ast.Expr;
import polyglot.ast.Node;
import polyglot.ast.ProcedureCall;
import polyglot.types.Type;
import polyglot.visit.NodeVisitor;

public class RedundantCastRemover
extends NodeVisitor {
    public Node leave(Node old, Node n, NodeVisitor v) {
        if (n instanceof Cast) {
            Cast c = (Cast)n;
            Type castType = c.castType().type();
            Type exprType = c.expr().type();
            if (exprType.isImplicitCastValid(castType) && !castType.isPrimitive()) {
                return c.expr();
            }
        }
        if (n instanceof ProcedureCall) {
            ProcedureCall newCall = (ProcedureCall)n;
            ProcedureCall oldCall = (ProcedureCall)old;
            ArrayList<Expr> newArgs = new ArrayList<Expr>(newCall.arguments().size());
            boolean changed = false;
            Iterator i = newCall.arguments().iterator();
            Iterator j = oldCall.arguments().iterator();
            while (i.hasNext() && j.hasNext()) {
                Expr newE = (Expr)i.next();
                Expr oldE = (Expr)j.next();
                if (oldE instanceof Cast) {
                    newArgs.add(oldE);
                    changed = true;
                    continue;
                }
                newArgs.add(newE);
            }
            if (changed) {
                n = newCall.arguments(newArgs);
            }
        }
        return n;
    }
}

