/*
 * Decompiled with CFR 0.152.
 */
package polyglot.visit;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import polyglot.ast.Assign;
import polyglot.ast.Block;
import polyglot.ast.BooleanLit;
import polyglot.ast.Branch;
import polyglot.ast.Do;
import polyglot.ast.Eval;
import polyglot.ast.Expr;
import polyglot.ast.For;
import polyglot.ast.Id;
import polyglot.ast.If;
import polyglot.ast.Local;
import polyglot.ast.LocalDecl;
import polyglot.ast.Loop;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Stmt;
import polyglot.ast.TypeNode;
import polyglot.ast.While;
import polyglot.frontend.Job;
import polyglot.types.Flags;
import polyglot.types.LocalInstance;
import polyglot.types.TypeSystem;
import polyglot.util.Position;
import polyglot.util.UniqueID;
import polyglot.visit.NodeVisitor;

public class LoopNormalizer
extends NodeVisitor {
    protected final Job job;
    protected final TypeSystem ts;
    protected final NodeFactory nf;

    public LoopNormalizer(Job job, TypeSystem ts, NodeFactory nf) {
        this.job = job;
        this.ts = ts;
        this.nf = nf;
    }

    public Node leave(Node parent, Node old, Node n, NodeVisitor v) {
        if (n instanceof While) {
            While s = (While)n;
            return this.translateWhile(s);
        }
        if (n instanceof Do) {
            Do s = (Do)n;
            return this.translateDo(s);
        }
        if (n instanceof For) {
            For s = (For)n;
            return this.translateFor(s);
        }
        return n;
    }

    protected Node postCreate(Node n) {
        return n;
    }

    protected String newId() {
        return UniqueID.newID("loop");
    }

    protected Block createBlock(List stmts) {
        return (Block)this.postCreate(this.nf.Block(Position.compilerGenerated(), stmts));
    }

    protected Block createBlock() {
        return (Block)this.postCreate(this.nf.Block(Position.compilerGenerated()));
    }

    protected While createLoop(Loop source) {
        Position pos = source.position();
        While w = this.nf.While(pos, this.createBool(true), this.createBlock());
        w = (While)this.postCreate(w);
        return w;
    }

    protected LocalDecl createLoopVar(Loop source, Expr cond) {
        Position pos = source.position();
        LocalInstance li = this.ts.localInstance(pos, Flags.NONE, this.ts.Boolean(), this.newId());
        LocalDecl var = this.nf.LocalDecl(pos, Flags.NONE, (TypeNode)this.postCreate(this.nf.CanonicalTypeNode(pos, this.ts.Boolean())), (Id)this.postCreate(this.nf.Id(pos, li.name())), cond);
        var = var.localInstance(li);
        var = (LocalDecl)this.postCreate(var);
        return var;
    }

    protected LocalDecl createLoopVar(Loop source) {
        return this.createLoopVar(source, this.createBool(false));
    }

    protected If createLoopIf(LocalDecl var, Stmt body) {
        Position pos = var.position();
        Local cond = this.createLocal(var.localInstance(), pos);
        Branch exit = (Branch)this.postCreate(this.nf.Branch(pos, Branch.BREAK));
        If s = this.nf.If(pos, cond, body, exit);
        s = (If)this.postCreate(s);
        return s;
    }

    protected Eval createAssign(LocalDecl var, Expr right) {
        Position pos = var.position();
        Local left = this.createLocal(var.localInstance(), pos);
        Eval a = this.nf.Eval(pos, (Assign)this.postCreate(this.nf.Assign(pos, left, Assign.ASSIGN, right)));
        a = (Eval)this.postCreate(a);
        return a;
    }

    protected Eval createAssign(LocalDecl var) {
        return this.createAssign(var, this.createBool(true));
    }

    protected If createInitIf(LocalDecl var, Expr cond) {
        Position pos = var.position();
        Local use = this.createLocal(var.localInstance(), pos);
        If s = this.nf.If(pos, use, this.createAssign(var, cond), this.createAssign(var));
        s = (If)this.postCreate(s);
        return s;
    }

    protected If createIterIf(LocalDecl var, List iters) {
        Position pos = var.position();
        Local use = this.createLocal(var.localInstance(), pos);
        ArrayList<Stmt> stmts = new ArrayList<Stmt>(iters.size());
        Iterator it = iters.iterator();
        while (it.hasNext()) {
            Stmt s = (Stmt)it.next();
            stmts.add((Stmt)this.postCreate(s));
        }
        If s = this.nf.If(pos, use, this.createBlock(stmts));
        s = (If)this.postCreate(s);
        return s;
    }

    protected Local createLocal(LocalInstance li, Position pos) {
        Local l = this.nf.Local(pos, this.nf.Id(pos, li.name()));
        l = l.localInstance(li);
        l = (Local)l.type(li.type());
        l = (Local)this.postCreate(l);
        return l;
    }

    protected void addInits(List stmts, For source) {
        Iterator it = source.inits().iterator();
        while (it.hasNext()) {
            Stmt s = (Stmt)it.next();
            stmts.add(this.postCreate(s));
        }
    }

    protected BooleanLit createBool(boolean val) {
        return (BooleanLit)this.nf.BooleanLit(Position.compilerGenerated(), val).type(this.ts.Boolean());
    }

    protected Stmt translateWhile(While s) {
        Expr cond = s.cond();
        if (s.condIsConstantTrue()) {
            if (cond instanceof BooleanLit) {
                return s;
            }
            return s.cond(this.createBool(true));
        }
        While w = this.createLoop(s);
        LocalDecl var = this.createLoopVar(s, cond);
        If branch = this.createLoopIf(var, s.body());
        ArrayList<Stmt> stmts = new ArrayList<Stmt>(2);
        stmts.add(var);
        stmts.add(branch);
        w = w.body(((Block)w.body()).statements(stmts));
        return w;
    }

    protected Stmt translateDo(Do s) {
        Expr cond = s.cond();
        While w = this.createLoop(s);
        LocalDecl var = this.createLoopVar(s);
        If init = this.createInitIf(var, cond);
        If branch = this.createLoopIf(var, s.body());
        ArrayList<Stmt> stmts = new ArrayList<Stmt>(2);
        stmts.add(init);
        stmts.add(branch);
        w = w.body(((Block)w.body()).statements(stmts));
        stmts = new ArrayList(2);
        stmts.add(var);
        stmts.add(w);
        return this.createBlock(stmts);
    }

    protected Stmt translateFor(For s) {
        Expr cond = s.cond();
        if (cond == null) {
            cond = this.createBool(true);
        }
        While w = this.createLoop(s);
        LocalDecl var = this.createLoopVar(s);
        If iter = this.createIterIf(var, s.iters());
        Eval update = this.createAssign(var, cond);
        If branch = this.createLoopIf(var, s.body());
        ArrayList<Stmt> stmts = new ArrayList<Stmt>(3);
        stmts.add(iter);
        stmts.add(update);
        stmts.add(branch);
        w = w.body(((Block)w.body()).statements(stmts));
        stmts = new ArrayList(s.inits().size() + 2);
        this.addInits(stmts, s);
        stmts.add(var);
        stmts.add(w);
        return this.createBlock(stmts);
    }
}

