/*
 * Decompiled with CFR 0.152.
 */
package polyglot.visit;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import polyglot.ast.Assign;
import polyglot.ast.Block;
import polyglot.ast.ClassBody;
import polyglot.ast.ClassDecl;
import polyglot.ast.ClassMember;
import polyglot.ast.ConstructorCall;
import polyglot.ast.ConstructorDecl;
import polyglot.ast.Field;
import polyglot.ast.FieldAssign;
import polyglot.ast.FieldDecl;
import polyglot.ast.Formal;
import polyglot.ast.Local;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Receiver;
import polyglot.ast.Special;
import polyglot.ast.Stmt;
import polyglot.ast.TypeNode;
import polyglot.frontend.Job;
import polyglot.types.ClassType;
import polyglot.types.ConstructorInstance;
import polyglot.types.Context;
import polyglot.types.FieldInstance;
import polyglot.types.Flags;
import polyglot.types.LocalInstance;
import polyglot.types.ParsedClassType;
import polyglot.types.SemanticException;
import polyglot.types.TypeSystem;
import polyglot.util.Position;
import polyglot.visit.InnerClassAbstractRemover;
import polyglot.visit.NodeVisitor;

public class InnerClassRewriter
extends InnerClassAbstractRemover {
    public InnerClassRewriter(Job job, TypeSystem ts, NodeFactory nf) {
        super(job, ts, nf);
    }

    FieldInstance localToField(ParsedClassType ct, ClassType outer) {
        FieldInstance fi = this.ts.fieldInstance(Position.compilerGenerated(), ct, Flags.FINAL.Protected(), outer, this.mangleClassName(outer));
        return fi;
    }

    FieldDecl createFieldDecl(FieldInstance fi) {
        FieldDecl fd = this.nf.FieldDecl(fi.position(), fi.flags(), (TypeNode)this.nf.CanonicalTypeNode(fi.position(), fi.type()), fi.name());
        fd = fd.fieldInstance(fi);
        return fd;
    }

    void addEnvToCI(ConstructorInstance ci, List env) {
        ArrayList formals = new ArrayList(ci.formalTypes());
        formals.addAll(this.envAsFormalTypes(env));
        ci.setFormalTypes(formals);
    }

    ConstructorDecl translateConstructorDecl(ParsedClassType ct, ConstructorDecl cd, Map m) {
        Stmt s;
        List env = this.env(ct, true);
        this.addEnvToCI(cd.constructorInstance(), env);
        cd = cd.name(ct.name());
        ArrayList newFormals = new ArrayList();
        newFormals.addAll(cd.formals());
        newFormals.addAll(this.envAsFormals(env));
        cd = cd.formals(newFormals);
        if (cd.body() == null) {
            return cd;
        }
        List oldStmts = cd.body().statements();
        ArrayList<Stmt> newStmts = new ArrayList<Stmt>();
        ConstructorCall cc = null;
        if (oldStmts.size() >= 1 && (s = (Stmt)oldStmts.get(0)) instanceof ConstructorCall) {
            cc = (ConstructorCall)s;
        }
        if (cc != null) {
            newStmts.add(cc);
        }
        if (cc == null || cc.kind() == ConstructorCall.SUPER) {
            Iterator i = this.envAsFormals(env).iterator();
            while (i.hasNext()) {
                Formal f = (Formal)i.next();
                LocalInstance li = f.localInstance();
                FieldInstance fi = (FieldInstance)m.get(li.type());
                if (fi == null) continue;
                Special this_ = this.nf.Special(Position.compilerGenerated(), Special.THIS);
                this_ = (Special)this_.type(ct);
                Field target = this.nf.Field(Position.compilerGenerated(), (Receiver)this_, fi.name());
                target = target.fieldInstance(fi);
                target = (Field)target.type(fi.type());
                Local source = this.nf.Local(Position.compilerGenerated(), li.name());
                source = source.localInstance(li);
                source = (Local)source.type(li.type());
                FieldAssign assign = this.nf.FieldAssign(Position.compilerGenerated(), target, Assign.ASSIGN, source);
                assign = (FieldAssign)assign.type(target.type());
                newStmts.add(this.nf.Eval(Position.compilerGenerated(), assign));
            }
        }
        if (cc != null) {
            for (int i = 1; i < oldStmts.size(); ++i) {
                newStmts.add((Stmt)oldStmts.get(i));
            }
        } else {
            newStmts.addAll(oldStmts);
        }
        Block b = cd.body().statements(newStmts);
        cd = (ConstructorDecl)cd.body(b);
        return cd;
    }

    protected Node leaveCall(Node old, Node n, NodeVisitor v) throws SemanticException {
        if (n instanceof ClassDecl) {
            ClassDecl cd = (ClassDecl)n;
            ParsedClassType ct = cd.type();
            List env = this.env(ct, true);
            if (!env.isEmpty()) {
                Context innerContext = cd.del().enterChildScope(cd.body(), this.context);
                cd = cd.body(this.translateClassBody(ct, cd.body(), innerContext));
            }
            n = cd;
        }
        n = super.leaveCall(old, n, v);
        return n;
    }

    protected ClassBody translateClassBody(ParsedClassType ct, ClassBody body, Context context) {
        ArrayList<FieldDecl> members = new ArrayList<FieldDecl>();
        List env = this.env(ct, false);
        HashMap<ClassType, FieldInstance> fieldMap = new HashMap<ClassType, FieldInstance>();
        Iterator i = env.iterator();
        while (i.hasNext()) {
            ClassType outer = (ClassType)i.next();
            FieldInstance fi = this.localToField(ct, outer);
            fieldMap.put(outer, fi);
            ct.addField(fi);
            members.add(this.createFieldDecl(fi));
        }
        ArrayList<ClassMember> ctors = new ArrayList<ClassMember>();
        ArrayList<ClassMember> others = new ArrayList<ClassMember>();
        Iterator i2 = body.members().iterator();
        while (i2.hasNext()) {
            ClassMember cm = (ClassMember)i2.next();
            if (cm instanceof ConstructorDecl) {
                ctors.add(cm);
                continue;
            }
            others.add(cm);
        }
        members.addAll(ctors);
        members.addAll(others);
        body = body.members(members);
        ClassBodyTranslator v = new ClassBodyTranslator(ct, fieldMap, context);
        v = (ClassBodyTranslator)v.begin();
        body = (ClassBody)body.visit(v);
        return body;
    }

    class ClassBodyTranslator
    extends NodeVisitor {
        ParsedClassType ct;
        Map fieldMap;
        Context outerContext;

        ClassBodyTranslator(ParsedClassType ct, Map fieldMap, Context context) {
            this.ct = ct;
            this.fieldMap = fieldMap;
            this.outerContext = context;
        }

        public Node leave(Node old, Node n, NodeVisitor v) {
            FieldInstance fi;
            Special s;
            if (n instanceof Special && (s = (Special)n).qualifier() != null && (fi = (FieldInstance)this.fieldMap.get(s.qualifier().type())) != null) {
                Special this_ = InnerClassRewriter.this.nf.Special(s.position(), Special.THIS);
                this_ = (Special)this_.type(this.ct);
                Field f = InnerClassRewriter.this.nf.Field(s.position(), (Receiver)this_, fi.name());
                f = f.fieldInstance(fi);
                f = (Field)f.type(fi.type());
                n = f;
            }
            if (n instanceof ConstructorDecl) {
                ConstructorDecl ctd = (ConstructorDecl)n;
                ClassType ct2 = (ClassType)ctd.constructorInstance().container();
                if (ct2.equals(this.ct)) {
                    ctd = InnerClassRewriter.this.translateConstructorDecl(this.ct, ctd, this.fieldMap);
                }
                n = ctd;
            }
            return super.leave(old, n, v);
        }
    }
}

