/*
 * Decompiled with CFR 0.152.
 */
package polyglot.visit;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import polyglot.ast.Assign;
import polyglot.ast.Block;
import polyglot.ast.ClassBody;
import polyglot.ast.ClassDecl;
import polyglot.ast.ClassMember;
import polyglot.ast.ConstructorCall;
import polyglot.ast.ConstructorDecl;
import polyglot.ast.Eval;
import polyglot.ast.Expr;
import polyglot.ast.Field;
import polyglot.ast.FieldDecl;
import polyglot.ast.Formal;
import polyglot.ast.Local;
import polyglot.ast.New;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.ProcedureCall;
import polyglot.ast.Receiver;
import polyglot.ast.SourceFile;
import polyglot.ast.Special;
import polyglot.ast.Stmt;
import polyglot.ast.Term;
import polyglot.ast.TypeNode;
import polyglot.frontend.Job;
import polyglot.main.Report;
import polyglot.types.ClassType;
import polyglot.types.ConstructorInstance;
import polyglot.types.Context;
import polyglot.types.FieldInstance;
import polyglot.types.Flags;
import polyglot.types.LocalInstance;
import polyglot.types.ParsedClassType;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.Copy;
import polyglot.util.Position;
import polyglot.visit.ContextVisitor;
import polyglot.visit.LocalClassRemover;
import polyglot.visit.NodeVisitor;

public class InnerClassRemover
extends ContextVisitor {
    private static final String OUTER_FIELD_NAME = "out$";
    Map outerFieldInstance = new HashMap();
    static final /* synthetic */ boolean $assertionsDisabled;

    public InnerClassRemover(Job job, TypeSystem ts, NodeFactory nf) {
        super(job, ts, nf);
    }

    Expr getContainer(Position pos, Expr this_, ClassType currentClass, ClassType containerClass) {
        if (containerClass == currentClass) {
            return this_;
        }
        FieldInstance fi = this.boxThis(currentClass, currentClass.outer());
        Field f = this.nf.Field(pos, (Receiver)this_, this.nf.Id(pos, OUTER_FIELD_NAME));
        f = f.fieldInstance(fi);
        f = (Field)f.type(fi.type());
        f = f.targetImplicit(false);
        return this.getContainer(pos, f, currentClass.outer(), containerClass);
    }

    protected ContextVisitor localClassRemover() {
        LocalClassRemover lcv = new LocalClassRemover(this.job, this.ts, this.nf);
        return lcv;
    }

    public Node override(Node parent, Node n) {
        if (n instanceof SourceFile) {
            ContextVisitor lcv = this.localClassRemover();
            lcv = (ContextVisitor)lcv.begin();
            lcv = lcv.context(this.context);
            if (Report.should_report("innerremover", 1)) {
                System.out.println(">>> output ----------------------");
                n.prettyPrint(System.out);
                System.out.println("<<< output ----------------------");
            }
            n = n.visit(lcv);
            if (Report.should_report("innerremover", 1)) {
                System.out.println(">>> locals removed ----------------------");
                n.prettyPrint(System.out);
                System.out.println("<<< locals removed ----------------------");
            }
            n = this.visitEdgeNoOverride(parent, n);
            if (Report.should_report("innerremover", 1)) {
                System.out.println(">>> inners removed ----------------------");
                n.prettyPrint(System.out);
                System.out.println("<<< inners removed ----------------------");
            }
            return n;
        }
        return null;
    }

    protected Node leaveCall(Node old, Node n, NodeVisitor v) throws SemanticException {
        Context context = this.context();
        Position pos = n.position();
        if (n instanceof Special) {
            Special s = (Special)n;
            if (s.qualifier() == null) {
                return s;
            }
            if (!$assertionsDisabled && s.qualifier().type().toClass() == null) {
                throw new AssertionError();
            }
            if (s.qualifier().type().toClass().declaration() == context.currentClassScope()) {
                return s;
            }
            return this.getContainer(pos, this.nf.This(pos).type(context.currentClass()), context.currentClass(), s.qualifier().type().toClass());
        }
        if (n instanceof New) {
            New neu = (New)n;
            Expr q = neu.qualifier();
            if (q != null) {
                ArrayList<Copy> args;
                ConstructorInstance ci = (neu = neu.qualifier(null)).constructorInstance();
                if (ci != ci.declaration()) {
                    args = new ArrayList<Copy>();
                    args.add(ci.container());
                    args.addAll(ci.formalTypes());
                    ci = ci.formalTypes(args);
                    neu = neu.constructorInstance(ci);
                }
                args = new ArrayList();
                args.add(q);
                args.addAll(neu.arguments());
                neu = (New)neu.arguments(args);
            }
            return neu;
        }
        if (n instanceof ConstructorCall) {
            ArrayList<Copy> args;
            boolean fixCI;
            ConstructorCall cc = (ConstructorCall)n;
            if (cc.kind() != ConstructorCall.SUPER) {
                return cc;
            }
            ConstructorInstance ci = cc.constructorInstance();
            ClassType ct = ci.container().toClass();
            if (cc.qualifier() == null) {
                return cc;
            }
            Expr q = cc.qualifier();
            cc = cc.qualifier(null);
            ConstructorInstance cidecl = (ConstructorInstance)ci.declaration();
            boolean bl = fixCI = cc.arguments().size() + 1 != ci.formalTypes().size();
            if (ci != cidecl && fixCI) {
                args = new ArrayList();
                args.add(ci.container());
                args.addAll(ci.formalTypes());
                ci = ci.formalTypes(args);
                cc = cc.constructorInstance(ci);
            }
            args = new ArrayList<Copy>();
            args.add(q);
            args.addAll(cc.arguments());
            cc = (ConstructorCall)cc.arguments(args);
            return cc;
        }
        if (n instanceof ClassDecl) {
            ClassDecl cd = (ClassDecl)n;
            if (cd.type().isMember() && !cd.type().flags().isStatic()) {
                cd.type().flags(cd.type().flags().Static());
                cd = cd.flags(cd.type().flags());
                ClassType ct = (ClassType)cd.type().container();
                FieldInstance fi = this.boxThis(cd.type(), ct);
                cd = InnerClassRemover.addFieldsToClass(cd, Collections.singletonList(fi), this.ts, this.nf, true);
                cd = this.fixQualifiers(cd);
            }
            return cd;
        }
        return n;
    }

    public ClassDecl fixQualifiers(ClassDecl cd) {
        return (ClassDecl)cd.visitChildren(new NodeVisitor(){
            LocalInstance li;

            public Node override(Node parent, Node n) {
                if (n instanceof ClassBody) {
                    return null;
                }
                if (n instanceof ConstructorDecl) {
                    return null;
                }
                if (parent instanceof ConstructorDecl && n instanceof Formal) {
                    Formal f = (Formal)n;
                    LocalInstance li = f.localInstance();
                    if (li.name().equals(InnerClassRemover.OUTER_FIELD_NAME)) {
                        this.li = li;
                    }
                    return n;
                }
                if (parent instanceof ConstructorDecl && n instanceof Block) {
                    return null;
                }
                if (parent instanceof Block && n instanceof ConstructorCall) {
                    return null;
                }
                if (parent instanceof ConstructorCall) {
                    return null;
                }
                return n;
            }

            public Node leave(Node parent, Node old, Node n, NodeVisitor v) {
                if (parent instanceof ConstructorCall && this.li != null && n instanceof Expr) {
                    return InnerClassRemover.this.fixQualifier((Expr)n, this.li);
                }
                return n;
            }
        });
    }

    public Expr fixQualifier(Expr e, final LocalInstance li) {
        return (Expr)e.visit(new NodeVisitor(){

            public Node leave(Node old, Node n, NodeVisitor v) {
                Special s;
                Field f;
                if (n instanceof Field && (f = (Field)n).target() instanceof Special && (s = (Special)f.target()).kind() == Special.THIS && f.name().equals(InnerClassRemover.OUTER_FIELD_NAME)) {
                    FieldInstance fi = f.fieldInstance();
                    Local l = InnerClassRemover.this.nf.Local(n.position(), f.id());
                    l = l.localInstance(li);
                    l = (Local)l.type(li.type());
                    return l;
                }
                return n;
            }
        });
    }

    public static ClassDecl addFieldsToClass(ClassDecl cd, List newFields, TypeSystem ts, NodeFactory nf, boolean rewriteMembers) {
        if (newFields.isEmpty()) {
            return cd;
        }
        ClassBody b = cd.body();
        ArrayList<Term> newMembers = new ArrayList<Term>();
        Iterator i = newFields.iterator();
        while (i.hasNext()) {
            FieldInstance fi = (FieldInstance)i.next();
            Position pos = fi.position();
            FieldDecl fd = nf.FieldDecl(pos, fi.flags(), (TypeNode)nf.CanonicalTypeNode(pos, fi.type()), nf.Id(pos, fi.name()));
            fd = fd.fieldInstance(fi);
            newMembers.add(fd);
        }
        i = b.members().iterator();
        while (i.hasNext()) {
            ClassMember m = (ClassMember)i.next();
            if (m instanceof ConstructorDecl) {
                Eval e;
                ConstructorDecl td = (ConstructorDecl)m;
                ArrayList<Formal> formals = new ArrayList<Formal>();
                ArrayList<LocalInstance> locals = new ArrayList<LocalInstance>();
                Iterator j = newFields.iterator();
                while (j.hasNext()) {
                    FieldInstance fi = (FieldInstance)j.next();
                    Position pos = fi.position();
                    LocalInstance li = ts.localInstance(pos, Flags.FINAL, fi.type(), fi.name());
                    li.setNotConstant();
                    Formal formal = nf.Formal(pos, li.flags(), (TypeNode)nf.CanonicalTypeNode(pos, li.type()), nf.Id(pos, li.name()));
                    formal = formal.localInstance(li);
                    formals.add(formal);
                    locals.add(li);
                }
                ArrayList<Formal> newFormals = new ArrayList<Formal>();
                newFormals.addAll(formals);
                newFormals.addAll(td.formals());
                td = td.formals(newFormals);
                ArrayList<Stmt> statements = new ArrayList<Stmt>();
                for (int j2 = 0; j2 < newFields.size(); ++j2) {
                    FieldInstance fi = (FieldInstance)newFields.get(j2);
                    LocalInstance li = ((Formal)formals.get(j2)).localInstance();
                    Position pos = fi.position();
                    Field f = nf.Field(pos, (Receiver)nf.This(pos).type(fi.container()), nf.Id(pos, fi.name()));
                    f = (Field)f.type(fi.type());
                    f = f.fieldInstance(fi);
                    f = f.targetImplicit(false);
                    Local l = nf.Local(pos, nf.Id(pos, li.name()));
                    l = (Local)l.type(li.type());
                    l = l.localInstance(li);
                    Assign a = nf.FieldAssign(pos, f, Assign.ASSIGN, l);
                    a = (Assign)a.type(li.type());
                    e = nf.Eval(pos, a);
                    statements.add(e);
                }
                Block block = td.body();
                if (block.statements().size() > 0) {
                    Stmt s0 = (Stmt)block.statements().get(0);
                    if (s0 instanceof ConstructorCall) {
                        ConstructorCall cc = (ConstructorCall)s0;
                        ConstructorInstance ci = cc.constructorInstance();
                        if (cc.kind() == ConstructorCall.THIS) {
                            ArrayList<Expr> arguments = new ArrayList<Expr>();
                            Iterator j3 = statements.iterator();
                            while (j3.hasNext()) {
                                Stmt si = (Stmt)j3.next();
                                e = (Eval)si;
                                Assign a = (Assign)e.expr();
                                arguments.add(a.right());
                            }
                            if (ci != ci.declaration()) {
                                ArrayList<Type> newFormalTypes = new ArrayList<Type>();
                                for (int j4 = 0; j4 < newFields.size(); ++j4) {
                                    FieldInstance fi = (FieldInstance)newFields.get(j4);
                                    newFormalTypes.add(fi.type());
                                }
                                newFormalTypes.addAll(ci.formalTypes());
                                ci.setFormalTypes(newFormalTypes);
                            }
                            arguments.addAll(cc.arguments());
                            cc = (ConstructorCall)cc.arguments(arguments);
                        }
                        statements.add(0, cc);
                    }
                    statements.addAll(block.statements().subList(1, block.statements().size()));
                } else {
                    statements.addAll(block.statements());
                }
                block = block.statements(statements);
                td = (ConstructorDecl)td.body(block);
                newMembers.add(td);
                ArrayList<Type> newFormalTypes = new ArrayList<Type>();
                Iterator j5 = newFormals.iterator();
                while (j5.hasNext()) {
                    Formal f = (Formal)j5.next();
                    newFormalTypes.add(f.declType());
                }
                ConstructorInstance ci = td.constructorInstance();
                if (!$assertionsDisabled && ci.declaration() != ci) {
                    throw new AssertionError();
                }
                ci.setFormalTypes(newFormalTypes);
                continue;
            }
            newMembers.add(m);
        }
        b = b.members(newMembers);
        return cd.body(b);
    }

    List addArgs(ProcedureCall n, ConstructorInstance nci, Expr q) {
        if (nci == null || q == null) {
            return n.arguments();
        }
        ArrayList<Expr> args = new ArrayList<Expr>();
        args.add(q);
        args.addAll(n.arguments());
        if (!$assertionsDisabled && args.size() != nci.formalTypes().size()) {
            throw new AssertionError();
        }
        return args;
    }

    private FieldInstance boxThis(ClassType currClass, ClassType outerClass) {
        FieldInstance fi = (FieldInstance)this.outerFieldInstance.get(currClass);
        if (fi != null) {
            return fi;
        }
        Position pos = outerClass.position();
        fi = this.ts.fieldInstance(pos, currClass, Flags.FINAL.Private(), outerClass, OUTER_FIELD_NAME);
        fi.setNotConstant();
        ParsedClassType currDecl = (ParsedClassType)currClass.declaration();
        currDecl.addField(fi);
        this.outerFieldInstance.put(currDecl, fi);
        return fi;
    }

    public static Object hashGet(Map map, Object k, Object v) {
        return LocalClassRemover.hashGet(map, k, v);
    }

    static {
        $assertionsDisabled = !InnerClassRemover.class.desiredAssertionStatus();
    }
}

