/*
 * Decompiled with CFR 0.152.
 */
package polyglot.visit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import polyglot.ast.Node;
import polyglot.ast.Term;
import polyglot.types.Type;
import polyglot.util.CollectionUtil;
import polyglot.util.IdentityKey;
import polyglot.visit.DataFlow;

public class FlowGraph {
    protected Map peerMap;
    protected Term root;
    protected boolean forward;
    public static final EdgeKey EDGE_KEY_TRUE = new EdgeKey("true");
    public static final EdgeKey EDGE_KEY_FALSE = new EdgeKey("false");
    public static final EdgeKey EDGE_KEY_OTHER = new EdgeKey("");

    FlowGraph(Term root, boolean forward) {
        this.root = root;
        this.forward = forward;
        this.peerMap = new HashMap();
    }

    public Term root() {
        return this.root;
    }

    public boolean forward() {
        return this.forward;
    }

    public Collection entryPeers() {
        return this.peers(this.root, 1);
    }

    public Collection exitPeers() {
        return this.peers(this.root, 0);
    }

    public Collection startPeers() {
        return this.forward ? this.entryPeers() : this.exitPeers();
    }

    public Collection finishPeers() {
        return this.forward ? this.exitPeers() : this.entryPeers();
    }

    public Collection pathMaps() {
        return this.peerMap.values();
    }

    public Map pathMap(Node n) {
        return (Map)this.peerMap.get(new IdentityKey(n));
    }

    public Collection peers() {
        ArrayList c = new ArrayList();
        Iterator i = this.peerMap.values().iterator();
        while (i.hasNext()) {
            Map m = (Map)i.next();
            Iterator j = m.values().iterator();
            while (j.hasNext()) {
                c.add(j.next());
            }
        }
        return c;
    }

    public Peer peer(Term n, int entry) {
        return this.peer(n, Collections.EMPTY_LIST, entry);
    }

    public Collection peers(Term n, int entry) {
        IdentityKey k = new IdentityKey(n);
        Map pathMap = (Map)this.peerMap.get(k);
        if (pathMap == null) {
            return Collections.EMPTY_LIST;
        }
        Collection peers = pathMap.values();
        ArrayList<Peer> l = new ArrayList<Peer>(peers.size());
        Iterator i = peers.iterator();
        while (i.hasNext()) {
            Peer p = (Peer)i.next();
            if (p.entry != entry) continue;
            l.add(p);
        }
        return l;
    }

    public Peer peer(Term n, List path_to_finally, int entry) {
        PeerKey lk;
        Peer p;
        IdentityKey k = new IdentityKey(n);
        HashMap<PeerKey, Peer> pathMap = (HashMap<PeerKey, Peer>)this.peerMap.get(k);
        if (pathMap == null) {
            pathMap = new HashMap<PeerKey, Peer>();
            this.peerMap.put(k, pathMap);
        }
        if ((p = (Peer)pathMap.get(lk = new PeerKey(path_to_finally, entry))) == null) {
            p = new Peer(n, path_to_finally, entry);
            pathMap.put(lk, p);
        }
        return p;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        Set todo = new HashSet(this.peers());
        LinkedList<Peer> queue = new LinkedList<Peer>(this.startPeers());
        while (!queue.isEmpty()) {
            Peer p = (Peer)queue.removeFirst();
            todo.remove(p);
            sb.append(p.node + " (" + p.node.position() + ")\n");
            Iterator i = p.succs.iterator();
            while (i.hasNext()) {
                Edge e = (Edge)i.next();
                Peer q = e.getTarget();
                sb.append("    -> " + q.node + " (" + q.node.position() + ")\n");
                if (!todo.contains(q) || queue.contains(q)) continue;
                queue.addLast(q);
            }
            if (!queue.isEmpty() || todo.isEmpty()) continue;
            sb.append("\n\n***UNREACHABLE***\n");
            queue.addAll(todo);
            todo = Collections.EMPTY_SET;
        }
        return sb.toString();
    }

    protected static class PeerKey {
        protected List list;
        protected int entry;

        public PeerKey(List list, int entry) {
            this.list = list;
            this.entry = entry;
        }

        public int hashCode() {
            return ((Object)this.list).hashCode() ^ this.entry;
        }

        public boolean equals(Object other) {
            if (other instanceof PeerKey) {
                PeerKey k = (PeerKey)other;
                return CollectionUtil.equals(this.list, k.list) && this.entry == k.entry;
            }
            return false;
        }
    }

    public static class Peer {
        protected DataFlow.Item inItem;
        protected Map outItems;
        protected Term node;
        protected List succs;
        protected List preds;
        protected List path_to_finally;
        protected int entry;
        private Set succEdgeKeys;

        public Peer(Term node, List path_to_finally, int entry) {
            this.node = node;
            this.path_to_finally = path_to_finally;
            this.inItem = null;
            this.outItems = null;
            this.succs = new ArrayList();
            this.preds = new ArrayList();
            this.entry = entry;
            this.succEdgeKeys = null;
        }

        public List succs() {
            return this.succs;
        }

        public List preds() {
            return this.preds;
        }

        public Term node() {
            return this.node;
        }

        public DataFlow.Item inItem() {
            return this.inItem;
        }

        public DataFlow.Item outItem(EdgeKey key) {
            return (DataFlow.Item)this.outItems.get(key);
        }

        public String toString() {
            return (this.entry == 1 ? "entry: " : "") + this.node + this.path_to_finally;
        }

        public Set succEdgeKeys() {
            if (this.succEdgeKeys == null) {
                this.succEdgeKeys = new HashSet();
                Iterator iter = this.succs.iterator();
                while (iter.hasNext()) {
                    Edge e = (Edge)iter.next();
                    this.succEdgeKeys.add(e.getKey());
                }
                if (this.succEdgeKeys.isEmpty()) {
                    this.succEdgeKeys.add(EDGE_KEY_OTHER);
                }
            }
            return this.succEdgeKeys;
        }
    }

    public static class Edge {
        protected EdgeKey key;
        protected Peer target;

        protected Edge(EdgeKey key, Peer target) {
            this.key = key;
            this.target = target;
        }

        public EdgeKey getKey() {
            return this.key;
        }

        public Peer getTarget() {
            return this.target;
        }

        public String toString() {
            return "(" + this.key + ")" + this.target;
        }
    }

    public static class ExceptionEdgeKey
    extends EdgeKey {
        public ExceptionEdgeKey(Type t) {
            super(t);
        }

        public Type type() {
            return (Type)this.o;
        }

        public String toString() {
            return this.type().isClass() ? this.type().toClass().name() : ((Object)this.type()).toString();
        }
    }

    public static class EdgeKey {
        protected Object o;

        protected EdgeKey(Object o) {
            this.o = o;
        }

        public int hashCode() {
            return this.o.hashCode();
        }

        public boolean equals(Object other) {
            return other instanceof EdgeKey && ((EdgeKey)other).o.equals(this.o);
        }

        public String toString() {
            return this.o.toString();
        }
    }
}

