/*
 * Decompiled with CFR 0.152.
 */
package polyglot.util.typedump;

import java.io.IOException;
import polyglot.frontend.ExtensionInfo;
import polyglot.types.TypeSystem;
import polyglot.util.CodeWriter;
import polyglot.util.OptimalCodeWriter;
import polyglot.util.typedump.TypeDumper;

public class Main {
    public static void main(String[] args) {
        String extension = "jl";
        if (args.length == 3 && args[0].equals("-ext")) {
            extension = args[1];
        }
        if (extension == null && args.length != 1 || extension != null && args.length != 3) {
            System.err.println("Usage: polyglot.util.typedump.Main [-ext <extension>] <classname>");
            System.exit(1);
        }
        String className = extension == null ? args[0] : args[2];
        ExtensionInfo extInfo = null;
        String extClassName = "polyglot.ext." + extension + ".ExtensionInfo";
        Class<?> extClass = null;
        try {
            extClass = Class.forName(extClassName);
        }
        catch (ClassNotFoundException e) {
            System.err.println("Extension " + extension + " not found: could not find class " + extClassName + ".");
            System.exit(1);
        }
        try {
            extInfo = (ExtensionInfo)extClass.newInstance();
        }
        catch (Exception e) {
            System.err.println("Extension " + extension + " could not be loaded: " + "could not instantiate " + extClassName + ".");
            System.exit(1);
        }
        try {
            TypeSystem ts = extInfo.typeSystem();
            TypeDumper t = TypeDumper.load(className, ts);
            OptimalCodeWriter cw = new OptimalCodeWriter(System.out, 72);
            t.dump(cw);
            cw.newline(0);
            try {
                ((CodeWriter)cw).flush();
            }
            catch (IOException exn) {
                System.err.println(exn.getMessage());
            }
        }
        catch (IOException exn) {
            System.err.println("IO errors.");
            System.err.println(exn.getMessage());
        }
        catch (ClassNotFoundException exn) {
            System.err.println("Could not load .class: " + className);
            System.err.println(exn.getMessage());
        }
        catch (NoSuchFieldException exn) {
            System.err.println("Could not reflect jlc fields");
            System.err.println(exn.getMessage());
        }
        catch (SecurityException exn) {
            System.err.println("Security policy error.");
            System.err.println(exn.getMessage());
        }
    }
}

