/*
 * Decompiled with CFR 0.152.
 */
package polyglot.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import polyglot.main.Report;
import polyglot.types.Named;
import polyglot.types.NamedPlaceHolder;
import polyglot.types.PlaceHolder;
import polyglot.types.TypeObject;
import polyglot.types.TypeSystem;
import polyglot.util.CannotResolvePlaceHolderException;
import polyglot.util.Internable;
import polyglot.util.InternalCompilerError;

public class TypeInputStream
extends ObjectInputStream {
    protected TypeSystem ts;
    protected Map cache;
    protected boolean failed;
    protected boolean enableReplace;
    protected Set placeHoldersUsed;
    private static final Object UNRESOLVED = new Object();

    public TypeInputStream(InputStream in, TypeSystem ts, Map cache) throws IOException {
        super(in);
        this.enableResolveObject(true);
        this.ts = ts;
        this.cache = cache;
        this.failed = false;
        this.enableReplace = true;
        this.placeHoldersUsed = new HashSet();
    }

    public Set placeHoldersUsed() {
        return this.placeHoldersUsed;
    }

    public boolean deserializationFailed() {
        return this.failed;
    }

    public TypeSystem getTypeSystem() {
        return this.ts;
    }

    public void installInPlaceHolderCache(PlaceHolder p, TypeObject t) {
        this.cache.put(p, t);
        if (t instanceof Named && p instanceof NamedPlaceHolder) {
            NamedPlaceHolder pp = (NamedPlaceHolder)p;
            if (Report.should_report("serialize", 2)) {
                Report.report(2, "Forcing " + pp.name() + " into system resolver");
            }
            this.ts.systemResolver().install(pp.name(), (Named)t);
        }
        String s = "";
        if (Report.should_report("serialize", 2)) {
            try {
                s = t.toString();
            }
            catch (NullPointerException e) {
                s = "<NullPointerException thrown>";
            }
        }
        if (Report.should_report("serialize", 2)) {
            Report.report(2, "- Installing " + p + " -> " + s + " in place holder cache");
        }
    }

    public void enableReplace(boolean f) {
        this.enableReplace = f;
    }

    protected Object resolveObject(Object o) {
        if (!this.enableReplace) {
            return o;
        }
        String s = "";
        if (Report.should_report("serialize", 2)) {
            try {
                s = o.toString();
            }
            catch (NullPointerException e) {
                s = "<NullPointerException thrown>";
            }
        }
        if (!this.enableReplace) {
            return o;
        }
        if (o instanceof PlaceHolder) {
            Object t;
            block18: {
                if (this.failed) {
                    return null;
                }
                this.placeHoldersUsed.add(o);
                t = this.cache.get(o);
                if (t == UNRESOLVED) {
                    this.failed = true;
                    return null;
                }
                if (t == null) {
                    try {
                        this.cache.put(o, UNRESOLVED);
                        t = ((PlaceHolder)o).resolve(this.ts);
                        if (t == null) {
                            throw new InternalCompilerError("Resolved " + s + " to null.");
                        }
                        this.cache.put(o, t);
                        if (Report.should_report("serialize", 2)) {
                            Report.report(2, "- Resolving " + s + " : " + o.getClass() + " to " + t + " : " + t.getClass());
                        }
                        break block18;
                    }
                    catch (CannotResolvePlaceHolderException e) {
                        this.failed = true;
                        if (Report.should_report("serialize", 2)) {
                            Report.report(2, "- Resolving " + s + " : " + o.getClass() + " to " + e);
                        }
                        break block18;
                    }
                }
                if (Report.should_report("serialize", 2)) {
                    Report.report(2, "- Resolving " + s + " : " + o.getClass() + " to (cached) " + t + " : " + t.getClass());
                }
            }
            return t;
        }
        if (o instanceof Internable) {
            if (Report.should_report("serialize", 2)) {
                Report.report(2, "- Interning " + s + " : " + o.getClass());
            }
            return ((Internable)o).intern();
        }
        if (Report.should_report("serialize", 2)) {
            Report.report(2, "- " + s + " : " + o.getClass());
        }
        return o;
    }
}

