/*
 * Decompiled with CFR 0.152.
 */
package polyglot.types;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import polyglot.types.MethodInstance;
import polyglot.types.ReferenceType;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.types.Type_c;
import polyglot.util.Position;

public abstract class ReferenceType_c
extends Type_c
implements ReferenceType {
    protected ReferenceType_c() {
    }

    public ReferenceType_c(TypeSystem ts) {
        this(ts, null);
    }

    public ReferenceType_c(TypeSystem ts, Position pos) {
        super(ts, pos);
    }

    public boolean isReference() {
        return true;
    }

    public ReferenceType toReference() {
        return this;
    }

    public List members() {
        ArrayList l = new ArrayList();
        l.addAll(this.methods());
        l.addAll(this.fields());
        return l;
    }

    public abstract List methods();

    public abstract List fields();

    public abstract Type superType();

    public abstract List interfaces();

    public final boolean hasMethod(MethodInstance mi) {
        return this.ts.hasMethod(this, mi);
    }

    public boolean hasMethodImpl(MethodInstance mi) {
        Iterator j = this.methods().iterator();
        while (j.hasNext()) {
            MethodInstance mj = (MethodInstance)j.next();
            if (!this.ts.isSameMethod(mi, mj)) continue;
            return true;
        }
        return false;
    }

    public boolean descendsFromImpl(Type ancestor) {
        if (!ancestor.isCanonical()) {
            return false;
        }
        if (ancestor.isNull()) {
            return false;
        }
        if (this.ts.typeEquals(this, ancestor)) {
            return false;
        }
        if (!ancestor.isReference()) {
            return false;
        }
        if (this.ts.typeEquals(ancestor, this.ts.Object())) {
            return true;
        }
        Iterator i = this.interfaces().iterator();
        while (i.hasNext()) {
            Type parentType = (Type)i.next();
            if (!this.ts.isSubtype(parentType, ancestor)) continue;
            return true;
        }
        return false;
    }

    public boolean isImplicitCastValidImpl(Type toType) {
        return this.ts.isSubtype(this, toType);
    }

    public List methodsNamed(String name) {
        LinkedList<MethodInstance> l = new LinkedList<MethodInstance>();
        Iterator i = this.methods().iterator();
        while (i.hasNext()) {
            MethodInstance mi = (MethodInstance)i.next();
            if (!mi.name().equals(name)) continue;
            l.add(mi);
        }
        return l;
    }

    public List methods(String name, List argTypes) {
        LinkedList<MethodInstance> l = new LinkedList<MethodInstance>();
        Iterator i = this.methodsNamed(name).iterator();
        while (i.hasNext()) {
            MethodInstance mi = (MethodInstance)i.next();
            if (!mi.hasFormals(argTypes)) continue;
            l.add(mi);
        }
        return l;
    }

    public boolean isCastValidImpl(Type toType) {
        if (!toType.isReference()) {
            return false;
        }
        return this.ts.isSubtype(this, toType) || this.ts.isSubtype(toType, this);
    }
}

