/*
 * Decompiled with CFR 0.152.
 */
package polyglot.types;

import java.io.InvalidClassException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import polyglot.frontend.SchedulerException;
import polyglot.main.Report;
import polyglot.main.Version;
import polyglot.types.BadSerializationException;
import polyglot.types.ClassType;
import polyglot.types.ConstructorInstance;
import polyglot.types.FieldInstance;
import polyglot.types.LazyClassInitializer;
import polyglot.types.LazyInitializer;
import polyglot.types.MethodInstance;
import polyglot.types.Named;
import polyglot.types.NoClassException;
import polyglot.types.ParsedClassType;
import polyglot.types.SemanticException;
import polyglot.types.SystemResolver;
import polyglot.types.TopLevelResolver;
import polyglot.types.TypeObject;
import polyglot.types.TypeSystem;
import polyglot.types.reflect.ClassFile;
import polyglot.types.reflect.ClassFileLoader;
import polyglot.types.reflect.ClassPathLoader;
import polyglot.util.CollectionUtil;
import polyglot.util.InternalCompilerError;
import polyglot.util.ObjectDumper;
import polyglot.util.SimpleCodeWriter;
import polyglot.util.TypeEncoder;

public class LoadedClassResolver
implements TopLevelResolver {
    protected static final int NOT_COMPATIBLE = -1;
    protected static final int MINOR_NOT_COMPATIBLE = 1;
    protected static final int COMPATIBLE = 0;
    protected TypeSystem ts;
    protected TypeEncoder te;
    protected ClassPathLoader loader;
    protected Version version;
    protected Set nocache;
    protected boolean allowRawClasses;
    protected static final Collection report_topics = CollectionUtil.list("types", "resolver", "loader");
    protected boolean recursive = false;

    public LoadedClassResolver(TypeSystem ts, String classpath, ClassFileLoader loader, Version version, boolean allowRawClasses) {
        this.ts = ts;
        this.te = new TypeEncoder(ts);
        this.loader = new ClassPathLoader(classpath, loader);
        this.version = version;
        this.nocache = new HashSet();
        this.allowRawClasses = allowRawClasses;
    }

    public boolean allowRawClasses() {
        return this.allowRawClasses;
    }

    public boolean packageExists(String name) {
        return this.loader.packageExists(name);
    }

    protected ClassFile loadFile(String name) {
        block6: {
            if (this.nocache.contains(name)) {
                return null;
            }
            try {
                ClassFile clazz = this.loader.loadClass(name);
                if (clazz == null) {
                    if (Report.should_report(report_topics, 4)) {
                        Report.report(4, "Class " + name + " not found in classpath " + this.loader.classpath());
                    }
                    break block6;
                }
                if (Report.should_report(report_topics, 4)) {
                    Report.report(4, "Class " + name + " found in classpath " + this.loader.classpath());
                }
                return clazz;
            }
            catch (ClassFormatError e) {
                if (!Report.should_report(report_topics, 4)) break block6;
                Report.report(4, "Class " + name + " format error");
            }
        }
        this.nocache.add(name);
        return null;
    }

    public Named find(String name) throws SemanticException {
        if (Report.should_report(report_topics, 3)) {
            Report.report(3, "LoadedCR.find(" + name + ")");
        }
        Named result = null;
        ClassFile clazz = this.loadFile(name);
        if (clazz == null) {
            throw new NoClassException(name);
        }
        if (clazz.encodedClassType(this.version.name()) != null) {
            if (Report.should_report(report_topics, 4)) {
                Report.report(4, "Using encoded class type for " + name);
            }
            result = this.getEncodedType(clazz, name);
        }
        if (this.allowRawClasses) {
            if (Report.should_report(report_topics, 4)) {
                Report.report(4, "Using raw class file for " + name);
            }
            result = this.ts.classFileLazyClassInitializer(clazz).type();
        }
        if (result != null) {
            if (name.equals(result.fullName())) {
                return result;
            }
            if (result instanceof ClassType && name.equals(this.ts.getTransformedClassName((ClassType)result))) {
                return result;
            }
        }
        throw new SemanticException("Unable to find a suitable definition of \"" + name + "\". A class file was found," + " but it did not contain appropriate information for this" + " language extension. If the source for this file is written" + " in the language extension, try recompiling the source code.");
    }

    protected ClassType getEncodedType(ClassFile clazz, String name) throws SemanticException {
        block29: {
            ClassType classType;
            SystemResolver oldResolver;
            block31: {
                block30: {
                    int comp = this.checkCompilerVersion(clazz.compilerVersion(this.version.name()));
                    if (comp == -1) {
                        throw new SemanticException("Unable to find a suitable definition of " + clazz.name() + ". Try recompiling or obtaining " + " a newer version of the class file.");
                    }
                    oldResolver = null;
                    if (Report.should_report("serialize", 1)) {
                        Report.report(1, "Saving system resolver");
                    }
                    oldResolver = this.ts.saveSystemResolver();
                    boolean okay = false;
                    boolean oldRecursive = this.recursive;
                    if (!this.recursive) {
                        this.ts.systemResolver().clearAdded();
                    }
                    this.recursive = true;
                    try {
                        TypeObject dt;
                        try {
                            if (Report.should_report("serialize", 1)) {
                                Report.report(1, "Decoding " + name + " in " + clazz);
                            }
                            if ((dt = this.te.decode(clazz.encodedClassType(this.version.name()), name)) == null) {
                                if (Report.should_report("serialize", 1)) {
                                    Report.report(1, "* Decoding " + name + " failed");
                                }
                                throw new SchedulerException("Could not decode " + name);
                            }
                        }
                        catch (InternalCompilerError e) {
                            throw e;
                        }
                        catch (InvalidClassException e) {
                            throw new BadSerializationException(clazz.name() + "@" + clazz.getClassFileLocation());
                        }
                        if (!(dt instanceof ClassType)) break block29;
                        ClassType ct = (ClassType)dt;
                        this.ts.systemResolver().addNamed(name, ct);
                        if (Report.should_report("serialize", 1)) {
                            Report.report(1, "* Decoding " + name + " succeeded");
                        }
                        if (Report.should_report("typedump", 1)) {
                            new ObjectDumper(new SimpleCodeWriter(System.out, 72)).dump(dt);
                        }
                        if (Report.should_report("serialize", 2)) {
                            ParsedClassType pct;
                            LazyInitializer init = null;
                            if (ct instanceof ParsedClassType) {
                                pct = (ParsedClassType)ct;
                                init = pct.initializer();
                                pct.setInitializer(new LazyClassInitializer(){

                                    public boolean fromClassFile() {
                                        return false;
                                    }

                                    public void setClass(ParsedClassType ct) {
                                    }

                                    public void initTypeObject() {
                                    }

                                    public boolean isTypeObjectInitialized() {
                                        return true;
                                    }

                                    public void initSuperclass() {
                                    }

                                    public void initInterfaces() {
                                    }

                                    public void initMemberClasses() {
                                    }

                                    public void initConstructors() {
                                    }

                                    public void initMethods() {
                                    }

                                    public void initFields() {
                                    }

                                    public void canonicalConstructors() {
                                    }

                                    public void canonicalMethods() {
                                    }

                                    public void canonicalFields() {
                                    }
                                });
                            }
                            Iterator i = ct.methods().iterator();
                            while (i.hasNext()) {
                                MethodInstance mi = (MethodInstance)i.next();
                                Report.report(2, "* " + mi);
                            }
                            i = ct.fields().iterator();
                            while (i.hasNext()) {
                                FieldInstance fi = (FieldInstance)i.next();
                                Report.report(2, "* " + fi);
                            }
                            i = ct.constructors().iterator();
                            while (i.hasNext()) {
                                ConstructorInstance ci = (ConstructorInstance)i.next();
                                Report.report(2, "* " + ci);
                            }
                            if (ct instanceof ParsedClassType) {
                                pct = (ParsedClassType)ct;
                                pct.setInitializer(init);
                            }
                        }
                        if (Report.should_report(report_topics, 2)) {
                            Report.report(2, "Returning serialized ClassType for " + clazz.name() + ".");
                        }
                        okay = true;
                        classType = ct;
                        Object var14_14 = null;
                        this.recursive = oldRecursive;
                        if (!okay) break block30;
                    }
                    catch (Throwable throwable) {
                        Object var14_15 = null;
                        this.recursive = oldRecursive;
                        if (okay) {
                            if (Report.should_report("serialize", 1)) {
                                Report.report(1, "Deserialization successful.  Installing " + this.ts.systemResolver().justAdded() + " into restored system resolver.");
                            }
                            oldResolver.putAll(this.ts.systemResolver());
                        } else {
                            if (Report.should_report("serialize", 1)) {
                                Report.report(1, "Deserialization failed.  Restoring previous system resolver.");
                            }
                            if (Report.should_report("serialize", 1)) {
                                Report.report(1, "Discarding " + this.ts.systemResolver().justAdded());
                            }
                        }
                        this.ts.restoreSystemResolver(oldResolver);
                        throw throwable;
                    }
                    if (Report.should_report("serialize", 1)) {
                        Report.report(1, "Deserialization successful.  Installing " + this.ts.systemResolver().justAdded() + " into restored system resolver.");
                    }
                    oldResolver.putAll(this.ts.systemResolver());
                    break block31;
                }
                if (Report.should_report("serialize", 1)) {
                    Report.report(1, "Deserialization failed.  Restoring previous system resolver.");
                }
                if (Report.should_report("serialize", 1)) {
                    Report.report(1, "Discarding " + this.ts.systemResolver().justAdded());
                }
            }
            this.ts.restoreSystemResolver(oldResolver);
            return classType;
        }
        throw new SemanticException("Class " + name + " not found in " + clazz.name() + ".");
    }

    protected int checkCompilerVersion(String clazzVersion) {
        if (clazzVersion == null) {
            return -1;
        }
        StringTokenizer st = new StringTokenizer(clazzVersion, ".");
        try {
            int v = Integer.parseInt(st.nextToken());
            Version version = this.version;
            if (v != version.major()) {
                return -1;
            }
            v = Integer.parseInt(st.nextToken());
            if (v != version.minor()) {
                return 1;
            }
        }
        catch (NumberFormatException e) {
            return -1;
        }
        return 0;
    }
}

