/*
 * Decompiled with CFR 0.152.
 */
package polyglot.types;

import polyglot.frontend.MissingDependencyException;
import polyglot.frontend.Scheduler;
import polyglot.frontend.goals.Goal;
import polyglot.types.FieldInstance;
import polyglot.types.Flags;
import polyglot.types.ReferenceType;
import polyglot.types.Type;
import polyglot.types.TypeObject;
import polyglot.types.TypeSystem;
import polyglot.types.VarInstance_c;
import polyglot.util.Position;

public class FieldInstance_c
extends VarInstance_c
implements FieldInstance {
    protected ReferenceType container;

    protected FieldInstance_c() {
    }

    public FieldInstance_c(TypeSystem ts, Position pos, ReferenceType container, Flags flags, Type type, String name) {
        super(ts, pos, flags, type, name);
        this.container = container;
    }

    public FieldInstance orig() {
        return (FieldInstance)this.declaration();
    }

    public FieldInstance flags(Flags flags) {
        if (!flags.equals(this.flags)) {
            FieldInstance n = (FieldInstance)this.copy();
            n.setFlags(flags);
            return n;
        }
        return this;
    }

    public FieldInstance name(String name) {
        if (name != null && !name.equals(this.name) || name == null && this.name != null) {
            FieldInstance n = (FieldInstance)this.copy();
            n.setName(name);
            return n;
        }
        return this;
    }

    public FieldInstance type(Type type) {
        if (this.type != type) {
            FieldInstance n = (FieldInstance)this.copy();
            n.setType(type);
            return n;
        }
        return this;
    }

    public FieldInstance container(ReferenceType container) {
        if (this.container != container) {
            FieldInstance_c n = (FieldInstance_c)this.copy();
            n.setContainer(container);
            return n;
        }
        return this;
    }

    public FieldInstance constantValue(Object constantValue) {
        if (!this.constantValueSet || constantValue != null && !constantValue.equals(this.constantValue) || constantValue == null && this.constantValue != null) {
            FieldInstance copy = (FieldInstance)this.copy();
            copy.setConstantValue(constantValue);
            return copy;
        }
        return this;
    }

    public FieldInstance notConstant() {
        if (!this.constantValueSet || this.isConstant) {
            FieldInstance copy = (FieldInstance)this.copy();
            copy.setNotConstant();
            return copy;
        }
        return this;
    }

    public ReferenceType container() {
        return this.container;
    }

    public boolean isConstant() {
        if (this != this.orig()) {
            return this.orig().isConstant();
        }
        if (!this.constantValueSet) {
            if (!this.flags.isFinal() || !this.type.isPrimitive() && !this.type.equals(this.ts.String())) {
                this.setNotConstant();
                return this.isConstant;
            }
            Scheduler scheduler = this.typeSystem().extensionInfo().scheduler();
            Goal g = scheduler.FieldConstantsChecked(this);
            throw new MissingDependencyException(g);
        }
        return this.isConstant;
    }

    public void setContainer(ReferenceType container) {
        this.container = container;
    }

    public boolean equalsImpl(TypeObject o) {
        if (o instanceof FieldInstance) {
            FieldInstance i = (FieldInstance)o;
            return super.equalsImpl(i) && this.ts.equals(this.container, i.container());
        }
        return false;
    }

    public String toString() {
        Object v = this.constantValue;
        if (v instanceof String) {
            String s = (String)v;
            if (s.length() > 8) {
                s = s.substring(0, 8) + "...";
            }
            v = "\"" + s + "\"";
        }
        return "field " + this.flags.translate() + this.type + " " + this.container + "." + this.name + (this.isConstant ? " = " + v : "");
    }

    public boolean isCanonical() {
        return this.container.isCanonical() && this.type.isCanonical();
    }
}

