/*
 * Decompiled with CFR 0.152.
 */
package polyglot.types;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import polyglot.main.Report;
import polyglot.types.Named;
import polyglot.types.NoClassException;
import polyglot.types.Resolver;
import polyglot.types.SemanticException;
import polyglot.types.SystemResolver;
import polyglot.util.CollectionUtil;
import polyglot.util.Copy;
import polyglot.util.InternalCompilerError;

public class CachingResolver
implements Resolver,
Copy {
    protected Resolver inner;
    private Map cache;
    private boolean cacheNotFound;
    private static final Collection TOPICS = CollectionUtil.list("types", "resolver");

    public CachingResolver(Resolver inner, boolean cacheNotFound) {
        this.inner = inner;
        this.cacheNotFound = cacheNotFound;
        this.cache = new HashMap();
    }

    public CachingResolver(Resolver inner) {
        this(inner, true);
    }

    protected boolean shouldReport(int level) {
        return Report.should_report("sysresolver", level) && this instanceof SystemResolver || Report.should_report(TOPICS, level);
    }

    public Object copy() {
        try {
            CachingResolver r = (CachingResolver)super.clone();
            r.cache = new HashMap(this.cache);
            return r;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalCompilerError("clone failed");
        }
    }

    public Resolver inner() {
        return this.inner;
    }

    public String toString() {
        return "(cache " + this.inner.toString() + ")";
    }

    protected Collection cachedObjects() {
        return this.cache.values();
    }

    public Named find(String name) throws SemanticException {
        Object o;
        if (this.shouldReport(2)) {
            Report.report(2, "CachingResolver: find: " + name);
        }
        if ((o = this.cache.get(name)) instanceof SemanticException) {
            throw (SemanticException)o;
        }
        Named q = (Named)o;
        if (q == null) {
            if (this.shouldReport(3)) {
                Report.report(3, "CachingResolver: not cached: " + name);
            }
            try {
                q = this.inner.find(name);
            }
            catch (NoClassException e) {
                if (this.shouldReport(3)) {
                    Report.report(3, "CachingResolver: " + e.getMessage());
                    Report.report(3, "CachingResolver: installing " + name + "-> (not found) in resolver cache");
                }
                if (this.cacheNotFound) {
                    this.cache.put(name, e);
                }
                throw e;
            }
            this.addNamed(name, q);
            if (this.shouldReport(3)) {
                Report.report(3, "CachingResolver: loaded: " + name);
            }
        } else if (this.shouldReport(3)) {
            Report.report(3, "CachingResolver: cached: " + name);
        }
        return q;
    }

    public Named check(String name) {
        Object o = this.cache.get(name);
        if (o instanceof Throwable) {
            return null;
        }
        return (Named)o;
    }

    public void install(String name, Named q) {
        if (this.shouldReport(3)) {
            Report.report(3, "CachingResolver: installing " + name + "->" + q + " in resolver cache");
        }
        if (this.shouldReport(5)) {
            new Exception().printStackTrace();
        }
        this.cache.put(name, q);
    }

    public void addNamed(String name, Named q) throws SemanticException {
        this.install(name, q);
    }

    public void dump() {
        Report.report(1, "Dumping " + this);
        Iterator i = this.cache.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            Report.report(2, e.toString());
        }
    }
}

