/*
 * Decompiled with CFR 0.152.
 */
package polyglot.frontend.goals;

import java.util.Collection;
import java.util.Iterator;
import polyglot.frontend.AbstractPass;
import polyglot.frontend.ExtensionInfo;
import polyglot.frontend.Job;
import polyglot.frontend.Pass;
import polyglot.frontend.Scheduler;
import polyglot.frontend.goals.AbstractGoal;
import polyglot.frontend.goals.Goal;

public abstract class Barrier
extends AbstractGoal {
    protected Scheduler scheduler;

    protected Barrier(Scheduler scheduler) {
        super(null);
        this.scheduler = scheduler;
    }

    protected Barrier(String name, Scheduler scheduler) {
        super(null, name);
        this.scheduler = scheduler;
    }

    public Collection jobs() {
        return this.scheduler.jobs();
    }

    public Pass createPass(ExtensionInfo extInfo) {
        return new BarrierPass(this.scheduler, this);
    }

    public abstract Goal goalForJob(Job var1);

    public String toString() {
        if (this.name == null) {
            return super.toString();
        }
        return this.name;
    }

    public int hashCode() {
        if (this.name == null) {
            return System.identityHashCode(this);
        }
        return this.name.hashCode();
    }

    public boolean equals(Object o) {
        if (this.name == null) {
            return this == o;
        }
        if (o instanceof Barrier) {
            Barrier b = (Barrier)o;
            return this.name.equals(b.name);
        }
        return false;
    }

    protected static class BarrierPass
    extends AbstractPass {
        public Scheduler scheduler;

        protected BarrierPass(Scheduler scheduler, Barrier barrier) {
            super(barrier);
            this.scheduler = scheduler;
        }

        public boolean run() {
            Barrier barrier = (Barrier)this.goal();
            Iterator i = barrier.jobs().iterator();
            while (i.hasNext()) {
                Job job = (Job)i.next();
                Goal subgoal = barrier.goalForJob(job);
                if (subgoal.hasBeenReached()) continue;
                this.scheduler.addDependencyAndEnqueue(barrier, subgoal, true);
                barrier.setUnreachableThisRun();
            }
            return true;
        }
    }
}

