/*
 * Decompiled with CFR 0.152.
 */
package polyglot.frontend;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import polyglot.frontend.Source;

public class FileSource
extends Source {
    protected final File file;
    protected Reader reader;

    public FileSource(File file) throws IOException {
        this(file, false);
    }

    public FileSource(File file, boolean userSpecified) throws IOException {
        super(file.getName(), userSpecified);
        this.file = file;
        if (!file.exists()) {
            throw new FileNotFoundException(file.getName());
        }
        this.path = file.getPath();
        this.lastModified = new Date(file.lastModified());
    }

    public boolean equals(Object o) {
        if (o instanceof FileSource) {
            FileSource s = (FileSource)o;
            return this.file.equals(s.file);
        }
        return false;
    }

    public int hashCode() {
        return this.file.getPath().hashCode();
    }

    public Reader open() throws IOException {
        if (this.reader == null) {
            FileInputStream str = new FileInputStream(this.file);
            this.reader = this.createReader(str);
        }
        return this.reader;
    }

    protected Reader createReader(InputStream str) {
        try {
            return new InputStreamReader(str, "US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
            this.reader = null;
        }
    }

    public String toString() {
        return this.file.getPath();
    }
}

