/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import polyglot.util.Enum;

public class Precedence
extends Enum {
    private int value;
    public static final Precedence LITERAL;
    public static final Precedence UNARY;
    public static final Precedence CAST;
    public static final Precedence MUL;
    public static final Precedence STRING_ADD;
    public static final Precedence ADD;
    public static final Precedence SHIFT;
    public static final Precedence RELATIONAL;
    public static final Precedence INSTANCEOF;
    public static final Precedence EQUAL;
    public static final Precedence BIT_AND;
    public static final Precedence BIT_XOR;
    public static final Precedence BIT_OR;
    public static final Precedence COND_AND;
    public static final Precedence COND_OR;
    public static final Precedence CONDITIONAL;
    public static final Precedence ASSIGN;
    public static final Precedence UNKNOWN;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Precedence(String name, int value) {
        super("prec_" + name);
        if (!$assertionsDisabled && value < 0) {
            throw new AssertionError();
        }
        this.value = value;
    }

    public int hashCode() {
        return this.value;
    }

    public boolean equals(Object o) {
        return o instanceof Precedence && this.equals((Precedence)o);
    }

    public boolean equals(Precedence p) {
        return this.value == p.value;
    }

    public boolean isTighter(Precedence p) {
        return this.value < p.value;
    }

    static {
        $assertionsDisabled = !Precedence.class.desiredAssertionStatus();
        LITERAL = new Precedence("literal", 0);
        UNARY = new Precedence("unary", 10);
        CAST = new Precedence("cast", 10);
        MUL = new Precedence("*", 20);
        STRING_ADD = new Precedence("string+", 30);
        ADD = new Precedence("+", 40);
        SHIFT = new Precedence("<<", 50);
        RELATIONAL = new Precedence("<", 60);
        INSTANCEOF = new Precedence("isa", 70);
        EQUAL = new Precedence("==", 80);
        BIT_AND = new Precedence("&", 90);
        BIT_XOR = new Precedence("^", 100);
        BIT_OR = new Precedence("|", 110);
        COND_AND = new Precedence("&&", 120);
        COND_OR = new Precedence("||", 130);
        CONDITIONAL = new Precedence("?:", 140);
        ASSIGN = new Precedence("=", 130);
        UNKNOWN = new Precedence("unknown", 999);
    }
}

