/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import polyglot.ast.AmbTypeNode;
import polyglot.ast.CanonicalTypeNode;
import polyglot.ast.ClassBody;
import polyglot.ast.Expr;
import polyglot.ast.Expr_c;
import polyglot.ast.New;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Precedence;
import polyglot.ast.ProcedureCall;
import polyglot.ast.Term;
import polyglot.ast.TypeNode;
import polyglot.types.ClassType;
import polyglot.types.ConstructorInstance;
import polyglot.types.Context;
import polyglot.types.Flags;
import polyglot.types.ParsedClassType;
import polyglot.types.ProcedureInstance;
import polyglot.types.ReferenceType;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.types.UnknownType;
import polyglot.util.CodeWriter;
import polyglot.util.CollectionUtil;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.util.TypedList;
import polyglot.visit.AmbiguityRemover;
import polyglot.visit.AscriptionVisitor;
import polyglot.visit.BodyDisambiguator;
import polyglot.visit.CFGBuilder;
import polyglot.visit.ConstantChecker;
import polyglot.visit.ExceptionChecker;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.PruningVisitor;
import polyglot.visit.SignatureDisambiguator;
import polyglot.visit.SupertypeDisambiguator;
import polyglot.visit.TypeBuilder;
import polyglot.visit.TypeChecker;

public class New_c
extends Expr_c
implements New {
    protected Expr qualifier;
    protected TypeNode tn;
    protected List arguments;
    protected ClassBody body;
    protected ConstructorInstance ci;
    protected ParsedClassType anonType;
    static final /* synthetic */ boolean $assertionsDisabled;

    public New_c(Position pos, Expr qualifier, TypeNode tn, List arguments, ClassBody body) {
        super(pos);
        if (!($assertionsDisabled || tn != null && arguments != null)) {
            throw new AssertionError();
        }
        this.qualifier = qualifier;
        this.tn = tn;
        this.arguments = TypedList.copyAndCheck(arguments, Expr.class, true);
        this.body = body;
    }

    public Expr qualifier() {
        return this.qualifier;
    }

    public New qualifier(Expr qualifier) {
        New_c n = (New_c)this.copy();
        n.qualifier = qualifier;
        return n;
    }

    public TypeNode objectType() {
        return this.tn;
    }

    public New objectType(TypeNode tn) {
        New_c n = (New_c)this.copy();
        n.tn = tn;
        return n;
    }

    public ParsedClassType anonType() {
        return this.anonType;
    }

    public New anonType(ParsedClassType anonType) {
        if (anonType == this.anonType) {
            return this;
        }
        New_c n = (New_c)this.copy();
        n.anonType = anonType;
        return n;
    }

    public ProcedureInstance procedureInstance() {
        return this.constructorInstance();
    }

    public ConstructorInstance constructorInstance() {
        return this.ci;
    }

    public New constructorInstance(ConstructorInstance ci) {
        if (ci == this.ci) {
            return this;
        }
        New_c n = (New_c)this.copy();
        n.ci = ci;
        return n;
    }

    public List arguments() {
        return this.arguments;
    }

    public ProcedureCall arguments(List arguments) {
        New_c n = (New_c)this.copy();
        n.arguments = TypedList.copyAndCheck(arguments, Expr.class, true);
        return n;
    }

    public ClassBody body() {
        return this.body;
    }

    public New body(ClassBody body) {
        New_c n = (New_c)this.copy();
        n.body = body;
        return n;
    }

    protected New_c reconstruct(Expr qualifier, TypeNode tn, List arguments, ClassBody body) {
        if (qualifier != this.qualifier || tn != this.tn || !CollectionUtil.equals(arguments, this.arguments) || body != this.body) {
            New_c n = (New_c)this.copy();
            n.tn = tn;
            n.qualifier = qualifier;
            n.arguments = TypedList.copyAndCheck(arguments, Expr.class, true);
            n.body = body;
            return n;
        }
        return this;
    }

    public Node visitChildren(NodeVisitor v) {
        Expr qualifier = (Expr)this.visitChild(this.qualifier, v);
        TypeNode tn = (TypeNode)this.visitChild(this.tn, v);
        List arguments = this.visitList(this.arguments, v);
        ClassBody body = (ClassBody)this.visitChild(this.body, v);
        return this.reconstruct(qualifier, tn, arguments, body);
    }

    public Context enterChildScope(Node child, Context c) {
        if (child == this.body && this.anonType != null && this.body != null) {
            c = c.pushClass(this.anonType, this.anonType);
        }
        return super.enterChildScope(child, c);
    }

    public NodeVisitor buildTypesEnter(TypeBuilder tb) throws SemanticException {
        if (this.body != null) {
            return tb.pushAnonClass(this.position());
        }
        return tb;
    }

    public Node buildTypes(TypeBuilder tb) throws SemanticException {
        New_c n = this;
        TypeSystem ts = tb.typeSystem();
        ArrayList<UnknownType> l = new ArrayList<UnknownType>(n.arguments.size());
        for (int i = 0; i < n.arguments.size(); ++i) {
            l.add(ts.unknownType(this.position()));
        }
        ConstructorInstance ci = ts.constructorInstance(this.position(), tb.currentClass(), Flags.NONE, l, Collections.EMPTY_LIST);
        if ((n = (New_c)n.constructorInstance(ci)).body() != null) {
            ParsedClassType type = tb.currentClass();
            n = (New_c)n.anonType(type);
            type.setMembersAdded(true);
        }
        return n.type(ts.unknownType(this.position()));
    }

    public Node disambiguateOverride(Node parent, AmbiguityRemover ar) throws SemanticException {
        ClassType ct;
        New nn = this;
        New_c old = nn;
        BodyDisambiguator bd = new BodyDisambiguator(ar);
        NodeVisitor childv = bd.enter(parent, this);
        if (childv instanceof PruningVisitor) {
            return nn;
        }
        BodyDisambiguator childbd = (BodyDisambiguator)childv;
        if (nn.qualifier() == null) {
            nn = nn.objectType((TypeNode)nn.visitChild(nn.objectType(), childbd));
            if (childbd.hasErrors()) {
                throw new SemanticException();
            }
            if (!nn.objectType().isDisambiguated()) {
                return nn;
            }
            ct = nn.objectType().type().toClass();
            if (ct.isMember() && !ct.flags().isStatic()) {
                nn = ((New_c)nn).findQualifier(ar, ct);
                nn = nn.qualifier((Expr)nn.visitChild(nn.qualifier(), childbd));
                if (childbd.hasErrors()) {
                    throw new SemanticException();
                }
            }
        } else {
            nn = nn.qualifier((Expr)nn.visitChild(nn.qualifier(), childbd));
            if (childbd.hasErrors()) {
                throw new SemanticException();
            }
            if (nn.objectType() instanceof AmbTypeNode && ((AmbTypeNode)nn.objectType()).qual() == null) {
                String name = ((AmbTypeNode)nn.objectType()).name();
                if (nn.qualifier().isDisambiguated() && nn.qualifier().type() != null && nn.qualifier().type().isCanonical()) {
                    TypeSystem ts = ar.typeSystem();
                    NodeFactory nf = ar.nodeFactory();
                    Context c = ar.context();
                    if (!nn.qualifier().type().isClass()) {
                        throw new SemanticException("Cannot instantiate member class of non-class type.", nn.position());
                    }
                    ClassType outer = nn.qualifier().type().toClass();
                    ClassType ct2 = ts.findMemberClass(outer, name, c.currentClass());
                    CanonicalTypeNode tn = nf.CanonicalTypeNode(nn.objectType().position(), ct2);
                    nn = nn.objectType(tn);
                }
            } else if (!nn.objectType().isDisambiguated()) {
                throw new SemanticException("Only simply-named member classes may be instantiated by a qualified new expression.", nn.objectType().position());
            }
        }
        nn = (New)nn.arguments(nn.visitList(nn.arguments(), childbd));
        if (childbd.hasErrors()) {
            throw new SemanticException();
        }
        if (nn.body() != null) {
            if (!nn.objectType().isDisambiguated()) {
                return nn;
            }
            ct = nn.objectType().type().toClass();
            ParsedClassType anonType = nn.anonType();
            if (anonType != null && !anonType.supertypesResolved()) {
                if (!ct.flags().isInterface()) {
                    anonType.superType(ct);
                } else {
                    anonType.superType(ar.typeSystem().Object());
                    anonType.addInterface(ct);
                }
                anonType.setSupertypesResolved(true);
            }
            SupertypeDisambiguator supDisamb = new SupertypeDisambiguator(childbd);
            nn = nn.body((ClassBody)nn.visitChild(nn.body(), supDisamb));
            if (supDisamb.hasErrors()) {
                throw new SemanticException();
            }
            SignatureDisambiguator sigDisamb = new SignatureDisambiguator(childbd);
            nn = nn.body((ClassBody)nn.visitChild(nn.body(), sigDisamb));
            if (sigDisamb.hasErrors()) {
                throw new SemanticException();
            }
            nn = nn.body((ClassBody)nn.visitChild(nn.body(), childbd));
            if (childbd.hasErrors()) {
                throw new SemanticException();
            }
        }
        nn = (New)bd.leave(parent, old, nn, childbd);
        return nn;
    }

    public Node disambiguate(AmbiguityRemover ar) throws SemanticException {
        return this;
    }

    protected New findQualifier(AmbiguityRemover ar, ClassType ct) throws SemanticException {
        NodeFactory nf = ar.nodeFactory();
        TypeSystem ts = ar.typeSystem();
        Context c = ar.context();
        Object outer = null;
        String name = ct.name();
        ClassType t = c.currentClass();
        if (t == this.anonType) {
            t = t.outer();
        }
        while (t != null) {
            try {
                t = ts.staticTarget(t).toClass();
                ClassType mt = ts.findMemberClass(t, name, c.currentClass());
                if (ts.equals(mt, ct)) {
                    outer = t;
                    break;
                }
            }
            catch (SemanticException e) {
                // empty catch block
            }
            t = t.outer();
        }
        if (outer == null) {
            throw new SemanticException("Could not find non-static member class \"" + name + "\".", this.position());
        }
        Expr q = outer.equals(c.currentClass()) ? nf.This(this.position().startOf()) : nf.This(this.position().startOf(), nf.CanonicalTypeNode(this.position(), (Type)outer));
        q = q.type((Type)outer);
        return this.qualifier(q);
    }

    public Node typeCheck(TypeChecker tc) throws SemanticException {
        ClassType ct;
        TypeSystem ts = tc.typeSystem();
        ArrayList<Type> argTypes = new ArrayList<Type>(this.arguments.size());
        Iterator i = this.arguments.iterator();
        while (i.hasNext()) {
            Expr e = (Expr)i.next();
            argTypes.add(e.type());
        }
        this.typeCheckFlags(tc);
        this.typeCheckNested(tc);
        if (this.body != null) {
            ts.checkClassConformance(this.anonType);
        }
        if (!(ct = this.tn.type().toClass()).flags().isInterface()) {
            Context c = tc.context();
            if (this.anonType != null) {
                c = c.pushClass(this.anonType, this.anonType);
            }
            this.ci = ts.findConstructor(ct, argTypes, c.currentClass());
        } else {
            this.ci = ts.defaultConstructor(this.position(), ct);
        }
        New n = this.constructorInstance(this.ci);
        if (this.anonType != null) {
            ct = this.anonType;
        }
        return n.type(ct);
    }

    protected void typeCheckNested(TypeChecker tc) throws SemanticException {
        if (this.qualifier != null) {
            Type qt = this.qualifier.type();
            if (!qt.isClass()) {
                throw new SemanticException("Cannot instantiate member class of a non-class type.", this.qualifier.position());
            }
            ClassType ct = this.tn.type().toClass();
            if (!ct.isInnerClass()) {
                throw new SemanticException("Cannot provide a containing instance for non-inner class " + ct.fullName() + ".", this.qualifier.position());
            }
        } else {
            ClassType ct = this.tn.type().toClass();
            if (ct.isMember()) {
                ClassType t = ct;
                while (t.isMember()) {
                    if (!t.flags().isStatic()) {
                        throw new SemanticException("Cannot allocate non-static member class \"" + t + "\".", this.position());
                    }
                    t = t.outer();
                }
            }
        }
    }

    protected void typeCheckFlags(TypeChecker tc) throws SemanticException {
        ClassType ct = this.tn.type().toClass();
        if (this.body == null) {
            if (ct.flags().isInterface()) {
                throw new SemanticException("Cannot instantiate an interface.", this.position());
            }
            if (ct.flags().isAbstract()) {
                throw new SemanticException("Cannot instantiate an abstract class.", this.position());
            }
        } else {
            if (ct.flags().isFinal()) {
                throw new SemanticException("Cannot create an anonymous subclass of a final class.", this.position());
            }
            if (ct.flags().isInterface() && !this.arguments.isEmpty()) {
                throw new SemanticException("Cannot pass arguments to an anonymous class that implements an interface.", ((Expr)this.arguments.get(0)).position());
            }
        }
    }

    public Type childExpectedType(Expr child, AscriptionVisitor av) {
        if (child == this.qualifier) {
            ReferenceType t = this.ci.container();
            if (t.isClass() && t.toClass().isMember()) {
                t = t.toClass().container();
                return t;
            }
            return child.type();
        }
        Iterator i = this.arguments.iterator();
        Iterator j = this.ci.formalTypes().iterator();
        while (i.hasNext() && j.hasNext()) {
            Expr e = (Expr)i.next();
            Type t = (Type)j.next();
            if (e != child) continue;
            return t;
        }
        return child.type();
    }

    public Node exceptionCheck(ExceptionChecker ec) throws SemanticException {
        if (this.ci == null) {
            throw new InternalCompilerError(this.position(), "Null constructor instance after type check.");
        }
        Iterator i = this.ci.throwTypes().iterator();
        while (i.hasNext()) {
            Type t = (Type)i.next();
            ec.throwsException(t, this.position());
        }
        return super.exceptionCheck(ec);
    }

    public Precedence precedence() {
        return Precedence.LITERAL;
    }

    public String toString() {
        return (this.qualifier != null ? this.qualifier.toString() + "." : "") + "new " + this.tn + "(...)" + (this.body != null ? " " + this.body : "");
    }

    protected void printQualifier(CodeWriter w, PrettyPrinter tr) {
        if (this.qualifier != null) {
            this.print(this.qualifier, w, tr);
            w.write(".");
        }
    }

    protected void printArgs(CodeWriter w, PrettyPrinter tr) {
        w.write("(");
        w.allowBreak(2, 2, "", 0);
        w.begin(0);
        Iterator i = this.arguments.iterator();
        while (i.hasNext()) {
            Expr e = (Expr)i.next();
            this.print(e, w, tr);
            if (!i.hasNext()) continue;
            w.write(",");
            w.allowBreak(0);
        }
        w.end();
        w.write(")");
    }

    protected void printBody(CodeWriter w, PrettyPrinter tr) {
        if (this.body != null) {
            w.write(" {");
            this.print(this.body, w, tr);
            w.write("}");
        }
    }

    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        this.printQualifier(w, tr);
        w.write("new ");
        if (this.qualifier != null) {
            w.write(this.tn.name());
        } else {
            this.print(this.tn, w, tr);
        }
        this.printArgs(w, tr);
        this.printBody(w, tr);
    }

    public Term firstChild() {
        return this.qualifier != null ? this.qualifier : this.tn;
    }

    public List acceptCFG(CFGBuilder v, List succs) {
        if (this.qualifier != null) {
            v.visitCFG(this.qualifier, this.tn, 1);
        }
        if (this.body() != null) {
            v.visitCFG(this.tn, New_c.listChild(this.arguments, this.body()), 1);
            v.visitCFGList(this.arguments, this.body(), 1);
            v.visitCFG(this.body(), this, 0);
        } else if (!this.arguments.isEmpty()) {
            v.visitCFG(this.tn, New_c.listChild(this.arguments, null), 1);
            v.visitCFGList(this.arguments, this, 0);
        } else {
            v.visitCFG(this.tn, this, 0);
        }
        return succs;
    }

    public List throwTypes(TypeSystem ts) {
        LinkedList l = new LinkedList();
        l.addAll(this.ci.throwTypes());
        l.addAll(ts.uncheckedExceptions());
        return l;
    }

    public Node typeCheckOverride(Node parent, TypeChecker tc) throws SemanticException {
        New nn = this;
        New_c old = nn;
        BodyDisambiguator bd = new BodyDisambiguator(tc);
        NodeVisitor childv = tc.enter(parent, this);
        if (childv instanceof PruningVisitor) {
            return nn;
        }
        TypeChecker childtc = (TypeChecker)childv;
        if (nn.qualifier() != null) {
            nn = nn.qualifier((Expr)nn.visitChild(nn.qualifier(), childtc));
            if (childtc.hasErrors()) {
                throw new SemanticException();
            }
            if (!nn.qualifier().type().isCanonical()) {
                return nn;
            }
            nn = (New)bd.visitEdge(parent, nn);
            if (bd.hasErrors()) {
                throw new SemanticException();
            }
            if (!nn.objectType().isDisambiguated()) {
                return nn;
            }
        }
        nn = nn.objectType((TypeNode)nn.visitChild(nn.objectType(), childtc));
        if (childtc.hasErrors()) {
            throw new SemanticException();
        }
        if (!nn.objectType().type().isCanonical()) {
            return nn;
        }
        nn = (New)nn.arguments(nn.visitList(nn.arguments(), childtc));
        if (childtc.hasErrors()) {
            throw new SemanticException();
        }
        nn = nn.body((ClassBody)nn.visitChild(nn.body(), childtc));
        if (childtc.hasErrors()) {
            throw new SemanticException();
        }
        nn = (New)tc.leave(parent, old, nn, childtc);
        ConstantChecker cc = new ConstantChecker(tc.job(), tc.typeSystem(), tc.nodeFactory());
        cc = (ConstantChecker)cc.context(childtc.context());
        nn = (New)nn.del().checkConstants(cc);
        return nn;
    }

    public Node copy(NodeFactory nf) {
        return nf.New(this.position, this.qualifier, this.tn, this.arguments, this.body);
    }

    static {
        $assertionsDisabled = !New_c.class.desiredAssertionStatus();
    }
}

